/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.admin.remote;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.DataSerializer;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.PooledDistributionMessage;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.AlertAppender;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.geode.internal.statistics.GemFireStatSampler;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public class AdminConsoleDisconnectMessage
extends PooledDistributionMessage {
    private static final Logger logger = LogService.getLogger();
    private boolean alertListenerExpected;
    private transient boolean ignoreAlertListenerRemovalFailure;
    private boolean crashed;
    private String reason;

    public static AdminConsoleDisconnectMessage create() {
        AdminConsoleDisconnectMessage m = new AdminConsoleDisconnectMessage();
        return m;
    }

    public void setCrashed(boolean crashed) {
        this.crashed = crashed;
    }

    public void setAlertListenerExpected(boolean alertListenerExpected) {
        this.alertListenerExpected = alertListenerExpected;
    }

    public void setIgnoreAlertListenerRemovalFailure(boolean ignore) {
        this.ignoreAlertListenerRemovalFailure = ignore;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    @Override
    public void process(ClusterDistributionManager dm) {
        GemFireStatSampler sampler;
        InternalDistributedSystem sys = dm.getSystem();
        if (this.alertListenerExpected && !AlertAppender.getInstance().removeAlertListener(this.getSender()) && !this.ignoreAlertListenerRemovalFailure) {
            logger.warn((Message)LocalizedMessage.create(LocalizedStrings.ManagerLogWriter_UNABLE_TO_REMOVE_CONSOLE_WITH_ID_0_FROM_ALERT_LISTENERS, this.getSender()));
        }
        if ((sampler = sys.getStatSampler()) != null) {
            sampler.removeListenersByRecipient(this.getSender());
        }
        dm.handleConsoleShutdown(this.getSender(), this.crashed, LocalizedStrings.AdminConsoleDisconnectMessage_AUTOMATIC_ADMIN_DISCONNECT_0.toLocalizedString(this.reason));
    }

    @Override
    public int getDSFID() {
        return 1004;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        out.writeBoolean(this.alertListenerExpected);
        out.writeBoolean(this.crashed);
        DataSerializer.writeString(this.reason, out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.alertListenerExpected = in.readBoolean();
        this.crashed = in.readBoolean();
        this.reason = DataSerializer.readString(in);
    }

    @Override
    public String toString() {
        return "AdminConsoleDisconnectMessage from " + this.getSender();
    }
}

