/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal;

import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Delayed;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ScheduledThreadPoolExecutorWithKeepAlive
extends ThreadPoolExecutor
implements ScheduledExecutorService {
    private final ScheduledThreadPoolExecutor timer;

    public ScheduledThreadPoolExecutorWithKeepAlive(int corePoolSize, long keepAlive, TimeUnit timeUnit, ThreadFactory threadFactory) {
        super(0, corePoolSize - 1, keepAlive, timeUnit, new SynchronousQueue<Runnable>(), threadFactory, new BlockCallerPolicy());
        this.timer = new ScheduledThreadPoolExecutor(1, threadFactory){

            @Override
            protected void terminated() {
                super.terminated();
                ScheduledThreadPoolExecutorWithKeepAlive.super.shutdown();
            }
        };
    }

    @Override
    public void execute(Runnable command) {
        this.timer.execute(new HandOffTask(command));
    }

    public Future submit(Callable task) {
        return this.schedule(task, 0L, TimeUnit.NANOSECONDS);
    }

    public Future submit(Runnable task, Object result) {
        return this.schedule(task, 0L, TimeUnit.NANOSECONDS, result);
    }

    public Future submit(Runnable task) {
        return this.schedule(task, 0L, TimeUnit.NANOSECONDS);
    }

    public ScheduledFuture schedule(Callable callable, long delay, TimeUnit unit) {
        DelegatingScheduledFuture future = new DelegatingScheduledFuture(callable);
        ScheduledFuture<?> timerFuture = this.timer.schedule(new HandOffTask(future), delay, unit);
        future.setDelegate(timerFuture);
        return future;
    }

    public ScheduledFuture schedule(Runnable command, long delay, TimeUnit unit) {
        return this.schedule(command, delay, unit, null);
    }

    private ScheduledFuture schedule(Runnable command, long delay, TimeUnit unit, Object result) {
        DelegatingScheduledFuture<Object> future = new DelegatingScheduledFuture<Object>(command, result);
        ScheduledFuture<?> timerFuture = this.timer.schedule(new HandOffTask(future), delay, unit);
        future.setDelegate(timerFuture);
        return future;
    }

    public ScheduledFuture scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        DelegatingScheduledFuture<Object> future = new DelegatingScheduledFuture<Object>(command, null, true);
        ScheduledFuture<?> timerFuture = this.timer.scheduleAtFixedRate(new HandOffTask(future), initialDelay, period, unit);
        future.setDelegate(timerFuture);
        return future;
    }

    public ScheduledFuture scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        DelegatingScheduledFuture<Object> future = new DelegatingScheduledFuture<Object>(command, null, true);
        ScheduledFuture<?> timerFuture = this.timer.scheduleWithFixedDelay(new HandOffTask(future), initialDelay, delay, unit);
        future.setDelegate(timerFuture);
        return future;
    }

    @Override
    public void shutdown() {
        this.timer.shutdown();
    }

    public List shutdownNow() {
        List<Runnable> tasks = this.timer.shutdownNow();
        super.shutdownNow();
        return tasks;
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        long start = System.nanoTime();
        if (!this.timer.awaitTermination(timeout, unit)) {
            return false;
        }
        long elapsed = System.nanoTime() - start;
        long remaining = unit.toNanos(timeout) - elapsed;
        if (remaining < 0L) {
            return false;
        }
        return super.awaitTermination(remaining, TimeUnit.NANOSECONDS);
    }

    @Override
    public int getCorePoolSize() {
        return super.getCorePoolSize() + 1;
    }

    @Override
    public int getLargestPoolSize() {
        return super.getLargestPoolSize() + 1;
    }

    @Override
    public int getMaximumPoolSize() {
        return super.getMaximumPoolSize() + 1;
    }

    @Override
    public int getPoolSize() {
        return super.getPoolSize() + 1;
    }

    @Override
    public boolean isShutdown() {
        return this.timer.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return super.isTerminated() && this.timer.isTerminated();
    }

    public void setContinueExistingPeriodicTasksAfterShutdownPolicy(boolean b) {
        this.timer.setContinueExistingPeriodicTasksAfterShutdownPolicy(b);
    }

    public void setExecuteExistingDelayedTasksAfterShutdownPolicy(boolean b) {
        this.timer.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
    }

    protected static class BlockCallerPolicy
    implements RejectedExecutionHandler {
        protected BlockCallerPolicy() {
        }

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            if (executor.isShutdown()) {
                throw new RejectedExecutionException("executor has been shutdown");
            }
            try {
                executor.getQueue().put(r);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                RejectedExecutionException e = new RejectedExecutionException("interrupted");
                e.initCause(ie);
                throw e;
            }
        }
    }

    private static class DelegatingScheduledFuture<V>
    extends FutureTask<V>
    implements ScheduledFuture<V> {
        private ScheduledFuture<V> delegate;
        private final boolean periodic;

        public DelegatingScheduledFuture(Runnable runnable, V result) {
            this(runnable, result, false);
        }

        public DelegatingScheduledFuture(Callable<V> callable) {
            this(callable, false);
        }

        public DelegatingScheduledFuture(Runnable runnable, V result, boolean periodic) {
            super(runnable, result);
            this.periodic = periodic;
        }

        public DelegatingScheduledFuture(Callable<V> callable, boolean periodic) {
            super(callable);
            this.periodic = periodic;
        }

        @Override
        public void run() {
            if (this.periodic) {
                super.runAndReset();
            } else {
                super.run();
            }
        }

        public void setDelegate(ScheduledFuture<V> future) {
            this.delegate = future;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            this.delegate.cancel(true);
            return super.cancel(mayInterruptIfRunning);
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return this.delegate.getDelay(unit);
        }

        @Override
        public int compareTo(Delayed o) {
            return this.delegate.compareTo(o);
        }

        public boolean equals(Object o) {
            return this.delegate.equals(o);
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }
    }

    private class HandOffTask
    implements Runnable {
        private final Runnable task;

        public HandOffTask(Runnable task) {
            this.task = task;
        }

        @Override
        public void run() {
            try {
                ScheduledThreadPoolExecutorWithKeepAlive.super.execute(this.task);
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
            }
        }
    }
}

