/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal.membership.gms.messages;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import org.apache.geode.DataSerializer;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.HighPriorityDistributionMessage;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.distributed.internal.membership.gms.messages.HasMemberID;
import org.apache.geode.internal.Version;

public class LeaveRequestMessage
extends HighPriorityDistributionMessage
implements HasMemberID {
    private InternalDistributedMember memberID;
    private String reason;

    public LeaveRequestMessage(Collection<InternalDistributedMember> coords, InternalDistributedMember id, String reason) {
        this.setRecipients(coords);
        this.memberID = id;
        this.reason = reason;
    }

    public LeaveRequestMessage(InternalDistributedMember coord, InternalDistributedMember id, String reason) {
        this.setRecipient(coord);
        this.memberID = id;
        this.reason = reason;
    }

    public LeaveRequestMessage() {
    }

    @Override
    public int getDSFID() {
        return -152;
    }

    @Override
    public void process(ClusterDistributionManager dm) {
        throw new IllegalStateException("this message is not intended to execute in a thread pool");
    }

    @Override
    public InternalDistributedMember getMemberID() {
        return this.memberID;
    }

    public String getReason() {
        return this.reason;
    }

    @Override
    public Version[] getSerializationVersions() {
        return null;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        DataSerializer.writeObject(this.memberID, out);
        DataSerializer.writeString(this.reason, out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.memberID = (InternalDistributedMember)DataSerializer.readObject(in);
        this.reason = DataSerializer.readString(in);
    }

    @Override
    public String toString() {
        return this.getShortClassName() + "(" + this.memberID + "; reason=" + this.reason + ")";
    }
}

