/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal.membership.gms;

import org.apache.geode.distributed.Locator;
import org.apache.geode.distributed.internal.DistributionConfig;
import org.apache.geode.internal.admin.remote.RemoteTransportConfig;
import org.apache.geode.internal.net.SocketCreator;

public class ServiceConfig {
    public static final long MEMBER_REQUEST_COLLECTION_INTERVAL = Long.getLong("gemfire.member-request-collection-interval", 300L);
    private final long joinTimeout;
    private final int[] membershipPortRange;
    private final int udpRecvBufferSize;
    private final int udpSendBufferSize;
    private final long memberTimeout;
    private Integer lossThreshold;
    private final Integer memberWeight;
    private boolean networkPartitionDetectionEnabled;
    private final int locatorWaitTime;
    private final DistributionConfig dconfig;
    private final RemoteTransportConfig transport;

    public int getLocatorWaitTime() {
        return this.locatorWaitTime;
    }

    public long getJoinTimeout() {
        return this.joinTimeout;
    }

    public int[] getMembershipPortRange() {
        return this.membershipPortRange;
    }

    public long getMemberTimeout() {
        return this.memberTimeout;
    }

    public int getLossThreshold() {
        return this.lossThreshold;
    }

    public int getMemberWeight() {
        return this.memberWeight;
    }

    public boolean isNetworkPartitionDetectionEnabled() {
        return this.networkPartitionDetectionEnabled;
    }

    public void setNetworkPartitionDetectionEnabled(boolean enabled) {
        this.networkPartitionDetectionEnabled = enabled;
    }

    public boolean areLocatorsPreferredAsCoordinators() {
        boolean locatorsAreCoordinators = false;
        if (this.networkPartitionDetectionEnabled) {
            locatorsAreCoordinators = true;
        } else {
            String prop = this.dconfig.getSecurityPeerAuthInit();
            boolean bl = locatorsAreCoordinators = prop != null && prop.length() > 0;
            if (!locatorsAreCoordinators) {
                locatorsAreCoordinators = Boolean.getBoolean("gemfire.disable-floating-coordinator");
            }
        }
        return locatorsAreCoordinators;
    }

    public DistributionConfig getDistributionConfig() {
        return this.dconfig;
    }

    public RemoteTransportConfig getTransport() {
        return this.transport;
    }

    public ServiceConfig(RemoteTransportConfig transport, DistributionConfig theConfig) {
        long minimumJoinTimeout;
        this.dconfig = theConfig;
        this.transport = transport;
        long defaultJoinTimeout = 24000L;
        if (theConfig.getLocators().length() > 0 && !Locator.hasLocator()) {
            defaultJoinTimeout = 60000L;
        }
        if (defaultJoinTimeout < (minimumJoinTimeout = (long)(this.dconfig.getMemberTimeout() * 2) + MEMBER_REQUEST_COLLECTION_INTERVAL)) {
            defaultJoinTimeout = minimumJoinTimeout;
        }
        this.joinTimeout = Long.getLong("p2p.joinTimeout", defaultJoinTimeout);
        if (theConfig.getEnableNetworkPartitionDetection() && !SocketCreator.FORCE_DNS_USE) {
            SocketCreator.resolve_dns = false;
        }
        this.membershipPortRange = theConfig.getMembershipPortRange();
        this.udpRecvBufferSize = 65535;
        this.udpSendBufferSize = theConfig.getUdpSendBufferSize();
        this.memberTimeout = theConfig.getMemberTimeout();
        int ackCollectionTimeout = theConfig.getMemberTimeout() * 2 * 12437 / 10000;
        if (ackCollectionTimeout < 1500) {
            ackCollectionTimeout = 1500;
        } else if (ackCollectionTimeout > 12437) {
            ackCollectionTimeout = 12437;
        }
        ackCollectionTimeout = Integer.getInteger("gemfire.VIEW_ACK_TIMEOUT", ackCollectionTimeout);
        this.lossThreshold = Integer.getInteger("gemfire.network-partition-threshold", 51);
        if (this.lossThreshold < 51) {
            this.lossThreshold = 51;
        }
        if (this.lossThreshold > 100) {
            this.lossThreshold = 100;
        }
        this.memberWeight = Integer.getInteger("gemfire.member-weight", 0);
        this.locatorWaitTime = theConfig.getLocatorWaitTime();
        this.networkPartitionDetectionEnabled = theConfig.getEnableNetworkPartitionDetection();
    }
}

