/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal.locks;

import java.util.WeakHashMap;
import org.apache.geode.distributed.LeaseExpiredException;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.locks.DLockService;
import org.apache.geode.distributed.internal.locks.RemoteThread;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.logging.log4j.Logger;

public class DLockToken {
    private static final Logger logger = LogService.getLogger();
    private final Object name;
    private final DistributionManager dm;
    private int leaseId = -1;
    private long leaseExpireTime = -1L;
    private RemoteThread lesseeThread = null;
    private int recursion;
    private WeakHashMap expiredLeases;
    private Thread thread;
    private int usageCount = 0;
    private boolean destroyed = false;
    private boolean ignoreForRecovery = false;

    public DLockToken(DistributionManager dm, Object name) {
        this.dm = dm;
        this.name = name;
    }

    public int getRecursion() {
        return this.recursion;
    }

    public String getThreadName() {
        return this.thread == null ? null : this.thread.getName();
    }

    public synchronized Thread getThread() {
        return this.thread;
    }

    public long getLeaseExpireTime() {
        return this.leaseExpireTime;
    }

    public int getUsageCount() {
        return this.usageCount;
    }

    Object getName() {
        return this.name;
    }

    int getLeaseId() {
        return this.leaseId;
    }

    RemoteThread getLesseeThread() {
        return this.lesseeThread;
    }

    void incUsage() {
        this.incUsage(1);
    }

    void decUsage() {
        this.incUsage(-1);
    }

    boolean isBeingUsed() {
        return this.usageCount > 0;
    }

    synchronized void destroy() {
        this.destroyed = true;
    }

    long getCurrentTime() {
        if (this.dm == null) {
            return -1L;
        }
        return DLockService.getLockTimeStamp(this.dm);
    }

    void throwIfCurrentThreadHadExpiredLease() throws LeaseExpiredException {
        if (this.expiredLeases == null) {
            return;
        }
        if (this.expiredLeases.containsKey(Thread.currentThread())) {
            this.expiredLeases.remove(Thread.currentThread());
            throw new LeaseExpiredException(LocalizedStrings.DLockToken_THIS_THREADS_LEASE_EXPIRED_FOR_THIS_LOCK.toLocalizedString());
        }
    }

    boolean checkForExpiration() {
        long currentTime;
        boolean expired = false;
        if (this.leaseId > -1 && this.leaseExpireTime < Long.MAX_VALUE && (currentTime = this.getCurrentTime()) > this.leaseExpireTime) {
            if (logger.isTraceEnabled(LogMarker.DLS_VERBOSE)) {
                logger.trace(LogMarker.DLS_VERBOSE, "[checkForExpiration] Expiring token at {}: {}", (Object)currentTime, (Object)this);
            }
            this.noteExpiredLease();
            this.basicReleaseLock();
            expired = true;
        }
        return expired;
    }

    synchronized void grantLock(long newLeaseExpireTime, int newLeaseId, int newRecursion, RemoteThread remoteThread) {
        Assert.assertTrue(remoteThread != null);
        Assert.assertTrue(newLeaseId > -1, "Invalid attempt to grant lock with leaseId " + newLeaseId);
        this.checkDestroyed();
        this.checkForExpiration();
        this.ignoreForRecovery = false;
        this.leaseExpireTime = newLeaseExpireTime;
        this.leaseId = newLeaseId;
        this.lesseeThread = remoteThread;
        this.recursion = newRecursion;
        this.thread = Thread.currentThread();
        if (logger.isTraceEnabled(LogMarker.DLS_VERBOSE)) {
            logger.trace(LogMarker.DLS_VERBOSE, "[DLockToken.grantLock.client] granted {}", (Object)this);
        }
    }

    synchronized boolean isLeaseHeld() {
        return this.leaseId > -1;
    }

    boolean isLeaseHeldByCurrentOrRemoteThread(RemoteThread remoteThread) {
        if (this.isLeaseHeldByCurrentThread()) {
            return true;
        }
        return this.lesseeThread != null && remoteThread != null && this.lesseeThread.equals(remoteThread);
    }

    boolean isLeaseHeldByCurrentThread() {
        return this.thread == Thread.currentThread();
    }

    synchronized boolean ignoreForRecovery() {
        return this.ignoreForRecovery;
    }

    void setIgnoreForRecovery(boolean value) {
        this.ignoreForRecovery = value;
    }

    synchronized boolean releaseLock(int leaseIdToRelease, RemoteThread remoteThread) {
        return this.releaseLock(leaseIdToRelease, remoteThread, true);
    }

    synchronized boolean releaseLock(int leaseIdToRelease, RemoteThread remoteThread, boolean decRecursion) {
        if (leaseIdToRelease == -1) {
            return false;
        }
        if (this.destroyed) {
            return true;
        }
        if (!this.isLeaseHeld(leaseIdToRelease) || !this.isLeaseHeldByCurrentOrRemoteThread(remoteThread)) {
            return false;
        }
        if (decRecursion && this.getRecursion() > 0) {
            this.incRecursion(-1);
            this.decUsage();
            if (logger.isTraceEnabled(LogMarker.DLS_VERBOSE)) {
                logger.trace(LogMarker.DLS_VERBOSE, "[DLockToken.releaseLock] decremented recursion: {}", (Object)this);
            }
            return true;
        }
        this.basicReleaseLock();
        return true;
    }

    private void basicReleaseLock() {
        if (logger.isTraceEnabled(LogMarker.DLS_VERBOSE)) {
            logger.trace(LogMarker.DLS_VERBOSE, "[DLockToken.basicReleaseLock] releasing ownership: {}", (Object)this);
        }
        this.leaseId = -1;
        this.lesseeThread = null;
        this.leaseExpireTime = -1L;
        this.thread = null;
        this.recursion = 0;
        this.ignoreForRecovery = false;
        this.decUsage();
    }

    private boolean isLeaseHeld(int memberLeaseId) {
        return memberLeaseId == this.leaseId;
    }

    private void incUsage(int amount) {
        if (amount < 0 && !this.destroyed) {
            Assert.assertTrue(this.usageCount - amount >= 0, amount + " cannot be subtracted from usageCount " + this.usageCount);
        }
        this.usageCount += amount;
    }

    private void incRecursion(int amount) {
        if (amount < 0) {
            Assert.assertTrue(this.recursion - amount >= 0, amount + " cannot be subtracted from recursion " + this.recursion);
        }
        this.recursion += amount;
    }

    private void checkDestroyed() {
        if (this.destroyed) {
            IllegalStateException e = new IllegalStateException(LocalizedStrings.DLockToken_ATTEMPTING_TO_USE_DESTROYED_TOKEN_0.toLocalizedString(this));
            throw e;
        }
    }

    private void noteExpiredLease() {
        if (logger.isTraceEnabled(LogMarker.DLS_VERBOSE)) {
            logger.trace(LogMarker.DLS_VERBOSE, "[noteExpiredLease] {}", (Object)this.thread);
        }
        if (this.expiredLeases == null) {
            this.expiredLeases = new WeakHashMap();
        }
        this.expiredLeases.put(this.thread, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        DLockToken dLockToken = this;
        synchronized (dLockToken) {
            return "DLockToken@" + Integer.toHexString(this.hashCode()) + ", name: " + this.name + ", thread: <" + this.getThreadName() + ">, recursion: " + this.recursion + ", leaseExpireTime: " + this.leaseExpireTime + ", leaseId: " + this.leaseId + ", ignoreForRecovery: " + this.ignoreForRecovery + ", lesseeThread: " + this.lesseeThread + ", usageCount: " + this.usageCount + ", currentTime: " + this.getCurrentTime();
        }
    }
}

