/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal.locks;

import java.io.DataInput;
import java.io.DataOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.geode.CancelCriterion;
import org.apache.geode.CancelException;
import org.apache.geode.InternalGemFireException;
import org.apache.geode.SystemFailure;
import org.apache.geode.distributed.DistributedLockService;
import org.apache.geode.distributed.DistributedSystem;
import org.apache.geode.distributed.DistributedSystemDisconnectedException;
import org.apache.geode.distributed.LeaseExpiredException;
import org.apache.geode.distributed.LockNotHeldException;
import org.apache.geode.distributed.LockServiceDestroyedException;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.ResourceEvent;
import org.apache.geode.distributed.internal.deadlock.UnsafeThreadLocal;
import org.apache.geode.distributed.internal.locks.DLockBatch;
import org.apache.geode.distributed.internal.locks.DLockBatchId;
import org.apache.geode.distributed.internal.locks.DLockGrantor;
import org.apache.geode.distributed.internal.locks.DLockLessorDepartureHandler;
import org.apache.geode.distributed.internal.locks.DLockQueryProcessor;
import org.apache.geode.distributed.internal.locks.DLockRecoverGrantorProcessor;
import org.apache.geode.distributed.internal.locks.DLockReleaseProcessor;
import org.apache.geode.distributed.internal.locks.DLockRemoteToken;
import org.apache.geode.distributed.internal.locks.DLockRequestProcessor;
import org.apache.geode.distributed.internal.locks.DLockStats;
import org.apache.geode.distributed.internal.locks.DLockToken;
import org.apache.geode.distributed.internal.locks.DistributedLockStats;
import org.apache.geode.distributed.internal.locks.DummyDLockStats;
import org.apache.geode.distributed.internal.locks.GrantorInfo;
import org.apache.geode.distributed.internal.locks.GrantorRequestProcessor;
import org.apache.geode.distributed.internal.locks.LockGrantorDestroyedException;
import org.apache.geode.distributed.internal.locks.LockGrantorId;
import org.apache.geode.distributed.internal.locks.NonGrantorDestroyedProcessor;
import org.apache.geode.distributed.internal.locks.RemoteThread;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.DataSerializableFixedID;
import org.apache.geode.internal.OSProcess;
import org.apache.geode.internal.Version;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.LoggingThreadGroup;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.geode.internal.util.StopWatch;
import org.apache.geode.internal.util.concurrent.FutureResult;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public class DLockService
extends DistributedLockService {
    private static final Logger logger = LogService.getLogger();
    public static final long NOT_GRANTOR_SLEEP = Long.getLong("gemfire.DLockService.notGrantorSleep", 100L);
    public static final boolean DEBUG_NONGRANTOR_DESTROY_LOOP = Boolean.getBoolean("gemfire.DLockService.debug.nonGrantorDestroyLoop");
    public static final int DEBUG_NONGRANTOR_DESTROY_LOOP_COUNT = Integer.getInteger("gemfire.DLockService.debug.nonGrantorDestroyLoopCount", 20);
    public static final boolean AUTOMATE_FREE_RESOURCES = Boolean.getBoolean("gemfire.DLockService.automateFreeResources");
    public static final int INVALID_LEASE_ID = -1;
    protected final String serviceName;
    private final DistributionManager dm;
    protected final InternalDistributedSystem ds;
    private final Map<Object, DLockToken> tokens = new HashMap<Object, DLockToken>();
    private volatile boolean destroyed = false;
    private final boolean isDistributed;
    private DLockLessorDepartureHandler lessorDepartureHandler;
    private DLockRecoverGrantorProcessor.MessageProcessor recoverGrantorProcessor;
    private final DistributedLockStats dlockStats;
    private final Object lockGrantorIdLock = new Object();
    private LockGrantorId lockGrantorId;
    private volatile DLockGrantor grantor;
    private int activeLocks = 0;
    private final boolean destroyOnDisconnect;
    private final boolean automateFreeResources;
    private final ThreadLocal<Boolean> destroyingThread = new ThreadLocal();
    private final Object destroyLock = new Object();
    private FutureResult lockGrantorFutureResult;
    private final DLockStopper stopper;
    private LockGrantorId deposingLockGrantorId;
    private final AtomicInteger threadSequence = new AtomicInteger();
    private final ThreadLocal threadRequestState = new ThreadLocal();
    private final UnsafeThreadLocal<Object> blockedOn = new UnsafeThreadLocal();
    protected static final InternalDistributedSystem.DisconnectListener disconnectListener = new InternalDistributedSystem.DisconnectListener(){

        public String toString() {
            return LocalizedStrings.DLockService_DISCONNECT_LISTENER_FOR_DISTRIBUTEDLOCKSERVICE.toLocalizedString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onDisconnect(InternalDistributedSystem sys) {
            boolean isDebugEnabled_DLS = logger.isTraceEnabled(LogMarker.DLS_VERBOSE);
            if (isDebugEnabled_DLS) {
                logger.trace(LogMarker.DLS_VERBOSE, "Shutting down Distributed Lock Services");
            }
            long start = System.currentTimeMillis();
            try {
                DLockService.destroyAll();
            }
            finally {
                DLockService.closeStats();
                long delta = System.currentTimeMillis() - start;
                if (isDebugEnabled_DLS) {
                    logger.trace(LogMarker.DLS_VERBOSE, "Distributed Lock Services stopped (took {} ms)", (Object)delta);
                }
            }
        }
    };
    private static final DummyDLockStats DUMMY_STATS = new DummyDLockStats();
    public static final SuspendLockingToken SUSPEND_LOCKING_TOKEN = new SuspendLockingToken();
    protected static final Map<String, DLockService> services = new HashMap<String, DLockService>();
    protected static final Object creationLock = new Object();
    static ThreadGroup threadGroup;
    private static DistributedLockStats stats;
    public static final String LTLS = "LTLS";
    public static final String DTLS = "DTLS";
    static final String[] reservedNames;
    public static final int START_SERIAL_NUMBER;
    private static final AtomicInteger serialNumberSequencer;
    private final int serialNumber;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDestroyed() {
        Object object = this.destroyLock;
        synchronized (object) {
            return this.destroyed && !this.isCurrentThreadDoingDestroy();
            {
            }
        }
    }

    public void checkDestroyed() {
        if (this.isDestroyed()) {
            throw this.generateLockServiceDestroyedException(this.generateLockServiceDestroyedMessage());
        }
    }

    protected LockServiceDestroyedException generateLockServiceDestroyedException(String message) {
        return new LockServiceDestroyedException(message);
    }

    protected String generateLockServiceDestroyedMessage() {
        return LocalizedStrings.DLockService_0_HAS_BEEN_DESTROYED.toLocalizedString(this);
    }

    private boolean checkLockGrantorId(LockGrantorId someLockGrantorId) {
        Assert.assertHoldsLock(this.lockGrantorIdLock, true);
        if (this.lockGrantorId == null) {
            return false;
        }
        return this.lockGrantorId.sameAs(someLockGrantorId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLockGrantorId(LockGrantorId someLockGrantorId) {
        Object object = this.lockGrantorIdLock;
        synchronized (object) {
            return this.checkLockGrantorId(someLockGrantorId);
        }
    }

    private boolean isCurrentThreadDoingDestroy() {
        return Boolean.TRUE.equals(this.destroyingThread.get());
    }

    private void setDestroyingThread() {
        this.destroyingThread.set(Boolean.TRUE);
    }

    private void clearDestroyingThread() {
        this.destroyingThread.remove();
    }

    private InternalDistributedMember getElderId() {
        InternalDistributedMember elder = this.dm.getElderId();
        if (elder == null) {
            this.dm.getSystem().getCancelCriterion().checkCancelInProgress(null);
        }
        Assert.assertTrue(elder != null);
        return elder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public LockGrantorId getLockGrantorId() {
        isDebugEnabled_DLS = DLockService.logger.isTraceEnabled(LogMarker.DLS_VERBOSE);
        ownLockGrantorFutureResult = false;
        lockGrantorFutureResultRef = null;
        statStart = -1L;
        theLockGrantorId = null;
        while (theLockGrantorId == null) {
            block59: {
                block60: {
                    ownLockGrantorFutureResult = false;
                    Assert.assertHoldsLock(this.destroyLock, false);
                    var7_6 = this.lockGrantorIdLock;
                    synchronized (var7_6) {
                        block61: {
                            if (this.lockGrantorFutureResult == null) break block61;
                            lockGrantorFutureResultRef = this.lockGrantorFutureResult;
                            ** GOTO lbl47
                        }
                        if (this.lockGrantorId == null) ** break block58
                        var8_7 = this.lockGrantorId;
                        // MONITOREXIT @DISABLED, blocks:[0, 1, 29, 13] lbl19 : MonitorExitStatement: MONITOREXIT : var7_6
                        var9_12 = this.lockGrantorIdLock;
                    }
                    synchronized (var9_12) {
                        v0 = getLockGrantorIdFailed = theLockGrantorId == null;
                        if (statStart > -1L) {
                            this.getStats().endGrantorWait(statStart, getLockGrantorIdFailed);
                        }
                        if (ownLockGrantorFutureResult) {
                            Assert.assertTrue(this.lockGrantorFutureResult == lockGrantorFutureResultRef);
                            if (getLockGrantorIdFailed) {
                                lockGrantorFutureResultRef.cancel(false);
                            } else {
                                lockGrantorFutureResultRef.set(theLockGrantorId);
                            }
                            this.lockGrantorFutureResult = null;
                        }
                    }
                    return var8_7;
                    {
                        ownLockGrantorFutureResult = true;
                        lockGrantorFutureResultRef = new FutureResult(this.dm.getCancelCriterion());
                        if (isDebugEnabled_DLS) {
                            DLockService.logger.trace(LogMarker.DLS_VERBOSE, "[getLockGrantorId] creating lockGrantorFutureResult");
                        }
                        this.lockGrantorFutureResult = lockGrantorFutureResultRef;
lbl47:
                        // 2 sources

                        // MONITOREXIT @DISABLED, blocks:[3, 4, 29, 13] lbl47 : MonitorExitStatement: MONITOREXIT : var7_6
                        {
                            catch (Throwable var12_20) {
                                throw var12_20;
                            }
                        }
                        statStart = this.getStats().startGrantorWait();
                        if (ownLockGrantorFutureResult) break block59;
                        lockGrantorIdRef = this.waitForLockGrantorFutureResult(lockGrantorFutureResultRef, 0L, TimeUnit.MILLISECONDS);
                        if (lockGrantorIdRef == null) break block60;
                        var8_8 = lockGrantorIdRef;
                        var9_13 = this.lockGrantorIdLock;
                    }
                    synchronized (var9_13) {
                        v1 = getLockGrantorIdFailed = theLockGrantorId == null;
                        if (statStart > -1L) {
                            this.getStats().endGrantorWait(statStart, getLockGrantorIdFailed);
                        }
                        if (ownLockGrantorFutureResult) {
                            Assert.assertTrue(this.lockGrantorFutureResult == lockGrantorFutureResultRef);
                            if (getLockGrantorIdFailed) {
                                lockGrantorFutureResultRef.cancel(false);
                            } else {
                                lockGrantorFutureResultRef.set(theLockGrantorId);
                            }
                            this.lockGrantorFutureResult = null;
                        }
                    }
                    return var8_8;
                }
                var8_9 = this.lockGrantorIdLock;
                synchronized (var8_9) {
                    v2 = getLockGrantorIdFailed = theLockGrantorId == null;
                    if (statStart > -1L) {
                        this.getStats().endGrantorWait(statStart, getLockGrantorIdFailed);
                    }
                    if (ownLockGrantorFutureResult) {
                        Assert.assertTrue(this.lockGrantorFutureResult == lockGrantorFutureResultRef);
                        if (getLockGrantorIdFailed) {
                            lockGrantorFutureResultRef.cancel(false);
                        } else {
                            lockGrantorFutureResultRef.set(theLockGrantorId);
                        }
                        this.lockGrantorFutureResult = null;
                    }
                    continue;
                }
            }
            elder = this.getElderId();
            Assert.assertTrue(elder != null);
            gi = this.getGrantorRequest();
            theLockGrantorId = new LockGrantorId(this.dm, gi.getId(), gi.getVersionId(), gi.getSerialNumber());
            if (isDebugEnabled_DLS) {
                DLockService.logger.trace(LogMarker.DLS_VERBOSE, "[getLockGrantorId] elder says grantor is {}", (Object)theLockGrantorId);
            }
            if (theLockGrantorId.isLocal(this.getSerialNumber())) {
                needsRecovery = gi.needsRecovery();
                if (!needsRecovery) {
                    if (isDebugEnabled_DLS) {
                        DLockService.logger.trace(LogMarker.DLS_VERBOSE, "[getLockGrantorId] needsRecovery is false");
                    }
                    var10_16 = this.lockGrantorIdLock;
                    synchronized (var10_16) {
                        Assert.assertTrue(this.lockGrantorId == null || this.lockGrantorId.isNewerThan(theLockGrantorId) != false || this.lockGrantorId.sameAs(theLockGrantorId) != false, this.lockGrantorId + " should be null or newer than or same as " + theLockGrantorId);
                    }
                }
                if (!this.createLocalGrantor(elder, needsRecovery, theLockGrantorId)) {
                    theLockGrantorId = this.lockGrantorId;
                }
            } else {
                var9_15 = this.lockGrantorIdLock;
                synchronized (var9_15) {
                    if (!this.setLockGrantorId(theLockGrantorId)) {
                        theLockGrantorId = this.lockGrantorId;
                    }
                }
            }
            var7_6 = this.lockGrantorIdLock;
            {
                catch (Throwable var18_26) {
                    var19_27 = this.lockGrantorIdLock;
                    synchronized (var19_27) {
                        v3 = getLockGrantorIdFailed = theLockGrantorId == null;
                        if (statStart > -1L) {
                            this.getStats().endGrantorWait(statStart, getLockGrantorIdFailed);
                        }
                        if (ownLockGrantorFutureResult) {
                            Assert.assertTrue(this.lockGrantorFutureResult == lockGrantorFutureResultRef);
                            if (getLockGrantorIdFailed) {
                                lockGrantorFutureResultRef.cancel(false);
                            } else {
                                lockGrantorFutureResultRef.set(theLockGrantorId);
                            }
                            this.lockGrantorFutureResult = null;
                        }
                    }
                    throw var18_26;
                }
            }
            synchronized (var7_6) {
                v4 = getLockGrantorIdFailed = theLockGrantorId == null;
                if (statStart > -1L) {
                    this.getStats().endGrantorWait(statStart, getLockGrantorIdFailed);
                }
                if (ownLockGrantorFutureResult) {
                    Assert.assertTrue(this.lockGrantorFutureResult == lockGrantorFutureResultRef);
                    if (getLockGrantorIdFailed) {
                        lockGrantorFutureResultRef.cancel(false);
                    } else {
                        lockGrantorFutureResultRef.set(theLockGrantorId);
                    }
                    this.lockGrantorFutureResult = null;
                }
            }
        }
        return theLockGrantorId;
    }

    private boolean createLocalGrantor(InternalDistributedMember elder, boolean needsRecovery, LockGrantorId myLockGrantorId) {
        DLockGrantor myGrantor = DLockGrantor.createGrantor(this, myLockGrantorId.getLockGrantorVersion());
        if (logger.isTraceEnabled(LogMarker.DLS_VERBOSE)) {
            logger.trace(LogMarker.DLS_VERBOSE, "[createLocalGrantor] Calling makeLocalGrantor");
        }
        return this.makeLocalGrantor(elder, needsRecovery, myLockGrantorId, myGrantor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private boolean makeLocalGrantor(InternalDistributedMember elder, boolean needsRecovery, LockGrantorId myLockGrantorId, DLockGrantor myGrantor) {
        isDebugEnabled_DLS = DLockService.logger.isTraceEnabled(LogMarker.DLS_VERBOSE);
        success = false;
        try {
            block77: {
                block76: {
                    block75: {
                        block74: {
                            block73: {
                                var7_7 = this.lockGrantorIdLock;
                                // MONITORENTER : var7_7
                                if (this.isDestroyed()) {
                                    this.checkDestroyed();
                                }
                                if ((currentElder = this.getElderId()).equals(elder)) break block73;
                                if (isDebugEnabled_DLS) {
                                    DLockService.logger.trace(LogMarker.DLS_VERBOSE, "Failed to create {} because elder changed from {} to {}", (Object)myLockGrantorId, (Object)elder, (Object)currentElder);
                                }
                                var9_17 = false;
                                // MONITOREXIT : var7_7
                                try {
                                    if (success) {
                                        if (this.isDestroyed() == false) return var9_17;
                                    }
                                    if (isDebugEnabled_DLS) {
                                        DLockService.logger.trace(LogMarker.DLS_VERBOSE, "[makeLocalGrantor] aborting {} and {}", (Object)myLockGrantorId, (Object)myGrantor);
                                    }
                                    this.nullLockGrantorId(myLockGrantorId);
                                    if (myGrantor.isDestroyed() != false) return var9_17;
                                    myGrantor.destroy();
                                    return var9_17;
                                }
                                finally {
                                    if (myGrantor.isInitializing() && !this.dm.getCancelCriterion().isCancelInProgress()) {
                                        DLockService.logger.error(LogMarker.DLS_MARKER, (Message)LocalizedMessage.create(LocalizedStrings.DLockService_GRANTOR_IS_STILL_INITIALIZING));
                                    }
                                    if (!(success || myGrantor.isDestroyed() || this.dm.getCancelCriterion().isCancelInProgress())) {
                                        DLockService.logger.error(LogMarker.DLS_MARKER, (Message)LocalizedMessage.create(LocalizedStrings.DLockService_GRANTOR_CREATION_WAS_ABORTED_BUT_GRANTOR_WAS_NOT_DESTROYED));
                                    }
                                }
                            }
                            if (this.deposingLockGrantorId == null) ** GOTO lbl60
                            if (!this.deposingLockGrantorId.isNewerThan(myLockGrantorId)) break block74;
                            if (isDebugEnabled_DLS) {
                                DLockService.logger.trace(LogMarker.DLS_VERBOSE, "Failed to create {} because I was deposed by {}", (Object)myLockGrantorId, (Object)this.deposingLockGrantorId);
                            }
                            this.deposingLockGrantorId = null;
                            var9_18 = false;
                            // MONITOREXIT : var7_7
                            try {
                                if (success) {
                                    if (this.isDestroyed() == false) return var9_18;
                                }
                                if (isDebugEnabled_DLS) {
                                    DLockService.logger.trace(LogMarker.DLS_VERBOSE, "[makeLocalGrantor] aborting {} and {}", (Object)myLockGrantorId, (Object)myGrantor);
                                }
                                this.nullLockGrantorId(myLockGrantorId);
                                if (myGrantor.isDestroyed() != false) return var9_18;
                                myGrantor.destroy();
                                return var9_18;
                            }
                            finally {
                                if (myGrantor.isInitializing() && !this.dm.getCancelCriterion().isCancelInProgress()) {
                                    DLockService.logger.error(LogMarker.DLS_MARKER, (Message)LocalizedMessage.create(LocalizedStrings.DLockService_GRANTOR_IS_STILL_INITIALIZING));
                                }
                                if (!(success || myGrantor.isDestroyed() || this.dm.getCancelCriterion().isCancelInProgress())) {
                                    DLockService.logger.error(LogMarker.DLS_MARKER, (Message)LocalizedMessage.create(LocalizedStrings.DLockService_GRANTOR_CREATION_WAS_ABORTED_BUT_GRANTOR_WAS_NOT_DESTROYED));
                                }
                            }
                        }
                        if (isDebugEnabled_DLS) {
                            DLockService.logger.trace(LogMarker.DLS_VERBOSE, "{} failed to depose {}", (Object)this.deposingLockGrantorId, (Object)myLockGrantorId);
                        }
                        this.deposingLockGrantorId = null;
lbl60:
                        // 2 sources

                        if (this.setLockGrantorId(myLockGrantorId, myGrantor)) break block75;
                        if (isDebugEnabled_DLS) {
                            DLockService.logger.trace(LogMarker.DLS_VERBOSE, "[getLockGrantorId] failed to create {} because current grantor is {}", (Object)myLockGrantorId, (Object)this.lockGrantorId);
                        }
                        var9_19 = false;
                        // MONITOREXIT : var7_7
                        try {
                            if (success) {
                                if (this.isDestroyed() == false) return var9_19;
                            }
                            if (isDebugEnabled_DLS) {
                                DLockService.logger.trace(LogMarker.DLS_VERBOSE, "[makeLocalGrantor] aborting {} and {}", (Object)myLockGrantorId, (Object)myGrantor);
                            }
                            this.nullLockGrantorId(myLockGrantorId);
                            if (myGrantor.isDestroyed() != false) return var9_19;
                            myGrantor.destroy();
                            return var9_19;
                        }
                        finally {
                            if (myGrantor.isInitializing() && !this.dm.getCancelCriterion().isCancelInProgress()) {
                                DLockService.logger.error(LogMarker.DLS_MARKER, (Message)LocalizedMessage.create(LocalizedStrings.DLockService_GRANTOR_IS_STILL_INITIALIZING));
                            }
                            if (!(success || myGrantor.isDestroyed() || this.dm.getCancelCriterion().isCancelInProgress())) {
                                DLockService.logger.error(LogMarker.DLS_MARKER, (Message)LocalizedMessage.create(LocalizedStrings.DLockService_GRANTOR_CREATION_WAS_ABORTED_BUT_GRANTOR_WAS_NOT_DESTROYED));
                            }
                        }
                    }
                    // MONITOREXIT : var7_7
                    if (!needsRecovery || (recovered = DLockRecoverGrantorProcessor.recoverLockGrantor(this.dm.getDistributionManagerIds(), this, myGrantor, this.dm, elder))) break block76;
                    this.checkDestroyed();
                    var8_15 = false;
                    try {
                        if (success) {
                            if (this.isDestroyed() == false) return var8_15;
                        }
                        if (isDebugEnabled_DLS) {
                            DLockService.logger.trace(LogMarker.DLS_VERBOSE, "[makeLocalGrantor] aborting {} and {}", (Object)myLockGrantorId, (Object)myGrantor);
                        }
                        this.nullLockGrantorId(myLockGrantorId);
                        if (myGrantor.isDestroyed() != false) return var8_15;
                        myGrantor.destroy();
                        return var8_15;
                    }
                    finally {
                        if (myGrantor.isInitializing() && !this.dm.getCancelCriterion().isCancelInProgress()) {
                            DLockService.logger.error(LogMarker.DLS_MARKER, (Message)LocalizedMessage.create(LocalizedStrings.DLockService_GRANTOR_IS_STILL_INITIALIZING));
                        }
                        if (!(success || myGrantor.isDestroyed() || this.dm.getCancelCriterion().isCancelInProgress())) {
                            DLockService.logger.error(LogMarker.DLS_MARKER, (Message)LocalizedMessage.create(LocalizedStrings.DLockService_GRANTOR_CREATION_WAS_ABORTED_BUT_GRANTOR_WAS_NOT_DESTROYED));
                        }
                    }
                }
                recovered = this.lockGrantorIdLock;
                // MONITORENTER : recovered
                if (this.isDestroyed()) {
                    this.checkDestroyed();
                }
                if (this.deposingLockGrantorId == null) ** GOTO lbl138
                if (!this.deposingLockGrantorId.isNewerThan(myLockGrantorId)) break block77;
                if (isDebugEnabled_DLS) {
                    DLockService.logger.trace(LogMarker.DLS_VERBOSE, "Failed to create {} because I was deposed by {}", (Object)myLockGrantorId, (Object)this.deposingLockGrantorId);
                }
                this.deposingLockGrantorId = null;
                var8_16 = false;
                // MONITOREXIT : recovered
                try {
                    if (success) {
                        if (this.isDestroyed() == false) return var8_16;
                    }
                    if (isDebugEnabled_DLS) {
                        DLockService.logger.trace(LogMarker.DLS_VERBOSE, "[makeLocalGrantor] aborting {} and {}", (Object)myLockGrantorId, (Object)myGrantor);
                    }
                    this.nullLockGrantorId(myLockGrantorId);
                    if (myGrantor.isDestroyed() != false) return var8_16;
                    myGrantor.destroy();
                    return var8_16;
                }
                finally {
                    if (myGrantor.isInitializing() && !this.dm.getCancelCriterion().isCancelInProgress()) {
                        DLockService.logger.error(LogMarker.DLS_MARKER, (Message)LocalizedMessage.create(LocalizedStrings.DLockService_GRANTOR_IS_STILL_INITIALIZING));
                    }
                    if (!(success || myGrantor.isDestroyed() || this.dm.getCancelCriterion().isCancelInProgress())) {
                        DLockService.logger.error(LogMarker.DLS_MARKER, (Message)LocalizedMessage.create(LocalizedStrings.DLockService_GRANTOR_CREATION_WAS_ABORTED_BUT_GRANTOR_WAS_NOT_DESTROYED));
                    }
                }
            }
            try {
                if (isDebugEnabled_DLS) {
                    DLockService.logger.trace(LogMarker.DLS_VERBOSE, "{} failed to depose {}", (Object)this.deposingLockGrantorId, (Object)myLockGrantorId);
                }
                this.deposingLockGrantorId = null;
lbl138:
                // 2 sources

                if (this.checkLockGrantorId(myLockGrantorId)) {
                    success = myGrantor.makeReady(true);
                }
                // MONITOREXIT : recovered
                recovered = success;
                return recovered;
            }
            catch (VirtualMachineError err) {
                SystemFailure.initiateFailure(err);
                throw err;
            }
            catch (Error e) {
                SystemFailure.checkFailure();
                if (isDebugEnabled_DLS == false) throw e;
                DLockService.logger.trace(LogMarker.DLS_VERBOSE, "[makeLocalGrantor] throwing Error", (Throwable)e);
                throw e;
            }
            catch (RuntimeException e) {
                if (isDebugEnabled_DLS == false) throw e;
                DLockService.logger.trace(LogMarker.DLS_VERBOSE, "[makeLocalGrantor] throwing RuntimeException", (Throwable)e);
                throw e;
            }
        }
        catch (Throwable var18_26) {
            throw var18_26;
        }
        finally {
            block78: {
                try {
                    if (success && !this.isDestroyed()) break block78;
                    if (isDebugEnabled_DLS) {
                        DLockService.logger.trace(LogMarker.DLS_VERBOSE, "[makeLocalGrantor] aborting {} and {}", (Object)myLockGrantorId, (Object)myGrantor);
                    }
                    this.nullLockGrantorId(myLockGrantorId);
                    if (!myGrantor.isDestroyed()) {
                        myGrantor.destroy();
                    }
                }
                finally {
                    if (myGrantor.isInitializing() && !this.dm.getCancelCriterion().isCancelInProgress()) {
                        DLockService.logger.error(LogMarker.DLS_MARKER, (Message)LocalizedMessage.create(LocalizedStrings.DLockService_GRANTOR_IS_STILL_INITIALIZING));
                    }
                    if (!(success || myGrantor.isDestroyed() || this.dm.getCancelCriterion().isCancelInProgress())) {
                        DLockService.logger.error(LogMarker.DLS_MARKER, (Message)LocalizedMessage.create(LocalizedStrings.DLockService_GRANTOR_CREATION_WAS_ABORTED_BUT_GRANTOR_WAS_NOT_DESTROYED));
                    }
                }
            }
        }
    }

    private boolean setLockGrantorId(LockGrantorId newLockGrantorId) {
        Assert.assertHoldsLock(this.lockGrantorIdLock, true);
        if (this.equalsLockGrantorId(newLockGrantorId)) {
            return true;
        }
        if (!newLockGrantorId.hasLockGrantorVersion()) {
            this.lockGrantorId = newLockGrantorId;
            return true;
        }
        if (newLockGrantorId.isRemote() && this.lockGrantorId != null && this.lockGrantorId.hasLockGrantorVersion()) {
            if (logger.isTraceEnabled(LogMarker.DLS_VERBOSE)) {
                logger.trace(LogMarker.DLS_VERBOSE, "[setLockGrantorId] tried to replace {} with {}", (Object)this.lockGrantorId, (Object)newLockGrantorId);
            }
            return false;
        }
        if (newLockGrantorId.isNewerThan(this.lockGrantorId)) {
            this.lockGrantorId = newLockGrantorId;
            return true;
        }
        return false;
    }

    private boolean setLockGrantorId(LockGrantorId localLockGrantorId, DLockGrantor localGrantor) {
        Assert.assertHoldsLock(this.lockGrantorIdLock, true);
        Assert.assertTrue(localLockGrantorId.isLocal(this.getSerialNumber()));
        if (this.setLockGrantorId(localLockGrantorId)) {
            this.grantor = localGrantor;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deposeOlderLockGrantorId(LockGrantorId newLockGrantorId) {
        LockGrantorId deposedLockGrantorId = null;
        boolean isDebugEnabled_DLS = logger.isTraceEnabled(LogMarker.DLS_VERBOSE);
        Object object = this.lockGrantorIdLock;
        synchronized (object) {
            if (isDebugEnabled_DLS) {
                logger.trace(LogMarker.DLS_VERBOSE, "[deposeOlderLockGrantorId] pre-deposing {} for new {}", deposedLockGrantorId, (Object)newLockGrantorId);
            }
            this.deposingLockGrantorId = newLockGrantorId;
            deposedLockGrantorId = this.lockGrantorId;
        }
        if (deposedLockGrantorId != null && deposedLockGrantorId.hasLockGrantorVersion() && newLockGrantorId.isNewerThan(deposedLockGrantorId)) {
            if (isDebugEnabled_DLS) {
                logger.trace(LogMarker.DLS_VERBOSE, "[deposeOlderLockGrantorId] post-deposing {} for new {}", (Object)deposedLockGrantorId, (Object)newLockGrantorId);
            }
            this.nullLockGrantorId(deposedLockGrantorId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private boolean nullLockGrantorId(LockGrantorId oldLockGrantorId) {
        DLockGrantor grantorToDestroy;
        block11: {
            boolean bl;
            Assert.assertHoldsLock(this.destroyLock, false);
            Assert.assertHoldsLock(this.lockGrantorIdLock, false);
            if (oldLockGrantorId == null) {
                return false;
            }
            grantorToDestroy = null;
            try {
                Object object = this.lockGrantorIdLock;
                // MONITORENTER : object
                if (!this.equalsLockGrantorId(oldLockGrantorId) && (!oldLockGrantorId.isLocal(this.getSerialNumber()) || !this.isMakingLockGrantor())) break block11;
                if (oldLockGrantorId.isLocal(this.getSerialNumber()) && this.isLockGrantorVersion(this.grantor, oldLockGrantorId.getLockGrantorVersion())) {
                    grantorToDestroy = this.grantor;
                    this.grantor = null;
                }
                this.lockGrantorId = null;
                bl = true;
                // MONITOREXIT : object
                if (grantorToDestroy == null) return bl;
            }
            catch (Throwable throwable) {
                if (grantorToDestroy == null) throw throwable;
                if (logger.isTraceEnabled(LogMarker.DLS_VERBOSE)) {
                    logger.trace(LogMarker.DLS_VERBOSE, "[nullLockGrantorId] destroying {}", (Object)grantorToDestroy);
                }
                grantorToDestroy.destroy();
                throw throwable;
            }
            if (logger.isTraceEnabled(LogMarker.DLS_VERBOSE)) {
                logger.trace(LogMarker.DLS_VERBOSE, "[nullLockGrantorId] destroying {}", (Object)grantorToDestroy);
            }
            grantorToDestroy.destroy();
            return bl;
        }
        boolean bl = false;
        // MONITOREXIT : object
        if (grantorToDestroy == null) return bl;
        if (logger.isTraceEnabled(LogMarker.DLS_VERBOSE)) {
            logger.trace(LogMarker.DLS_VERBOSE, "[nullLockGrantorId] destroying {}", (Object)grantorToDestroy);
        }
        grantorToDestroy.destroy();
        return bl;
    }

    private boolean isLockGrantorVersion(DLockGrantor dlockGrantor, long grantorVersion) {
        if (dlockGrantor == null) {
            return false;
        }
        return dlockGrantor.getVersionId() == grantorVersion;
    }

    private boolean equalsLockGrantorId(LockGrantorId someLockGrantor) {
        Assert.assertHoldsLock(this.lockGrantorIdLock, true);
        if (someLockGrantor == null) {
            return this.lockGrantorId == null;
        }
        return someLockGrantor.equals(this.lockGrantorId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LockGrantorId peekLockGrantorId() {
        InternalDistributedMember lockGrantorMember;
        GrantorInfo gi;
        LockGrantorId theLockGrantorId;
        long statStart;
        block7: {
            boolean getLockGrantorIdFailed;
            LockGrantorId lockGrantorId;
            Assert.assertHoldsLock(this.destroyLock, false);
            Object object = this.lockGrantorIdLock;
            synchronized (object) {
                LockGrantorId currentLockGrantorId = this.lockGrantorId;
                if (currentLockGrantorId != null) {
                    return currentLockGrantorId;
                }
            }
            statStart = this.getStats().startGrantorWait();
            theLockGrantorId = null;
            try {
                gi = this.peekGrantor();
                lockGrantorMember = gi.getId();
                if (lockGrantorMember != null) break block7;
                lockGrantorId = null;
                getLockGrantorIdFailed = theLockGrantorId == null;
            }
            catch (Throwable throwable) {
                boolean getLockGrantorIdFailed2 = theLockGrantorId == null;
                this.getStats().endGrantorWait(statStart, getLockGrantorIdFailed2);
                throw throwable;
            }
            this.getStats().endGrantorWait(statStart, getLockGrantorIdFailed);
            return lockGrantorId;
        }
        LockGrantorId lockGrantorId = theLockGrantorId = new LockGrantorId(this.dm, lockGrantorMember, gi.getVersionId(), gi.getSerialNumber());
        boolean getLockGrantorIdFailed = theLockGrantorId == null;
        this.getStats().endGrantorWait(statStart, getLockGrantorIdFailed);
        return lockGrantorId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incActiveLocks() {
        Object object = this.destroyLock;
        synchronized (object) {
            this.checkDestroyed();
            ++this.activeLocks;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decActiveLocks() {
        Object object = this.destroyLock;
        synchronized (object) {
            --this.activeLocks;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LockGrantorId waitForLockGrantorFutureResult(FutureResult lockGrantorFutureResultRef, long timeToWait, TimeUnit timeUnit) {
        LockGrantorId lockGrantorIdRef = null;
        while (lockGrantorIdRef == null) {
            boolean interrupted = Thread.interrupted();
            try {
                this.checkDestroyed();
                if (timeToWait == 0L) {
                    lockGrantorIdRef = (LockGrantorId)lockGrantorFutureResultRef.get();
                    continue;
                }
                lockGrantorIdRef = (LockGrantorId)lockGrantorFutureResultRef.get(timeToWait, timeUnit);
            }
            catch (TimeoutException e) {
                break;
            }
            catch (InterruptedException e) {
                interrupted = true;
                this.dm.getCancelCriterion().checkCancelInProgress(e);
                if (!lockGrantorFutureResultRef.isCancelled()) continue;
                this.checkDestroyed();
                break;
            }
            catch (CancellationException e) {
                this.checkDestroyed();
                break;
            }
            finally {
                if (!interrupted) continue;
                Thread.currentThread().interrupt();
            }
        }
        return lockGrantorIdRef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void notLockGrantorId(LockGrantorId notLockGrantorId, long timeToWait, TimeUnit timeUnit) {
        block41: {
            block40: {
                if (notLockGrantorId.isLocal(this.getSerialNumber())) {
                    if (DLockService.logger.isTraceEnabled(LogMarker.DLS_VERBOSE)) {
                        DLockService.logger.trace(LogMarker.DLS_VERBOSE, "notLockGrantorId {} returning early because notGrantor {} was equal to the local dm {}", (Object)this.serviceName, (Object)notLockGrantorId, (Object)this.dm.getId());
                    }
                    return;
                }
                ownLockGrantorFutureResult = false;
                lockGrantorFutureResultRef = null;
                statStart = -1L;
                currentLockGrantorId = null;
                Assert.assertHoldsLock(this.destroyLock, false);
                var10_8 = this.lockGrantorIdLock;
                synchronized (var10_8) {
                    block42: {
                        currentLockGrantorId = this.lockGrantorId;
                        if (this.lockGrantorFutureResult == null) break block42;
                        lockGrantorFutureResultRef = this.lockGrantorFutureResult;
                        ** GOTO lbl41
                    }
                    if (notLockGrantorId.sameAs(currentLockGrantorId)) ** break block39
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 12] lbl20 : MonitorExitStatement: MONITOREXIT : var10_8
                    var11_9 = this.lockGrantorIdLock;
                }
                synchronized (var11_9) {
                    if (statStart > -1L) {
                        this.getStats().endGrantorWait(statStart, false);
                    }
                    if (ownLockGrantorFutureResult) {
                        Assert.assertTrue(this.lockGrantorFutureResult == lockGrantorFutureResultRef);
                        lockGrantorFutureResultRef.cancel(false);
                        this.lockGrantorFutureResult = null;
                    }
                }
                return;
                {
                    ownLockGrantorFutureResult = true;
                    this.lockGrantorFutureResult = lockGrantorFutureResultRef = new FutureResult(this.dm.getCancelCriterion());
lbl41:
                    // 2 sources

                    // MONITOREXIT @DISABLED, blocks:[3, 4, 12] lbl41 : MonitorExitStatement: MONITOREXIT : var10_8
                    {
                        catch (Throwable var13_13) {
                            throw var13_13;
                        }
                    }
                    statStart = this.getStats().startGrantorWait();
                    if (ownLockGrantorFutureResult) break block40;
                    if (timeToWait >= 0L) {
                        this.waitForLockGrantorFutureResult(lockGrantorFutureResultRef, timeToWait, timeUnit);
                    }
                    var10_8 = this.lockGrantorIdLock;
                }
                synchronized (var10_8) {
                    if (statStart > -1L) {
                        this.getStats().endGrantorWait(statStart, false);
                    }
                    if (ownLockGrantorFutureResult) {
                        Assert.assertTrue(this.lockGrantorFutureResult == lockGrantorFutureResultRef);
                        lockGrantorFutureResultRef.cancel(false);
                        this.lockGrantorFutureResult = null;
                    }
                }
                return;
            }
            elder = this.getElderId();
            Assert.assertTrue(elder != null);
            elderLockGrantorId = null;
            gi = this.peekGrantor();
            if (gi.getId() != null) {
                elderLockGrantorId = new LockGrantorId(this.dm, gi.getId(), gi.getVersionId(), gi.getSerialNumber());
            }
            if (!notLockGrantorId.sameAs(elderLockGrantorId)) break block41;
            this.sleep(DLockService.NOT_GRANTOR_SLEEP);
            var13_14 = this.lockGrantorIdLock;
            {
                catch (Throwable var17_18) {
                    var18_19 = this.lockGrantorIdLock;
                    synchronized (var18_19) {
                        if (statStart > -1L) {
                            this.getStats().endGrantorWait(statStart, false);
                        }
                        if (ownLockGrantorFutureResult) {
                            Assert.assertTrue(this.lockGrantorFutureResult == lockGrantorFutureResultRef);
                            lockGrantorFutureResultRef.cancel(false);
                            this.lockGrantorFutureResult = null;
                        }
                    }
                    throw var17_18;
                }
            }
            synchronized (var13_14) {
                if (statStart > -1L) {
                    this.getStats().endGrantorWait(statStart, false);
                }
                if (ownLockGrantorFutureResult) {
                    Assert.assertTrue(this.lockGrantorFutureResult == lockGrantorFutureResultRef);
                    lockGrantorFutureResultRef.cancel(false);
                    this.lockGrantorFutureResult = null;
                }
            }
            return;
        }
        this.nullLockGrantorId(notLockGrantorId);
        if (DLockService.logger.isTraceEnabled(LogMarker.DLS_VERBOSE)) {
            DLockService.logger.trace(LogMarker.DLS_VERBOSE, "notLockGrantorId cleared lockGrantorId for service {}", (Object)this.serviceName);
        }
        var10_8 = this.lockGrantorIdLock;
        synchronized (var10_8) {
            if (statStart > -1L) {
                this.getStats().endGrantorWait(statStart, false);
            }
            if (ownLockGrantorFutureResult) {
                Assert.assertTrue(this.lockGrantorFutureResult == lockGrantorFutureResultRef);
                lockGrantorFutureResultRef.cancel(false);
                this.lockGrantorFutureResult = null;
            }
        }
    }

    void clearGrantor(long grantorVersion, boolean withLocks) {
        GrantorRequestProcessor.clearGrantor(grantorVersion, this, this.getSerialNumber(), this.ds, withLocks);
    }

    private GrantorInfo getGrantorRequest() {
        return GrantorRequestProcessor.getGrantor(this, this.getSerialNumber(), this.ds);
    }

    private GrantorInfo peekGrantor() {
        return GrantorRequestProcessor.peekGrantor(this, this.ds);
    }

    private GrantorInfo becomeGrantor(InternalDistributedMember predecessor) {
        return GrantorRequestProcessor.becomeGrantor(this, this.getSerialNumber(), predecessor, this.ds);
    }

    @Override
    public void becomeLockGrantor() {
        this.becomeLockGrantor(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DLockGrantor getGrantor() {
        Assert.assertHoldsLock(this.destroyLock, false);
        Object object = this.lockGrantorIdLock;
        synchronized (object) {
            return this.grantor;
        }
    }

    public DLockGrantor getGrantorForElderRecovery() {
        return this.getGrantor();
    }

    public DLockGrantor getGrantorWithNoSync() {
        return this.grantor;
    }

    /*
     * Exception decompiling
     */
    void becomeLockGrantor(InternalDistributedMember predecessor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [12[MONITOR], 25[UNCONDITIONALDOLOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public boolean isLockGrantor() {
        if (this.isDestroyed()) {
            return false;
        }
        return this.isCurrentlyLockGrantor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isMakingLockGrantor() {
        Assert.assertHoldsLock(this.destroyLock, false);
        Object object = this.lockGrantorIdLock;
        synchronized (object) {
            return this.lockGrantorId != null && this.lockGrantorId.isLocal(this.getSerialNumber()) && this.grantor != null && this.grantor.isInitializing();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isCurrentlyOrIsMakingLockGrantor() {
        Assert.assertHoldsLock(this.destroyLock, false);
        Object object = this.lockGrantorIdLock;
        synchronized (object) {
            return this.lockGrantorId != null && this.lockGrantorId.isLocal(this.getSerialNumber());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isCurrentlyLockGrantor() {
        Assert.assertHoldsLock(this.destroyLock, false);
        Object object = this.lockGrantorIdLock;
        synchronized (object) {
            return this.lockGrantorId != null && this.lockGrantorId.isLocal(this.getSerialNumber()) && this.grantor != null && this.grantor.isReady();
        }
    }

    @Override
    public void freeResources(Object name) {
        this.checkDestroyed();
        if (name == null) {
            this.removeAllUnusedTokens();
        } else {
            this.removeTokenIfUnused(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeTokenIfUnused(Object name) {
        Map<Object, DLockToken> map = this.tokens;
        synchronized (map) {
            if (this.destroyed) {
                this.getStats().incFreeResourcesFailed();
                return false;
            }
            DLockToken token = this.tokens.get(name);
            if (token != null) {
                DLockToken dLockToken = token;
                synchronized (dLockToken) {
                    if (!token.isBeingUsed()) {
                        if (logger.isTraceEnabled(LogMarker.DLS_VERBOSE)) {
                            logger.trace(LogMarker.DLS_VERBOSE, "Freeing {} in {}", (Object)token, (Object)this);
                        }
                        this.removeTokenFromMap(name);
                        token.destroy();
                        this.getStats().incTokens(-1);
                        this.getStats().incFreeResourcesCompleted();
                        return true;
                    }
                }
            }
        }
        this.getStats().incFreeResourcesFailed();
        return false;
    }

    protected Object removeTokenFromMap(Object name) {
        return this.tokens.remove(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAllUnusedTokens() {
        Map<Object, DLockToken> map = this.tokens;
        synchronized (map) {
            DLockToken dLockToken;
            DLockToken token;
            if (this.destroyed) {
                this.getStats().incFreeResourcesFailed();
                return;
            }
            HashSet<DLockToken> unusedTokens = Collections.EMPTY_SET;
            Iterator<DLockToken> iter = this.tokens.values().iterator();
            while (iter.hasNext()) {
                dLockToken = token = iter.next();
                synchronized (dLockToken) {
                    if (!token.isBeingUsed()) {
                        if (logger.isTraceEnabled(LogMarker.DLS_VERBOSE)) {
                            logger.trace(LogMarker.DLS_VERBOSE, "Freeing {} in {}", (Object)token, (Object)this);
                        }
                        if (unusedTokens == Collections.EMPTY_SET) {
                            unusedTokens = new HashSet<DLockToken>();
                        }
                        unusedTokens.add(token);
                    } else {
                        this.getStats().incFreeResourcesFailed();
                    }
                }
            }
            iter = unusedTokens.iterator();
            while (iter.hasNext()) {
                dLockToken = token = iter.next();
                synchronized (dLockToken) {
                    int tokensSizeBefore = this.tokens.size();
                    Object obj = this.removeTokenFromMap(token.getName());
                    Assert.assertTrue(obj != null);
                    int tokensSizeAfter = this.tokens.size();
                    Assert.assertTrue(tokensSizeBefore - tokensSizeAfter == 1);
                    token.destroy();
                    this.getStats().incTokens(-1);
                    this.getStats().incFreeResourcesCompleted();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAllTokens() {
        Map<Object, DLockToken> map = this.tokens;
        synchronized (map) {
            Assert.assertTrue(this.destroyed);
            Iterator<DLockToken> iter = this.tokens.values().iterator();
            while (iter.hasNext()) {
                DLockToken token;
                DLockToken dLockToken = token = iter.next();
                synchronized (dLockToken) {
                    token.destroy();
                }
            }
            this.getStats().incTokens(-this.tokens.size());
            this.tokens.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isHeldByCurrentThread(Object name) {
        this.checkDestroyed();
        Map<Object, DLockToken> map = this.tokens;
        synchronized (map) {
            DLockToken token = this.basicGetToken(name);
            if (token == null) {
                return false;
            }
            DLockToken dLockToken = token;
            synchronized (dLockToken) {
                token.checkForExpiration();
                return token.isLeaseHeldByCurrentThread();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isHeldByThreadId(Object name, int threadId) {
        this.checkDestroyed();
        Map<Object, DLockToken> map = this.tokens;
        synchronized (map) {
            DLockToken token = this.basicGetToken(name);
            if (token == null) {
                return false;
            }
            DLockToken dLockToken = token;
            synchronized (dLockToken) {
                token.checkForExpiration();
                if (token.getLesseeThread() == null) {
                    return false;
                }
                return token.getLesseeThread().getThreadId() == threadId;
            }
        }
    }

    @Override
    public boolean isLockingSuspendedByCurrentThread() {
        this.checkDestroyed();
        return this.isHeldByCurrentThread(SUSPEND_LOCKING_TOKEN);
    }

    @Override
    public boolean lock(Object name, long waitTimeMillis, long leaseTimeMillis) {
        boolean tryLock = false;
        return this.lock(name, waitTimeMillis, leaseTimeMillis, tryLock);
    }

    public boolean lock(Object name, long waitTimeMillis, long leaseTimeMillis, boolean tryLock) {
        return this.lock(name, waitTimeMillis, leaseTimeMillis, tryLock, false);
    }

    public boolean lock(Object name, long waitTimeMillis, long leaseTimeMillis, boolean tryLock, boolean disallowReentrant) {
        return this.lock(name, waitTimeMillis, leaseTimeMillis, tryLock, false, false);
    }

    public boolean lock(Object name, long waitTimeMillis, long leaseTimeMillis, boolean tryLock, boolean disallowReentrant, boolean diableAlerts) {
        this.checkDestroyed();
        try {
            boolean interruptible = false;
            return this.lockInterruptibly(name, waitTimeMillis, leaseTimeMillis, tryLock, interruptible, disallowReentrant, diableAlerts);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            logger.error(LogMarker.DLS_MARKER, (Message)LocalizedMessage.create(LocalizedStrings.DLockService_LOCK_WAS_INTERRUPTED), (Throwable)ex);
            Assert.assertTrue(false, "lock() was interrupted: " + ex.getMessage());
            return false;
        }
    }

    @Override
    public boolean lockInterruptibly(Object name, long waitTimeMillis, long leaseTimeMillis) throws InterruptedException {
        this.checkDestroyed();
        boolean tryLock = false;
        boolean interruptible = true;
        return this.lockInterruptibly(name, waitTimeMillis, leaseTimeMillis, tryLock, interruptible, false);
    }

    private void sleep(long millis, boolean interruptible) throws InterruptedException {
        if (interruptible) {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            Thread.sleep(millis);
            return;
        }
        this.sleep(millis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sleep(long millis) {
        StopWatch timer = new StopWatch(true);
        while (true) {
            boolean interrupted = Thread.interrupted();
            try {
                long timeLeft = millis - timer.elapsedTimeMillis();
                if (timeLeft <= 0L) break;
                Thread.sleep(timeLeft);
            }
            catch (InterruptedException e) {
                interrupted = true;
                continue;
            }
            finally {
                if (!interrupted) continue;
                Thread.currentThread().interrupt();
                continue;
            }
            break;
        }
    }

    protected DLockRequestProcessor createRequestProcessor(LockGrantorId grantorId, Object name, int threadId, long startTime, long requestLeaseTime, long requestWaitTime, boolean reentrant, boolean tryLock) {
        return this.createRequestProcessor(grantorId, name, threadId, startTime, requestLeaseTime, requestWaitTime, reentrant, tryLock, false);
    }

    protected DLockRequestProcessor createRequestProcessor(LockGrantorId grantorId, Object name, int threadId, long startTime, long requestLeaseTime, long requestWaitTime, boolean reentrant, boolean tryLock, boolean disableAlerts) {
        return new DLockRequestProcessor(grantorId, this, name, threadId, startTime, requestLeaseTime, requestWaitTime, reentrant, tryLock, disableAlerts, this.dm);
    }

    protected boolean callReleaseProcessor(InternalDistributedMember grantor, Object name, boolean lockBatch, int lockId) {
        return DLockService.callReleaseProcessor(this.dm, this.serviceName, grantor, name, lockBatch, lockId);
    }

    protected static boolean callReleaseProcessor(DistributionManager dm, String serviceName, InternalDistributedMember grantor, Object name, boolean lockBatch, int lockId) {
        DLockReleaseProcessor processor = new DLockReleaseProcessor(dm, grantor, serviceName, name);
        return processor.release(grantor, serviceName, lockBatch, lockId);
    }

    public boolean lockInterruptibly(Object name, long waitTimeMillis, long leaseTimeMillis, boolean tryLock, boolean interruptible, boolean disallowReentrant) throws InterruptedException {
        return this.lockInterruptibly(name, waitTimeMillis, leaseTimeMillis, tryLock, interruptible, disallowReentrant, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean lockInterruptibly(Object name, long waitTimeMillis, long leaseTimeMillis, boolean tryLock, boolean interruptible, boolean disallowReentrant, boolean disableAlerts) throws InterruptedException {
        this.checkDestroyed();
        boolean interrupted = Thread.interrupted();
        if (interrupted && interruptible) {
            throw new InterruptedException();
        }
        try {
            long waitLimit;
            long statStart = this.getStats().startLockWait();
            long startTime = DLockService.getLockTimeStamp(this.dm);
            long requestWaitTime = waitTimeMillis;
            long requestLeaseTime = leaseTimeMillis;
            if (requestLeaseTime == -1L) {
                requestLeaseTime = Long.MAX_VALUE;
            }
            if (requestWaitTime == -1L) {
                requestWaitTime = Long.MAX_VALUE;
            }
            if ((waitLimit = startTime + requestWaitTime) < 0L) {
                waitLimit = Long.MAX_VALUE;
            }
            if (logger.isTraceEnabled(LogMarker.DLS_VERBOSE)) {
                logger.trace(LogMarker.DLS_VERBOSE, "{}, name: {} - entering lock()", (Object)this, name);
            }
            DLockToken token = this.getOrCreateToken(name);
            boolean gotLock = false;
            this.blockedOn.set(name);
            try {
                ThreadRequestState requestState = (ThreadRequestState)this.threadRequestState.get();
                if (requestState == null) {
                    requestState = new ThreadRequestState(this.incThreadSequence(), interruptible);
                    this.threadRequestState.set(requestState);
                } else {
                    requestState.interruptible = interruptible;
                }
                int threadId = requestState.threadId;
                long leaseExpireTime = 0L;
                boolean keepTrying = true;
                int lockId = -1;
                this.incActiveLocks();
                while (keepTrying) {
                    DLockToken dLockToken;
                    this.checkDestroyed();
                    boolean bl = interrupted = Thread.interrupted() || interrupted;
                    if (interrupted && interruptible) {
                        throw new InterruptedException();
                    }
                    boolean reentrant = false;
                    int recursionBefore = -1;
                    DLockToken dLockToken2 = token;
                    synchronized (dLockToken2) {
                        token.checkForExpiration();
                        if (token.isLeaseHeldByCurrentThread()) {
                            if (logger.isTraceEnabled(LogMarker.DLS_VERBOSE)) {
                                logger.trace(LogMarker.DLS_VERBOSE, "{} , name: {} - lock() is reentrant: {}", (Object)this, name, (Object)token);
                            }
                            if ((reentrant = true) && disallowReentrant) {
                                throw new IllegalStateException(LocalizedStrings.DLockService_0_ATTEMPTED_TO_REENTER_NONREENTRANT_LOCK_1.toLocalizedString(Thread.currentThread(), token));
                            }
                            recursionBefore = token.getRecursion();
                            lockId = token.getLeaseId();
                            if (lockId < 0) {
                                continue;
                            }
                        }
                    }
                    LockGrantorId theLockGrantorId = this.getLockGrantorId();
                    if (reentrant) {
                        Assert.assertTrue(lockId > -1, "Reentrant lock must have lockId > -1");
                    } else {
                        lockId = -1;
                    }
                    DLockRequestProcessor processor = this.createRequestProcessor(theLockGrantorId, name, threadId, startTime, requestLeaseTime, requestWaitTime, reentrant, tryLock, disableAlerts);
                    if (reentrant) {
                        dLockToken = token;
                        synchronized (dLockToken) {
                            if (!token.isLeaseHeldByCurrentThread()) {
                                reentrant = false;
                                recursionBefore = -1;
                                token.checkForExpiration();
                            }
                        }
                    } else {
                        lockId = processor.getProcessorId();
                    }
                    gotLock = processor.requestLock(interruptible, lockId);
                    if (logger.isTraceEnabled(LogMarker.DLS_VERBOSE)) {
                        logger.trace(LogMarker.DLS_VERBOSE, "Grantor {} replied {}", (Object)theLockGrantorId, (Object)processor.getResponseCodeString());
                    }
                    if (gotLock) {
                        int recursion;
                        leaseExpireTime = processor.getLeaseExpireTime();
                        if (!this.grantLocalDLockAfterObtainingRemoteLock(name, token, threadId, leaseExpireTime, lockId, theLockGrantorId, processor, recursion = recursionBefore + 1)) continue;
                        if (logger.isTraceEnabled(LogMarker.DLS_VERBOSE)) {
                            logger.trace(LogMarker.DLS_VERBOSE, "{}, name: {} - granted lock: {}", (Object)this, name, (Object)token);
                        }
                        keepTrying = false;
                        continue;
                    }
                    if (processor.repliedDestroyed()) {
                        this.checkDestroyed();
                        Assert.assertTrue(this.isDestroyed(), "Grantor reports service " + this + " is destroyed: " + name);
                        continue;
                    }
                    if (processor.repliedNotGrantor() || processor.hadNoResponse()) {
                        long waitForGrantorTime = waitLimit - token.getCurrentTime();
                        if (waitForGrantorTime <= 0L) {
                            waitForGrantorTime = 100L;
                        }
                        this.notLockGrantorId(theLockGrantorId, waitForGrantorTime, TimeUnit.MILLISECONDS);
                        continue;
                    }
                    if (processor.repliedNotHolder()) {
                        reentrant = false;
                        recursionBefore = -1;
                        dLockToken = token;
                        synchronized (dLockToken) {
                            token.checkForExpiration();
                            if (token.isLeaseHeldByCurrentThread()) {
                                logger.warn(LogMarker.DLS_MARKER, (Message)LocalizedMessage.create(LocalizedStrings.DLockService_GRANTOR_REPORTS_REENTRANT_LOCK_NOT_HELD_0, token));
                                RemoteThread rThread = new RemoteThread(this.getDistributionManager().getId(), threadId);
                                token.releaseLock(lockId, rThread, false);
                            }
                            continue;
                        }
                    }
                    if (waitLimit > token.getCurrentTime() + 20L) {
                        this.sleep(20L, interruptible);
                    }
                    keepTrying = waitLimit > token.getCurrentTime();
                }
            }
            finally {
                this.getStats().endLockWait(statStart, gotLock);
                if (!gotLock) {
                    DLockToken dLockToken = token;
                    synchronized (dLockToken) {
                        token.decUsage();
                    }
                    this.freeResources(token.getName());
                }
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
                if (!gotLock && interruptible && Thread.interrupted()) {
                    throw new InterruptedException();
                }
                this.blockedOn.set(null);
            }
            if (logger.isTraceEnabled(LogMarker.DLS_VERBOSE)) {
                logger.trace(LogMarker.DLS_VERBOSE, "{}, name: {} - exiting lock() returning {}", (Object)this, name, (Object)gotLock);
            }
            boolean bl = gotLock;
            return bl;
        }
        finally {
            if (logger.isTraceEnabled(LogMarker.DLS_VERBOSE)) {
                logger.trace(LogMarker.DLS_VERBOSE, "{}, name: {} - exiting lock() without returning value", (Object)this, name);
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean grantLocalDLockAfterObtainingRemoteLock(Object name, DLockToken token, int threadId, long leaseExpireTime, int lockId, LockGrantorId theLockGrantorId, DLockRequestProcessor processor, int recursion) {
        boolean needToReleaseOrphanedGrant = false;
        Assert.assertHoldsLock(this.destroyLock, false);
        Object object = this.lockGrantorIdLock;
        synchronized (object) {
            if (!this.checkLockGrantorId(theLockGrantorId)) {
                if (logger.isTraceEnabled(LogMarker.DLS_VERBOSE)) {
                    logger.trace(LogMarker.DLS_VERBOSE, "Cannot honor grant from {} because {} is now a grantor.", (Object)theLockGrantorId, (Object)this.lockGrantorId);
                }
            } else if (this.isDestroyed()) {
                if (logger.isTraceEnabled(LogMarker.DLS_VERBOSE)) {
                    logger.trace(LogMarker.DLS_VERBOSE, "Cannot honor grant from {} because this lock service has been destroyed.", (Object)theLockGrantorId);
                }
                needToReleaseOrphanedGrant = true;
            } else {
                Map<Object, DLockToken> map = this.tokens;
                synchronized (map) {
                    this.checkDestroyed();
                    Assert.assertTrue(token == this.basicGetToken(name));
                    RemoteThread rThread = new RemoteThread(this.getDistributionManager().getId(), threadId);
                    token.grantLock(leaseExpireTime, lockId, recursion, rThread);
                    return true;
                }
            }
        }
        if (needToReleaseOrphanedGrant) {
            processor.getResponse().releaseOrphanedGrant(this.dm);
        }
        return false;
    }

    @Override
    public void resumeLocking() {
        this.checkDestroyed();
        try {
            this.unlock(SUSPEND_LOCKING_TOKEN);
        }
        catch (IllegalStateException e) {
            this.checkDestroyed();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean suspendLocking(long waitTimeMillis) {
        block9: {
            long startTime = System.currentTimeMillis();
            long requestWaitTime = waitTimeMillis;
            boolean interrupted = false;
            while (true) {
                this.checkDestroyed();
                try {
                    boolean bl = this.suspendLockingInterruptibly(requestWaitTime, false);
                    return bl;
                }
                catch (InterruptedException ex) {
                    interrupted = true;
                    long millisPassed = System.currentTimeMillis() - startTime;
                    if (requestWaitTime < 0L) continue;
                    requestWaitTime = Math.max(0L, requestWaitTime - millisPassed);
                    if (requestWaitTime != 0L) continue;
                    if (interrupted) {
                        Thread.currentThread().interrupt();
                    }
                    break block9;
                }
                break;
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        return false;
    }

    @Override
    public boolean suspendLockingInterruptibly(long waitTimeMillis) throws InterruptedException {
        return this.suspendLockingInterruptibly(waitTimeMillis, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean suspendLockingInterruptibly(long waitTimeMillis, boolean interruptible) throws InterruptedException {
        this.checkDestroyed();
        boolean wasInterrupted = false;
        if (Thread.interrupted()) {
            if (interruptible) {
                throw new InterruptedException();
            }
            wasInterrupted = true;
        }
        try {
            if (this.isLockingSuspendedByCurrentThread()) {
                throw new IllegalStateException(LocalizedStrings.DLockService_CURRENT_THREAD_HAS_ALREADY_LOCKED_ENTIRE_SERVICE.toLocalizedString());
            }
            boolean tryLock = false;
            SuspendLockingToken suspendToken = SUSPEND_LOCKING_TOKEN;
            boolean gotToken = false;
            boolean keepTrying = true;
            long startTime = System.currentTimeMillis();
            long waitLimit = startTime + waitTimeMillis;
            if (waitLimit < 0L) {
                waitLimit = Long.MAX_VALUE;
            }
            while (!gotToken && keepTrying) {
                gotToken = this.lockInterruptibly(suspendToken, waitTimeMillis, -1L, tryLock, interruptible, false);
                keepTrying = !gotToken && waitLimit > System.currentTimeMillis();
            }
            boolean bl = gotToken;
            return bl;
        }
        finally {
            if (wasInterrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void unlock(Object name) throws LockNotHeldException, LeaseExpiredException {
        RemoteThread rThread;
        DLockToken token;
        int lockId;
        boolean unlocked;
        boolean hadRecursion;
        long statStart;
        boolean isDebugEnabled_DLS;
        block35: {
            isDebugEnabled_DLS = logger.isTraceEnabled(LogMarker.DLS_VERBOSE);
            if (this.ds.isDisconnectListenerThread()) {
                if (!isDebugEnabled_DLS) return;
                logger.trace(LogMarker.DLS_VERBOSE, "{}, name: {} - disconnect listener thread is exiting unlock()", (Object)this, name);
                return;
            }
            if (isDebugEnabled_DLS) {
                logger.trace(LogMarker.DLS_VERBOSE, "{}, name: {} - entering unlock()", (Object)this, name);
            }
            statStart = this.getStats().startLockRelease();
            hadRecursion = false;
            unlocked = false;
            lockId = -1;
            token = null;
            rThread = null;
            try {
                Map<Object, DLockToken> map = this.tokens;
                synchronized (map) {
                    this.checkDestroyed();
                    token = this.basicGetToken(name);
                    if (token == null) {
                        if (!isDebugEnabled_DLS) throw new LockNotHeldException(LocalizedStrings.DLockService_ATTEMPTING_TO_UNLOCK_0_1_BUT_THIS_THREAD_DOESNT_OWN_THE_LOCK.toLocalizedString(this, name));
                        logger.trace(LogMarker.DLS_VERBOSE, "{}, [unlock] no token found for: {}", (Object)this, name);
                        throw new LockNotHeldException(LocalizedStrings.DLockService_ATTEMPTING_TO_UNLOCK_0_1_BUT_THIS_THREAD_DOESNT_OWN_THE_LOCK.toLocalizedString(this, name));
                    }
                    DLockToken dLockToken = token;
                    synchronized (dLockToken) {
                        token.checkForExpiration();
                        rThread = token.getLesseeThread();
                        if (!token.isLeaseHeldByCurrentOrRemoteThread(rThread)) {
                            token.throwIfCurrentThreadHadExpiredLease();
                            if (!isDebugEnabled_DLS) throw new LockNotHeldException(LocalizedStrings.DLockService_ATTEMPTING_TO_UNLOCK_0_1_BUT_THIS_THREAD_DOESNT_OWN_THE_LOCK_2.toLocalizedString(this, name, token));
                            logger.trace(LogMarker.DLS_VERBOSE, "{}, [unlock] {} not leased by this thread.", (Object)this, (Object)token);
                            throw new LockNotHeldException(LocalizedStrings.DLockService_ATTEMPTING_TO_UNLOCK_0_1_BUT_THIS_THREAD_DOESNT_OWN_THE_LOCK_2.toLocalizedString(this, name, token));
                        }
                        hadRecursion = token.getRecursion() > 0;
                        lockId = token.getLeaseId();
                        Assert.assertTrue(lockId > -1);
                        if (hadRecursion) {
                            unlocked = token.releaseLock(lockId, rThread);
                        } else {
                            token.setIgnoreForRecovery(true);
                        }
                    }
                }
                if (hadRecursion) break block35;
                boolean lockBatch = false;
                boolean released = false;
                while (!released) {
                    this.checkDestroyed();
                    LockGrantorId theLockGrantorId = this.getLockGrantorId();
                    try {
                        Object object = this.lockGrantorIdLock;
                        synchronized (object) {
                            unlocked = token.releaseLock(lockId, rThread);
                        }
                        released = this.callReleaseProcessor(theLockGrantorId.getLockGrantorMember(), name, lockBatch, lockId);
                    }
                    catch (LockGrantorDestroyedException lockGrantorDestroyedException) {}
                    continue;
                    catch (LockServiceDestroyedException e) {
                        released = true;
                        continue;
                    }
                    finally {
                        if (released) continue;
                        this.notLockGrantorId(theLockGrantorId, 0L, TimeUnit.MILLISECONDS);
                    }
                }
            }
            catch (Throwable throwable) {
                try {
                    if (hadRecursion || lockId <= -1 || token == null) throw throwable;
                    this.decActiveLocks();
                    if (unlocked) throw throwable;
                    token.releaseLock(lockId, rThread);
                    throw throwable;
                }
                finally {
                    this.getStats().endLockRelease(statStart);
                    if (this.automateFreeResources) {
                        this.freeResources(name);
                    }
                    if (isDebugEnabled_DLS) {
                        logger.trace(LogMarker.DLS_VERBOSE, "{}, name: {} - exiting unlock()", (Object)this, name);
                    }
                }
            }
        }
        try {
            if (hadRecursion || lockId <= -1 || token == null) return;
            this.decActiveLocks();
            if (unlocked) return;
            token.releaseLock(lockId, rThread);
            return;
        }
        finally {
            this.getStats().endLockRelease(statStart);
            if (this.automateFreeResources) {
                this.freeResources(name);
            }
            if (isDebugEnabled_DLS) {
                logger.trace(LogMarker.DLS_VERBOSE, "{}, name: {} - exiting unlock()", (Object)this, name);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DLockRemoteToken queryLock(Object name) {
        DLockQueryProcessor.DLockQueryReplyMessage queryReply = null;
        while (queryReply == null || queryReply.repliedNotGrantor()) {
            this.checkDestroyed();
            LockGrantorId theLockGrantorId = this.getLockGrantorId();
            try {
                queryReply = DLockQueryProcessor.query(theLockGrantorId.getLockGrantorMember(), this.serviceName, name, false, this.dm);
            }
            catch (LockGrantorDestroyedException lockGrantorDestroyedException) {}
            continue;
            finally {
                if (queryReply == null || !queryReply.repliedNotGrantor()) continue;
                this.notLockGrantorId(theLockGrantorId, 0L, TimeUnit.MILLISECONDS);
            }
        }
        return DLockRemoteToken.create(name, queryReply.getLesseeThread(), queryReply.getLeaseId(), queryReply.getLeaseExpireTime());
    }

    static DLockService basicCreate(String serviceName, InternalDistributedSystem ds, boolean isDistributed, boolean destroyOnDisconnect, boolean automateFreeResources) throws IllegalArgumentException {
        Assert.assertHoldsLock(services, true);
        if (logger.isTraceEnabled(LogMarker.DLS_VERBOSE)) {
            logger.trace(LogMarker.DLS_VERBOSE, "About to create DistributedLockService <{}>", (Object)serviceName);
        }
        DLockService svc = new DLockService(serviceName, ds, isDistributed, destroyOnDisconnect, automateFreeResources);
        svc.init();
        return svc;
    }

    protected boolean init() {
        boolean success = false;
        try {
            services.put(this.serviceName, this);
            this.getStats().incServices(1);
            this.ds.addDisconnectListener(disconnectListener);
            success = true;
            if (logger.isTraceEnabled(LogMarker.DLS_VERBOSE)) {
                logger.trace(LogMarker.DLS_VERBOSE, "Created DistributedLockService <{}>", (Object)this.serviceName);
            }
        }
        finally {
            if (!success) {
                services.remove(this.serviceName);
                this.getStats().incServices(-1);
            }
        }
        this.ds.handleResourceEvent(ResourceEvent.LOCKSERVICE_CREATE, this);
        return success;
    }

    protected DLockService(String serviceName, DistributedSystem ds, boolean isDistributed, boolean destroyOnDisconnect, boolean automateFreeResources) {
        this.dlockStats = DLockService.getOrCreateStats(ds);
        this.serialNumber = DLockService.createSerialNumber();
        this.serviceName = serviceName;
        this.ds = (InternalDistributedSystem)ds;
        this.dm = this.ds.getDistributionManager();
        this.stopper = new DLockStopper(this.dm, this);
        this.isDistributed = isDistributed;
        this.destroyOnDisconnect = destroyOnDisconnect;
        this.automateFreeResources = automateFreeResources || AUTOMATE_FREE_RESOURCES;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(128);
        buffer.append('<').append("DLockService").append("@").append(Integer.toHexString(System.identityHashCode(this))).append(" named ").append(this.serviceName).append(" destroyed=").append(this.destroyed).append(" grantorId=").append(this.lockGrantorId).append(" grantor=").append(this.grantor).append('>');
        return buffer.toString();
    }

    public DistributedLockStats getStats() {
        return this.dlockStats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseTryLocks(DLockBatchId batchId, Callable<Boolean> untilCondition) {
        boolean isDebugEnabled_DLS = logger.isTraceEnabled(LogMarker.DLS_VERBOSE);
        if (isDebugEnabled_DLS) {
            logger.trace(LogMarker.DLS_VERBOSE, "[DLockService.releaseTryLocks] enter: {}", (Object)batchId);
        }
        long statStart = this.getStats().startLockRelease();
        try {
            boolean lockBatch = true;
            boolean released = false;
            while (!released) {
                try {
                    boolean quit = untilCondition.call();
                    if (quit) {
                        return;
                    }
                }
                catch (Exception e) {
                    throw new InternalGemFireException("unexpected exception", e);
                }
                this.checkDestroyed();
                LockGrantorId theLockGrantorId = null;
                theLockGrantorId = batchId.getLockGrantorId();
                Object object = this.lockGrantorIdLock;
                synchronized (object) {
                    if (!this.checkLockGrantorId(theLockGrantorId)) {
                        break;
                    }
                }
                released = this.callReleaseProcessor(theLockGrantorId.getLockGrantorMember(), batchId, lockBatch, -1);
                if (released) continue;
                this.notLockGrantorId(theLockGrantorId, 100L, TimeUnit.MILLISECONDS);
            }
        }
        finally {
            this.decActiveLocks();
            this.getStats().endLockRelease(statStart);
            if (isDebugEnabled_DLS) {
                logger.trace(LogMarker.DLS_VERBOSE, "[DLockService.releaseTryLocks] exit: {}", (Object)batchId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean acquireTryLocks(DLockBatch dlockBatch, long waitTimeMillis, long leaseTimeMillis, Object[] keyIfFailed) throws InterruptedException {
        long waitLimit;
        this.checkDestroyed();
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (keyIfFailed.length < 1) {
            throw new IllegalArgumentException(LocalizedStrings.DLockService_KEYIFFAILED_MUST_HAVE_A_LENGTH_OF_ONE_OR_GREATER.toLocalizedString());
        }
        long startTime = DLockService.getLockTimeStamp(this.dm);
        boolean isDebugEnabled_DLS = logger.isTraceEnabled(LogMarker.DLS_VERBOSE);
        if (isDebugEnabled_DLS) {
            logger.trace(LogMarker.DLS_VERBOSE, "[acquireTryLocks] acquiring {}", (Object)dlockBatch);
        }
        long requestWaitTime = waitTimeMillis;
        long requestLeaseTime = leaseTimeMillis;
        if (requestLeaseTime == -1L) {
            requestLeaseTime = Long.MAX_VALUE;
        }
        if (requestWaitTime == -1L) {
            requestWaitTime = Long.MAX_VALUE;
        }
        if ((waitLimit = startTime + requestWaitTime) < 0L) {
            waitLimit = Long.MAX_VALUE;
        }
        long statStart = this.getStats().startLockWait();
        boolean gotLocks = false;
        try {
            ThreadRequestState requestState = (ThreadRequestState)this.threadRequestState.get();
            if (requestState == null) {
                requestState = new ThreadRequestState(this.incThreadSequence(), false);
                this.threadRequestState.set(requestState);
            } else {
                requestState.interruptible = false;
            }
            int threadId = requestState.threadId;
            boolean keepTrying = true;
            this.incActiveLocks();
            while (keepTrying) {
                this.checkDestroyed();
                LockGrantorId theLockGrantorId = this.getLockGrantorId();
                boolean tryLock = true;
                boolean reentrant = false;
                DLockRequestProcessor processor = this.createRequestProcessor(theLockGrantorId, dlockBatch, threadId, startTime, requestLeaseTime, requestWaitTime, reentrant, tryLock, false);
                boolean interruptible = true;
                int lockId = processor.getProcessorId();
                gotLocks = processor.requestLock(interruptible, lockId);
                if (gotLocks) {
                    dlockBatch.grantedBy(theLockGrantorId);
                } else if (processor.repliedDestroyed()) {
                    this.checkDestroyed();
                    Assert.assertTrue(this.isDestroyed(), "Grantor reports service " + this + " is destroyed");
                } else if (processor.repliedNotGrantor() || processor.hadNoResponse()) {
                    this.notLockGrantorId(theLockGrantorId, 0L, TimeUnit.MILLISECONDS);
                } else {
                    keyIfFailed[0] = processor.getKeyIfFailed();
                    if (keyIfFailed[0] != null) break;
                    if (isDebugEnabled_DLS) {
                        logger.trace(LogMarker.DLS_VERBOSE, "[acquireTryLocks] lock request failed but provided no conflict key; responseCode=", (Object)processor.getResponseCodeString());
                    }
                }
                long timeLeft = requestWaitTime;
                if (requestWaitTime < Long.MAX_VALUE) {
                    timeLeft = waitLimit - DLockService.getLockTimeStamp(this.dm);
                }
                if (!(keepTrying = !gotLocks && timeLeft > 0L) || timeLeft <= 10L) continue;
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException ignore) {
                    Thread.currentThread().interrupt();
                }
            }
            if (isDebugEnabled_DLS) {
                logger.trace(LogMarker.DLS_VERBOSE, "[acquireTryLocks] {} locks for {}", (Object)(gotLocks ? "acquired" : "failed to acquire"), (Object)dlockBatch);
            }
        }
        finally {
            this.getStats().endLockWait(statStart, gotLocks);
        }
        return gotLocks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Object, DLockToken> snapshotService() {
        Map<Object, DLockToken> map = this.tokens;
        synchronized (map) {
            return new HashMap<Object, DLockToken>(this.tokens);
        }
    }

    public UnsafeThreadLocal<Object> getBlockedOn() {
        return this.blockedOn;
    }

    public boolean isDistributed() {
        return this.isDistributed;
    }

    public void setDLockLessorDepartureHandler(DLockLessorDepartureHandler handler) {
        this.lessorDepartureHandler = handler;
    }

    public DLockLessorDepartureHandler getDLockLessorDepartureHandler() {
        return this.lessorDepartureHandler;
    }

    public String getName() {
        return this.serviceName;
    }

    public DistributionManager getDistributionManager() {
        return this.dm;
    }

    public void setDLockRecoverGrantorMessageProcessor(DLockRecoverGrantorProcessor.MessageProcessor recoverGrantorProcessor) {
        this.recoverGrantorProcessor = recoverGrantorProcessor;
    }

    public DLockRecoverGrantorProcessor.MessageProcessor getDLockRecoverGrantorMessageProcessor() {
        return this.recoverGrantorProcessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasHeldLocks() {
        Map<Object, DLockToken> map = this.tokens;
        synchronized (map) {
            for (DLockToken token : this.tokens.values()) {
                if (!token.isLeaseHeld()) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void destroyServiceNamed(String serviceName) throws IllegalArgumentException {
        DLockService svc = null;
        Map<String, DLockService> map = services;
        synchronized (map) {
            svc = services.get(serviceName);
        }
        if (svc == null) {
            throw new IllegalArgumentException(LocalizedStrings.DLockService_SERVICE_NAMED_0_NOT_CREATED.toLocalizedString(serviceName));
        }
        svc.destroyAndRemove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void destroyAll() {
        HashSet<DLockService> svcs = Collections.EMPTY_SET;
        Map<String, DLockService> map = services;
        synchronized (map) {
            svcs = new HashSet<DLockService>(services.values());
        }
        for (DLockService svc : svcs) {
            try {
                svc.destroyAndRemove();
            }
            catch (CancelException e) {
                if (!logger.isTraceEnabled(LogMarker.DLS_VERBOSE)) continue;
                logger.trace(LogMarker.DLS_VERBOSE, "destroyAndRemove of {} terminated due to cancellation: ", (Object)svc, (Object)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void destroyAndRemove() {
        boolean isCurrentlyLockGrantor = false;
        boolean isMakingLockGrantor = false;
        boolean maybeHasActiveLocks = false;
        Object object = creationLock;
        synchronized (object) {
            try {
                Map<String, DLockService> map = services;
                synchronized (map) {
                    try {
                        if (this.isDestroyed()) {
                            return;
                        }
                        this.setDestroyingThread();
                        Object object2 = this.lockGrantorIdLock;
                        synchronized (object2) {
                            Object object3 = this.destroyLock;
                            synchronized (object3) {
                                this.destroyed = true;
                                maybeHasActiveLocks = this.activeLocks > 0;
                            }
                            isCurrentlyLockGrantor = this.isCurrentlyLockGrantor();
                            isMakingLockGrantor = this.isMakingLockGrantor();
                        }
                    }
                    finally {
                        if (this.isCurrentThreadDoingDestroy()) {
                            DLockService.removeLockService(this);
                        }
                    }
                }
            }
            catch (CancelException cancelException) {
            }
            finally {
                if (this.isCurrentThreadDoingDestroy()) {
                    try {
                        this.basicDestroy(isCurrentlyLockGrantor, isMakingLockGrantor, maybeHasActiveLocks);
                    }
                    catch (CancelException cancelException) {
                    }
                    finally {
                        this.clearDestroyingThread();
                    }
                }
                this.postDestroyAction();
            }
            return;
        }
    }

    private void basicDestroy(boolean isCurrentlyLockGrantor, boolean isMakingLockGrantor, boolean maybeHasActiveLocks) {
        Assert.assertHoldsLock(services, false);
        boolean isDebugEnabled_DLS = logger.isTraceEnabled(LogMarker.DLS_VERBOSE);
        if (isDebugEnabled_DLS) {
            logger.trace(LogMarker.DLS_VERBOSE, "[DLockService.basicDestroy] Destroying {}, isCurrentlyLockGrantor={}, isMakingLockGrantor={}", (Object)this, (Object)isCurrentlyLockGrantor, (Object)isMakingLockGrantor);
        }
        if (!isCurrentlyLockGrantor && maybeHasActiveLocks && !this.ds.isDisconnectListenerThread()) {
            boolean retry;
            int nonGrantorDestroyLoopCount = 0;
            do {
                retry = false;
                LockGrantorId theLockGrantorId = this.peekLockGrantorId();
                if (theLockGrantorId != null && !theLockGrantorId.isLocal(this.getSerialNumber()) && !NonGrantorDestroyedProcessor.send(this.serviceName, theLockGrantorId, this.dm)) {
                    this.notLockGrantorId(theLockGrantorId, 0L, TimeUnit.MILLISECONDS);
                    retry = true;
                }
                if (!DEBUG_NONGRANTOR_DESTROY_LOOP || ++nonGrantorDestroyLoopCount < DEBUG_NONGRANTOR_DESTROY_LOOP_COUNT) continue;
                logger.fatal(LogMarker.DLS_MARKER, (Message)LocalizedMessage.create(LocalizedStrings.DLockService_FAILED_TO_NOTIFY_GRANTOR_OF_DESTRUCTION_WITHIN_0_ATTEMPTS, DEBUG_NONGRANTOR_DESTROY_LOOP_COUNT));
                Assert.assertTrue(false, LocalizedStrings.DLockService_FAILED_TO_NOTIFY_GRANTOR_OF_DESTRUCTION_WITHIN_0_ATTEMPTS.toLocalizedString(DEBUG_NONGRANTOR_DESTROY_LOOP_COUNT));
            } while (retry);
        }
        if (isCurrentlyLockGrantor || isMakingLockGrantor) {
            block9: {
                if (this.ds.getCancelCriterion().isCancelInProgress()) {
                    try {
                        DLockGrantor.waitForGrantor(this);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    catch (DistributedSystemDisconnectedException e) {
                        if (!isDebugEnabled_DLS) break block9;
                        logger.trace(LogMarker.DLS_VERBOSE, "No longer waiting for grantor because of disconnect.", (Throwable)e);
                    }
                }
            }
            this.nullLockGrantorId(this.lockGrantorId);
        }
    }

    protected void postDestroyAction() {
        this.ds.handleResourceEvent(ResourceEvent.LOCKSERVICE_REMOVE, this);
    }

    boolean destroyOnDisconnect() {
        return this.destroyOnDisconnect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<DLockRemoteToken> getLockTokensForRecovery(LockGrantorId newlockGrantorId) {
        HashSet<DLockRemoteToken> heldLockSet = Collections.EMPTY_SET;
        LockGrantorId currentLockGrantorId = null;
        Object object = this.lockGrantorIdLock;
        synchronized (object) {
            if (this.isDestroyed()) {
                return heldLockSet;
            }
            currentLockGrantorId = this.lockGrantorId;
        }
        if (currentLockGrantorId != null && currentLockGrantorId.hasLockGrantorVersion() && newlockGrantorId.isNewerThan(currentLockGrantorId)) {
            this.nullLockGrantorId(currentLockGrantorId);
        }
        boolean isDebugEnabled_DLS = logger.isTraceEnabled(LogMarker.DLS_VERBOSE);
        Object object2 = this.lockGrantorIdLock;
        synchronized (object2) {
            Map<Object, DLockToken> map = this.tokens;
            synchronized (map) {
                Iterator<DLockToken> iter = this.tokens.values().iterator();
                while (iter.hasNext()) {
                    DLockToken token;
                    DLockToken dLockToken = token = iter.next();
                    synchronized (dLockToken) {
                        if (token.isLeaseHeld()) {
                            if (token.ignoreForRecovery()) {
                                if (isDebugEnabled_DLS) {
                                    logger.trace(LogMarker.DLS_VERBOSE, "getLockTokensForRecovery is skipping {}", (Object)token);
                                }
                            } else {
                                if (heldLockSet == Collections.EMPTY_SET) {
                                    heldLockSet = new HashSet<DLockRemoteToken>();
                                }
                                heldLockSet.add(DLockRemoteToken.createFromDLockToken(token));
                            }
                        }
                    }
                }
            }
            return heldLockSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DLockToken getToken(Object name) {
        Map<Object, DLockToken> map = this.tokens;
        synchronized (map) {
            return this.tokens.get(name);
        }
    }

    private DLockToken basicGetToken(Object name) {
        return this.tokens.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getTokens() {
        Map<Object, DLockToken> map = this.tokens;
        synchronized (map) {
            return Collections.unmodifiableCollection(this.tokens.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DLockToken getOrCreateToken(Object name) {
        Map<Object, DLockToken> map = this.tokens;
        synchronized (map) {
            boolean createNewToken;
            this.checkDestroyed();
            DLockToken token = this.tokens.get(name);
            boolean bl = createNewToken = token == null;
            if (createNewToken) {
                token = new DLockToken(this.dm, name);
            }
            DLockToken dLockToken = token;
            synchronized (dLockToken) {
                if (createNewToken) {
                    this.tokens.put(name, token);
                    if (logger.isTraceEnabled(LogMarker.DLS_VERBOSE)) {
                        logger.trace(LogMarker.DLS_VERBOSE, "Creating {} in {}", (Object)token, (Object)this);
                    }
                    this.getStats().incTokens(1);
                }
                token.incUsage();
            }
            return token;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int numLocksHeldInThisVM() {
        int numLocksHeld = 0;
        Map<Object, DLockToken> map = this.tokens;
        synchronized (map) {
            Iterator<DLockToken> iter = this.tokens.values().iterator();
            while (iter.hasNext()) {
                DLockToken token;
                DLockToken dLockToken = token = iter.next();
                synchronized (dLockToken) {
                    if (token.isLeaseHeld()) {
                        ++numLocksHeld;
                    }
                }
            }
        }
        return numLocksHeld;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dumpService() {
        Map<Object, DLockToken> map = this.tokens;
        synchronized (map) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("  ").append(this.tokens.size()).append(" tokens, ");
            buffer.append(this.numLocksHeldInThisVM()).append(" locks held\n");
            for (Map.Entry<Object, DLockToken> entry : this.tokens.entrySet()) {
                buffer.append("    ").append(entry.getKey()).append(": ");
                DLockToken token = entry.getValue();
                buffer.append(token.toString()).append("\n");
            }
            logger.info(LogMarker.DLS_MARKER, (Message)LocalizedMessage.create(LocalizedStrings.ONE_ARG, buffer));
        }
    }

    boolean isInterruptibleLockRequest() {
        ThreadRequestState requestState = (ThreadRequestState)this.threadRequestState.get();
        if (requestState == null) {
            return false;
        }
        return requestState.interruptible;
    }

    ThreadLocal getThreadRequestState() {
        return this.threadRequestState;
    }

    protected int incThreadSequence() {
        return this.threadSequence.incrementAndGet();
    }

    protected static int createSerialNumber() {
        return serialNumberSequencer.incrementAndGet();
    }

    public int getSerialNumber() {
        return this.serialNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DistributedLockService getServiceNamed(String serviceName) {
        DLockService svc = null;
        Map<String, DLockService> map = services;
        synchronized (map) {
            svc = services.get(serviceName);
            return svc;
        }
    }

    public static DistributedLockService create(String serviceName, InternalDistributedSystem ds, boolean distributed, boolean destroyOnDisconnect) {
        return DLockService.create(serviceName, ds, distributed, destroyOnDisconnect, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DistributedLockService create(String serviceName, InternalDistributedSystem ds, boolean distributed, boolean destroyOnDisconnect, boolean automateFreeResources) throws IllegalArgumentException, IllegalStateException {
        Object object = creationLock;
        synchronized (object) {
            Map<String, DLockService> map = services;
            synchronized (map) {
                ds.getCancelCriterion().checkCancelInProgress(null);
                DLockService.readyThreadGroup(ds);
                if (services.get(serviceName) != null) {
                    throw new IllegalArgumentException(LocalizedStrings.DLockService_SERVICE_NAMED_0_ALREADY_CREATED.toLocalizedString(serviceName));
                }
                return DLockService.basicCreate(serviceName, ds, distributed, destroyOnDisconnect, automateFreeResources);
            }
        }
    }

    public static void becomeLockGrantor(String serviceName) throws IllegalArgumentException {
        DLockService.becomeLockGrantor(serviceName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void becomeLockGrantor(String serviceName, InternalDistributedMember oldTurk) throws IllegalArgumentException {
        if (serviceName == null || serviceName.length() == 0) {
            throw new IllegalArgumentException(LocalizedStrings.DLockService_SERVICE_NAMED_0_IS_NOT_VALID.toLocalizedString(serviceName));
        }
        DLockService svc = null;
        Map<String, DLockService> map = services;
        synchronized (map) {
            svc = services.get(serviceName);
        }
        if (svc == null) {
            throw new IllegalArgumentException(LocalizedStrings.DLockService_SERVICE_NAMED_0_NOT_CREATED.toLocalizedString(serviceName));
        }
        svc.becomeLockGrantor(oldTurk);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isLockGrantor(String serviceName) throws IllegalArgumentException {
        if (serviceName == null || serviceName.length() == 0) {
            throw new IllegalArgumentException(LocalizedStrings.DLockService_SERVICE_NAMED_0_IS_NOT_VALID.toLocalizedString(serviceName));
        }
        DLockService svc = null;
        Map<String, DLockService> map = services;
        synchronized (map) {
            svc = services.get(serviceName);
        }
        if (svc == null) {
            throw new IllegalArgumentException(LocalizedStrings.DLockService_SERVICE_NAMED_0_NOT_CREATED.toLocalizedString(serviceName));
        }
        return svc.isLockGrantor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void recoverRmtElder(ArrayList grantors, ArrayList grantorVersions, ArrayList grantorSerialNumbers, ArrayList nonGrantors) {
        Map<String, DLockService> map = services;
        synchronized (map) {
            for (Map.Entry<String, DLockService> entry : services.entrySet()) {
                String serviceName = entry.getKey();
                DLockService service = entry.getValue();
                boolean foundGrantor = false;
                DLockGrantor grantor = service.getGrantor();
                if (grantor != null && grantor.getVersionId() != -1L && !grantor.isDestroyed()) {
                    foundGrantor = true;
                    grantors.add(serviceName);
                    grantorVersions.add(grantor.getVersionId());
                    grantorSerialNumbers.add(service.getSerialNumber());
                }
                if (foundGrantor) continue;
                nonGrantors.add(serviceName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void recoverLocalElder(DistributionManager dm, Map grantors, Set needsRecovery) {
        Map<String, DLockService> map = services;
        synchronized (map) {
            for (Map.Entry<String, DLockService> entry : services.entrySet()) {
                String serviceName = entry.getKey();
                DLockService service = entry.getValue();
                boolean foundGrantor = false;
                DLockGrantor grantor = service.getGrantor();
                if (grantor != null && grantor.getVersionId() != -1L && !grantor.isDestroyed()) {
                    foundGrantor = true;
                    GrantorInfo oldgi = (GrantorInfo)grantors.get(serviceName);
                    if (oldgi == null || oldgi.getVersionId() < grantor.getVersionId()) {
                        grantors.put(serviceName, new GrantorInfo(dm.getId(), grantor.getVersionId(), service.getSerialNumber(), false));
                        needsRecovery.remove(serviceName);
                    }
                }
                if (foundGrantor || dm.isAdam() && !service.hasHeldLocks() || grantors.containsKey(serviceName)) continue;
                needsRecovery.add(serviceName);
            }
        }
    }

    public static DLockService getInternalServiceNamed(String serviceName) {
        return services.get(serviceName);
    }

    public static void validateServiceName(String serviceName) {
        if (serviceName == null || serviceName.length() == 0) {
            throw new IllegalArgumentException(LocalizedStrings.DLockService_LOCK_SERVICE_NAME_MUST_NOT_BE_NULL_OR_EMPTY.toLocalizedString());
        }
        for (int i = 0; i < reservedNames.length; ++i) {
            if (!serviceName.startsWith(reservedNames[i])) continue;
            throw new IllegalArgumentException(LocalizedStrings.DLockService_SERVICE_NAMED_0_IS_RESERVED_FOR_INTERNAL_USE_ONLY.toLocalizedString(serviceName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, DLockService> snapshotAllServices() {
        HashMap<String, DLockService> snapshot = null;
        Map<String, DLockService> map = services;
        synchronized (map) {
            snapshot = new HashMap<String, DLockService>(services);
        }
        return snapshot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpAllServices() {
        StringBuffer buffer = new StringBuffer();
        Map<String, DLockService> map = services;
        synchronized (map) {
            logger.info(LogMarker.DLS_MARKER, (Message)LocalizedMessage.create(LocalizedStrings.TESTING, "DLockService.dumpAllServices() - " + services.size() + " services:\n"));
            for (Map.Entry<String, DLockService> entry : services.entrySet()) {
                buffer.append("  " + entry.getKey() + ":\n");
                DLockService svc = entry.getValue();
                svc.dumpService();
                if (!svc.isCurrentlyLockGrantor()) continue;
                svc.grantor.dumpService();
            }
        }
    }

    static ThreadGroup getThreadGroup() {
        return threadGroup;
    }

    static long getLockTimeStamp(DistributionManager dm) {
        return dm.cacheTimeMillis();
    }

    protected static synchronized DistributedLockStats getOrCreateStats(DistributedSystem ds) {
        if (stats == DUMMY_STATS) {
            Assert.assertTrue(ds != null, "Need an instance of InternalDistributedSystem");
            DistributedSystem statFactory = ds;
            long statId = OSProcess.getId();
            stats = new DLockStats(statFactory, statId);
        }
        return stats;
    }

    protected static synchronized DistributedLockStats getDistributedLockStats() {
        return stats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addLockServiceForTests(String name, DLockService service) {
        Map<String, DLockService> map = services;
        synchronized (map) {
            services.put(name, service);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeLockServiceForTests(String name) {
        Map<String, DLockService> map = services;
        synchronized (map) {
            services.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static void removeLockService(DLockService service) {
        service.removeAllTokens();
        InternalDistributedSystem system = null;
        Object object = services;
        synchronized (object) {
            DLockService removedService = services.remove(service.getName());
            if (removedService == null) {
                return;
            }
            if (removedService != service) {
                services.put(service.getName(), removedService);
            } else {
                service.getStats().incServices(-1);
            }
            system = removedService.getDistributionManager().getSystem();
        }
        if (!services.isEmpty() || !system.isDisconnecting()) return;
        object = DLockService.class;
        synchronized (DLockService.class) {
            DLockService.closeStats();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    static void closeStats() {
        if (stats != DUMMY_STATS) {
            ((DLockStats)stats).close();
            stats = DUMMY_STATS;
        }
        threadGroup = null;
    }

    static GrantorInfo checkLockGrantorInfo(String serviceName, InternalDistributedSystem system) {
        GrantorInfo gi = GrantorRequestProcessor.peekGrantor(serviceName, system);
        if (logger.isTraceEnabled(LogMarker.DLS_VERBOSE)) {
            logger.trace(LogMarker.DLS_VERBOSE, "[checkLockGrantorId] returning {}", (Object)gi);
        }
        return gi;
    }

    protected static synchronized void readyThreadGroup(InternalDistributedSystem ds) {
        if (threadGroup == null) {
            Assert.assertTrue(ds != null, "Cannot find any instance of InternalDistributedSystem");
            String threadGroupName = LocalizedStrings.DLockService_DISTRIBUTED_LOCKING_THREADS.toLocalizedString();
            LoggingThreadGroup group = LoggingThreadGroup.createThreadGroup(threadGroupName);
            threadGroup = group;
        }
    }

    public CancelCriterion getCancelCriterion() {
        return this.stopper;
    }

    static {
        stats = DUMMY_STATS;
        reservedNames = new String[]{LTLS, DTLS};
        START_SERIAL_NUMBER = Integer.getInteger("gemfire.DistributedLockService.startSerialNumber", 1);
        serialNumberSequencer = new AtomicInteger(START_SERIAL_NUMBER);
    }

    private static class DLockStopper
    extends CancelCriterion {
        private final DLockService dls;

        DLockStopper(DistributionManager dm, DLockService dls) {
            Assert.assertTrue(dls != null);
            this.dls = dls;
            Assert.assertTrue(dls.getDistributionManager() != null);
        }

        @Override
        public String cancelInProgress() {
            String cancelInProgressString = this.dls.getDistributionManager().getCancelCriterion().cancelInProgress();
            if (cancelInProgressString != null) {
                return cancelInProgressString;
            }
            if (this.dls.isDestroyed()) {
                return this.dls.generateLockServiceDestroyedMessage();
            }
            return null;
        }

        @Override
        public RuntimeException generateCancelledException(Throwable e) {
            String reason = this.cancelInProgress();
            if (reason == null) {
                return null;
            }
            return this.dls.generateLockServiceDestroyedException(reason);
        }
    }

    public static class SuspendLockingToken
    implements DataSerializableFixedID {
        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            return o instanceof SuspendLockingToken;
        }

        public int hashCode() {
            return 15325;
        }

        @Override
        public int getDSFID() {
            return -62;
        }

        @Override
        public void fromData(DataInput in) {
        }

        @Override
        public void toData(DataOutput out) {
        }

        @Override
        public Version[] getSerializationVersions() {
            return null;
        }
    }

    protected static class ThreadRequestState {
        protected final int threadId;
        protected boolean interruptible;

        ThreadRequestState(int threadId, boolean interruptible) {
            this.threadId = threadId;
            this.interruptible = interruptible;
        }
    }
}

