/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.internal.index;

import org.apache.geode.cache.Region;
import org.apache.geode.cache.query.AmbiguousNameException;
import org.apache.geode.cache.query.IndexType;
import org.apache.geode.cache.query.NameResolutionException;
import org.apache.geode.cache.query.TypeMismatchException;
import org.apache.geode.cache.query.internal.CompiledValue;
import org.apache.geode.cache.query.internal.DefaultQueryService;
import org.apache.geode.cache.query.internal.ExecutionContext;
import org.apache.geode.cache.query.internal.index.IndexData;
import org.apache.geode.cache.query.internal.index.IndexManager;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.PartitionedRegion;

public class IndexUtils {
    public static final boolean indexesEnabled = System.getProperty("query.disableIndexes") == null;
    public static final boolean useOnlyExactIndexs = false;
    public static IndexManager.TestHook testHook;

    public static void setTestHook(IndexManager.TestHook testHook) {
        IndexUtils.testHook = testHook;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IndexManager getIndexManager(InternalCache cache, Region region, boolean createIfNotAvailable) {
        if (region == null || region.isDestroyed()) {
            return null;
        }
        LocalRegion lRegion = (LocalRegion)region;
        IndexManager idxMgr = lRegion.getIndexManager();
        if (idxMgr == null && createIfNotAvailable) {
            Object imSync;
            if (testHook != null && region instanceof PartitionedRegion) {
                testHook.hook(0);
            }
            Object object = imSync = lRegion.getIMSync();
            synchronized (object) {
                if (lRegion.getIndexManager() == null) {
                    idxMgr = new IndexManager(cache, region);
                    lRegion.setIndexManager(idxMgr);
                } else {
                    idxMgr = lRegion.getIndexManager();
                }
            }
        }
        return idxMgr;
    }

    public static IndexData findIndex(String regionpath, String[] defintions, CompiledValue indexedExpression, String projectionAttributes, InternalCache cache, boolean usePrimaryIndex, ExecutionContext context) throws AmbiguousNameException, TypeMismatchException, NameResolutionException {
        IndexData functionalIndxData;
        DefaultQueryService qs = (DefaultQueryService)cache.getLocalQueryService();
        IndexData indxData = null;
        if (usePrimaryIndex && (indxData = qs.getBestMatchIndex(regionpath, defintions, IndexType.PRIMARY_KEY, indexedExpression, context)) == null) {
            indxData = qs.getBestMatchIndex(regionpath, defintions, IndexType.HASH, indexedExpression, context);
        }
        if (indxData == null || !indxData._index.isValid()) {
            indxData = qs.getBestMatchIndex(regionpath, defintions, IndexType.FUNCTIONAL, indexedExpression, context);
        } else if (indxData._matchLevel != 0 && (functionalIndxData = qs.getIndex(regionpath, defintions, IndexType.FUNCTIONAL, indexedExpression, context)) != null && functionalIndxData._index.isValid()) {
            indxData = functionalIndxData;
        }
        return indxData;
    }
}

