/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.internal;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.geode.DataSerializer;
import org.apache.geode.cache.query.SelectResults;
import org.apache.geode.cache.query.internal.Ordered;
import org.apache.geode.cache.query.internal.types.CollectionTypeImpl;
import org.apache.geode.cache.query.types.CollectionType;
import org.apache.geode.cache.query.types.ObjectType;
import org.apache.geode.cache.query.types.StructType;
import org.apache.geode.internal.DataSerializableFixedID;
import org.apache.geode.internal.Version;
import org.apache.geode.internal.i18n.LocalizedStrings;

public class SortedResultSet
extends TreeSet
implements SelectResults,
Ordered,
DataSerializableFixedID {
    private static final long serialVersionUID = 5184711453750319224L;
    private ObjectType elementType;

    public SortedResultSet() {
    }

    SortedResultSet(Collection c) {
        super(c);
    }

    SortedResultSet(SelectResults sr) {
        super(sr);
        this.setElementType(sr.getCollectionType().getElementType());
    }

    SortedResultSet(ObjectType elementType) {
        this.setElementType(elementType);
    }

    SortedResultSet(Comparator c) {
        super(c);
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof SortedResultSet)) {
            return false;
        }
        if (!this.elementType.equals(((SortedResultSet)other).elementType)) {
            return false;
        }
        return super.equals(other);
    }

    @Override
    public void setElementType(ObjectType elementType) {
        if (elementType instanceof StructType) {
            throw new IllegalArgumentException(LocalizedStrings.SortedResultSet_THIS_COLLECTION_DOES_NOT_SUPPORT_STRUCT_ELEMENTS.toLocalizedString());
        }
        this.elementType = elementType;
    }

    public List asList() {
        return new ArrayList(this);
    }

    public Set asSet() {
        return this;
    }

    @Override
    public CollectionType getCollectionType() {
        return new CollectionTypeImpl(SortedResultSet.class, this.elementType);
    }

    @Override
    public boolean isModifiable() {
        return true;
    }

    public int occurrences(Object element) {
        return this.contains(element) ? 1 : 0;
    }

    @Override
    public int getDSFID() {
        return 29;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        this.elementType = (ObjectType)DataSerializer.readObject(in);
        for (int j = size; j > 0; --j) {
            this.add(DataSerializer.readObject(in));
        }
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        out.writeInt(this.size());
        DataSerializer.writeObject(this.elementType, out);
        Iterator i = this.iterator();
        while (i.hasNext()) {
            DataSerializer.writeObject(i.next(), out);
        }
    }

    @Override
    public Version[] getSerializationVersions() {
        return null;
    }

    @Override
    public boolean dataPreordered() {
        return false;
    }
}

