/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.client.internal;

import org.apache.geode.cache.client.internal.AbstractOp;
import org.apache.geode.cache.client.internal.Connection;
import org.apache.geode.cache.client.internal.ConnectionStats;
import org.apache.geode.cache.client.internal.InternalPool;
import org.apache.geode.internal.cache.tier.sockets.Message;

public class SizeOp {
    public static Integer execute(InternalPool pool, String region) {
        SizeOpImpl op = new SizeOpImpl(region);
        return (Integer)pool.execute(op);
    }

    private SizeOp() {
    }

    private static class SizeOpImpl
    extends AbstractOp {
        public SizeOpImpl(String region) {
            super(81, 1);
            this.getMessage().addStringPart(region);
        }

        @Override
        protected Object processResponse(Message msg) throws Exception {
            return this.processObjResponse(msg, "size");
        }

        @Override
        protected boolean isErrorResponse(int msgType) {
            return msgType == 82;
        }

        @Override
        protected long startAttempt(ConnectionStats stats) {
            return stats.startSize();
        }

        @Override
        protected void endSendAttempt(ConnectionStats stats, long start) {
            stats.endSizeSend(start, this.hasFailed());
        }

        @Override
        protected void endAttempt(ConnectionStats stats, long start) {
            stats.endSize(start, this.hasTimedOut(), this.hasFailed());
        }

        @Override
        protected boolean needsUserId() {
            return false;
        }

        @Override
        protected void sendMessage(Connection cnx) throws Exception {
            this.getMessage().clearMessageHasSecurePartFlag();
            this.getMessage().send(false);
        }
    }
}

