/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.client.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.geode.SystemFailure;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.cache.client.internal.PoolImpl;
import org.apache.geode.cache.client.internal.PrimaryAckOp;
import org.apache.geode.cache.client.internal.QueueManager;
import org.apache.geode.cache.client.internal.QueueState;
import org.apache.geode.internal.cache.ClientServerObserver;
import org.apache.geode.internal.cache.ClientServerObserverHolder;
import org.apache.geode.internal.cache.EventID;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.ha.ThreadIdentifier;
import org.apache.geode.internal.logging.LogService;
import org.apache.logging.log4j.Logger;

public class QueueStateImpl
implements QueueState {
    private static final Logger logger = LogService.getLogger();
    protected QueueManager qManager = null;
    private boolean processedMarker = false;
    private final AtomicInteger invalidateCount = new AtomicInteger();
    protected final Map threadIdToSequenceId = new LinkedHashMap();

    public QueueStateImpl(QueueManager qm) {
        this.qManager = qm;
    }

    @Override
    public void processMarker() {
        if (!this.processedMarker) {
            this.handleMarker();
            this.processedMarker = true;
        } else if (logger.isDebugEnabled()) {
            logger.debug("{}: extra marker received", (Object)this);
        }
    }

    @Override
    public boolean getProcessedMarker() {
        return this.processedMarker;
    }

    public void handleMarker() {
        ArrayList regions = new ArrayList();
        GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
        if (cache == null) {
            return;
        }
        Set<Region<?, ?>> rootRegions = cache.rootRegions();
        for (Region<?, ?> region : rootRegions) {
            regions.add(region);
            try {
                Set<Region<?, ?>> subRegions = region.subregions(true);
                Iterator<Region<?, ?>> iter2 = subRegions.iterator();
                while (iter2.hasNext()) {
                    regions.add(iter2.next());
                }
            }
            catch (RegionDestroyedException e) {
            }
        }
        for (LocalRegion localRegion : regions) {
            try {
                if (localRegion.getAttributes().getPoolName() == null || !localRegion.getAttributes().getPoolName().equals(this.qManager.getPool().getName())) continue;
                localRegion.handleMarker();
            }
            catch (RegionDestroyedException e) {}
        }
    }

    @Override
    public void incrementInvalidatedStats() {
        this.invalidateCount.incrementAndGet();
    }

    public int getInvalidateCount() {
        return this.invalidateCount.get();
    }

    @Override
    public Map getThreadIdToSequenceIdMap() {
        return this.threadIdToSequenceId;
    }

    @Override
    public boolean verifyIfDuplicate(EventID eid) {
        return this.verifyIfDuplicate(eid, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean verifyIfDuplicate(EventID eid, boolean addToMap) {
        ThreadIdentifier tid = new ThreadIdentifier(eid.getMembershipID(), eid.getThreadID());
        long seqId = eid.getSequenceID();
        SequenceIdAndExpirationObject seo = null;
        Map map = this.threadIdToSequenceId;
        synchronized (map) {
            seo = (SequenceIdAndExpirationObject)this.threadIdToSequenceId.get(tid);
            if (seo != null && seo.getSequenceId() >= seqId) {
                if (logger.isDebugEnabled()) {
                    logger.debug(" got a duplicate entry with EventId {}. Ignoring the entry", (Object)eid);
                }
                seo.setAckSend(false);
                return true;
            }
            if (addToMap) {
                ThreadIdentifier real_tid = new ThreadIdentifier(eid.getMembershipID(), ThreadIdentifier.getRealThreadIDIncludingWan(eid.getThreadID()));
                if (ThreadIdentifier.isPutAllFakeThreadID(eid.getThreadID())) {
                    seo = (SequenceIdAndExpirationObject)this.threadIdToSequenceId.get(real_tid);
                    if (seo != null && seo.getSequenceId() >= seqId) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("got a duplicate putAll entry with eventId {}. Other operation with same thread id and bigger seqno {} has happened. Ignoring the entry", (Object)eid, (Object)seo.getSequenceId());
                        }
                        seo.setAckSend(false);
                        return true;
                    }
                    this.threadIdToSequenceId.remove(real_tid);
                    this.threadIdToSequenceId.put(real_tid, seo == null ? new SequenceIdAndExpirationObject(-1L, seqId) : new SequenceIdAndExpirationObject(seo.getSequenceId(), seqId));
                    this.threadIdToSequenceId.remove(tid);
                    this.threadIdToSequenceId.put(tid, new SequenceIdAndExpirationObject(seqId, -1L));
                } else {
                    seo = (SequenceIdAndExpirationObject)this.threadIdToSequenceId.get(real_tid);
                    if (seo != null && seo.getPutAllSequenceId() >= seqId) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("got a duplicate non-putAll entry with eventId {}. One putAll operation with same real thread id and bigger seqno {} has happened. Ignoring the entry", (Object)eid, (Object)seo.getPutAllSequenceId());
                        }
                        seo.setAckSend(false);
                        return true;
                    }
                    this.threadIdToSequenceId.remove(tid);
                    this.threadIdToSequenceId.put(tid, seo == null ? new SequenceIdAndExpirationObject(seqId, -1L) : new SequenceIdAndExpirationObject(seqId, seo.getPutAllSequenceId()));
                }
            }
        }
        return false;
    }

    @Override
    public void start(ScheduledExecutorService timer, int interval) {
        timer.scheduleWithFixedDelay(new ThreadIdToSequenceIdExpiryTask(), interval, interval, TimeUnit.MILLISECONDS);
    }

    public static class SequenceIdAndExpirationObject {
        private final long sequenceId;
        private final long putAllSequenceId;
        private final long creationTime;
        private boolean ackSend;

        SequenceIdAndExpirationObject(long sequenceId, long putAllSequenceId) {
            this.sequenceId = sequenceId;
            this.putAllSequenceId = putAllSequenceId;
            this.creationTime = System.currentTimeMillis();
            this.ackSend = false;
        }

        public long getCreationTime() {
            return this.creationTime;
        }

        public long getSequenceId() {
            return this.sequenceId;
        }

        public long getPutAllSequenceId() {
            return this.putAllSequenceId;
        }

        public boolean getAckSend() {
            return this.ackSend;
        }

        public void setAckSend(boolean ackSend) {
            this.ackSend = ackSend;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("SequenceIdAndExpirationObject[");
            sb.append("ackSend = " + this.ackSend);
            sb.append("; creation = " + this.creationTime);
            sb.append("; seq = " + this.sequenceId);
            sb.append("; putAll seq = " + this.putAllSequenceId);
            sb.append("]");
            return sb.toString();
        }
    }

    private class ThreadIdToSequenceIdExpiryTask
    extends PoolImpl.PoolTask {
        private final long expiryTime;

        public ThreadIdToSequenceIdExpiryTask() {
            this.expiryTime = QueueStateImpl.this.qManager.getPool().getSubscriptionMessageTrackingTimeout();
        }

        @Override
        public void run2() {
            SystemFailure.checkFailure();
            if (QueueStateImpl.this.qManager.getPool().getCancelCriterion().isCancelInProgress()) {
                return;
            }
            if (PoolImpl.BEFORE_SENDING_CLIENT_ACK_CALLBACK_FLAG) {
                ClientServerObserver bo = ClientServerObserverHolder.getInstance();
                bo.beforeSendingClientAck();
            }
            this.sendPeriodicAck();
            this.checkForExpiry();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void checkForExpiry() {
            Map map = QueueStateImpl.this.threadIdToSequenceId;
            synchronized (map) {
                Map.Entry entry;
                SequenceIdAndExpirationObject seo;
                Iterator iterator = QueueStateImpl.this.threadIdToSequenceId.entrySet().iterator();
                long currentTime = System.currentTimeMillis();
                while (iterator.hasNext() && currentTime - (seo = (SequenceIdAndExpirationObject)(entry = iterator.next()).getValue()).getCreationTime() > this.expiryTime) {
                    if (!seo.getAckSend() && (QueueStateImpl.this.qManager.getPool().getSubscriptionRedundancy() != 0 || QueueStateImpl.this.qManager.getPool().isDurableClient())) continue;
                    iterator.remove();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void sendPeriodicAck() {
            block22: {
                ArrayList<EventID> events = new ArrayList<EventID>();
                boolean success = false;
                Map map = QueueStateImpl.this.threadIdToSequenceId;
                synchronized (map) {
                    for (Map.Entry entry : QueueStateImpl.this.threadIdToSequenceId.entrySet()) {
                        SequenceIdAndExpirationObject seo = (SequenceIdAndExpirationObject)entry.getValue();
                        if (seo.getAckSend()) continue;
                        ThreadIdentifier tid = (ThreadIdentifier)entry.getKey();
                        events.add(new EventID(tid.getMembershipID(), tid.getThreadID(), seo.getSequenceId()));
                        seo.setAckSend(true);
                    }
                }
                if (events.size() > 0) {
                    try {
                        PrimaryAckOp.execute(QueueStateImpl.this.qManager.getAllConnections().getPrimary(), QueueStateImpl.this.qManager.getPool(), events);
                        success = true;
                    }
                    catch (Exception ex) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Exception while sending an ack to the primary server: {}", (Throwable)ex);
                        }
                    }
                    finally {
                        if (success) break block22;
                        for (EventID eid : events) {
                            ThreadIdentifier tid = new ThreadIdentifier(eid.getMembershipID(), eid.getThreadID());
                            Map map2 = QueueStateImpl.this.threadIdToSequenceId;
                            synchronized (map2) {
                                SequenceIdAndExpirationObject seo = (SequenceIdAndExpirationObject)QueueStateImpl.this.threadIdToSequenceId.get(tid);
                                if (seo != null && seo.getAckSend() && (seo = (SequenceIdAndExpirationObject)QueueStateImpl.this.threadIdToSequenceId.remove(tid)) != null) {
                                    SequenceIdAndExpirationObject siaeo = new SequenceIdAndExpirationObject(seo.getSequenceId(), seo.getPutAllSequenceId());
                                    QueueStateImpl.this.threadIdToSequenceId.put(tid, siaeo);
                                }
                            }
                        }
                    }
                }
            }
        }
    }
}

