/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.client.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.geode.CancelException;
import org.apache.geode.GemFireConfigException;
import org.apache.geode.GemFireException;
import org.apache.geode.SystemFailure;
import org.apache.geode.cache.InterestResultPolicy;
import org.apache.geode.cache.NoSubscriptionServersAvailableException;
import org.apache.geode.cache.client.ServerConnectivityException;
import org.apache.geode.cache.client.internal.ClientUpdater;
import org.apache.geode.cache.client.internal.Connection;
import org.apache.geode.cache.client.internal.ConnectionFactory;
import org.apache.geode.cache.client.internal.ConnectionSource;
import org.apache.geode.cache.client.internal.Endpoint;
import org.apache.geode.cache.client.internal.EndpointManager;
import org.apache.geode.cache.client.internal.InternalPool;
import org.apache.geode.cache.client.internal.MakePrimaryOp;
import org.apache.geode.cache.client.internal.PoolImpl;
import org.apache.geode.cache.client.internal.QueueConnectionImpl;
import org.apache.geode.cache.client.internal.QueueManager;
import org.apache.geode.cache.client.internal.QueueState;
import org.apache.geode.cache.client.internal.QueueStateImpl;
import org.apache.geode.cache.client.internal.ReadyForEventsOp;
import org.apache.geode.cache.client.internal.RegisterInterestTracker;
import org.apache.geode.cache.client.internal.ServerBlackList;
import org.apache.geode.cache.client.internal.UserAttributes;
import org.apache.geode.cache.query.internal.CqStateImpl;
import org.apache.geode.cache.query.internal.DefaultQueryService;
import org.apache.geode.cache.query.internal.cq.ClientCQ;
import org.apache.geode.cache.query.internal.cq.CqService;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.ServerLocation;
import org.apache.geode.i18n.StringId;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.cache.ClientServerObserver;
import org.apache.geode.internal.cache.ClientServerObserverHolder;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.tier.InterestType;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.internal.cache.tier.sockets.ServerQueueStatus;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.InternalLogWriter;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.geode.security.GemFireSecurityException;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public class QueueManagerImpl
implements QueueManager {
    private static final Logger logger = LogService.getLogger();
    private static final Comparator QSIZE_COMPARATOR = new QSizeComparator();
    protected final long redundancyRetryInterval;
    private final EndpointManager endpointManager;
    private final EndpointManager.EndpointListenerAdapter endpointListener;
    private final ConnectionSource source;
    private final int redundancyLevel;
    protected final ConnectionFactory factory;
    private final InternalLogWriter securityLogger;
    private final ClientProxyMembershipID proxyId;
    protected final InternalPool pool;
    private final QueueStateImpl state;
    private boolean printPrimaryNotFoundError = true;
    private boolean printRedundancyNotSatisfiedError = true;
    private boolean printRecoveringPrimary = true;
    private boolean printRecoveringRedundant = true;
    protected final ServerBlackList blackList;
    protected final Object lock = new Object();
    protected final CountDownLatch initializedLatch = new CountDownLatch(1);
    private ScheduledThreadPoolExecutor recoveryThread;
    private volatile boolean sentClientReady;
    protected volatile ConnectionList queueConnections = new ConnectionList();
    protected volatile RedundancySatisfierTask redundancySatisfierTask = null;
    private volatile boolean shuttingDown;

    public QueueManagerImpl(InternalPool pool, EndpointManager endpointManager, ConnectionSource source, ConnectionFactory factory, int queueRedundancyLevel, long redundancyRetryInterval, InternalLogWriter securityLogger, ClientProxyMembershipID proxyId) {
        this.pool = pool;
        this.endpointManager = endpointManager;
        this.source = source;
        this.factory = factory;
        this.redundancyLevel = queueRedundancyLevel;
        this.securityLogger = securityLogger;
        this.proxyId = proxyId;
        this.redundancyRetryInterval = redundancyRetryInterval;
        this.blackList = new ServerBlackList(redundancyRetryInterval);
        this.endpointListener = new EndpointManager.EndpointListenerAdapter(){

            @Override
            public void endpointCrashed(Endpoint endpoint) {
                QueueManagerImpl.this.endpointCrashed(endpoint);
            }
        };
        this.state = new QueueStateImpl(this);
    }

    @Override
    public InternalPool getPool() {
        return this.pool;
    }

    public boolean isPrimaryUpdaterAlive() {
        ClientUpdater cu;
        boolean result = false;
        QueueConnectionImpl primary = (QueueConnectionImpl)this.queueConnections.getPrimary();
        if (primary != null && (cu = primary.getUpdater()) != null) {
            result = cu.isAlive();
        }
        return result;
    }

    @Override
    public QueueManager.QueueConnections getAllConnectionsNoWait() {
        return this.queueConnections;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QueueManager.QueueConnections getAllConnections() {
        ConnectionList snapshot = this.queueConnections;
        if (snapshot.getPrimary() == null) {
            Object object = this.lock;
            synchronized (object) {
                snapshot = this.queueConnections;
                while (snapshot.getPrimary() == null && !snapshot.primaryDiscoveryFailed() && !this.shuttingDown && this.pool.getPoolOrCacheCancelInProgress() == null) {
                    try {
                        this.lock.wait();
                    }
                    catch (InterruptedException ignore) {
                        Thread.currentThread().interrupt();
                        break;
                    }
                    snapshot = this.queueConnections;
                }
            }
        }
        if (snapshot.getPrimary() == null) {
            this.pool.getCancelCriterion().checkCancelInProgress(null);
            GemFireException exception = snapshot.getPrimaryDiscoveryException();
            exception = exception == null || exception instanceof NoSubscriptionServersAvailableException ? new NoSubscriptionServersAvailableException(exception) : new ServerConnectivityException(exception.getMessage(), exception);
            throw exception;
        }
        return snapshot;
    }

    @Override
    public InternalLogWriter getSecurityLogger() {
        return this.securityLogger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(boolean keepAlive) {
        this.endpointManager.removeListener(this.endpointListener);
        Object object = this.lock;
        synchronized (object) {
            this.shuttingDown = true;
            if (this.redundancySatisfierTask != null) {
                this.redundancySatisfierTask.cancel();
            }
            this.lock.notifyAll();
        }
        if (this.recoveryThread != null) {
            this.recoveryThread.shutdown();
        }
        if (this.recoveryThread != null) {
            try {
                if (!this.recoveryThread.awaitTermination(PoolImpl.SHUTDOWN_TIMEOUT, TimeUnit.MILLISECONDS)) {
                    logger.warn((Message)LocalizedMessage.create(LocalizedStrings.QueueManagerImpl_TIMEOUT_WAITING_FOR_RECOVERY_THREAD_TO_COMPLETE));
                }
            }
            catch (InterruptedException ignore) {
                Thread.currentThread().interrupt();
                logger.debug("Interrupted waiting for recovery thread termination");
            }
        }
        QueueConnectionImpl primary = (QueueConnectionImpl)this.queueConnections.getPrimary();
        if (logger.isDebugEnabled()) {
            logger.debug("QueueManagerImpl - closing connections with keepAlive={}", (Object)keepAlive);
        }
        if (primary != null) {
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug("QueueManagerImpl - closing primary {}", (Object)primary);
                }
                primary.internalClose(keepAlive);
            }
            catch (Exception e) {
                logger.warn((Message)LocalizedMessage.create(LocalizedStrings.QueueManagerImpl_ERROR_CLOSING_PRIMARY_CONNECTION_TO_0, primary.getEndpoint()), (Throwable)e);
            }
        }
        List backups = this.queueConnections.getBackups();
        for (QueueConnectionImpl backup : backups) {
            if (backup == null) continue;
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug("QueueManagerImpl - closing backup {}", (Object)backup);
                }
                backup.internalClose(keepAlive);
            }
            catch (Exception e) {
                logger.warn((Message)LocalizedMessage.create(LocalizedStrings.QueueManagerImpl_ERROR_CLOSING_BACKUP_CONNECTION_TO_0, backup.getEndpoint()), (Throwable)e);
            }
        }
    }

    @Override
    public void emergencyClose() {
        this.shuttingDown = true;
        this.queueConnections.getPrimary().emergencyClose();
        List backups = this.queueConnections.getBackups();
        for (int i = 0; i < backups.size(); ++i) {
            Connection backup = (Connection)backups.get(i);
            backup.emergencyClose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(ScheduledExecutorService background) {
        try {
            this.blackList.start(background);
            this.endpointManager.addListener(this.endpointListener);
            final String name = "queueTimer-" + this.pool.getName();
            this.recoveryThread = new ScheduledThreadPoolExecutor(1, new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    Thread result = new Thread(r, name);
                    result.setDaemon(true);
                    return result;
                }
            });
            this.recoveryThread.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
            this.getState().start(background, this.getPool().getSubscriptionAckInterval());
            this.initializeConnections();
            this.scheduleRedundancySatisfierIfNeeded(this.redundancyRetryInterval);
            ServerBlackList.BlackListListenerAdapter blackListListener = new ServerBlackList.BlackListListenerAdapter(){

                @Override
                public void serverRemoved(ServerLocation location) {
                    QueueManagerImpl.this.scheduleRedundancySatisfierIfNeeded(0L);
                }
            };
            this.blackList.addListener(blackListListener);
            this.factory.getBlackList().addListener(blackListListener);
        }
        finally {
            this.initializedLatch.countDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readyForEvents(InternalDistributedSystem system) {
        Object object = this.lock;
        synchronized (object) {
            this.sentClientReady = true;
        }
        QueueConnectionImpl primary = null;
        while (primary == null) {
            try {
                primary = (QueueConnectionImpl)this.getAllConnections().getPrimary();
            }
            catch (NoSubscriptionServersAvailableException ignore) {
                primary = null;
                break;
            }
            if (!primary.sendClientReady()) continue;
            try {
                logger.info((Message)LocalizedMessage.create(LocalizedStrings.QueueManagerImpl_SENDING_READY_FOR_EVENTS_TO_PRIMARY_0, primary));
                ReadyForEventsOp.execute(this.pool, primary);
            }
            catch (Exception e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Error sending ready for events to {}", (Object)primary, (Object)e);
                }
                primary.destroy();
                primary = null;
            }
        }
    }

    public void readyForEventsAfterFailover(QueueConnectionImpl primary) {
        try {
            logger.info((Message)LocalizedMessage.create(LocalizedStrings.QueueManagerImpl_SENDING_READY_FOR_EVENTS_TO_PRIMARY_0, primary));
            ReadyForEventsOp.execute(this.pool, primary);
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug("Error sending ready for events to {}", (Object)primary, (Object)e);
            }
            primary.destroy();
        }
    }

    void connectionCrashed(Connection con) {
        this.endpointCrashed(con.getEndpoint());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void endpointCrashed(Endpoint endpoint) {
        QueueConnectionImpl deadConnection = null;
        Object object = this.lock;
        synchronized (object) {
            deadConnection = this.queueConnections.getConnection(endpoint);
            if (deadConnection != null) {
                this.queueConnections = this.queueConnections.removeConnection(deadConnection);
            }
        }
        if (deadConnection != null) {
            Object[] objectArray = new Object[2];
            objectArray[0] = deadConnection.getUpdater() != null ? (deadConnection.getUpdater().isPrimary() ? "Primary" : "Redundant") : "Queue";
            objectArray[1] = endpoint;
            logger.info((Message)LocalizedMessage.create(LocalizedStrings.QueueManagerImpl_SUBSCRIPTION_ENDPOINT_CRASHED_SCHEDULING_RECOVERY, objectArray));
            this.scheduleRedundancySatisfierIfNeeded(0L);
            deadConnection.internalDestroy();
        } else if (logger.isDebugEnabled()) {
            logger.debug("Ignoring crashed endpoint {} it does not have a queue.", (Object)endpoint);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkEndpoint(ClientUpdater ccu, Endpoint endpoint) {
        QueueConnectionImpl deadConnection = null;
        Object object = this.lock;
        synchronized (object) {
            if (this.shuttingDown) {
                return;
            }
            deadConnection = this.queueConnections.getConnection(endpoint);
            if (deadConnection != null && ccu.equals(deadConnection.getUpdater())) {
                this.queueConnections = this.queueConnections.removeConnection(deadConnection);
                try {
                    deadConnection.internalClose(this.pool.getKeepAlive());
                }
                catch (Exception e) {
                    logger.warn("Error destroying client to server connection to {}", (Object)deadConnection.getEndpoint(), (Object)e);
                }
            }
        }
        Object[] objectArray = new Object[2];
        objectArray[0] = deadConnection != null && deadConnection.getUpdater() != null ? (deadConnection.getUpdater().isPrimary() ? "Primary" : "Redundant") : "Queue";
        objectArray[1] = endpoint;
        logger.info((Message)LocalizedMessage.create(LocalizedStrings.QueueManagerImpl_CACHE_CLIENT_UPDATER_FOR_ON_ENDPOINT_EXITING_SCHEDULING_RECOVERY, objectArray));
        this.scheduleRedundancySatisfierIfNeeded(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeConnections() {
        Object object;
        boolean isDebugEnabled = logger.isDebugEnabled();
        if (isDebugEnabled) {
            logger.debug("SubscriptionManager - intitializing connections");
        }
        int queuesNeeded = this.redundancyLevel == -1 ? -1 : this.redundancyLevel + 1;
        HashSet<ServerLocation> excludedServers = new HashSet<ServerLocation>(this.blackList.getBadServers());
        List servers = this.findQueueServers(excludedServers, queuesNeeded, true, false, null);
        if (servers == null || servers.isEmpty()) {
            logger.warn((Object)LocalizedStrings.QueueManagerImpl_COULD_NOT_CREATE_A_QUEUE_NO_QUEUE_SERVERS_AVAILABLE);
            this.scheduleRedundancySatisfierIfNeeded(this.redundancyRetryInterval);
            Object object2 = this.lock;
            synchronized (object2) {
                this.queueConnections = this.queueConnections.setPrimaryDiscoveryFailed(null);
                this.lock.notifyAll();
            }
            return;
        }
        if (isDebugEnabled) {
            logger.debug("SubscriptionManager - discovered subscription servers {}", (Object)servers);
        }
        TreeMap<ServerQueueStatus, Connection> oldQueueServers = new TreeMap<ServerQueueStatus, Connection>(QSIZE_COMPARATOR);
        ArrayList<Connection> nonRedundantServers = new ArrayList<Connection>();
        for (ServerLocation server : servers) {
            Connection connection;
            block37: {
                connection = null;
                try {
                    connection = this.factory.createClientToServerConnection(server, true);
                }
                catch (GemFireSecurityException e) {
                    throw e;
                }
                catch (GemFireConfigException e) {
                    throw e;
                }
                catch (Exception e) {
                    if (!isDebugEnabled) break block37;
                    logger.debug("SubscriptionManager - Error connected to server: {}", (Object)server, (Object)e);
                }
            }
            if (connection == null) continue;
            ServerQueueStatus status = connection.getQueueStatus();
            if (status.isRedundant() || status.isPrimary()) {
                oldQueueServers.put(status, connection);
                continue;
            }
            nonRedundantServers.add(connection);
        }
        Connection newPrimary = null;
        if (!oldQueueServers.isEmpty()) {
            newPrimary = (Connection)oldQueueServers.remove(oldQueueServers.lastKey());
        } else if (!nonRedundantServers.isEmpty()) {
            newPrimary = (Connection)nonRedundantServers.remove(0);
        }
        nonRedundantServers.addAll(0, oldQueueServers.values());
        for (Connection connection : nonRedundantServers) {
            QueueConnectionImpl queueConnection = this.initializeQueueConnection(connection, false, null);
            if (queueConnection == null) continue;
            this.addToConnectionList(queueConnection, false);
        }
        QueueConnectionImpl primaryQueue = null;
        if (newPrimary != null) {
            primaryQueue = this.initializeQueueConnection(newPrimary, true, null);
            if (primaryQueue == null) {
                newPrimary.destroy();
            } else if (!this.addToConnectionList(primaryQueue, true)) {
                primaryQueue = null;
            }
        }
        excludedServers.addAll(servers);
        if (this.redundancyLevel != -1 && this.getCurrentRedundancy() < this.redundancyLevel) {
            if (isDebugEnabled) {
                logger.debug("SubscriptionManager - Some initial connections failed. Trying to create redundant queues");
            }
            this.recoverRedundancy(excludedServers, false);
        }
        if (this.redundancyLevel != -1 && primaryQueue == null) {
            if (isDebugEnabled) {
                logger.debug("SubscriptionManager - Intial primary creation failed. Trying to create a new primary");
            }
            while (primaryQueue == null && (primaryQueue = this.createNewPrimary(excludedServers)) != null) {
                if (this.addToConnectionList(primaryQueue, true)) continue;
                excludedServers.add(primaryQueue.getServer());
                primaryQueue = null;
            }
        }
        if (primaryQueue == null) {
            if (isDebugEnabled) {
                logger.debug("SubscriptionManager - Unable to create a new primary queue, using one of the redundant queues");
            }
            while (primaryQueue == null && (primaryQueue = this.promoteBackupToPrimary(this.queueConnections.getBackups())) != null) {
                if (this.addToConnectionList(primaryQueue, true)) continue;
                object = this.lock;
                synchronized (object) {
                    this.queueConnections = this.queueConnections.removeConnection(primaryQueue);
                }
                primaryQueue = null;
            }
        }
        if (primaryQueue == null) {
            logger.error((Message)LocalizedMessage.create(LocalizedStrings.QueueManagerImpl_COULD_NOT_INITIALIZE_A_PRIMARY_QUEUE_ON_STARTUP_NO_QUEUE_SERVERS_AVAILABLE));
            object = this.lock;
            synchronized (object) {
                this.queueConnections = this.queueConnections.setPrimaryDiscoveryFailed(new NoSubscriptionServersAvailableException(LocalizedStrings.QueueManagerImpl_COULD_NOT_INITIALIZE_A_PRIMARY_QUEUE_ON_STARTUP_NO_QUEUE_SERVERS_AVAILABLE.toLocalizedString()));
                this.lock.notifyAll();
            }
            this.cqsDisconnected();
        } else {
            this.cqsConnected();
        }
        if (this.getCurrentRedundancy() < this.redundancyLevel) {
            logger.warn((Message)LocalizedMessage.create(LocalizedStrings.QueueManagerImpl_UNABLE_TO_INITIALIZE_ENOUGH_REDUNDANT_QUEUES_ON_STARTUP_THE_REDUNDANCY_COUNT_IS_CURRENTLY_0, this.getCurrentRedundancy()));
        }
    }

    private void cqsConnected() {
        GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
        if (cache != null) {
            CqService cqService = cache.getCqService();
            cqService.cqsConnected(this.pool);
        }
    }

    private void cqsDisconnected() {
        GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
        if (cache != null) {
            CqService cqService = cache.getCqService();
            cqService.cqsDisconnected(this.pool);
        }
    }

    private int getCurrentRedundancy() {
        return this.queueConnections.getBackups().size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean recoverRedundancy(Set excludedServers, boolean recoverInterest) {
        int additionalBackups;
        if (this.pool.getPoolOrCacheCancelInProgress() != null) {
            return true;
        }
        while (this.pool.getPoolOrCacheCancelInProgress() == null && ((additionalBackups = this.redundancyLevel - this.getCurrentRedundancy()) > 0 || this.redundancyLevel == -1)) {
            List servers;
            if (this.redundancyLevel != -1 && this.printRecoveringRedundant) {
                logger.info((Message)LocalizedMessage.create(LocalizedStrings.QueueManagerImpl_SUBSCRIPTION_MANAGER_REDUNDANCY_SATISFIER_REDUNDANT_ENDPOINT_HAS_BEEN_LOST_ATTEMPTIMG_TO_RECOVER));
                this.printRecoveringRedundant = false;
            }
            if ((servers = this.findQueueServers(excludedServers, this.redundancyLevel == -1 ? -1 : additionalBackups, false, this.redundancyLevel == -1 ? false : this.printRedundancyNotSatisfiedError, LocalizedStrings.QueueManagerImpl_COULD_NOT_FIND_SERVER_TO_CREATE_REDUNDANT_CLIENT_QUEUE)) == null || servers.isEmpty()) {
                if (this.redundancyLevel != -1 && this.printRedundancyNotSatisfiedError) {
                    logger.info((Message)LocalizedMessage.create(LocalizedStrings.QueueManagerImpl_REDUNDANCY_LEVEL_0_IS_NOT_SATISFIED_BUT_THERE_ARE_NO_MORE_SERVERS_AVAILABLE_REDUNDANCY_IS_CURRENTLY_1, new Object[]{this.redundancyLevel, this.getCurrentRedundancy()}));
                }
                this.printRedundancyNotSatisfiedError = false;
                return false;
            }
            excludedServers.addAll(servers);
            boolean isDebugEnabled = logger.isDebugEnabled();
            for (ServerLocation server : servers) {
                QueueConnectionImpl queueConnection;
                Connection connection;
                block15: {
                    connection = null;
                    try {
                        connection = this.factory.createClientToServerConnection(server, true);
                    }
                    catch (GemFireSecurityException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        if (!isDebugEnabled) break block15;
                        logger.debug("SubscriptionManager - Error connecting to server: ()", (Object)server, (Object)e);
                    }
                }
                if (connection == null || (queueConnection = this.initializeQueueConnection(connection, false, null)) == null) continue;
                boolean isFirstNewConnection = false;
                Object object = this.lock;
                synchronized (object) {
                    if (recoverInterest && this.queueConnections.getPrimary() == null && this.queueConnections.getBackups().isEmpty()) {
                        isFirstNewConnection = true;
                    }
                }
                boolean promotionFailed = false;
                if (isFirstNewConnection && !this.promoteBackupCnxToPrimary(queueConnection)) {
                    promotionFailed = true;
                }
                if (promotionFailed || !this.addToConnectionList(queueConnection, isFirstNewConnection)) continue;
                this.printRedundancyNotSatisfiedError = true;
                this.printRecoveringRedundant = true;
                if (logger.isDebugEnabled()) {
                    logger.debug("SubscriptionManager redundancy satisfier - created a queue on server {}", (Object)queueConnection.getEndpoint());
                }
                if (!recoverInterest) continue;
                this.recoverInterest(queueConnection, isFirstNewConnection);
            }
        }
        return true;
    }

    private QueueConnectionImpl promoteBackupToPrimary(List backups) {
        QueueConnectionImpl primary = null;
        for (int i = 0; primary == null && i < backups.size(); ++i) {
            QueueConnectionImpl lastConnection = (QueueConnectionImpl)backups.get(i);
            if (!this.promoteBackupCnxToPrimary(lastConnection)) continue;
            primary = lastConnection;
        }
        return primary;
    }

    private boolean promoteBackupCnxToPrimary(QueueConnectionImpl cnx) {
        boolean result;
        block8: {
            result = false;
            if (PoolImpl.BEFORE_PRIMARY_IDENTIFICATION_FROM_BACKUP_CALLBACK_FLAG) {
                ClientServerObserver bo = ClientServerObserverHolder.getInstance();
                bo.beforePrimaryIdentificationFromBackup();
            }
            try {
                ClientUpdater updater;
                boolean haveSentClientReady = this.sentClientReady;
                if (haveSentClientReady) {
                    cnx.sendClientReady();
                }
                if ((updater = cnx.getUpdater()) == null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("backup connection was destroyed before it could become the primary.");
                    }
                    Assert.assertTrue(cnx.isDestroyed());
                } else {
                    updater.setFailedUpdater(this.queueConnections.getFailedUpdater());
                    MakePrimaryOp.execute(this.pool, cnx, haveSentClientReady);
                    result = true;
                    if (PoolImpl.AFTER_PRIMARY_IDENTIFICATION_FROM_BACKUP_CALLBACK_FLAG) {
                        ClientServerObserver bo = ClientServerObserverHolder.getInstance();
                        bo.afterPrimaryIdentificationFromBackup(cnx.getServer());
                    }
                }
            }
            catch (Exception e) {
                if (this.pool.getPoolOrCacheCancelInProgress() != null || !logger.isDebugEnabled()) break block8;
                logger.debug("Error making a backup server the primary server for client subscriptions", (Throwable)e);
            }
        }
        return result;
    }

    private QueueConnectionImpl createNewPrimary(Set excludedServers) {
        QueueConnectionImpl primary = null;
        while (primary == null && this.pool.getPoolOrCacheCancelInProgress() == null) {
            Connection connection;
            List servers;
            block6: {
                servers = this.findQueueServers(excludedServers, 1, false, this.printPrimaryNotFoundError, LocalizedStrings.QueueManagerImpl_COULD_NOT_FIND_SERVER_TO_CREATE_PRIMARY_CLIENT_QUEUE);
                this.printPrimaryNotFoundError = false;
                if (servers == null || servers.isEmpty()) break;
                connection = null;
                try {
                    connection = this.factory.createClientToServerConnection((ServerLocation)servers.get(0), true);
                }
                catch (GemFireSecurityException e) {
                    throw e;
                }
                catch (Exception e) {
                    if (!logger.isDebugEnabled()) break block6;
                    logger.debug("SubscriptionManagerImpl - error creating a connection to server {}", servers.get(0));
                }
            }
            if (connection != null) {
                primary = this.initializeQueueConnection(connection, true, this.queueConnections.getFailedUpdater());
            }
            excludedServers.addAll(servers);
        }
        if (primary != null && this.sentClientReady && primary.sendClientReady()) {
            this.readyForEventsAfterFailover(primary);
        }
        return primary;
    }

    private List findQueueServers(Set excludedServers, int count, boolean findDurable, boolean printErrorMessage, StringId msgId) {
        Exception ex;
        List servers;
        block5: {
            servers = null;
            ex = null;
            try {
                if (this.pool.getPoolOrCacheCancelInProgress() != null) {
                    return null;
                }
                servers = this.source.findServersForQueue(excludedServers, count, this.proxyId, findDurable);
            }
            catch (GemFireSecurityException e) {
                throw e;
            }
            catch (Exception e) {
                ex = e;
                if (!logger.isDebugEnabled()) break block5;
                logger.debug("SubscriptionManager - Error getting the list of servers: {}", (Throwable)e);
            }
        }
        if (printErrorMessage && (servers == null || servers.isEmpty())) {
            logger.error((Message)LocalizedMessage.create(msgId, new Object[]{excludedServers != null ? excludedServers.size() : 0, ex != null ? ex.getMessage() : "no exception"}));
        }
        return servers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void recoverPrimary(Set excludedServers) {
        ClientServerObserver bo;
        List backups;
        if (this.pool.getPoolOrCacheCancelInProgress() != null) {
            return;
        }
        boolean isDebugEnabled = logger.isDebugEnabled();
        if (this.queueConnections.getPrimary() != null) {
            if (isDebugEnabled) {
                logger.debug("Primary recovery not needed");
            }
            return;
        }
        if (isDebugEnabled) {
            logger.debug("SubscriptionManager redundancy satisfier - primary endpoint has been lost. Attempting to recover");
        }
        if (this.printRecoveringPrimary) {
            logger.info((Message)LocalizedMessage.create(LocalizedStrings.QueueManagerImpl_SUBSCRIPTION_MANAGER_REDUNDANCY_SATISFIER_PRIMARY_ENDPOINT_HAS_BEEN_LOST_ATTEMPTIMG_TO_RECOVER));
            this.printRecoveringPrimary = false;
        }
        QueueConnectionImpl newPrimary = null;
        while (newPrimary == null && this.pool.getPoolOrCacheCancelInProgress() == null && (newPrimary = this.promoteBackupToPrimary(backups = this.queueConnections.getBackups())) != null) {
            if (this.addToConnectionList(newPrimary, true)) continue;
            Object object = this.lock;
            synchronized (object) {
                this.queueConnections = this.queueConnections.removeConnection(newPrimary);
            }
            newPrimary = null;
        }
        if (newPrimary != null) {
            if (isDebugEnabled) {
                logger.debug("SubscriptionManager redundancy satisfier - Switched backup server to primary: {}", (Object)newPrimary.getEndpoint());
            }
            if (PoolImpl.AFTER_PRIMARY_RECOVERED_CALLBACK_FLAG) {
                bo = ClientServerObserverHolder.getInstance();
                bo.afterPrimaryRecovered(newPrimary.getServer());
            }
            this.cqsConnected();
            this.printPrimaryNotFoundError = true;
            this.printRecoveringPrimary = true;
            return;
        }
        if (newPrimary == null && (newPrimary = this.createNewPrimary(excludedServers)) != null) {
            if (!this.addToConnectionList(newPrimary, true)) {
                excludedServers.add(newPrimary.getServer());
                newPrimary = null;
            }
            if (newPrimary != null) {
                if (isDebugEnabled) {
                    logger.debug("SubscriptionManager redundancy satisfier - Non backup server was made primary. Recovering interest {}", (Object)newPrimary.getEndpoint());
                }
                if (!this.recoverInterest(newPrimary, true)) {
                    excludedServers.add(newPrimary.getServer());
                    newPrimary = null;
                }
                this.cqsConnected();
            }
            if (newPrimary != null && PoolImpl.AFTER_PRIMARY_RECOVERED_CALLBACK_FLAG) {
                bo = ClientServerObserverHolder.getInstance();
                bo.afterPrimaryRecovered(newPrimary.getServer());
            }
            this.printPrimaryNotFoundError = true;
            this.printRecoveringPrimary = true;
            return;
        }
        this.cqsDisconnected();
        if (isDebugEnabled) {
            logger.debug("SubscriptionManager redundancy satisfier - Could not recover a new primary");
        }
        Object object = this.lock;
        synchronized (object) {
            this.queueConnections = this.queueConnections.setPrimaryDiscoveryFailed(null);
            this.lock.notifyAll();
        }
    }

    private QueueConnectionImpl initializeQueueConnection(Connection connection, boolean isPrimary, ClientUpdater failedUpdater) {
        ServerBlackList.FailureTracker failureTracker;
        QueueConnectionImpl queueConnection;
        block5: {
            queueConnection = null;
            failureTracker = this.blackList.getFailureTracker(connection.getServer());
            try {
                ClientUpdater updater = this.factory.createServerToClientConnection(connection.getEndpoint(), this, isPrimary, failedUpdater);
                if (updater != null) {
                    queueConnection = new QueueConnectionImpl(this, connection, updater, failureTracker);
                } else {
                    logger.warn((Message)LocalizedMessage.create(LocalizedStrings.QueueManagerImpl_UNABLE_TO_CREATE_A_SUBSCRIPTION_CONNECTION_TO_SERVER_0, connection.getEndpoint()));
                }
            }
            catch (Exception e) {
                if (!logger.isDebugEnabled()) break block5;
                logger.debug("error creating subscription connection to server {}", (Object)connection.getEndpoint(), (Object)e);
            }
        }
        if (queueConnection == null) {
            failureTracker.addFailure();
            connection.destroy();
        }
        return queueConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addToConnectionList(QueueConnectionImpl connection, boolean isPrimary) {
        boolean isBadConnection;
        block12: {
            Object object = this.lock;
            synchronized (object) {
                ClientUpdater cu = connection.getUpdater();
                if (cu == null || !cu.isAlive() || !cu.isProcessing()) {
                    return false;
                }
                if (connection.getEndpoint().isClosed() || this.shuttingDown || this.pool.getPoolOrCacheCancelInProgress() != null) {
                    isBadConnection = true;
                } else {
                    isBadConnection = false;
                    if (isPrimary) {
                        this.queueConnections = this.queueConnections.setPrimary(connection);
                        this.lock.notifyAll();
                    } else {
                        this.queueConnections = this.queueConnections.addBackup(connection);
                    }
                }
            }
            if (isBadConnection) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Endpoint {} crashed while creating a connection. The connection will be destroyed", (Object)connection.getEndpoint());
                }
                try {
                    connection.internalClose(this.pool.getKeepAlive());
                }
                catch (Exception e) {
                    if (!logger.isDebugEnabled()) break block12;
                    logger.debug("Error destroying client to server connection to {}", (Object)connection.getEndpoint(), (Object)e);
                }
            }
        }
        return !isBadConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scheduleRedundancySatisfierIfNeeded(long delay) {
        if (this.shuttingDown) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.shuttingDown) {
                return;
            }
            if (this.queueConnections.getPrimary() == null || this.getCurrentRedundancy() < this.redundancyLevel || this.redundancyLevel == -1 || this.queueConnections.primaryDiscoveryFailed()) {
                if (this.redundancySatisfierTask != null) {
                    if (this.redundancySatisfierTask.getRemainingDelay() > delay) {
                        this.redundancySatisfierTask.cancel();
                    } else {
                        return;
                    }
                }
                this.redundancySatisfierTask = new RedundancySatisfierTask();
                try {
                    ScheduledFuture<?> future = this.recoveryThread.schedule(this.redundancySatisfierTask, delay, TimeUnit.MILLISECONDS);
                    this.redundancySatisfierTask.setFuture(future);
                }
                catch (RejectedExecutionException rejectedExecutionException) {
                    // empty catch block
                }
            }
        }
    }

    private boolean recoverInterest(QueueConnectionImpl newConnection, boolean isFirstNewConnection) {
        if (this.pool.getPoolOrCacheCancelInProgress() != null) {
            return true;
        }
        try {
            this.recoverAllInterestTypes(newConnection, isFirstNewConnection);
            newConnection.getFailureTracker().reset();
            return true;
        }
        catch (CancelException ignore) {
            return true;
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Throwable t) {
            SystemFailure.checkFailure();
            this.pool.getCancelCriterion().checkCancelInProgress(t);
            logger.warn((Message)LocalizedMessage.create(LocalizedStrings.QueueManagerImpl_QUEUEMANAGERIMPL_FAILED_TO_RECOVER_INTEREST_TO_SERVER_0, newConnection.getServer()), t);
            newConnection.getFailureTracker().addFailure();
            newConnection.destroy();
            return false;
        }
    }

    @Override
    public QueueState getState() {
        return this.state;
    }

    private void recoverSingleList(int interestType2, Connection recoveredConnection, boolean isDurable, boolean receiveValues, boolean isFirstNewConnection) {
        for (RegisterInterestTracker.RegionInterestEntry e : this.getPool().getRITracker().getRegionToInterestsMap(interestType2, isDurable, !receiveValues).values()) {
            this.recoverSingleRegion(e.getRegion(), e.getInterests(), interestType2, recoveredConnection, isDurable, receiveValues, isFirstNewConnection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recoverCqs(Connection recoveredConnection, boolean isDurable) {
        Map cqs = this.getPool().getRITracker().getCqsMap();
        for (Map.Entry e : cqs.entrySet()) {
            ClientCQ cqi = (ClientCQ)e.getKey();
            String name = cqi.getName();
            if (this.pool.getMultiuserAuthentication()) {
                UserAttributes.userAttributes.set(((DefaultQueryService)this.pool.getQueryService()).getUserAttributes(name));
            }
            try {
                if (((CqStateImpl)cqi.getState()).getState() == 4) continue;
                cqi.createOn(recoveredConnection, isDurable);
            }
            finally {
                UserAttributes.userAttributes.set(null);
            }
        }
    }

    private void recoverSingleRegion(LocalRegion r, Map keys, int interestType2, Connection recoveredConnection, boolean isDurable, boolean receiveValues, boolean isFirstNewConnection) {
        if (logger.isDebugEnabled()) {
            logger.debug("{}.recoverSingleRegion starting kind={} region={}: {}", (Object)this, (Object)InterestType.getString(interestType2), (Object)r.getFullPath(), (Object)keys);
        }
        HashMap policyMap = new HashMap();
        for (Map.Entry me : keys.entrySet()) {
            Object key = me.getKey();
            InterestResultPolicy pol = (InterestResultPolicy)me.getValue();
            if (interestType2 == 0) {
                LinkedList keyList = (LinkedList)policyMap.get(pol);
                if (keyList == null) {
                    keyList = new LinkedList();
                }
                keyList.add(key);
                policyMap.put(pol, keyList);
                continue;
            }
            this.recoverSingleKey(r, key, pol, interestType2, recoveredConnection, isDurable, receiveValues, isFirstNewConnection);
        }
        for (Map.Entry me : policyMap.entrySet()) {
            LinkedList keyList = (LinkedList)me.getValue();
            InterestResultPolicy pol = (InterestResultPolicy)me.getKey();
            this.recoverSingleKey(r, keyList, pol, interestType2, recoveredConnection, isDurable, receiveValues, isFirstNewConnection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recoverSingleKey(LocalRegion r, Object keys, InterestResultPolicy policy, int interestType2, Connection recoveredConnection, boolean isDurable, boolean receiveValues, boolean isFirstNewConnection) {
        r.startRegisterInterest();
        try {
            if (isFirstNewConnection) {
                r.clearKeysOfInterest(keys, interestType2, policy);
                if (logger.isDebugEnabled()) {
                    logger.debug("{}.recoverSingleRegion :Endpoint recovered is primary so clearing the keys of interest starting kind={} region={}: {}", (Object)this, (Object)InterestType.getString(interestType2), (Object)r.getFullPath(), keys);
                }
            }
            if (policy != InterestResultPolicy.KEYS_VALUES) {
                List serverKeys = r.getServerProxy().registerInterestOn(recoveredConnection, keys, interestType2, policy, isDurable, !receiveValues, r.getAttributes().getDataPolicy().ordinal);
                if (isFirstNewConnection) {
                    r.refreshEntriesFromServerKeys(recoveredConnection, serverKeys, policy);
                }
            } else if (!isFirstNewConnection) {
                List serverKeys = r.getServerProxy().registerInterestOn(recoveredConnection, keys, interestType2, InterestResultPolicy.NONE, isDurable, !receiveValues, r.getAttributes().getDataPolicy().ordinal);
            } else {
                List serverKeys = r.getServerProxy().registerInterestOn(recoveredConnection, keys, interestType2, policy, isDurable, !receiveValues, r.getAttributes().getDataPolicy().ordinal);
                r.refreshEntriesFromServerKeys(recoveredConnection, serverKeys, policy);
            }
        }
        finally {
            r.finishRegisterInterest();
        }
    }

    private void recoverInterestList(Connection recoveredConnection, boolean durable, boolean receiveValues, boolean isFirstNewConnection) {
        this.recoverSingleList(0, recoveredConnection, durable, receiveValues, isFirstNewConnection);
        this.recoverSingleList(1, recoveredConnection, durable, receiveValues, isFirstNewConnection);
        this.recoverSingleList(2, recoveredConnection, durable, receiveValues, isFirstNewConnection);
        this.recoverSingleList(3, recoveredConnection, durable, receiveValues, isFirstNewConnection);
    }

    protected void recoverAllInterestTypes(Connection recoveredConnection, boolean isFirstNewConnection) {
        if (PoolImpl.BEFORE_RECOVER_INTEREST_CALLBACK_FLAG) {
            ClientServerObserver bo = ClientServerObserverHolder.getInstance();
            bo.beforeInterestRecovery();
        }
        this.recoverInterestList(recoveredConnection, false, true, isFirstNewConnection);
        this.recoverInterestList(recoveredConnection, false, false, isFirstNewConnection);
        this.recoverCqs(recoveredConnection, false);
        if (this.getPool().isDurableClient()) {
            this.recoverInterestList(recoveredConnection, true, true, isFirstNewConnection);
            this.recoverInterestList(recoveredConnection, true, false, isFirstNewConnection);
            this.recoverCqs(recoveredConnection, true);
        }
    }

    protected void logError(StringId message, Throwable t) {
        if (t instanceof GemFireSecurityException) {
            this.securityLogger.error(message, t);
        } else {
            logger.error((Object)message, t);
        }
    }

    public static void loadEmergencyClasses() {
        QueueConnectionImpl.loadEmergencyClasses();
    }

    protected class RedundancySatisfierTask
    extends PoolImpl.PoolTask {
        private boolean isCancelled;
        private ScheduledFuture future;

        protected RedundancySatisfierTask() {
        }

        public void setFuture(ScheduledFuture future) {
            this.future = future;
        }

        public long getRemainingDelay() {
            return this.future.getDelay(TimeUnit.MILLISECONDS);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run2() {
            try {
                QueueManagerImpl.this.initializedLatch.await();
                Object object = QueueManagerImpl.this.lock;
                synchronized (object) {
                    if (this.isCancelled) {
                        return;
                    }
                    QueueManagerImpl.this.redundancySatisfierTask = null;
                    if (QueueManagerImpl.this.pool.getPoolOrCacheCancelInProgress() != null) {
                        QueueManagerImpl.this.lock.notifyAll();
                        return;
                    }
                }
                Set excludedServers = QueueManagerImpl.this.queueConnections.getAllLocations();
                excludedServers.addAll(QueueManagerImpl.this.blackList.getBadServers());
                excludedServers.addAll(QueueManagerImpl.this.factory.getBlackList().getBadServers());
                QueueManagerImpl.this.recoverPrimary(excludedServers);
                QueueManagerImpl.this.recoverRedundancy(excludedServers, true);
            }
            catch (VirtualMachineError err) {
                SystemFailure.initiateFailure(err);
                throw err;
            }
            catch (CancelException e) {
                throw e;
            }
            catch (Throwable t) {
                SystemFailure.checkFailure();
                Object object = QueueManagerImpl.this.lock;
                synchronized (object) {
                    QueueManagerImpl.this.queueConnections = t instanceof GemFireSecurityException ? QueueManagerImpl.this.queueConnections.setPrimaryDiscoveryFailed((GemFireSecurityException)t) : QueueManagerImpl.this.queueConnections.setPrimaryDiscoveryFailed(null);
                    QueueManagerImpl.this.lock.notifyAll();
                    QueueManagerImpl.this.pool.getCancelCriterion().checkCancelInProgress(t);
                    QueueManagerImpl.this.logError(LocalizedStrings.QueueManagerImpl_ERROR_IN_REDUNDANCY_SATISFIER, t);
                }
            }
            QueueManagerImpl.this.scheduleRedundancySatisfierIfNeeded(QueueManagerImpl.this.redundancyRetryInterval);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean cancel() {
            Object object = QueueManagerImpl.this.lock;
            synchronized (object) {
                if (this.isCancelled) {
                    return false;
                }
                this.isCancelled = true;
                this.future.cancel(false);
                QueueManagerImpl.this.redundancySatisfierTask = null;
                return true;
            }
        }
    }

    public class ConnectionList
    implements QueueManager.QueueConnections {
        private final QueueConnectionImpl primary;
        private final Map connectionMap;
        private final List backups;
        private final GemFireException primaryDiscoveryException;
        private final QueueConnectionImpl failedPrimary;

        public ConnectionList() {
            this.primary = null;
            this.connectionMap = Collections.EMPTY_MAP;
            this.backups = Collections.EMPTY_LIST;
            this.primaryDiscoveryException = null;
            this.failedPrimary = null;
        }

        private ConnectionList(QueueConnectionImpl primary, List backups, GemFireException discoveryException, QueueConnectionImpl failedPrimary) {
            this.primary = primary;
            HashMap<Endpoint, QueueConnectionImpl> allConnectionsTmp = new HashMap<Endpoint, QueueConnectionImpl>();
            for (QueueConnectionImpl nextConnection : backups) {
                allConnectionsTmp.put(nextConnection.getEndpoint(), nextConnection);
            }
            if (primary != null) {
                allConnectionsTmp.put(primary.getEndpoint(), primary);
            }
            this.connectionMap = Collections.unmodifiableMap(allConnectionsTmp);
            this.backups = Collections.unmodifiableList(new ArrayList(backups));
            QueueManagerImpl.this.pool.getStats().setSubscriptionCount(this.connectionMap.size());
            this.primaryDiscoveryException = discoveryException;
            this.failedPrimary = failedPrimary;
        }

        public ConnectionList setPrimary(QueueConnectionImpl newPrimary) {
            ArrayList newBackups = this.backups;
            if (this.backups.contains(newPrimary)) {
                newBackups = new ArrayList(this.backups);
                newBackups.remove(newPrimary);
            }
            return new ConnectionList(newPrimary, newBackups, null, null);
        }

        public ConnectionList setPrimaryDiscoveryFailed(GemFireException p_discoveryException) {
            GemFireException discoveryException = p_discoveryException;
            if (discoveryException == null) {
                discoveryException = new NoSubscriptionServersAvailableException("Primary discovery failed.");
            }
            return new ConnectionList(this.primary, this.backups, discoveryException, this.failedPrimary);
        }

        public ConnectionList addBackup(QueueConnectionImpl queueConnection) {
            ArrayList<QueueConnectionImpl> newBackups = new ArrayList<QueueConnectionImpl>(this.backups);
            newBackups.add(queueConnection);
            return new ConnectionList(this.primary, newBackups, this.primaryDiscoveryException, this.failedPrimary);
        }

        public ConnectionList removeConnection(QueueConnectionImpl connection) {
            if (this.primary == connection) {
                return new ConnectionList(null, this.backups, this.primaryDiscoveryException, this.primary);
            }
            ArrayList newBackups = new ArrayList(this.backups);
            newBackups.remove(connection);
            return new ConnectionList(this.primary, newBackups, this.primaryDiscoveryException, this.failedPrimary);
        }

        @Override
        public Connection getPrimary() {
            return this.primary;
        }

        @Override
        public List getBackups() {
            return this.backups;
        }

        public ClientUpdater getFailedUpdater() {
            if (this.failedPrimary != null) {
                return this.failedPrimary.getUpdater();
            }
            return null;
        }

        public boolean primaryDiscoveryFailed() {
            return this.primaryDiscoveryException != null;
        }

        public GemFireException getPrimaryDiscoveryException() {
            return this.primaryDiscoveryException;
        }

        @Override
        public QueueConnectionImpl getConnection(Endpoint endpoint) {
            return (QueueConnectionImpl)this.connectionMap.get(endpoint);
        }

        public Set getAllLocations() {
            HashSet<ServerLocation> locations = new HashSet<ServerLocation>();
            for (Endpoint endpoint : this.connectionMap.keySet()) {
                locations.add(endpoint.getLocation());
            }
            return locations;
        }
    }

    protected static class QSizeComparator
    implements Comparator {
        protected QSizeComparator() {
        }

        public int compare(Object o1, Object o2) {
            ServerQueueStatus s1 = (ServerQueueStatus)o1;
            ServerQueueStatus s2 = (ServerQueueStatus)o2;
            if (s1.isPrimary() && !s2.isPrimary()) {
                return -1;
            }
            if (!s1.isPrimary() && s2.isPrimary()) {
                return 1;
            }
            int diff = s1.getServerQueueSize() - s2.getServerQueueSize();
            if (diff != 0) {
                return diff;
            }
            return s1.getMemberId().compareTo(s2.getMemberId());
        }
    }
}

