/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.client.internal;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.geode.cache.client.internal.ClientUpdater;
import org.apache.geode.cache.client.internal.Connection;
import org.apache.geode.cache.client.internal.ConnectionImpl;
import org.apache.geode.cache.client.internal.ConnectionStats;
import org.apache.geode.cache.client.internal.Endpoint;
import org.apache.geode.cache.client.internal.Op;
import org.apache.geode.cache.client.internal.QueueManagerImpl;
import org.apache.geode.cache.client.internal.ServerBlackList;
import org.apache.geode.cache.client.internal.pooling.ConnectionDestroyedException;
import org.apache.geode.distributed.internal.ServerLocation;
import org.apache.geode.internal.cache.tier.sockets.ServerQueueStatus;
import org.apache.geode.internal.logging.LogService;
import org.apache.logging.log4j.Logger;

public class QueueConnectionImpl
implements Connection {
    private static final Logger logger = LogService.getLogger();
    private final AtomicReference clientToServerConn = new AtomicReference();
    private final Endpoint endpoint;
    private volatile ClientUpdater updater;
    private boolean shouldDestroy;
    private QueueManagerImpl manager;
    private final AtomicBoolean sentClientReady = new AtomicBoolean();
    private ServerBlackList.FailureTracker failureTracker;

    public QueueConnectionImpl(QueueManagerImpl manager, Connection clientToServer, ClientUpdater updater, ServerBlackList.FailureTracker failureTracker) {
        this.manager = manager;
        this.clientToServerConn.set(clientToServer);
        this.endpoint = clientToServer.getEndpoint();
        this.updater = updater;
        this.failureTracker = failureTracker;
    }

    @Override
    public void close(boolean keepAlive) throws Exception {
        throw new UnsupportedOperationException("Subscription connections should only be closed by subscription manager");
    }

    @Override
    public void emergencyClose() {
        Connection conn = this.clientToServerConn.getAndSet(null);
        if (conn != null) {
            conn.emergencyClose();
        }
    }

    public void internalClose(boolean keepAlive) throws Exception {
        try {
            this.getConnection().close(keepAlive);
        }
        finally {
            if (this.updater != null) {
                this.updater.close();
            }
        }
    }

    @Override
    public void destroy() {
        Connection conn = (Connection)this.clientToServerConn.get();
        if (conn != null) {
            this.manager.connectionCrashed(conn);
        }
    }

    public void internalDestroy() {
        block8: {
            ClientUpdater currentUpdater;
            block7: {
                Connection currentConn = (Connection)this.clientToServerConn.get();
                if (currentConn != null) {
                    if (!this.clientToServerConn.compareAndSet(currentConn, null)) {
                        return;
                    }
                    try {
                        currentConn.destroy();
                    }
                    catch (Exception e) {
                        if (!logger.isDebugEnabled()) break block7;
                        logger.debug("SubscriptionConnectionImpl - error destroying client to server connection", (Throwable)e);
                    }
                }
            }
            if ((currentUpdater = this.updater) != null) {
                try {
                    currentUpdater.close();
                }
                catch (Exception e) {
                    if (!logger.isDebugEnabled()) break block8;
                    logger.debug("SubscriptionConnectionImpl - error destroying client updater", (Throwable)e);
                }
            }
        }
        this.updater = null;
    }

    public ClientUpdater getUpdater() {
        return this.updater;
    }

    @Override
    public boolean isDestroyed() {
        return this.clientToServerConn.get() == null;
    }

    public boolean getShouldDestroy() {
        return this.shouldDestroy;
    }

    @Override
    public ByteBuffer getCommBuffer() throws SocketException {
        return this.getConnection().getCommBuffer();
    }

    @Override
    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    @Override
    public ServerQueueStatus getQueueStatus() {
        return this.getConnection().getQueueStatus();
    }

    @Override
    public ServerLocation getServer() {
        return this.getEndpoint().getLocation();
    }

    @Override
    public Socket getSocket() {
        return this.getConnection().getSocket();
    }

    @Override
    public OutputStream getOutputStream() {
        return this.getConnection().getOutputStream();
    }

    @Override
    public InputStream getInputStream() {
        return this.getConnection().getInputStream();
    }

    @Override
    public ConnectionStats getStats() {
        return this.getEndpoint().getStats();
    }

    @Override
    public Object execute(Op op) throws Exception {
        return this.getConnection().execute(op);
    }

    public Connection getConnection() {
        Connection result = (Connection)this.clientToServerConn.get();
        if (result == null) {
            throw new ConnectionDestroyedException();
        }
        return result;
    }

    public ServerBlackList.FailureTracker getFailureTracker() {
        return this.failureTracker;
    }

    public boolean sendClientReady() {
        return this.sentClientReady.compareAndSet(false, true);
    }

    public String toString() {
        Connection result = (Connection)this.clientToServerConn.get();
        if (result != null) {
            return result.toString();
        }
        return "SubscriptionConnectionImpl[" + this.getServer() + ":closed]";
    }

    public static void loadEmergencyClasses() {
        ConnectionImpl.loadEmergencyClasses();
    }

    @Override
    public short getWanSiteVersion() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getDistributedSystemId() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setWanSiteVersion(short wanSiteVersion) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setConnectionID(long id) {
        ((Connection)this.clientToServerConn.get()).setConnectionID(id);
    }

    @Override
    public long getConnectionID() {
        return ((Connection)this.clientToServerConn.get()).getConnectionID();
    }
}

