/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.client.internal;

import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.cache.EntryNotFoundException;
import org.apache.geode.cache.Operation;
import org.apache.geode.cache.client.AllConnectionsInUseException;
import org.apache.geode.cache.client.ServerConnectivityException;
import org.apache.geode.cache.client.ServerOperationException;
import org.apache.geode.cache.client.internal.AbstractOp;
import org.apache.geode.cache.client.internal.ClientMetadataService;
import org.apache.geode.cache.client.internal.Connection;
import org.apache.geode.cache.client.internal.ConnectionStats;
import org.apache.geode.cache.client.internal.ExecutablePool;
import org.apache.geode.cache.client.internal.Op;
import org.apache.geode.cache.client.internal.PoolImpl;
import org.apache.geode.distributed.internal.ServerLocation;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.EntryEventImpl;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.versions.VersionTag;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.logging.log4j.Logger;

public class DestroyOp {
    private static final Logger logger = LogService.getLogger();
    public static final int HAS_VERSION_TAG = 1;
    public static final int HAS_ENTRY_NOT_FOUND_PART = 2;
    public static boolean TEST_HOOK_ENTRY_NOT_FOUND;

    public static Object execute(ExecutablePool pool, LocalRegion region, Object key, Object expectedOldValue, Operation operation, EntryEventImpl event, Object callbackArg, boolean prSingleHopEnabled) {
        ClientMetadataService cms;
        ServerLocation server;
        if (logger.isDebugEnabled()) {
            logger.debug("Preparing DestroyOp for {} operation={}", key, (Object)operation);
        }
        DestroyOpImpl op = new DestroyOpImpl(region, key, expectedOldValue, operation, event, callbackArg, prSingleHopEnabled);
        if (prSingleHopEnabled && (server = (cms = region.getCache().getClientMetadataService()).getBucketServerLocation(region, Operation.DESTROY, key, null, callbackArg)) != null) {
            try {
                PoolImpl poolImpl = (PoolImpl)pool;
                boolean onlyUseExistingCnx = poolImpl.getMaxConnections() != -1 && poolImpl.getConnectionCount() >= poolImpl.getMaxConnections();
                op.setAllowDuplicateMetadataRefresh(!onlyUseExistingCnx);
                return pool.executeOn(server, op, true, onlyUseExistingCnx);
            }
            catch (AllConnectionsInUseException poolImpl) {
            }
            catch (ServerConnectivityException e) {
                if (e instanceof ServerOperationException) {
                    throw e;
                }
                cms.removeBucketServerLocation(server);
            }
        }
        return pool.execute(op);
    }

    public static void execute(Connection con, ExecutablePool pool, String region, Object key, Object expectedOldValue, Operation operation, EntryEventImpl event, Object callbackArg) {
        DestroyOpImpl op = new DestroyOpImpl(region, key, expectedOldValue, operation, event, callbackArg);
        pool.executeOn(con, (Op)op);
    }

    private DestroyOp() {
    }

    static /* synthetic */ Logger access$000() {
        return logger;
    }

    private static class DestroyOpImpl
    extends AbstractOp {
        Object key = null;
        private LocalRegion region;
        private Operation operation;
        private boolean prSingleHopEnabled = false;
        private EntryEventImpl event;
        private Object callbackArg;

        public DestroyOpImpl(LocalRegion region, Object key, Object expectedOldValue, Operation operation, EntryEventImpl event, Object callbackArg, boolean prSingleHopEnabled) {
            super(9, callbackArg != null ? 6 : 5);
            this.key = key;
            this.region = region;
            this.operation = operation;
            this.prSingleHopEnabled = prSingleHopEnabled;
            this.callbackArg = callbackArg;
            this.event = event;
            this.getMessage().addStringPart(region.getFullPath());
            this.getMessage().addStringOrObjPart(key);
            this.getMessage().addObjPart(expectedOldValue);
            this.getMessage().addObjPart(operation == Operation.DESTROY ? null : operation);
            this.getMessage().addBytesPart(event.getEventId().calcBytes());
            if (callbackArg != null) {
                this.getMessage().addObjPart(callbackArg);
            }
        }

        public DestroyOpImpl(String region, Object key, Object expectedOldValue, Operation operation, EntryEventImpl event, Object callbackArg) {
            super(9, callbackArg != null ? 6 : 5);
            this.key = key;
            this.event = event;
            this.callbackArg = callbackArg;
            this.getMessage().addStringPart(region);
            this.getMessage().addStringOrObjPart(key);
            this.getMessage().addObjPart(expectedOldValue);
            this.getMessage().addObjPart(operation == Operation.DESTROY ? null : operation);
            this.getMessage().addBytesPart(event.getEventId().calcBytes());
            if (callbackArg != null) {
                this.getMessage().addObjPart(callbackArg);
            }
        }

        @Override
        protected Object processResponse(Message msg) throws Exception {
            throw new UnsupportedOperationException();
        }

        /*
         * Unable to fully structure code
         */
        @Override
        protected Object processResponse(Message msg, Connection con) throws Exception {
            this.processAck(msg, "destroy");
            isReply = msg.getMessageType() == 6;
            partIdx = 0;
            flags = 0;
            if (isReply) {
                if (((flags = msg.getPart(partIdx++).getInt()) & 1) != 0) {
                    tag = (VersionTag)msg.getPart(partIdx++).getObject();
                    tag.replaceNullIDs((InternalDistributedMember)con.getEndpoint().getMemberId());
                    this.event.setVersionTag(tag);
                    if (DestroyOp.access$000().isDebugEnabled()) {
                        DestroyOp.access$000().debug("received Destroy response with {}", (Object)tag);
                    }
                } else if (DestroyOp.access$000().isDebugEnabled()) {
                    DestroyOp.access$000().debug("received Destroy response with no version tag");
                }
            }
            if (this.prSingleHopEnabled) {
                if ((bytesReceived = (part = msg.getPart(partIdx++)).getSerializedForm())[0] != 0 && bytesReceived.length == 2 && this.region != null) {
                    try {
                        cms = this.region.getCache().getClientMetadataService();
                        myVersion = cms.getMetaDataVersion(this.region, Operation.UPDATE, this.key, null, this.callbackArg);
                        if (myVersion == bytesReceived[0] && !this.isAllowDuplicateMetadataRefresh()) ** GOTO lbl27
                        cms.scheduleGetPRMetaData(this.region, false, bytesReceived[1]);
                    }
                    catch (CacheClosedException e) {
                        return null;
                    }
                }
            } else {
                ++partIdx;
            }
lbl27:
            // 4 sources

            entryNotFound = false;
            if (msg.getMessageType() == 6 && (flags & 2) != 0) {
                v0 = entryNotFound = msg.getPart(partIdx++).getInt() == 1;
                if (DestroyOp.access$000().isDebugEnabled() && (flags & 2) != 0) {
                    DestroyOp.access$000().debug("destroy response has entryNotFound={}", (Object)entryNotFound);
                }
                if (entryNotFound) {
                    DestroyOp.TEST_HOOK_ENTRY_NOT_FOUND = true;
                }
            }
            if (this.operation == Operation.REMOVE && entryNotFound) {
                if (DestroyOp.access$000().isDebugEnabled()) {
                    DestroyOp.access$000().debug("received REMOVE response from server with entryNotFound={}", (Object)entryNotFound);
                }
                return new EntryNotFoundException(LocalizedStrings.AbstractRegionMap_ENTRY_NOT_FOUND_WITH_EXPECTED_VALUE.toLocalizedString());
            }
            return null;
        }

        @Override
        protected boolean isErrorResponse(int msgType) {
            return msgType == 10;
        }

        @Override
        protected long startAttempt(ConnectionStats stats) {
            return stats.startDestroy();
        }

        @Override
        protected void endSendAttempt(ConnectionStats stats, long start) {
            stats.endDestroySend(start, this.hasFailed());
        }

        @Override
        protected void endAttempt(ConnectionStats stats, long start) {
            stats.endDestroy(start, this.hasTimedOut(), this.hasFailed());
        }

        public String toString() {
            return "DestroyOp:" + this.key;
        }
    }
}

