/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.client.internal;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.net.ssl.SSLSocket;
import org.apache.geode.CancelCriterion;
import org.apache.geode.DataSerializer;
import org.apache.geode.GemFireConfigException;
import org.apache.geode.InternalGemFireException;
import org.apache.geode.cache.GatewayConfigurationException;
import org.apache.geode.cache.client.ServerRefusedConnectionException;
import org.apache.geode.cache.client.internal.Connection;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.LonerDistributionManager;
import org.apache.geode.distributed.internal.ServerLocation;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.HeapDataOutputStream;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.InternalInstantiator;
import org.apache.geode.internal.Version;
import org.apache.geode.internal.VersionedDataInputStream;
import org.apache.geode.internal.VersionedDataOutputStream;
import org.apache.geode.internal.cache.tier.ClientSideHandshake;
import org.apache.geode.internal.cache.tier.CommunicationMode;
import org.apache.geode.internal.cache.tier.Encryptor;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.internal.cache.tier.sockets.EncryptorImpl;
import org.apache.geode.internal.cache.tier.sockets.Handshake;
import org.apache.geode.internal.cache.tier.sockets.ServerQueueStatus;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.security.AuthenticationFailedException;
import org.apache.geode.security.AuthenticationRequiredException;
import org.apache.geode.security.GemFireSecurityException;

public class ClientSideHandshakeImpl
extends Handshake
implements ClientSideHandshake {
    private final boolean multiuserSecureMode;
    private static short overrideClientVersion = (short)-1;
    private final byte replyCode;

    @Override
    protected byte getReplyCode() {
        return this.replyCode;
    }

    public ClientSideHandshakeImpl(ClientProxyMembershipID proxyId, InternalDistributedSystem distributedSystem, SecurityService securityService, boolean multiuserSecureMode) {
        this.multiuserSecureMode = multiuserSecureMode;
        this.id = proxyId;
        this.system = distributedSystem;
        this.securityService = securityService;
        this.replyCode = (byte)59;
        this.setOverrides();
        this.credentials = null;
        this.encryptor = new EncryptorImpl(distributedSystem.getSecurityLogWriter());
    }

    public ClientSideHandshakeImpl(ClientSideHandshakeImpl handshake) {
        super(handshake);
        this.multiuserSecureMode = handshake.multiuserSecureMode;
        this.replyCode = handshake.getReplyCode();
    }

    public static void setVersionForTesting(short ver) {
        if (ver > Version.CURRENT_ORDINAL) {
            overrideClientVersion = ver;
        } else {
            currentClientVersion = Version.fromOrdinalOrCurrent(ver);
            overrideClientVersion = (short)-1;
        }
    }

    private void setOverrides() {
        this.clientConflation = this.determineClientConflation();
        if (currentClientVersion.compareTo(Version.GFE_603) >= 0) {
            this.overrides = new byte[]{this.clientConflation};
        }
    }

    private byte determineClientConflation() {
        int result = 0;
        String clientConflationValue = this.system.getProperties().getProperty("conflate-events");
        if ("true".equalsIgnoreCase(clientConflationValue)) {
            result = 1;
        } else if ("false".equalsIgnoreCase(clientConflationValue)) {
            result = 2;
        }
        return (byte)result;
    }

    private InternalDistributedMember getIDForSocket(Socket sock) {
        return new InternalDistributedMember(sock.getInetAddress(), sock.getPort(), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServerQueueStatus handshakeWithServer(Connection conn, ServerLocation location, CommunicationMode communicationMode) throws IOException, AuthenticationRequiredException, AuthenticationFailedException, ServerRefusedConnectionException {
        try {
            byte acceptanceCode;
            InternalDistributedMember idm;
            ServerQueueStatus serverQStatus = null;
            Socket sock = conn.getSocket();
            DataOutputStream dos = new DataOutputStream(sock.getOutputStream());
            InputStream in = sock.getInputStream();
            DataInputStream dis = new DataInputStream(in);
            InternalDistributedMember member = this.getIDForSocket(sock);
            DistributionManager dm = ((InternalDistributedSystem)this.system).getDistributionManager();
            InternalDistributedMember internalDistributedMember = idm = dm.getDistributionManagerId();
            synchronized (internalDistributedMember) {
                if (idm.getPort() == 0 && dm instanceof LonerDistributionManager) {
                    int port = sock.getLocalPort();
                    ((LonerDistributionManager)dm).updateLonerPort(port);
                    this.id.updateID(dm.getDistributionManagerId());
                }
            }
            if (communicationMode.isWAN()) {
                this.credentials = this.getCredentials(member);
            }
            byte intermediateAcceptanceCode = this.write(dos, dis, communicationMode, 59, this.clientReadTimeout, null, this.credentials, member, false);
            String authInit = this.system.getProperties().getProperty("security-client-auth-init");
            if (!communicationMode.isWAN() && intermediateAcceptanceCode != 66 && authInit != null && authInit.length() != 0) {
                location.compareAndSetRequiresCredentials(true);
            }
            if ((acceptanceCode = dis.readByte()) == 21 && !(sock instanceof SSLSocket)) {
                throw new AuthenticationRequiredException(LocalizedStrings.HandShake_SERVER_EXPECTING_SSL_CONNECTION.toLocalizedString());
            }
            if (acceptanceCode == 67) {
                throw new GemFireConfigException("Improperly configured client detected.  Server at " + location + " is actually a locator.  Use addPoolLocator to configure locators.");
            }
            if (communicationMode.isWAN() && acceptanceCode != 62 && acceptanceCode != 63) {
                short wanSiteVersion = Version.readOrdinal(dis);
                conn.setWanSiteVersion(wanSiteVersion);
                if (wanSiteVersion < Version.CURRENT_ORDINAL) {
                    dis = new VersionedDataInputStream(dis, Version.fromOrdinalOrCurrent(wanSiteVersion));
                }
            }
            byte endpointType = dis.readByte();
            int queueSize = dis.readInt();
            member = this.readServerMember(dis);
            serverQStatus = new ServerQueueStatus(endpointType, queueSize, member);
            this.readMessage(dis, dos, acceptanceCode, member);
            if (!communicationMode.isWAN() && currentClientVersion.compareTo(Version.GFE_61) >= 0) {
                ((InternalDistributedSystem)this.system).setDeltaEnabledOnServer(dis.readBoolean());
            }
            if (communicationMode.isWAN() && Version.GFE_66.compareTo(conn.getWanSiteVersion()) <= 0 && currentClientVersion.compareTo(Version.GFE_66) >= 0) {
                int remoteDistributedSystemId = in.read();
                int localDistributedSystemId = ((InternalDistributedSystem)this.system).getDistributionManager().getDistributedSystemId();
                if (localDistributedSystemId >= 0 && localDistributedSystemId == remoteDistributedSystemId) {
                    throw new GatewayConfigurationException("Remote WAN site's distributed system id " + remoteDistributedSystemId + " matches this sites distributed system id " + localDistributedSystemId);
                }
            }
            if (communicationMode.isWAN() && Version.GFE_80.compareTo(conn.getWanSiteVersion()) <= 0 && currentClientVersion.compareTo(Version.GFE_80) >= 0) {
                int remotePdxSize = dis.readInt();
                serverQStatus.setPdxSize(remotePdxSize);
            }
            return serverQStatus;
        }
        catch (IOException ex) {
            CancelCriterion stopper = this.system.getCancelCriterion();
            stopper.checkCancelInProgress(null);
            throw ex;
        }
    }

    private InternalDistributedMember readServerMember(DataInputStream p_dis) throws IOException {
        byte[] memberBytes = DataSerializer.readByteArray(p_dis);
        ByteArrayInputStream bais = new ByteArrayInputStream(memberBytes);
        DataInputStream dis = new DataInputStream(bais);
        Version v = InternalDataSerializer.getVersionForDataStreamOrNull(p_dis);
        if (v != null) {
            dis = new VersionedDataInputStream(dis, v);
        }
        try {
            return (InternalDistributedMember)DataSerializer.readObject(dis);
        }
        catch (EOFException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalGemFireException(LocalizedStrings.HandShake_UNABLE_TO_DESERIALIZE_MEMBER.toLocalizedString(), e);
        }
    }

    @Override
    public ServerQueueStatus handshakeWithSubscriptionFeed(Socket sock, boolean isPrimary) throws IOException, AuthenticationRequiredException, AuthenticationFailedException, ServerRefusedConnectionException, ClassNotFoundException {
        ServerQueueStatus serverQueueStatus = null;
        try {
            DataOutputStream dos = new DataOutputStream(sock.getOutputStream());
            InputStream in = sock.getInputStream();
            DataInputStream dis = new DataInputStream(in);
            InternalDistributedMember member = this.getIDForSocket(sock);
            if (!this.multiuserSecureMode) {
                this.credentials = this.getCredentials(member);
            }
            CommunicationMode mode = isPrimary ? CommunicationMode.PrimaryServerToClient : CommunicationMode.SecondaryServerToClient;
            this.write(dos, dis, mode, 59, 0, new ArrayList(), this.credentials, member, true);
            byte acceptanceCode = dis.readByte();
            if (acceptanceCode == 21 && !(sock instanceof SSLSocket)) {
                throw new AuthenticationRequiredException(LocalizedStrings.HandShake_SERVER_EXPECTING_SSL_CONNECTION.toLocalizedString());
            }
            byte endpointType = dis.readByte();
            int queueSize = dis.readInt();
            this.readMessage(dis, dos, acceptanceCode, member);
            if (currentClientVersion.compareTo(Version.GFE_61) < 0) {
                return new ServerQueueStatus(endpointType, queueSize, member);
            }
            HashMap instantiatorMap = DataSerializer.readHashMap(dis);
            for (Map.Entry instantiator : instantiatorMap.entrySet()) {
                Integer id = (Integer)instantiator.getKey();
                ArrayList instantiatorArguments = (ArrayList)instantiator.getValue();
                InternalInstantiator.register((String)instantiatorArguments.get(0), (String)instantiatorArguments.get(1), (int)id, false);
            }
            HashMap dataSerializersMap = DataSerializer.readHashMap(dis);
            for (Map.Entry dataSerializer : dataSerializersMap.entrySet()) {
                Integer id = (Integer)dataSerializer.getKey();
                InternalDataSerializer.register((String)dataSerializer.getValue(), false, null, null, id);
            }
            HashMap<Integer, List<String>> dsToSupportedClassNames = DataSerializer.readHashMap(dis);
            InternalDataSerializer.updateSupportedClassesMap(dsToSupportedClassNames);
            int pingInterval = dis.readInt();
            serverQueueStatus = new ServerQueueStatus(endpointType, queueSize, member, pingInterval);
        }
        catch (IOException ex) {
            CancelCriterion stopper = this.system.getCancelCriterion();
            stopper.checkCancelInProgress(null);
            throw ex;
        }
        catch (ClassNotFoundException ex) {
            CancelCriterion stopper = this.system.getCancelCriterion();
            stopper.checkCancelInProgress(null);
            throw ex;
        }
        return serverQueueStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte write(DataOutputStream dos, DataInputStream dis, CommunicationMode communicationMode, int replyCode, int readTimeout, List ports, Properties p_credentials, DistributedMember member, boolean isCallbackConnection) throws IOException {
        byte acceptanceCode = -1;
        try (HeapDataOutputStream hdos = new HeapDataOutputStream(32, Version.CURRENT);){
            hdos.writeByte(communicationMode.getModeNumber());
            if (overrideClientVersion > 0) {
                Version.writeOrdinal(hdos, overrideClientVersion, true);
            } else {
                Version.writeOrdinal(hdos, currentClientVersion.ordinal(), true);
            }
            hdos.writeByte(replyCode);
            if (ports != null) {
                hdos.writeInt(ports.size());
                for (int i = 0; i < ports.size(); ++i) {
                    hdos.writeInt(Integer.parseInt((String)ports.get(i)));
                }
            } else {
                hdos.writeInt(readTimeout);
            }
            VersionedDataOutputStream idOut = new VersionedDataOutputStream(hdos, Version.GFE_82);
            DataSerializer.writeObject(this.id, idOut);
            if (currentClientVersion.compareTo(Version.GFE_603) >= 0) {
                byte[] overrides = this.getOverrides();
                for (int bytes = 0; bytes < overrides.length; ++bytes) {
                    hdos.writeByte(overrides[bytes]);
                }
            } else if (setClientConflationForTesting) {
                hdos.writeByte(clientConflationForTesting);
            } else {
                hdos.writeByte(this.clientConflation);
            }
            if (isCallbackConnection || communicationMode.isWAN()) {
                if (isCallbackConnection && this.multiuserSecureMode && !communicationMode.isWAN()) {
                    hdos.writeByte(3);
                    hdos.flush();
                    dos.write(hdos.toByteArray());
                    dos.flush();
                } else {
                    this.writeCredentials(dos, dis, p_credentials, ports != null, member, hdos);
                }
            } else {
                String authInitMethod = this.system.getProperties().getProperty("security-client-auth-init");
                acceptanceCode = this.writeCredential(dos, dis, authInitMethod, ports != null, member, hdos);
            }
        }
        return acceptanceCode;
    }

    @Override
    protected byte writeCredential(DataOutputStream dos, DataInputStream dis, String authInit, boolean isNotification, DistributedMember member, HeapDataOutputStream heapdos) throws IOException, GemFireSecurityException {
        if (!(this.multiuserSecureMode || authInit != null && authInit.length() != 0)) {
            heapdos.writeByte(0);
            heapdos.flush();
            dos.write(heapdos.toByteArray());
            dos.flush();
            return -1;
        }
        return super.writeCredential(dos, dis, authInit, isNotification, member, heapdos);
    }

    @Override
    public Encryptor getEncryptor() {
        return this.encryptor;
    }
}

