/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.geode.DataSerializable;
import org.apache.geode.DataSerializer;
import org.apache.geode.cache.LossAction;
import org.apache.geode.cache.ResumptionAction;
import org.apache.geode.distributed.Role;
import org.apache.geode.distributed.internal.membership.InternalRole;
import org.apache.geode.internal.i18n.LocalizedStrings;

public class MembershipAttributes
implements DataSerializable,
Externalizable {
    private Set<Role> requiredRoles;
    private LossAction lossAction;
    private ResumptionAction resumptionAction;

    public MembershipAttributes() {
        this.requiredRoles = Collections.emptySet();
        this.lossAction = LossAction.FULL_ACCESS;
        this.resumptionAction = ResumptionAction.NONE;
    }

    public MembershipAttributes(String[] requiredRoles) {
        this(requiredRoles, LossAction.NO_ACCESS, ResumptionAction.REINITIALIZE);
    }

    public MembershipAttributes(String[] requiredRoles, LossAction lossAction, ResumptionAction resumptionAction) {
        this.requiredRoles = this.toRoleSet(requiredRoles);
        if (this.requiredRoles.isEmpty()) {
            throw new IllegalArgumentException(LocalizedStrings.MembershipAttributes_ONE_OR_MORE_REQUIRED_ROLES_MUST_BE_SPECIFIED.toLocalizedString());
        }
        this.lossAction = lossAction;
        this.resumptionAction = resumptionAction;
    }

    public Set<Role> getRequiredRoles() {
        return Collections.unmodifiableSet(this.requiredRoles);
    }

    public boolean hasRequiredRoles() {
        return !this.requiredRoles.isEmpty();
    }

    public LossAction getLossAction() {
        return this.lossAction;
    }

    public ResumptionAction getResumptionAction() {
        return this.resumptionAction;
    }

    private Set<Role> toRoleSet(String[] roleNames) {
        if (roleNames == null || roleNames.length == 0) {
            return Collections.emptySet();
        }
        HashSet<Role> roleSet = new HashSet<Role>();
        for (int i = 0; i < roleNames.length; ++i) {
            roleSet.add(InternalRole.getRole(roleNames[i]));
        }
        return roleSet;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof MembershipAttributes)) {
            return false;
        }
        MembershipAttributes that = (MembershipAttributes)other;
        if (!(this.requiredRoles == that.requiredRoles || this.requiredRoles != null && this.requiredRoles.equals(that.requiredRoles))) {
            return false;
        }
        if (!(this.lossAction == that.lossAction || this.lossAction != null && this.lossAction.equals(that.lossAction))) {
            return false;
        }
        return this.resumptionAction == that.resumptionAction || this.resumptionAction != null && this.resumptionAction.equals(that.resumptionAction);
    }

    public int hashCode() {
        int result = 17;
        int mult = 37;
        result = 37 * result + (this.requiredRoles == null ? 0 : this.requiredRoles.hashCode());
        result = 37 * result + (this.lossAction == null ? 0 : this.lossAction.hashCode());
        result = 37 * result + (this.resumptionAction == null ? 0 : this.resumptionAction.hashCode());
        return result;
    }

    public String toString() {
        if (!this.hasRequiredRoles()) {
            return "RequiredRoles(none)";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("RequiredRoles(");
        boolean comma = false;
        Iterator<Role> iter = this.requiredRoles.iterator();
        while (iter.hasNext()) {
            if (comma) {
                sb.append(",");
            }
            Role role = iter.next();
            sb.append(role.getName());
            comma = true;
        }
        sb.append("); Policy:");
        sb.append(this.lossAction.toString());
        sb.append("; Action:");
        sb.append(this.resumptionAction.toString());
        return sb.toString();
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        String[] names = new String[this.requiredRoles.size()];
        Iterator<Role> iter = this.requiredRoles.iterator();
        for (int i = 0; i < names.length; ++i) {
            names[i] = iter.next().getName();
        }
        DataSerializer.writeStringArray(names, out);
        out.writeByte(this.lossAction.ordinal);
        out.writeByte(this.resumptionAction.ordinal);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.requiredRoles = this.toRoleSet(DataSerializer.readStringArray(in));
        this.lossAction = LossAction.fromOrdinal(in.readByte());
        this.resumptionAction = ResumptionAction.fromOrdinal(in.readByte());
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.toData(out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.fromData(in);
    }
}

