/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.admin.internal;

import java.io.File;
import java.net.URL;
import java.net.UnknownHostException;
import org.apache.geode.admin.ManagedEntityConfig;
import org.apache.geode.admin.internal.InetAddressUtil;
import org.apache.geode.admin.internal.InternalManagedEntity;
import org.apache.geode.internal.GemFireVersion;
import org.apache.geode.internal.admin.GemFireVM;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.net.SocketCreator;

public abstract class ManagedEntityConfigImpl
implements ManagedEntityConfig {
    private String host;
    private String workingDirectory;
    private String productDirectory;
    private String remoteCommand;
    private InternalManagedEntity entity = null;

    protected static String getLocalHostName() {
        try {
            return SocketCreator.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException ex) {
            IllegalStateException ex2 = new IllegalStateException(LocalizedStrings.ManagedEntityConfigImpl_COULD_NOT_DETERMINE_LOCALHOST.toLocalizedString());
            ex2.initCause(ex);
            throw ex2;
        }
    }

    private static File getCurrentWorkingDirectory() {
        File cwd = new File(System.getProperty("user.dir"));
        return cwd.getAbsoluteFile();
    }

    private static File getGemFireInstallation() {
        URL url = GemFireVersion.getJarURL();
        if (url == null) {
            throw new IllegalStateException(LocalizedStrings.ManagedEntityConfigImpl_COULD_NOT_FIND_GEMFIREJAR.toLocalizedString());
        }
        File gemfireJar = new File(url.getPath());
        File lib = gemfireJar.getParentFile();
        File product = lib.getParentFile();
        return product;
    }

    protected ManagedEntityConfigImpl() {
        this.host = ManagedEntityConfigImpl.getLocalHostName();
        this.workingDirectory = ManagedEntityConfigImpl.getCurrentWorkingDirectory().getAbsolutePath();
        this.productDirectory = ManagedEntityConfigImpl.getGemFireInstallation().getAbsolutePath();
        this.remoteCommand = null;
    }

    protected ManagedEntityConfigImpl(GemFireVM vm) {
        this.host = SocketCreator.getHostName(vm.getHost());
        this.workingDirectory = vm.getWorkingDirectory().getAbsolutePath();
        this.productDirectory = vm.getGeodeHomeDir().getAbsolutePath();
        this.remoteCommand = null;
    }

    protected ManagedEntityConfigImpl(ManagedEntityConfig other) {
        this.host = other.getHost();
        this.workingDirectory = other.getWorkingDirectory();
        this.productDirectory = other.getProductDirectory();
        this.remoteCommand = other.getRemoteCommand();
    }

    public void checkReadOnly() {
        if (this.isReadOnly()) {
            throw new IllegalStateException(LocalizedStrings.ManagedEntityConfigImpl_THIS_CONFIGURATION_CANNOT_BE_MODIFIED_WHILE_ITS_MANAGED_ENTITY_IS_RUNNING.toLocalizedString());
        }
    }

    protected boolean isReadOnly() {
        return this.entity != null && this.entity.isRunning();
    }

    public void setManagedEntity(InternalManagedEntity entity) {
        this.entity = entity;
    }

    protected abstract void configChanged();

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public void setHost(String host) {
        this.checkReadOnly();
        this.host = host;
        this.configChanged();
    }

    @Override
    public String getWorkingDirectory() {
        String dir = this.workingDirectory;
        return dir;
    }

    @Override
    public void setWorkingDirectory(String workingDirectory) {
        this.checkReadOnly();
        this.workingDirectory = workingDirectory;
        this.configChanged();
    }

    @Override
    public String getProductDirectory() {
        return this.productDirectory;
    }

    @Override
    public void setProductDirectory(String productDirectory) {
        this.checkReadOnly();
        this.productDirectory = productDirectory;
        this.configChanged();
    }

    @Override
    public String getRemoteCommand() {
        return this.remoteCommand;
    }

    @Override
    public void setRemoteCommand(String remoteCommand) {
        this.checkReadOnly();
        this.remoteCommand = remoteCommand;
        this.configChanged();
    }

    @Override
    public void validate() {
        if (InetAddressUtil.validateHost(this.host) == null) {
            throw new IllegalStateException(LocalizedStrings.ManagedEntityConfigImpl_INVALID_HOST_0.toLocalizedString(this.host));
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        ManagedEntityConfigImpl clone = (ManagedEntityConfigImpl)super.clone();
        clone.entity = null;
        return clone;
    }

    public String toString() {
        String className = this.getClass().getName();
        int index = className.lastIndexOf(46);
        className = className.substring(index + 1);
        StringBuffer sb = new StringBuffer();
        sb.append(className);
        sb.append(" host=");
        sb.append(this.getHost());
        sb.append(" workingDirectory=");
        sb.append(this.getWorkingDirectory());
        sb.append(" productDirectory=");
        sb.append(this.getProductDirectory());
        sb.append(" remoteCommand=\"");
        sb.append(this.getRemoteCommand());
        sb.append("\"");
        return sb.toString();
    }
}

