/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.fasterxml.jackson.databind.type.ArrayType;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.sql.Date;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.geode.management.internal.json.AbstractJSONFormatter;

public class QueryResultFormatter
extends AbstractJSONFormatter {
    private final Map<String, List<Object>> map = new LinkedHashMap<String, List<Object>>();

    public QueryResultFormatter(int maxCollectionElements) {
        this(maxCollectionElements, maxCollectionElements);
    }

    private QueryResultFormatter(int maxCollectionElements, int serializationDepth) {
        super(maxCollectionElements, serializationDepth, true);
    }

    @Override
    void postCreateMapper() {
        if (this.generateTypeInformation) {
            TypeSerializationEnforcerModule typeModule = new TypeSerializationEnforcerModule(this.nonOverridableSerializers);
            this.mapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
            typeModule.addSerializer(Date.class, new SqlDateSerializer(this.mapper.getDateFormat()));
            this.mapper.registerModule((Module)typeModule);
            this.mapper.enableDefaultTyping(ObjectMapper.DefaultTyping.NON_FINAL);
        }
    }

    public synchronized QueryResultFormatter add(String key, Object value) {
        List<Object> list = this.map.get(key);
        if (list != null) {
            list.add(value);
        } else {
            list = new ArrayList<Object>();
            if (value != null) {
                list.add(value);
            }
            this.map.put(key, list);
        }
        return this;
    }

    public synchronized String toString() {
        StringWriter writer = new StringWriter();
        try {
            boolean addComma = false;
            ((Writer)writer).write(123);
            for (Map.Entry<String, List<Object>> entry : this.map.entrySet()) {
                if (addComma) {
                    ((Writer)writer).write(44);
                }
                ((Writer)writer).write("\"");
                ((Writer)writer).write(entry.getKey());
                ((Writer)writer).write("\"");
                ((Writer)writer).write(58);
                this.writeList(writer, entry.getValue());
                addComma = true;
            }
            ((Writer)writer).write(125);
            return ((Object)writer).toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void writeList(Writer writer, List<Object> values) {
        this.serializedObjects.clear();
        try {
            writer.write(91);
            boolean addComma = false;
            int length = values.size();
            if (length == 0) {
                this.mapper.writeValue(writer, null);
            } else {
                for (Object value : values) {
                    if (addComma) {
                        writer.write(44);
                    }
                    this.mapper.writerFor(value.getClass()).writeValue(writer, value);
                    addComma = true;
                }
            }
            writer.write(93);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static class TypeSerializationEnforcerModule
    extends SimpleModule {
        private final Set<Class> nonOverridableSerializers;

        TypeSerializationEnforcerModule(Set<Class> nonOverridableSerializers) {
            this.nonOverridableSerializers = nonOverridableSerializers;
        }

        public void setupModule(Module.SetupContext context) {
            super.setupModule(context);
            context.addBeanSerializerModifier(new BeanSerializerModifier(){

                public JsonSerializer<?> modifySerializer(SerializationConfig config, BeanDescription desc, JsonSerializer<?> serializer) {
                    if (!nonOverridableSerializers.contains(desc.getBeanClass())) {
                        return new ContextAwareBeanSerializer(serializer);
                    }
                    return serializer;
                }

                public JsonSerializer<?> modifyArraySerializer(SerializationConfig config, ArrayType valueType, BeanDescription beanDesc, JsonSerializer<?> serializer) {
                    return new CustomArraySerializer(serializer);
                }
            });
        }
    }

    private static class CustomArraySerializer<T>
    extends JsonSerializer<T> {
        private final JsonSerializer defaultSerializer;

        CustomArraySerializer(JsonSerializer defaultSerializer) {
            this.defaultSerializer = defaultSerializer;
        }

        private void serializeInternal(T value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeStartArray();
            gen.writeString(value.getClass().getCanonicalName());
            this.defaultSerializer.serialize(value, gen, serializers);
            gen.writeEndArray();
        }

        public void serialize(T value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            this.serializeInternal(value, gen, serializers);
        }

        public void serializeWithType(T value, JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
            this.serializeInternal(value, gen, serializers);
        }
    }

    private static class ContextAwareBeanSerializer<T>
    extends JsonSerializer<T> {
        private final JsonSerializer defaultSerializer;

        ContextAwareBeanSerializer(JsonSerializer defaultSerializer) {
            this.defaultSerializer = defaultSerializer;
        }

        private void serializeInternal(T value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            if (gen.getOutputContext().inArray()) {
                this.defaultSerializer.serialize(value, gen, serializers);
            } else {
                gen.writeStartArray();
                gen.writeString(value.getClass().getCanonicalName());
                this.defaultSerializer.serialize(value, gen, serializers);
                gen.writeEndArray();
            }
        }

        public void serialize(T value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            this.serializeInternal(value, gen, serializers);
        }

        public void serializeWithType(T value, JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
            this.serializeInternal(value, gen, serializers);
        }
    }

    private static class SqlDateSerializer
    extends JsonSerializer<Date> {
        private final DateFormat dateFormat;

        SqlDateSerializer(DateFormat dateFormat) {
            this.dateFormat = dateFormat;
        }

        private void serializeInternal(Date value, JsonGenerator gen) throws IOException {
            gen.writeString(this.dateFormat.format(value));
        }

        public void serialize(Date value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            this.serializeInternal(value, gen);
        }

        public void serializeWithType(Date value, JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
            this.serializeInternal(value, gen);
        }
    }
}

