/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.WritableTypeId;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.query.Struct;
import org.apache.geode.cache.query.internal.StructImpl;
import org.apache.geode.management.internal.util.JsonUtil;
import org.apache.geode.pdx.PdxInstance;
import org.apache.geode.pdx.internal.PdxInstanceImpl;

public abstract class AbstractJSONFormatter {
    final ObjectMapper mapper;
    final boolean generateTypeInformation;
    final Set<Class> nonOverridableSerializers;
    final Map<Object, Object> serializedObjects;

    public AbstractJSONFormatter(int maxCollectionElements, int serializationDepth, boolean generateTypeInformation) {
        int serDepth = serializationDepth < 0 ? Integer.MAX_VALUE : serializationDepth;
        int maxElements = maxCollectionElements < 0 ? Integer.MAX_VALUE : maxCollectionElements;
        this.mapper = new ObjectMapper();
        this.serializedObjects = new IdentityHashMap<Object, Object>();
        this.generateTypeInformation = generateTypeInformation;
        this.nonOverridableSerializers = new HashSet<Class>();
        PreventReserializationModule mapperModule = new PreventReserializationModule(this.serializedObjects, serDepth);
        mapperModule.addSerializer(StructImpl.class, new StructSerializer());
        this.nonOverridableSerializers.add(StructImpl.class);
        mapperModule.addSerializer(PdxInstance.class, new PdxInstanceSerializer());
        this.nonOverridableSerializers.add(PdxInstanceImpl.class);
        mapperModule.addSerializer(Region.Entry.class, new RegionEntrySerializer());
        this.nonOverridableSerializers.add(Region.Entry.class);
        mapperModule.addSerializer(Collection.class, new CollectionSerializer(maxElements));
        this.mapper.registerModule((Module)mapperModule);
        this.mapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        this.mapper.enable(SerializationFeature.WRITE_ENUMS_USING_TO_STRING);
        this.mapper.configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true);
        this.postCreateMapper();
    }

    void postCreateMapper() {
    }

    private static class PreventReserializationModule
    extends SimpleModule {
        private final Map<Object, Object> serializedObjects;
        private final int serializationDepth;

        PreventReserializationModule(Map<Object, Object> serializedObjects, int serializationDepth) {
            this.serializedObjects = serializedObjects;
            this.serializationDepth = serializationDepth;
        }

        public void setupModule(Module.SetupContext context) {
            super.setupModule(context);
            context.addBeanSerializerModifier(new BeanSerializerModifier(){

                public JsonSerializer<?> modifySerializer(SerializationConfig config, BeanDescription desc, JsonSerializer<?> serializer) {
                    return new PreventReserializationSerializer(serializer, serializedObjects, serializationDepth);
                }
            });
        }
    }

    private static class CollectionSerializer
    extends JsonSerializer<Collection> {
        private final int maxCollectionElements;

        CollectionSerializer(int maxCollectionElements) {
            this.maxCollectionElements = maxCollectionElements;
        }

        public void serializeWithType(Collection value, JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
            gen.setCurrentValue((Object)value);
            WritableTypeId typeIdDef = typeSer.writeTypePrefix(gen, typeSer.typeId((Object)value, JsonToken.START_OBJECT));
            this.serializeElements(value, gen);
            typeSer.writeTypeSuffix(gen, typeIdDef);
        }

        public void serialize(Collection value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeStartObject();
            this.serializeElements(value, gen);
            gen.writeEndObject();
        }

        void serializeElements(Collection value, JsonGenerator gen) throws IOException {
            Iterator objects = value.iterator();
            for (int i = 0; i < this.maxCollectionElements && objects.hasNext(); ++i) {
                Object nextObject = objects.next();
                gen.writeObjectField("" + i, nextObject);
            }
        }

        public Class<Collection> handledType() {
            return Collection.class;
        }
    }

    private static class RegionEntrySerializer
    extends JsonSerializer<Region.Entry> {
        private RegionEntrySerializer() {
        }

        public void serializeWithType(Region.Entry value, JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
            typeSer.writeTypePrefix(gen, typeSer.typeId((Object)value, Region.Entry.class, JsonToken.START_OBJECT));
            gen.writeObjectField(value.getKey().toString(), value.getValue());
            typeSer.writeTypeSuffix(gen, typeSer.typeId((Object)value, JsonToken.START_OBJECT));
        }

        public void serialize(Region.Entry value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeStartObject();
            gen.writeObjectField(value.getKey().toString(), value.getValue());
            gen.writeEndObject();
        }

        public Class<Region.Entry> handledType() {
            return Region.Entry.class;
        }
    }

    private static class PdxInstanceSerializer
    extends JsonSerializer<PdxInstance> {
        private PdxInstanceSerializer() {
        }

        public void serializeWithType(PdxInstance value, JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
            WritableTypeId typeId = typeSer.typeId((Object)value, PdxInstance.class, JsonToken.START_OBJECT);
            typeSer.writeTypePrefix(gen, typeId);
            this.serializeFields(value, gen);
            typeSer.writeTypeSuffix(gen, typeId);
        }

        public void serialize(PdxInstance value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeStartObject();
            this.serializeFields(value, gen);
            gen.writeEndObject();
        }

        void serializeFields(PdxInstance value, JsonGenerator gen) throws IOException {
            for (String field : value.getFieldNames()) {
                gen.writeObjectField(field, value.getField(field));
            }
        }

        public Class<PdxInstance> handledType() {
            return PdxInstance.class;
        }
    }

    private static class StructSerializer
    extends JsonSerializer<StructImpl> {
        private StructSerializer() {
        }

        public void serializeWithType(StructImpl value, JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
            WritableTypeId typeId = typeSer.typeId((Object)value, Struct.class, JsonToken.START_OBJECT);
            typeSer.writeTypePrefix(gen, typeId);
            this.serializeElements(value, gen);
            typeSer.writeTypeSuffix(gen, typeId);
        }

        public void serialize(StructImpl value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeStartObject();
            this.serializeElements(value, gen);
            gen.writeEndObject();
        }

        void serializeElements(StructImpl value, JsonGenerator gen) throws IOException {
            String[] fields = value.getFieldNames();
            Object[] values = value.getFieldValues();
            for (int i = 0; i < fields.length; ++i) {
                gen.writeObjectField(fields[i], values[i]);
            }
        }

        public Class<StructImpl> handledType() {
            return StructImpl.class;
        }
    }

    private static class PreventReserializationSerializer
    extends JsonSerializer {
        int depth;
        Map serializedObjects;
        private JsonSerializer defaultSerializer;
        private final int serializationDepth;

        PreventReserializationSerializer(JsonSerializer serializer, Map serializedObjects, int serializationDepth) {
            this.defaultSerializer = serializer;
            this.serializedObjects = serializedObjects;
            this.serializationDepth = serializationDepth;
        }

        private boolean isPrimitiveOrWrapper(Class<?> klass) {
            return JsonUtil.isPrimitiveOrWrapper(klass);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void serializeWithType(Object value, JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
            if (value == null || this.isPrimitiveOrWrapper(value.getClass()) || value.getClass().isEnum()) {
                this.defaultSerializer.serializeWithType(value, gen, serializers, typeSer);
                return;
            }
            ++this.depth;
            try {
                if (this.depth > this.serializationDepth) {
                    gen.writeString("{}");
                } else if (this.serializedObjects.containsKey(value)) {
                    gen.writeString("duplicate " + value.getClass().getName());
                } else {
                    this.serializedObjects.put(value, value);
                    this.defaultSerializer.serializeWithType(value, gen, serializers, typeSer);
                }
            }
            finally {
                --this.depth;
            }
        }

        public void serialize(Object value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            if (value == null || this.isPrimitiveOrWrapper(value.getClass()) || value.getClass().isEnum()) {
                this.defaultSerializer.serialize(value, gen, serializers);
                return;
            }
            if (this.serializedObjects.containsKey(value)) {
                gen.writeStartObject(value);
                gen.writeFieldName("duplicate");
                gen.writeString("reference@" + Integer.toHexString(System.identityHashCode(value)));
                gen.writeEndObject();
            } else {
                this.serializedObjects.put(value, value);
                this.defaultSerializer.serialize(value, gen, serializers);
            }
        }
    }
}

