/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.configuration.realizers;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheListener;
import org.apache.geode.cache.CacheLoader;
import org.apache.geode.cache.CacheWriter;
import org.apache.geode.cache.CustomExpiry;
import org.apache.geode.cache.DataPolicy;
import org.apache.geode.cache.ExpirationAction;
import org.apache.geode.cache.ExpirationAttributes;
import org.apache.geode.cache.PartitionResolver;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.cache.RegionFactory;
import org.apache.geode.cache.Scope;
import org.apache.geode.cache.configuration.DeclarableType;
import org.apache.geode.cache.configuration.RegionAttributesType;
import org.apache.geode.cache.configuration.RegionConfig;
import org.apache.geode.cache.partition.PartitionListener;
import org.apache.geode.compression.Compressor;
import org.apache.geode.internal.cache.EvictionAttributesImpl;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.PartitionAttributesImpl;
import org.apache.geode.management.api.RealizationResult;
import org.apache.geode.management.internal.configuration.converters.RegionConverter;
import org.apache.geode.management.internal.configuration.domain.DeclarableTypeInstantiator;
import org.apache.geode.management.internal.configuration.realizers.ConfigurationRealizer;
import org.apache.geode.management.internal.util.ManagementUtils;
import org.apache.geode.management.internal.util.RegionPath;
import org.apache.geode.management.runtime.RuntimeRegionInfo;

public class RegionConfigRealizer
implements ConfigurationRealizer<org.apache.geode.management.configuration.Region, RuntimeRegionInfo> {
    private final RegionConverter converter = new RegionConverter();

    @Override
    public RealizationResult create(org.apache.geode.management.configuration.Region regionConfig, InternalCache cache) {
        RegionConfig xmlConfig = (RegionConfig)this.converter.fromConfigObject(regionConfig);
        return this.create(xmlConfig, regionConfig.getName(), cache);
    }

    public RealizationResult create(RegionConfig regionConfig, String regionPath, InternalCache cache) {
        RegionFactory factory = this.getRegionFactory(cache, regionConfig.getRegionAttributes());
        RegionPath regionPathData = new RegionPath(regionPath);
        String regionName = regionPathData.getName();
        String parentRegionPath = regionPathData.getParent();
        if (parentRegionPath == null) {
            factory.create(regionName);
            return new RealizationResult().setMessage("Region successfully created.");
        }
        Region parentRegion = cache.getRegion(parentRegionPath);
        factory.createSubregion(parentRegion, regionName);
        return new RealizationResult().setMessage("Region successfully created.");
    }

    private RegionFactory getRegionFactory(Cache cache, RegionAttributesType regionAttributes) {
        RegionFactory factory = cache.createRegionFactory();
        factory.setDataPolicy(DataPolicy.fromString(regionAttributes.getDataPolicy().name()));
        if (regionAttributes.getScope() != null) {
            factory.setScope(Scope.fromString(regionAttributes.getScope().name()));
        }
        if (regionAttributes.getCacheLoader() != null) {
            factory.setCacheLoader((CacheLoader)DeclarableTypeInstantiator.newInstance(regionAttributes.getCacheLoader(), cache));
        }
        if (regionAttributes.getCacheWriter() != null) {
            factory.setCacheWriter((CacheWriter)DeclarableTypeInstantiator.newInstance(regionAttributes.getCacheWriter(), cache));
        }
        if (regionAttributes.getCacheListeners() != null) {
            List<DeclarableType> configListeners = regionAttributes.getCacheListeners();
            CacheListener[] listeners = new CacheListener[configListeners.size()];
            for (int i = 0; i < configListeners.size(); ++i) {
                listeners[i] = (CacheListener)DeclarableTypeInstantiator.newInstance(configListeners.get(i), cache);
            }
            factory.initCacheListeners(listeners);
        }
        String keyConstraint = regionAttributes.getKeyConstraint();
        String valueConstraint = regionAttributes.getValueConstraint();
        if (keyConstraint != null && !keyConstraint.isEmpty()) {
            Class keyConstraintClass = ManagementUtils.forName(keyConstraint, "key-constraint");
            factory.setKeyConstraint(keyConstraintClass);
        }
        if (valueConstraint != null && !valueConstraint.isEmpty()) {
            Class valueConstraintClass = ManagementUtils.forName(valueConstraint, "value-constraint");
            factory.setValueConstraint(valueConstraintClass);
        }
        if (regionAttributes.getCompressor() != null) {
            factory.setCompressor((Compressor)DeclarableTypeInstantiator.newInstance(regionAttributes.getCompressor()));
        }
        if (regionAttributes.getPartitionAttributes() != null) {
            factory.setPartitionAttributes(this.convertToRegionFactoryPartitionAttributes(regionAttributes.getPartitionAttributes(), cache));
        }
        if (regionAttributes.getEntryIdleTime() != null) {
            RegionAttributesType.ExpirationAttributesType eitl = regionAttributes.getEntryIdleTime();
            factory.setEntryIdleTimeout(new ExpirationAttributes(Integer.valueOf(eitl.getTimeout()), ExpirationAction.fromXmlString(eitl.getAction())));
            if (eitl.getCustomExpiry() != null) {
                factory.setCustomEntryIdleTimeout((CustomExpiry)DeclarableTypeInstantiator.newInstance(eitl.getCustomExpiry(), cache));
            }
        }
        if (regionAttributes.getEntryTimeToLive() != null) {
            RegionAttributesType.ExpirationAttributesType ettl = regionAttributes.getEntryTimeToLive();
            factory.setEntryTimeToLive(new ExpirationAttributes(Integer.valueOf(ettl.getTimeout()), ExpirationAction.fromXmlString(ettl.getAction())));
            if (ettl.getCustomExpiry() != null) {
                factory.setCustomEntryTimeToLive((CustomExpiry)DeclarableTypeInstantiator.newInstance(ettl.getCustomExpiry(), cache));
            }
        }
        if (regionAttributes.getRegionIdleTime() != null) {
            RegionAttributesType.ExpirationAttributesType ritl = regionAttributes.getRegionIdleTime();
            factory.setRegionIdleTimeout(new ExpirationAttributes(Integer.valueOf(ritl.getTimeout()), ExpirationAction.fromXmlString(ritl.getAction())));
        }
        if (regionAttributes.getRegionTimeToLive() != null) {
            RegionAttributesType.ExpirationAttributesType rttl = regionAttributes.getRegionTimeToLive();
            factory.setRegionTimeToLive(new ExpirationAttributes(Integer.valueOf(rttl.getTimeout()), ExpirationAction.fromXmlString(rttl.getAction())));
        }
        if (regionAttributes.getEvictionAttributes() != null) {
            try {
                factory.setEvictionAttributes(EvictionAttributesImpl.fromConfig(regionAttributes.getEvictionAttributes()));
            }
            catch (Exception e) {
                throw new IllegalArgumentException("eviction-object-sizer must implement both ObjectSizer and Declarable interfaces");
            }
        }
        if (regionAttributes.getDiskStoreName() != null) {
            factory.setDiskStoreName(regionAttributes.getDiskStoreName());
        }
        if (regionAttributes.isDiskSynchronous() != null) {
            factory.setDiskSynchronous(regionAttributes.isDiskSynchronous());
        }
        if (regionAttributes.isOffHeap() != null) {
            factory.setOffHeap(regionAttributes.isOffHeap());
        }
        if (regionAttributes.isStatisticsEnabled() != null) {
            factory.setStatisticsEnabled(regionAttributes.isStatisticsEnabled());
        }
        if (regionAttributes.isEnableAsyncConflation() != null) {
            factory.setEnableAsyncConflation(regionAttributes.isEnableAsyncConflation());
        }
        if (regionAttributes.isEnableSubscriptionConflation() != null) {
            factory.setEnableSubscriptionConflation(regionAttributes.isEnableSubscriptionConflation());
        }
        if (regionAttributes.getGatewaySenderIds() != null) {
            Arrays.stream(regionAttributes.getGatewaySenderIds().split(",")).forEach(gsi -> factory.addGatewaySenderId((String)gsi));
        }
        if (regionAttributes.getAsyncEventQueueIds() != null) {
            Arrays.stream(regionAttributes.getAsyncEventQueueIds().split(",")).forEach(gsi -> factory.addAsyncEventQueueId((String)gsi));
        }
        factory.setConcurrencyChecksEnabled(regionAttributes.isConcurrencyChecksEnabled());
        if (regionAttributes.getConcurrencyLevel() != null) {
            factory.setConcurrencyLevel(Integer.valueOf(regionAttributes.getConcurrencyLevel()));
        }
        if (regionAttributes.isCloningEnabled() != null) {
            factory.setCloningEnabled(regionAttributes.isCloningEnabled());
        }
        if (regionAttributes.isMulticastEnabled() != null) {
            factory.setMulticastEnabled(regionAttributes.isMulticastEnabled());
        }
        return factory;
    }

    PartitionAttributesImpl convertToRegionFactoryPartitionAttributes(RegionAttributesType.PartitionAttributes configAttributes, Cache cache) {
        PartitionAttributesImpl partitionAttributes = new PartitionAttributesImpl();
        if (configAttributes == null) {
            return null;
        }
        if (configAttributes.getRedundantCopies() != null) {
            partitionAttributes.setRedundantCopies(Integer.valueOf(configAttributes.getRedundantCopies()));
        }
        if (configAttributes.getTotalMaxMemory() != null) {
            partitionAttributes.setTotalMaxMemory(Integer.valueOf(configAttributes.getTotalMaxMemory()).intValue());
        }
        if (configAttributes.getTotalNumBuckets() != null) {
            partitionAttributes.setTotalNumBuckets(Integer.valueOf(configAttributes.getTotalNumBuckets()));
        }
        if (configAttributes.getLocalMaxMemory() != null) {
            partitionAttributes.setLocalMaxMemory(Integer.valueOf(configAttributes.getLocalMaxMemory()));
        }
        if (configAttributes.getColocatedWith() != null) {
            partitionAttributes.setColocatedWith(configAttributes.getColocatedWith());
        }
        if (configAttributes.getPartitionResolver() != null) {
            partitionAttributes.setPartitionResolver((PartitionResolver)DeclarableTypeInstantiator.newInstance(configAttributes.getPartitionResolver(), cache));
        }
        if (configAttributes.getRecoveryDelay() != null) {
            partitionAttributes.setRecoveryDelay(Long.valueOf(configAttributes.getRecoveryDelay()));
        }
        if (configAttributes.getStartupRecoveryDelay() != null) {
            partitionAttributes.setStartupRecoveryDelay(Long.valueOf(configAttributes.getStartupRecoveryDelay()));
        }
        if (configAttributes.getPartitionListeners() != null) {
            List<DeclarableType> configListeners = configAttributes.getPartitionListeners();
            for (int i = 0; i < configListeners.size(); ++i) {
                partitionAttributes.addPartitionListener((PartitionListener)DeclarableTypeInstantiator.newInstance(configListeners.get(i), cache));
            }
        }
        return partitionAttributes;
    }

    @Override
    public RuntimeRegionInfo get(org.apache.geode.management.configuration.Region config, InternalCache cache) {
        Region region = cache.getRegion("/" + config.getName());
        if (region == null) {
            return null;
        }
        RuntimeRegionInfo info = new RuntimeRegionInfo();
        info.setEntryCount((long)region.size());
        return info;
    }

    @Override
    public RealizationResult update(org.apache.geode.management.configuration.Region config, InternalCache cache) {
        throw new NotImplementedException("Not implemented");
    }

    @Override
    public RealizationResult delete(org.apache.geode.management.configuration.Region config, InternalCache cache) {
        Region region = cache.getRegion(config.getName());
        if (region == null) {
            return new RealizationResult().setMessage("Region does not exist.");
        }
        try {
            region.destroyRegion();
        }
        catch (RegionDestroyedException dex) {
            return new RealizationResult().setMessage("Region does not exist.");
        }
        return new RealizationResult().setMessage("Region successfully deleted.");
    }
}

