/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.configuration.realizers;

import java.io.IOException;
import java.util.Optional;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.Distribution;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.management.api.RealizationResult;
import org.apache.geode.management.configuration.Member;
import org.apache.geode.management.internal.configuration.realizers.ConfigurationRealizer;
import org.apache.geode.management.internal.functions.GetMemberInformationFunction;
import org.apache.geode.management.runtime.MemberInformation;
import org.apache.logging.log4j.Logger;

public class MemberRealizer
implements ConfigurationRealizer<Member, MemberInformation> {
    private static final Logger logger = LogService.getLogger();

    @Override
    public RealizationResult create(Member config, InternalCache cache) {
        throw new IllegalStateException("Not supported");
    }

    @Override
    public MemberInformation get(Member config, InternalCache cache) {
        GetMemberInformationFunction getMemberInfoFunction = new GetMemberInformationFunction();
        InternalDistributedSystem system = (InternalDistributedSystem)cache.getDistributedSystem();
        InternalDistributedMember member = system.getDistributedMember();
        try {
            MemberInformation memberInformation = getMemberInfoFunction.getMemberInformation(cache, system.getConfig(), member);
            if (member.getId().equals(this.getCoordinatorId(cache))) {
                memberInformation.setCoordinator(true);
            }
            return memberInformation;
        }
        catch (IOException e) {
            logger.error("unable to get the member information. ", (Throwable)e);
            return null;
        }
    }

    @Override
    public RealizationResult update(Member config, InternalCache cache) {
        throw new IllegalStateException("Not supported");
    }

    @Override
    public RealizationResult delete(Member config, InternalCache cache) {
        throw new IllegalStateException("Not supported");
    }

    @VisibleForTesting
    String getCoordinatorId(InternalCache cache) {
        return Optional.ofNullable(cache.getDistributionManager()).map(DistributionManager::getDistribution).map(Distribution::getCoordinator).map(DistributedMember::getId).orElse(null);
    }
}

