/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.configuration.mutators;

import java.util.List;
import java.util.function.BiConsumer;
import org.apache.geode.annotations.Experimental;
import org.apache.geode.cache.configuration.CacheConfig;
import org.apache.geode.distributed.ConfigurationPersistenceService;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.management.configuration.AbstractConfiguration;
import org.apache.geode.management.internal.configuration.mutators.ConfigurationManager;
import org.apache.logging.log4j.Logger;

@Experimental
public abstract class CacheConfigurationManager<T extends AbstractConfiguration>
implements ConfigurationManager<T> {
    private static final Logger logger = LogService.getLogger();
    private final ConfigurationPersistenceService persistenceService;

    CacheConfigurationManager(ConfigurationPersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }

    public abstract void add(T var1, CacheConfig var2);

    public abstract void update(T var1, CacheConfig var2);

    public abstract void delete(T var1, CacheConfig var2);

    public abstract List<T> list(T var1, CacheConfig var2);

    public abstract T get(T var1, CacheConfig var2);

    public void checkCompatibility(T incoming, String group, T existing) {
    }

    @Override
    public final void add(T config, String groupName) {
        this.updateCacheConfig(config, groupName, this::add);
    }

    @Override
    public final void delete(T config, String groupName) {
        this.updateCacheConfig(config, groupName, this::delete);
    }

    @Override
    public final void update(T config, String groupName) {
        this.updateCacheConfig(config, groupName, this::update);
    }

    @Override
    public final List<T> list(T filterConfig, String groupName) {
        CacheConfig currentPersistedConfig = this.persistenceService.getCacheConfig(AbstractConfiguration.isCluster((String)groupName) ? "cluster" : groupName, true);
        return this.list(filterConfig, currentPersistedConfig);
    }

    void updateCacheConfig(T config, String groupName, BiConsumer<T, CacheConfig> updater) {
        this.persistenceService.updateCacheConfig(groupName, cacheConfigForGroup -> {
            updater.accept(config, (CacheConfig)cacheConfigForGroup);
            return cacheConfigForGroup;
        });
    }
}

