/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.configuration.handlers;

import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.distributed.internal.DistributionConfigImpl;
import org.apache.geode.distributed.internal.InternalLocator;
import org.apache.geode.distributed.internal.tcpserver.TcpHandler;
import org.apache.geode.distributed.internal.tcpserver.TcpServer;
import org.apache.geode.internal.admin.SSLConfig;
import org.apache.geode.internal.net.SSLConfigurationFactory;
import org.apache.geode.internal.security.SecurableCommunicationChannel;
import org.apache.geode.management.internal.configuration.messages.ClusterManagementServiceInfo;
import org.apache.geode.management.internal.configuration.messages.ClusterManagementServiceInfoRequest;

public class ClusterManagementServiceInfoRequestHandler
implements TcpHandler {
    public Object processRequest(Object request) throws IOException {
        if (!(request instanceof ClusterManagementServiceInfoRequest)) {
            throw new IllegalArgumentException("invalid request type");
        }
        ClusterManagementServiceInfo info = new ClusterManagementServiceInfo();
        InternalLocator locator = InternalLocator.getLocator();
        if (locator.getClusterManagementService() == null) {
            return info;
        }
        DistributionConfigImpl config = locator.getConfig();
        info.setHttpPort(config.getHttpServicePort());
        String hostName = null;
        hostName = StringUtils.isNotBlank((CharSequence)config.getHttpServiceBindAddress()) ? config.getHttpServiceBindAddress() : (StringUtils.isNotBlank((CharSequence)config.getServerBindAddress()) ? config.getServerBindAddress() : (StringUtils.isNotBlank((CharSequence)locator.getHostnameForClients()) ? locator.getHostnameForClients() : locator.getBindAddress().getHostName()));
        info.setHostName(hostName);
        if (StringUtils.isNotBlank((CharSequence)config.getSecurityManager())) {
            info.setSecured(true);
        }
        SSLConfig sslConfig = SSLConfigurationFactory.getSSLConfigForComponent(config, SecurableCommunicationChannel.WEB);
        info.setSSL(sslConfig.isEnabled());
        return info;
    }

    public void endRequest(Object request, long startTime) {
    }

    public void endResponse(Object request, long startTime) {
    }

    public void shutDown() {
    }

    public void init(TcpServer tcpServer) {
    }
}

