/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.api;

import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.cache.execute.Execution;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionService;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.InternalConfigurationPersistenceService;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.execute.AbstractExecution;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.management.api.ClusterManagementException;
import org.apache.geode.management.api.ClusterManagementGetResult;
import org.apache.geode.management.api.ClusterManagementListOperationsResult;
import org.apache.geode.management.api.ClusterManagementListResult;
import org.apache.geode.management.api.ClusterManagementOperation;
import org.apache.geode.management.api.ClusterManagementOperationResult;
import org.apache.geode.management.api.ClusterManagementRealizationException;
import org.apache.geode.management.api.ClusterManagementRealizationResult;
import org.apache.geode.management.api.ClusterManagementResult;
import org.apache.geode.management.api.ClusterManagementService;
import org.apache.geode.management.api.EntityGroupInfo;
import org.apache.geode.management.api.EntityInfo;
import org.apache.geode.management.configuration.AbstractConfiguration;
import org.apache.geode.management.configuration.Deployment;
import org.apache.geode.management.configuration.GatewayReceiver;
import org.apache.geode.management.configuration.GroupableConfiguration;
import org.apache.geode.management.configuration.Index;
import org.apache.geode.management.configuration.Links;
import org.apache.geode.management.configuration.Member;
import org.apache.geode.management.configuration.Pdx;
import org.apache.geode.management.configuration.Region;
import org.apache.geode.management.configuration.RegionScoped;
import org.apache.geode.management.internal.CacheElementOperation;
import org.apache.geode.management.internal.ClusterManagementOperationStatusResult;
import org.apache.geode.management.internal.configuration.mutators.CacheConfigurationManager;
import org.apache.geode.management.internal.configuration.mutators.ConfigurationManager;
import org.apache.geode.management.internal.configuration.mutators.DeploymentManager;
import org.apache.geode.management.internal.configuration.mutators.GatewayReceiverConfigManager;
import org.apache.geode.management.internal.configuration.mutators.IndexConfigManager;
import org.apache.geode.management.internal.configuration.mutators.PdxManager;
import org.apache.geode.management.internal.configuration.mutators.RegionConfigManager;
import org.apache.geode.management.internal.configuration.validators.CommonConfigurationValidator;
import org.apache.geode.management.internal.configuration.validators.ConfigurationValidator;
import org.apache.geode.management.internal.configuration.validators.GatewayReceiverConfigValidator;
import org.apache.geode.management.internal.configuration.validators.IndexValidator;
import org.apache.geode.management.internal.configuration.validators.MemberValidator;
import org.apache.geode.management.internal.configuration.validators.PdxValidator;
import org.apache.geode.management.internal.configuration.validators.RegionConfigValidator;
import org.apache.geode.management.internal.exceptions.EntityExistsException;
import org.apache.geode.management.internal.functions.CacheRealizationFunction;
import org.apache.geode.management.internal.operation.OperationHistoryManager;
import org.apache.geode.management.internal.operation.OperationManager;
import org.apache.geode.management.internal.operation.TaggedWithOperator;
import org.apache.geode.management.runtime.OperationResult;
import org.apache.geode.management.runtime.RuntimeInfo;
import org.apache.logging.log4j.Logger;

public class LocatorClusterManagementService
implements ClusterManagementService {
    private static final Logger logger = LogService.getLogger();
    private final InternalConfigurationPersistenceService persistenceService;
    private final Map<Class, ConfigurationManager> managers;
    private final Map<Class, ConfigurationValidator> validators;
    private final OperationManager operationManager;
    private final MemberValidator memberValidator;
    private final CommonConfigurationValidator commonValidator;

    public LocatorClusterManagementService(InternalCache cache, InternalConfigurationPersistenceService persistenceService) {
        this(persistenceService, new ConcurrentHashMap<Class, ConfigurationManager>(), new ConcurrentHashMap<Class, ConfigurationValidator>(), new MemberValidator(cache, persistenceService), new CommonConfigurationValidator(), new OperationManager(cache, new OperationHistoryManager()));
        this.managers.put(Region.class, new RegionConfigManager(persistenceService));
        this.managers.put(Pdx.class, new PdxManager(persistenceService));
        this.managers.put(GatewayReceiver.class, new GatewayReceiverConfigManager(persistenceService));
        this.managers.put(Index.class, new IndexConfigManager(persistenceService));
        this.managers.put(Deployment.class, new DeploymentManager(persistenceService));
        this.validators.put(Region.class, new RegionConfigValidator(cache));
        this.validators.put(GatewayReceiver.class, new GatewayReceiverConfigValidator());
        this.validators.put(Pdx.class, new PdxValidator());
        this.validators.put(Index.class, new IndexValidator());
    }

    @VisibleForTesting
    public LocatorClusterManagementService(InternalConfigurationPersistenceService persistenceService, Map<Class, ConfigurationManager> managers, Map<Class, ConfigurationValidator> validators, MemberValidator memberValidator, CommonConfigurationValidator commonValidator, OperationManager operationManager) {
        this.persistenceService = persistenceService;
        this.managers = managers;
        this.validators = validators;
        this.memberValidator = memberValidator;
        this.commonValidator = commonValidator;
        this.operationManager = operationManager;
    }

    public <T extends AbstractConfiguration<?>> ClusterManagementRealizationResult create(T config) {
        Set<DistributedMember> targetedMembers;
        ConfigurationManager<T> configurationManager = this.getConfigurationManager(config);
        if (this.persistenceService == null) {
            return this.assertSuccessful(new ClusterManagementRealizationResult(ClusterManagementResult.StatusCode.ERROR, "Cluster configuration service needs to be enabled."));
        }
        try {
            this.commonValidator.validate(CacheElementOperation.CREATE, config);
            ConfigurationValidator validator = this.validators.get(config.getClass());
            if (validator != null) {
                validator.validate(CacheElementOperation.CREATE, config);
            }
            if (configurationManager instanceof CacheConfigurationManager) {
                this.memberValidator.validateCreate(config, (CacheConfigurationManager)configurationManager);
            }
        }
        catch (EntityExistsException e) {
            LocatorClusterManagementService.raise(ClusterManagementResult.StatusCode.ENTITY_EXISTS, e);
        }
        catch (IllegalArgumentException e) {
            LocatorClusterManagementService.raise(ClusterManagementResult.StatusCode.ILLEGAL_ARGUMENT, e);
        }
        Set<Object> groups = new HashSet<String>();
        if (config instanceof RegionScoped) {
            String regionName = ((RegionScoped)config).getRegionName();
            groups = this.memberValidator.findGroups(regionName);
            if (groups.isEmpty()) {
                LocatorClusterManagementService.raise(ClusterManagementResult.StatusCode.ENTITY_NOT_FOUND, "Region provided does not exist: " + regionName);
            }
            targetedMembers = this.memberValidator.findServers(groups.toArray(new String[0]));
        } else {
            String groupName = AbstractConfiguration.isCluster((String)config.getGroup()) ? "cluster" : config.getGroup();
            groups.add(groupName);
            targetedMembers = this.memberValidator.findServers(groupName);
        }
        ClusterManagementRealizationResult result = new ClusterManagementRealizationResult();
        List functionResults = this.executeAndGetFunctionResult(new CacheRealizationFunction(), Arrays.asList(new Serializable[]{config, CacheElementOperation.CREATE}), targetedMembers);
        functionResults.forEach(arg_0 -> ((ClusterManagementRealizationResult)result).addMemberStatus(arg_0));
        if (result.getStatusCode() != ClusterManagementResult.StatusCode.OK) {
            result.setStatus(ClusterManagementResult.StatusCode.ERROR, "Failed to create on all members.");
            return this.assertSuccessful(result);
        }
        for (String string : groups) {
            configurationManager.add(config, string);
        }
        result.setStatus(ClusterManagementResult.StatusCode.OK, "Successfully updated configuration for " + String.join((CharSequence)", ", groups) + ".");
        if (result.isSuccessful()) {
            result.setLinks(config.getLinks());
        }
        return this.assertSuccessful(result);
    }

    public <T extends AbstractConfiguration<?>> ClusterManagementRealizationResult delete(T config) {
        CacheConfigurationManager configurationManager = (CacheConfigurationManager)this.getConfigurationManager(config);
        if (this.persistenceService == null) {
            return this.assertSuccessful(new ClusterManagementRealizationResult(ClusterManagementResult.StatusCode.ERROR, "Cluster configuration service needs to be enabled."));
        }
        try {
            this.commonValidator.validate(CacheElementOperation.DELETE, config);
            ConfigurationValidator validator = this.validators.get(config.getClass());
            if (validator != null) {
                validator.validate(CacheElementOperation.DELETE, config);
            }
        }
        catch (IllegalArgumentException e) {
            LocatorClusterManagementService.raise(ClusterManagementResult.StatusCode.ILLEGAL_ARGUMENT, e);
        }
        String[] groupsWithThisElement = this.memberValidator.findGroupsWithThisElement(config, configurationManager);
        if (groupsWithThisElement.length == 0) {
            LocatorClusterManagementService.raise(ClusterManagementResult.StatusCode.ENTITY_NOT_FOUND, config.getClass().getSimpleName() + " '" + config.getId() + "' does not exist.");
        }
        ClusterManagementRealizationResult result = new ClusterManagementRealizationResult();
        List functionResults = this.executeAndGetFunctionResult(new CacheRealizationFunction(), Arrays.asList(new Serializable[]{config, CacheElementOperation.DELETE}), this.memberValidator.findServers(groupsWithThisElement));
        functionResults.forEach(arg_0 -> ((ClusterManagementRealizationResult)result).addMemberStatus(arg_0));
        if (result.getStatusCode() != ClusterManagementResult.StatusCode.OK) {
            result.setStatus(ClusterManagementResult.StatusCode.ERROR, "Failed to delete on all members.");
            return result;
        }
        ArrayList<String> updatedGroups = new ArrayList<String>();
        ArrayList<String> failedGroups = new ArrayList<String>();
        for (String finalGroup : groupsWithThisElement) {
            try {
                configurationManager.delete(config, finalGroup);
                updatedGroups.add(finalGroup);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                failedGroups.add(finalGroup);
            }
        }
        if (failedGroups.isEmpty()) {
            result.setStatus(ClusterManagementResult.StatusCode.OK, "Successfully removed configuration for " + updatedGroups + ".");
        } else {
            String message = "Failed to update cluster configuration for " + failedGroups + ".";
            result.setStatus(ClusterManagementResult.StatusCode.FAIL_TO_PERSIST, message);
        }
        return this.assertSuccessful(result);
    }

    public <T extends AbstractConfiguration<?>> ClusterManagementRealizationResult update(T config) {
        throw new NotImplementedException("Not implemented");
    }

    public <T extends AbstractConfiguration<R>, R extends RuntimeInfo> ClusterManagementListResult<T, R> list(T filter) {
        ClusterManagementListResult result = new ClusterManagementListResult();
        if (this.persistenceService == null) {
            return this.assertSuccessful(new ClusterManagementListResult(ClusterManagementResult.StatusCode.ERROR, "Cluster configuration service needs to be enabled."));
        }
        ArrayList resultList = new ArrayList();
        if (filter instanceof Member) {
            resultList.add(filter);
        } else {
            ConfigurationManager<T> manager = this.getConfigurationManager(filter);
            Set<String> groups = StringUtils.isNotBlank((CharSequence)filter.getGroup()) ? Collections.singleton(filter.getGroup()) : this.persistenceService.getGroups();
            for (String group : groups) {
                List<AbstractConfiguration> list = manager.list(filter, group);
                if (!AbstractConfiguration.isCluster((String)group)) {
                    list.forEach(t -> {
                        if (t instanceof GroupableConfiguration) {
                            ((GroupableConfiguration)t).setGroup(group);
                        }
                    });
                }
                list.stream().filter(t -> !resultList.contains(t)).forEach(resultList::add);
            }
        }
        ArrayList<EntityGroupInfo> responses = new ArrayList<EntityGroupInfo>();
        boolean hasRuntimeInfo = this.hasRuntimeInfo(filter.getClass());
        for (AbstractConfiguration element : resultList) {
            Set<DistributedMember> members;
            EntityGroupInfo response = new EntityGroupInfo(element);
            responses.add(response);
            if (!hasRuntimeInfo || (members = filter instanceof Member ? this.memberValidator.findMembers(filter.getId(), filter.getGroup()) : this.memberValidator.findServers(element)).size() == 0) continue;
            if (element.isGlobalRuntime()) {
                members = Collections.singleton(members.iterator().next());
            }
            List<R> runtimeInfos = this.executeAndGetFunctionResult(new CacheRealizationFunction(), Arrays.asList(new Serializable[]{element, CacheElementOperation.GET}), members);
            response.setRuntimeInfo(runtimeInfos);
        }
        if (filter instanceof Member) {
            List members = ((EntityGroupInfo)responses.get(0)).getRuntimeInfo();
            for (RuntimeInfo memberInfo : members) {
                Member member = new Member();
                member.setId(memberInfo.getMemberName());
                EntityInfo entityInfo = new EntityInfo(memberInfo.getMemberName(), Collections.singletonList(new EntityGroupInfo((AbstractConfiguration)member, Collections.singletonList(memberInfo))));
                result.addEntityInfo(entityInfo);
            }
        } else {
            result.setEntityGroupInfo(responses);
        }
        return this.assertSuccessful(result);
    }

    public <T extends AbstractConfiguration<R>, R extends RuntimeInfo> ClusterManagementGetResult<T, R> get(T config) {
        ClusterManagementListResult<T, R> list = this.list(config);
        List result = list.getResult();
        if (result.size() == 0) {
            LocatorClusterManagementService.raise(ClusterManagementResult.StatusCode.ENTITY_NOT_FOUND, config.getClass().getSimpleName() + " '" + config.getId() + "' does not exist.");
        }
        return new ClusterManagementGetResult((EntityInfo)result.get(0));
    }

    public <A extends ClusterManagementOperation<V>, V extends OperationResult> ClusterManagementOperationResult<V> start(A op) {
        OperationHistoryManager.OperationInstance operationInstance = this.operationManager.submit(op);
        if (op instanceof TaggedWithOperator) {
            operationInstance.setOperator(((TaggedWithOperator)op).getOperator());
        }
        ClusterManagementResult result = new ClusterManagementResult(ClusterManagementResult.StatusCode.ACCEPTED, "Operation started.  Use the URI to check its status.");
        return this.assertSuccessful((ClusterManagementResult)this.toClusterManagementListOperationsResult(result, operationInstance));
    }

    public <A extends ClusterManagementOperation<V>, V extends OperationResult> ClusterManagementListOperationsResult<V> list(A opType) {
        return this.assertSuccessful(new ClusterManagementListOperationsResult(this.operationManager.listOperationInstances(opType).stream().map(this::toClusterManagementListOperationsResult).collect(Collectors.toList())));
    }

    private static <V extends OperationResult> ClusterManagementResult getStatus(CompletableFuture<V> future) {
        if (future.isCompletedExceptionally()) {
            String error = "Operation failed.";
            try {
                future.get();
            }
            catch (InterruptedException ignore) {
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException e) {
                error = e.getMessage();
            }
            return new ClusterManagementResult(ClusterManagementResult.StatusCode.ERROR, error);
        }
        if (future.isDone()) {
            return new ClusterManagementResult(ClusterManagementResult.StatusCode.OK, "Operation finished successfully.");
        }
        return new ClusterManagementResult(ClusterManagementResult.StatusCode.IN_PROGRESS, "Operation in progress.");
    }

    private <A extends ClusterManagementOperation<V>, V extends OperationResult> ClusterManagementOperationResult<V> toClusterManagementListOperationsResult(ClusterManagementResult status, OperationHistoryManager.OperationInstance<A, V> operationInstance) {
        ClusterManagementOperationResult result = new ClusterManagementOperationResult(status, operationInstance.getFutureResult(), operationInstance.getOperationStart(), operationInstance.getFutureOperationEnded(), operationInstance.getOperator(), operationInstance.getId());
        result.setLinks(new Links(operationInstance.getId(), operationInstance.getOperation().getEndpoint()));
        return result;
    }

    private <A extends ClusterManagementOperation<V>, V extends OperationResult> ClusterManagementOperationResult<V> toClusterManagementListOperationsResult(OperationHistoryManager.OperationInstance<A, V> operationInstance) {
        return this.toClusterManagementListOperationsResult(LocatorClusterManagementService.getStatus(operationInstance.getFutureResult()), operationInstance);
    }

    public <V extends OperationResult> ClusterManagementOperationStatusResult<V> checkStatus(String opId) {
        OperationHistoryManager.OperationInstance operationInstance = this.operationManager.getOperationInstance(opId);
        if (operationInstance == null) {
            LocatorClusterManagementService.raise(ClusterManagementResult.StatusCode.ENTITY_NOT_FOUND, "Operation '" + opId + "' does not exist.");
        }
        CompletableFuture status = operationInstance.getFutureResult();
        ClusterManagementOperationStatusResult result = new ClusterManagementOperationStatusResult(LocatorClusterManagementService.getStatus(status));
        result.setOperator(operationInstance.getOperator());
        result.setOperationStart(operationInstance.getOperationStart());
        if (status.isDone() && !status.isCompletedExceptionally()) {
            try {
                result.setOperationEnded(operationInstance.getFutureOperationEnded().get());
                result.setResult((OperationResult)status.get());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
        }
        return result;
    }

    private <T extends ClusterManagementResult> T assertSuccessful(T result) {
        if (!result.isSuccessful()) {
            if (result instanceof ClusterManagementRealizationResult) {
                throw new ClusterManagementRealizationException((ClusterManagementRealizationResult)result);
            }
            throw new ClusterManagementException(result);
        }
        return result;
    }

    private static void raise(ClusterManagementResult.StatusCode statusCode, String statusMessage) {
        throw new ClusterManagementException(new ClusterManagementResult(statusCode, statusMessage));
    }

    private static void raise(ClusterManagementResult.StatusCode statusCode, Exception e) {
        throw new ClusterManagementException(new ClusterManagementResult(statusCode, e.getMessage()), (Throwable)e);
    }

    public boolean isConnected() {
        return true;
    }

    public void close() {
        this.operationManager.close();
    }

    private <T extends AbstractConfiguration> ConfigurationManager<T> getConfigurationManager(T config) {
        ConfigurationManager configurationManager = this.managers.get(config.getClass());
        if (configurationManager == null) {
            LocatorClusterManagementService.raise(ClusterManagementResult.StatusCode.ILLEGAL_ARGUMENT, String.format("%s is not supported.", config.getClass().getSimpleName()));
        }
        return configurationManager;
    }

    @VisibleForTesting
    <R> List<R> executeAndGetFunctionResult(Function function, Object args, Set<DistributedMember> targetMembers) {
        if (targetMembers.size() == 0) {
            return Collections.emptyList();
        }
        Execution execution = FunctionService.onMembers(targetMembers).setArguments(args);
        ((AbstractExecution)execution).setIgnoreDepartedMembers(true);
        ResultCollector rc = execution.execute(function);
        return (List)rc.getResult();
    }

    @VisibleForTesting
    Class<?> getRuntimeClass(Class<?> configClass) {
        Type genericSuperclass = configClass.getGenericSuperclass();
        if (genericSuperclass instanceof ParameterizedType) {
            return (Class)((ParameterizedType)genericSuperclass).getActualTypeArguments()[0];
        }
        return null;
    }

    @VisibleForTesting
    boolean hasRuntimeInfo(Class<?> configClass) {
        return !RuntimeInfo.class.equals(this.getRuntimeClass(configClass));
    }
}

