/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.tcp;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.geode.distributed.internal.DMStats;
import org.apache.geode.distributed.internal.DistributionMessage;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.net.BufferPool;
import org.apache.geode.internal.net.NioFilter;
import org.apache.geode.internal.serialization.Version;
import org.apache.geode.internal.tcp.ByteBufferInputStream;
import org.apache.geode.internal.tcp.Connection;
import org.apache.geode.internal.tcp.MsgDestreamer;
import org.apache.geode.internal.tcp.VersionedByteBufferInputStream;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class MsgReader {
    private static final Logger logger = LogService.getLogger();
    protected final Connection conn;
    protected final Header header = new Header();
    private final NioFilter ioFilter;
    private ByteBuffer peerNetData;
    private final ByteBufferInputStream byteBufferInputStream;

    MsgReader(Connection conn, NioFilter nioFilter, Version version) {
        this.conn = conn;
        this.ioFilter = nioFilter;
        this.byteBufferInputStream = version == null ? new ByteBufferInputStream() : new VersionedByteBufferInputStream(version);
    }

    Header readHeader() throws IOException {
        boolean directAck;
        ByteBuffer unwrappedBuffer = this.readAtLeast(7);
        Assert.assertTrue(unwrappedBuffer.remaining() >= 7);
        int nioMessageLength = unwrappedBuffer.getInt();
        Connection.calcHdrVersion(nioMessageLength);
        nioMessageLength = Connection.calcMsgByteSize(nioMessageLength);
        byte nioMessageType = unwrappedBuffer.get();
        short nioMsgId = unwrappedBuffer.getShort();
        boolean bl = directAck = (nioMessageType & 0x20) != 0;
        if (directAck) {
            nioMessageType = (byte)(nioMessageType & 0xFFFFFFDF);
        }
        this.header.setFields(nioMessageLength, nioMessageType, nioMsgId);
        return this.header;
    }

    DistributionMessage readMessage(Header header) throws IOException, ClassNotFoundException {
        ByteBuffer nioInputBuffer = this.readAtLeast(header.messageLength);
        Assert.assertTrue(nioInputBuffer.remaining() >= header.messageLength);
        this.getStats().incMessagesBeingReceived(true, header.messageLength);
        long startSer = this.getStats().startMsgDeserialization();
        try {
            this.byteBufferInputStream.setBuffer(nioInputBuffer);
            ReplyProcessor21.initMessageRPId();
            DistributionMessage distributionMessage = (DistributionMessage)InternalDataSerializer.readDSFID(this.byteBufferInputStream);
            return distributionMessage;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            this.getStats().endMsgDeserialization(startSer);
            this.getStats().decMessagesBeingReceived(header.messageLength);
            this.ioFilter.doneReadingDirectAck(nioInputBuffer);
        }
    }

    void readChunk(Header header, MsgDestreamer md) throws IOException {
        ByteBuffer unwrappedBuffer = this.readAtLeast(header.messageLength);
        this.getStats().incMessagesBeingReceived(md.size() == 0, header.messageLength);
        md.addChunk(unwrappedBuffer, header.messageLength);
        unwrappedBuffer.position(unwrappedBuffer.position() + header.messageLength);
    }

    private ByteBuffer readAtLeast(int bytes) throws IOException {
        this.peerNetData = this.ioFilter.ensureWrappedCapacity(bytes, this.peerNetData, BufferPool.BufferType.TRACKED_RECEIVER);
        return this.ioFilter.readAtLeast(this.conn.getSocket().getChannel(), bytes, this.peerNetData);
    }

    public void close() {
        if (this.peerNetData != null) {
            this.conn.getBufferPool().releaseReceiveBuffer(this.peerNetData);
        }
    }

    private DMStats getStats() {
        return this.conn.getConduit().getStats();
    }

    public static class Header {
        private int messageLength;
        private byte messageType;
        private short messageId;

        public void setFields(int nioMessageLength, byte nioMessageType, short nioMsgId) {
            this.messageLength = nioMessageLength;
            this.messageType = nioMessageType;
            this.messageId = nioMsgId;
        }

        int getMessageLength() {
            return this.messageLength;
        }

        byte getMessageType() {
            return this.messageType;
        }

        short getMessageId() {
            return this.messageId;
        }
    }
}

