/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.net;

import java.io.Console;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLProtocolException;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedKeyManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.GemFireConfigException;
import org.apache.geode.SystemConnectException;
import org.apache.geode.SystemFailure;
import org.apache.geode.annotations.internal.MakeNotStatic;
import org.apache.geode.cache.wan.GatewaySender;
import org.apache.geode.cache.wan.GatewayTransportFilter;
import org.apache.geode.distributed.ClientSocketFactory;
import org.apache.geode.distributed.internal.DistributionConfigImpl;
import org.apache.geode.distributed.internal.tcpserver.ConnectionWatcher;
import org.apache.geode.distributed.internal.tcpserver.TcpSocketCreatorImpl;
import org.apache.geode.internal.ClassPathLoader;
import org.apache.geode.internal.admin.SSLConfig;
import org.apache.geode.internal.cache.wan.TransportFilterServerSocket;
import org.apache.geode.internal.cache.wan.TransportFilterSocketFactory;
import org.apache.geode.internal.inet.LocalHostUtil;
import org.apache.geode.internal.net.BufferPool;
import org.apache.geode.internal.net.NioSslEngine;
import org.apache.geode.internal.tcp.TCPConduit;
import org.apache.geode.internal.util.ArgumentRedactor;
import org.apache.geode.internal.util.PasswordUtil;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.management.internal.SSLUtil;
import org.apache.geode.net.SSLParameterExtension;
import org.apache.logging.log4j.Logger;

public class SocketCreator
extends TcpSocketCreatorImpl {
    private static final Logger logger = LogService.getLogger();
    @MakeNotStatic
    private static final ConcurrentHashMap<InetAddress, String> hostNames = new ConcurrentHashMap();
    public static final boolean FORCE_DNS_USE = Boolean.getBoolean("gemfire.forceDnsUse");
    @MakeNotStatic
    public static volatile boolean resolve_dns = true;
    @MakeNotStatic
    public static volatile boolean use_client_host_name = true;
    private boolean configShown = false;
    private boolean hostnameValidationDisabledLogShown = false;
    private SSLContext sslContext;
    private final SSLConfig sslConfig;
    private ClientSocketFactory clientSocketFactory;
    public static final boolean ENABLE_TCP_KEEP_ALIVE = TcpSocketCreatorImpl.ENABLE_TCP_KEEP_ALIVE;

    public SocketCreator(SSLConfig sslConfig) {
        this.sslConfig = sslConfig;
        this.initialize();
    }

    public static InetAddress getLocalHost() throws UnknownHostException {
        return LocalHostUtil.getLocalHost();
    }

    public static String getHostName(InetAddress addr) {
        String result = hostNames.get(addr);
        if (result == null) {
            result = addr.getHostName();
            hostNames.put(addr, result);
        }
        return result;
    }

    public static String getCanonicalHostName(InetAddress addr, String hostName) {
        String result = hostNames.get(addr);
        if (result == null) {
            hostNames.put(addr, hostName);
            return hostName;
        }
        return result;
    }

    public static void resetHostNameCache() {
        hostNames.clear();
    }

    private void initialize() {
        try {
            try {
                if (this.sslConfig.isEnabled() && this.sslContext == null) {
                    this.sslContext = this.createAndConfigureSSLContext();
                }
            }
            catch (Exception e) {
                throw new GemFireConfigException("Error configuring GemFire ssl ", e);
            }
            TCPConduit.init();
            this.initializeClientSocketFactory();
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Error t) {
            SystemFailure.checkFailure();
            t.printStackTrace();
            throw t;
        }
        catch (RuntimeException re) {
            re.printStackTrace();
            throw re;
        }
    }

    private SSLContext createAndConfigureSSLContext() throws GeneralSecurityException, IOException {
        if (this.sslConfig.useDefaultSSLContext()) {
            return SSLContext.getDefault();
        }
        SSLContext newSSLContext = SSLUtil.getSSLContextInstance(this.sslConfig);
        KeyManager[] keyManagers = this.getKeyManagers();
        TrustManager[] trustManagers = this.getTrustManagers();
        newSSLContext.init(keyManagers, trustManagers, null);
        return newSSLContext;
    }

    public static void readSSLProperties(Map<String, String> env) {
        SocketCreator.readSSLProperties(env, false);
    }

    public static void readSSLProperties(Map<String, String> env, boolean ignoreGemFirePropsFile) {
        Properties props = new Properties();
        DistributionConfigImpl.loadGemFireProperties(props, ignoreGemFirePropsFile);
        for (Map.Entry<Object, Object> ent : props.entrySet()) {
            String value;
            String key = (String)ent.getKey();
            if (!key.startsWith("javax.net.ssl") && !key.startsWith("sysprop-")) continue;
            if (key.startsWith("sysprop-")) {
                key = key.substring("sysprop-".length());
            }
            if ((value = (String)ent.getValue()) != null && !value.trim().equals("")) continue;
            Console console = System.console();
            if (console == null) {
                throw new GemFireConfigException("SSL properties are empty, but a console is not available");
            }
            String val = console.readLine("Please enter " + key + ": ", new Object[0]);
            env.put(key, val);
        }
    }

    private TrustManager[] getTrustManagers() throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        String trustStoreType = this.sslConfig.getTruststoreType();
        if (StringUtils.isEmpty((CharSequence)trustStoreType)) {
            trustStoreType = KeyStore.getDefaultType();
        }
        KeyStore ts = KeyStore.getInstance(trustStoreType);
        String trustStorePath = this.sslConfig.getTruststore();
        FileInputStream fis = new FileInputStream(trustStorePath);
        String passwordString = this.sslConfig.getTruststorePassword();
        char[] password = null;
        if (passwordString != null) {
            if (passwordString.trim().equals("")) {
                if (!StringUtils.isEmpty((CharSequence)passwordString)) {
                    String toDecrypt = "encrypted(" + passwordString + ")";
                    passwordString = PasswordUtil.decrypt(toDecrypt);
                    password = passwordString.toCharArray();
                }
            } else {
                password = passwordString.toCharArray();
            }
        }
        ts.load(fis, password);
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(ts);
        TrustManager[] trustManagers = tmf.getTrustManagers();
        if (password != null) {
            Arrays.fill(password, ' ');
        }
        return trustManagers;
    }

    private KeyManager[] getKeyManagers() throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException {
        if (this.sslConfig.getKeystore() == null) {
            return null;
        }
        String keyStoreType = this.sslConfig.getKeystoreType();
        if (StringUtils.isEmpty((CharSequence)keyStoreType)) {
            keyStoreType = KeyStore.getDefaultType();
        }
        KeyStore keyStore = KeyStore.getInstance(keyStoreType);
        String keyStoreFilePath = this.sslConfig.getKeystore();
        if (StringUtils.isEmpty((CharSequence)keyStoreFilePath)) {
            keyStoreFilePath = System.getProperty("user.home") + System.getProperty("file.separator") + ".keystore";
        }
        FileInputStream fileInputStream = new FileInputStream(keyStoreFilePath);
        String passwordString = this.sslConfig.getKeystorePassword();
        char[] password = null;
        if (passwordString != null) {
            if (passwordString.trim().equals("")) {
                String encryptedPass = System.getenv("javax.net.ssl.keyStorePassword");
                if (!StringUtils.isEmpty((CharSequence)encryptedPass)) {
                    String toDecrypt = "encrypted(" + encryptedPass + ")";
                    passwordString = PasswordUtil.decrypt(toDecrypt);
                    password = passwordString.toCharArray();
                }
            } else {
                password = passwordString.toCharArray();
            }
        }
        keyStore.load(fileInputStream, password);
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(keyStore, password);
        KeyManager[] keyManagers = keyManagerFactory.getKeyManagers();
        if (password != null) {
            Arrays.fill(password, ' ');
        }
        KeyManager[] extendedKeyManagers = new KeyManager[keyManagers.length];
        for (int i = 0; i < keyManagers.length; ++i) {
            extendedKeyManagers[i] = new ExtendedAliasKeyManager(keyManagers[i], this.sslConfig.getAlias());
        }
        return extendedKeyManagers;
    }

    public SSLContext getSslContext() {
        return this.sslContext;
    }

    public boolean useSSL() {
        return this.sslConfig.isEnabled();
    }

    public ServerSocket createServerSocket(int nport, int backlog, InetAddress bindAddr, List<GatewayTransportFilter> transportFilters, int socketBufferSize) throws IOException {
        if (transportFilters.isEmpty()) {
            return this.createServerSocket(nport, backlog, bindAddr, socketBufferSize);
        }
        this.printConfig();
        TransportFilterServerSocket result = new TransportFilterServerSocket(transportFilters);
        result.setReuseAddress(true);
        result.setReceiveBufferSize(socketBufferSize);
        try {
            result.bind(new InetSocketAddress(bindAddr, nport), backlog);
        }
        catch (BindException e) {
            BindException throwMe = new BindException(String.format("Failed to create server socket on %s[%s]", bindAddr, nport));
            throwMe.initCause(e);
            throw throwMe;
        }
        return result;
    }

    public ServerSocket createServerSocket(int nport, int backlog, InetAddress bindAddr, int socketBufferSize) throws IOException {
        return this.createServerSocket(nport, backlog, bindAddr, socketBufferSize, this.sslConfig.isEnabled());
    }

    protected ServerSocket createServerSocket(int nport, int backlog, InetAddress bindAddr, int socketBufferSize, boolean sslConnection) throws IOException {
        this.printConfig();
        if (!sslConnection) {
            return super.createServerSocket(nport, backlog, bindAddr, socketBufferSize, sslConnection);
        }
        if (this.sslContext == null) {
            throw new GemFireConfigException("SSL not configured correctly, Please look at previous error");
        }
        SSLServerSocketFactory ssf = this.sslContext.getServerSocketFactory();
        SSLServerSocket serverSocket = (SSLServerSocket)ssf.createServerSocket();
        serverSocket.setReuseAddress(true);
        if (socketBufferSize != -1) {
            serverSocket.setReceiveBufferSize(socketBufferSize);
        }
        serverSocket.bind(new InetSocketAddress(bindAddr, nport), backlog);
        this.finishServerSocket(serverSocket);
        return serverSocket;
    }

    public ServerSocket createServerSocketUsingPortRange(InetAddress ba, int backlog, boolean isBindAddress, boolean useNIO, int tcpBufferSize, int[] tcpPortRange) throws IOException {
        return this.createServerSocketUsingPortRange(ba, backlog, isBindAddress, useNIO, tcpBufferSize, tcpPortRange, this.sslConfig.isEnabled());
    }

    protected RuntimeException problemCreatingSocketInPortRangeException(String s, IOException e) {
        return new GemFireConfigException(s, e);
    }

    protected RuntimeException noFreePortException(String reason) {
        return new SystemConnectException(reason);
    }

    public Socket connectForClient(String host, int port, int timeout) throws IOException {
        return this.connect(InetAddress.getByName(host), port, timeout, null, true, -1);
    }

    public Socket connectForClient(String host, int port, int timeout, int socketBufferSize) throws IOException {
        return this.connect(InetAddress.getByName(host), port, timeout, null, true, socketBufferSize);
    }

    public Socket connectForServer(InetAddress inetadd, int port) throws IOException {
        return this.connect(inetadd, port, 0, null, false, -1);
    }

    public Socket connect(InetAddress inetadd, int port, int timeout, ConnectionWatcher optionalWatcher, boolean clientSide, int socketBufferSize) throws IOException {
        return this.connect(inetadd, port, timeout, optionalWatcher, clientSide, socketBufferSize, this.sslConfig.isEnabled());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Socket connect(InetAddress inetadd, int port, int timeout, ConnectionWatcher optionalWatcher, boolean clientSide, int socketBufferSize, boolean sslConnection) throws IOException {
        this.printConfig();
        if (!sslConnection) {
            return super.connect(inetadd, port, timeout, optionalWatcher, clientSide, socketBufferSize, sslConnection);
        }
        InetSocketAddress sockaddr = new InetSocketAddress(inetadd, port);
        if (this.sslContext == null) {
            throw new GemFireConfigException("SSL not configured correctly, Please look at previous error");
        }
        SSLSocketFactory sf = this.sslContext.getSocketFactory();
        Socket socket = sf.createSocket();
        socket.setKeepAlive(ENABLE_TCP_KEEP_ALIVE);
        if (socketBufferSize != -1) {
            socket.setReceiveBufferSize(socketBufferSize);
        }
        try {
            if (optionalWatcher != null) {
                optionalWatcher.beforeConnect(socket);
            }
            socket.connect(sockaddr, Math.max(timeout, 0));
            this.configureClientSSLSocket(socket, timeout);
            Socket socket2 = socket;
            return socket2;
        }
        finally {
            if (optionalWatcher != null) {
                optionalWatcher.afterConnect(socket);
            }
        }
    }

    protected Socket createCustomClientSocket(InetAddress inetadd, int port) throws IOException {
        if (this.clientSocketFactory != null) {
            return this.clientSocketFactory.createSocket(inetadd, port);
        }
        return null;
    }

    public SSLEngine createSSLEngine(String hostName, int port) {
        return this.sslContext.createSSLEngine(hostName, port);
    }

    public NioSslEngine handshakeSSLSocketChannel(SocketChannel socketChannel, SSLEngine engine, int timeout, boolean clientSocket, ByteBuffer peerNetBuffer, BufferPool bufferPool) throws IOException {
        engine.setUseClientMode(clientSocket);
        if (!clientSocket) {
            engine.setNeedClientAuth(this.sslConfig.isRequireAuth());
        }
        if (clientSocket) {
            SSLParameters modifiedParams = this.checkAndEnableHostnameValidation(engine.getSSLParameters());
            engine.setSSLParameters(modifiedParams);
        }
        while (!socketChannel.finishConnect()) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                if (!socketChannel.socket().isClosed()) {
                    socketChannel.close();
                }
                throw new IOException("Interrupted while performing handshake", e);
            }
        }
        NioSslEngine nioSslEngine = new NioSslEngine(engine, bufferPool);
        boolean blocking = socketChannel.isBlocking();
        if (blocking) {
            socketChannel.configureBlocking(false);
        }
        try {
            nioSslEngine.handshake(socketChannel, timeout, peerNetBuffer);
        }
        catch (SSLException e) {
            if (!socketChannel.socket().isClosed()) {
                socketChannel.close();
            }
            logger.warn("SSL handshake exception", (Throwable)e);
            throw e;
        }
        catch (InterruptedException e) {
            if (!socketChannel.socket().isClosed()) {
                socketChannel.close();
            }
            throw new IOException("SSL handshake interrupted");
        }
        finally {
            if (blocking) {
                try {
                    socketChannel.configureBlocking(true);
                }
                catch (IOException iOException) {}
            }
        }
        return nioSslEngine;
    }

    private SSLParameters checkAndEnableHostnameValidation(SSLParameters sslParameters) {
        if (this.sslConfig.doEndpointIdentification()) {
            sslParameters.setEndpointIdentificationAlgorithm("HTTPS");
        } else if (!this.hostnameValidationDisabledLogShown) {
            logger.info("Your SSL configuration disables hostname validation. ssl-endpoint-identification-enabled should be set to true when SSL is enabled. Please refer to the Apache GEODE SSL Documentation for SSL Property: ssl\u2011endpoint\u2011identification\u2011enabled");
            this.hostnameValidationDisabledLogShown = true;
        }
        return sslParameters;
    }

    public void handshakeIfSocketIsSSL(Socket socket, int timeout) throws IOException {
        if (!(socket instanceof SSLSocket)) {
            return;
        }
        int oldTimeout = socket.getSoTimeout();
        socket.setSoTimeout(timeout);
        SSLSocket sslSocket = (SSLSocket)socket;
        try {
            sslSocket.startHandshake();
        }
        catch (SSLPeerUnverifiedException ex) {
            if (this.sslConfig.isRequireAuth()) {
                logger.fatal(String.format("SSL Error in authenticating peer %s[%s].", socket.getInetAddress(), socket.getPort()), (Throwable)ex);
                throw ex;
            }
        }
        catch (SSLProtocolException ex) {
            if (ex.getCause() instanceof SocketTimeoutException) {
                throw (SocketTimeoutException)ex.getCause();
            }
            throw ex;
        }
        finally {
            try {
                socket.setSoTimeout(oldTimeout);
            }
            catch (SocketException ex) {}
        }
    }

    private void finishServerSocket(SSLServerSocket serverSocket) {
        SSLParameterExtension sslParameterExtension;
        String[] ciphers;
        serverSocket.setUseClientMode(false);
        if (this.sslConfig.isRequireAuth()) {
            serverSocket.setNeedClientAuth(true);
        }
        serverSocket.setEnableSessionCreation(true);
        String[] protocols = this.sslConfig.getProtocolsAsStringArray();
        if (!"any".equalsIgnoreCase(protocols[0])) {
            serverSocket.setEnabledProtocols(protocols);
        }
        if (!"any".equalsIgnoreCase((ciphers = this.sslConfig.getCiphersAsStringArray())[0])) {
            serverSocket.setEnabledCipherSuites(ciphers);
        }
        if ((sslParameterExtension = this.sslConfig.getSSLParameterExtension()) != null) {
            SSLParameters modifiedParams = sslParameterExtension.modifySSLServerSocketParameters(serverSocket.getSSLParameters());
            serverSocket.setSSLParameters(modifiedParams);
        }
    }

    private void configureClientSSLSocket(Socket socket, int timeout) throws IOException {
        block10: {
            if (socket instanceof SSLSocket) {
                String[] ciphers;
                SSLSocket sslSocket = (SSLSocket)socket;
                sslSocket.setUseClientMode(true);
                sslSocket.setEnableSessionCreation(true);
                SSLParameters modifiedParams = this.checkAndEnableHostnameValidation(sslSocket.getSSLParameters());
                SSLParameterExtension sslParameterExtension = this.sslConfig.getSSLParameterExtension();
                if (sslParameterExtension != null) {
                    modifiedParams = sslParameterExtension.modifySSLClientSocketParameters(modifiedParams);
                }
                sslSocket.setSSLParameters(modifiedParams);
                String[] protocols = this.sslConfig.getProtocolsAsStringArray();
                if (protocols != null && !"any".equalsIgnoreCase(protocols[0])) {
                    sslSocket.setEnabledProtocols(protocols);
                }
                if ((ciphers = this.sslConfig.getCiphersAsStringArray()) != null && !"any".equalsIgnoreCase(ciphers[0])) {
                    sslSocket.setEnabledCipherSuites(ciphers);
                }
                try {
                    if (timeout > 0) {
                        sslSocket.setSoTimeout(timeout);
                    }
                    sslSocket.startHandshake();
                }
                catch (SSLProtocolException ex) {
                    if (ex.getCause() instanceof SocketTimeoutException) {
                        throw (SocketTimeoutException)ex.getCause();
                    }
                    throw ex;
                }
                catch (SSLHandshakeException ex) {
                    logger.fatal(String.format("Problem forming SSL connection to %s[%s].", socket.getInetAddress(), socket.getPort()), (Throwable)ex);
                    throw ex;
                }
                catch (SSLPeerUnverifiedException ex) {
                    if (!this.sslConfig.isRequireAuth()) break block10;
                    logger.fatal("SSL authentication exception.", (Throwable)ex);
                    throw ex;
                }
            }
        }
    }

    private void printConfig() {
        if (!this.configShown && logger.isDebugEnabled()) {
            this.configShown = true;
            StringBuilder sb = new StringBuilder();
            sb.append("SSL Configuration: \n");
            sb.append("  ssl-enabled = ").append(this.sslConfig.isEnabled()).append("\n");
            for (String key : System.getProperties().stringPropertyNames()) {
                if (!key.startsWith("javax.net.ssl")) continue;
                String possiblyRedactedValue = ArgumentRedactor.redactArgumentIfNecessary(key, System.getProperty(key));
                sb.append("  ").append(key).append(" = ").append(possiblyRedactedValue).append("\n");
            }
            logger.debug(sb.toString());
        }
    }

    protected void initializeClientSocketFactory() {
        this.clientSocketFactory = null;
        String className = System.getProperty("gemfire.clientSocketFactory");
        if (className != null) {
            Object o;
            try {
                Class<?> c = ClassPathLoader.getLatest().forName(className);
                o = c.newInstance();
            }
            catch (Exception e) {
                String s = "An unexpected exception occurred while instantiating a " + className + ": " + e;
                throw new IllegalArgumentException(s);
            }
            if (o instanceof ClientSocketFactory) {
                this.clientSocketFactory = (ClientSocketFactory)o;
            } else {
                String s = "Class \"" + className + "\" is not a ClientSocketFactory";
                throw new IllegalArgumentException(s);
            }
        }
    }

    public void initializeTransportFilterClientSocketFactory(GatewaySender sender) {
        this.clientSocketFactory = new TransportFilterSocketFactory().setGatewayTransportFilters(sender.getGatewayTransportFilters());
    }

    private static class ExtendedAliasKeyManager
    extends X509ExtendedKeyManager {
        private final X509ExtendedKeyManager delegate;
        private final String keyAlias;

        ExtendedAliasKeyManager(KeyManager mgr, String keyAlias) {
            this.delegate = (X509ExtendedKeyManager)mgr;
            this.keyAlias = keyAlias;
        }

        @Override
        public String[] getClientAliases(String s, Principal[] principals) {
            return this.delegate.getClientAliases(s, principals);
        }

        @Override
        public String chooseClientAlias(String[] strings, Principal[] principals, Socket socket) {
            if (!StringUtils.isEmpty((CharSequence)this.keyAlias)) {
                return this.keyAlias;
            }
            return this.delegate.chooseClientAlias(strings, principals, socket);
        }

        @Override
        public String[] getServerAliases(String s, Principal[] principals) {
            return this.delegate.getServerAliases(s, principals);
        }

        @Override
        public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
            if (!StringUtils.isEmpty((CharSequence)this.keyAlias)) {
                PrivateKey key = this.delegate.getPrivateKey(this.keyAlias);
                return this.getKeyAlias(keyType, key);
            }
            return this.delegate.chooseServerAlias(keyType, issuers, socket);
        }

        @Override
        public X509Certificate[] getCertificateChain(String s) {
            if (!StringUtils.isEmpty((CharSequence)this.keyAlias)) {
                return this.delegate.getCertificateChain(this.keyAlias);
            }
            return this.delegate.getCertificateChain(s);
        }

        @Override
        public PrivateKey getPrivateKey(String alias) {
            return this.delegate.getPrivateKey(alias);
        }

        @Override
        public String chooseEngineClientAlias(String[] keyTypes, Principal[] principals, SSLEngine sslEngine) {
            return this.delegate.chooseEngineClientAlias(keyTypes, principals, sslEngine);
        }

        @Override
        public String chooseEngineServerAlias(String keyType, Principal[] principals, SSLEngine sslEngine) {
            if (!StringUtils.isEmpty((CharSequence)this.keyAlias)) {
                PrivateKey key = this.delegate.getPrivateKey(this.keyAlias);
                return this.getKeyAlias(keyType, key);
            }
            return this.delegate.chooseEngineServerAlias(keyType, principals, sslEngine);
        }

        private String getKeyAlias(String keyType, PrivateKey key) {
            if (key != null) {
                if (key.getAlgorithm().equals(keyType)) {
                    return this.keyAlias;
                }
                return null;
            }
            return null;
        }
    }
}

