/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.net;

import java.io.EOFException;
import java.io.IOException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SocketChannel;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSession;
import org.apache.geode.GemFireIOException;
import org.apache.geode.internal.net.BufferPool;
import org.apache.geode.internal.net.NioFilter;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class NioSslEngine
implements NioFilter {
    private static final Logger logger = LogService.getLogger();
    private final BufferPool bufferPool;
    private volatile boolean closed;
    SSLEngine engine;
    ByteBuffer myNetData;
    ByteBuffer peerAppData;

    NioSslEngine(SSLEngine engine, BufferPool bufferPool) {
        SSLSession session = engine.getSession();
        int appBufferSize = session.getApplicationBufferSize();
        int packetBufferSize = engine.getSession().getPacketBufferSize();
        this.engine = engine;
        this.bufferPool = bufferPool;
        this.myNetData = bufferPool.acquireDirectSenderBuffer(packetBufferSize);
        this.peerAppData = bufferPool.acquireNonDirectReceiveBuffer(appBufferSize);
    }

    public boolean handshake(SocketChannel socketChannel, int timeout, ByteBuffer peerNetData) throws IOException, InterruptedException {
        if (peerNetData.capacity() < this.engine.getSession().getPacketBufferSize()) {
            throw new IllegalArgumentException(String.format("Provided buffer is too small to perform SSL handshake.  Buffer capacity is %s but need %s", peerNetData.capacity(), this.engine.getSession().getPacketBufferSize()));
        }
        ByteBuffer handshakeBuffer = peerNetData;
        handshakeBuffer.clear();
        ByteBuffer myAppData = ByteBuffer.wrap(new byte[0]);
        if (logger.isDebugEnabled()) {
            logger.debug("Starting TLS handshake with {}.  Timeout is {}ms", (Object)socketChannel.socket(), (Object)timeout);
        }
        long timeoutNanos = -1L;
        if (timeout > 0) {
            timeoutNanos = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(timeout);
        }
        this.engine.beginHandshake();
        SSLEngineResult.HandshakeStatus status = this.engine.getHandshakeStatus();
        SSLEngineResult engineResult = null;
        while (status != SSLEngineResult.HandshakeStatus.FINISHED && status != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
            if (socketChannel.socket().isClosed()) {
                logger.info("Handshake terminated because socket is closed");
                throw new SocketException("handshake terminated - socket is closed");
            }
            if (timeoutNanos > 0L && timeoutNanos < System.nanoTime()) {
                logger.info("TLS handshake is timing out");
                throw new SocketTimeoutException("handshake timed out");
            }
            block0 : switch (status) {
                case NEED_UNWRAP: {
                    int dataRead = socketChannel.read(handshakeBuffer);
                    handshakeBuffer.flip();
                    engineResult = this.engine.unwrap(handshakeBuffer, this.peerAppData);
                    handshakeBuffer.compact();
                    status = engineResult.getHandshakeStatus();
                    if (this.peerAppData.remaining() == 0 && dataRead == 0 && status == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
                        Thread.sleep(10L);
                    }
                    if (engineResult.getStatus() != SSLEngineResult.Status.BUFFER_OVERFLOW) break;
                    this.peerAppData = this.expandWriteBuffer(BufferPool.BufferType.TRACKED_RECEIVER, this.peerAppData, this.peerAppData.capacity() * 2);
                    break;
                }
                case NEED_WRAP: {
                    this.myNetData.clear();
                    engineResult = this.engine.wrap(myAppData, this.myNetData);
                    status = engineResult.getHandshakeStatus();
                    switch (engineResult.getStatus()) {
                        case BUFFER_OVERFLOW: {
                            this.myNetData = this.expandWriteBuffer(BufferPool.BufferType.TRACKED_SENDER, this.myNetData, this.myNetData.capacity() * 2);
                            break block0;
                        }
                        case OK: {
                            this.myNetData.flip();
                            while (this.myNetData.hasRemaining()) {
                                socketChannel.write(this.myNetData);
                            }
                            break block0;
                        }
                        case CLOSED: {
                            break block0;
                        }
                        default: {
                            logger.info("handshake terminated with illegal state due to {}", (Object)status);
                            throw new IllegalStateException("Unknown SSLEngineResult status: " + (Object)((Object)engineResult.getStatus()));
                        }
                    }
                }
                case NEED_TASK: {
                    this.handleBlockingTasks();
                    status = this.engine.getHandshakeStatus();
                    break;
                }
                default: {
                    logger.info("handshake terminated with illegal state due to {}", (Object)status);
                    throw new IllegalStateException("Unknown SSL Handshake state: " + (Object)((Object)status));
                }
            }
            Thread.sleep(10L);
        }
        if (status != SSLEngineResult.HandshakeStatus.FINISHED) {
            logger.info("handshake terminated with exception due to {}", (Object)status);
            throw new SSLHandshakeException("SSL Handshake terminated with status " + (Object)((Object)status));
        }
        if (logger.isDebugEnabled()) {
            if (engineResult != null) {
                logger.debug("TLS handshake successful.  result={} and handshakeResult={}", (Object)engineResult.getStatus(), (Object)this.engine.getHandshakeStatus());
            } else {
                logger.debug("TLS handshake successful.  handshakeResult={}", (Object)this.engine.getHandshakeStatus());
            }
        }
        return true;
    }

    ByteBuffer expandWriteBuffer(BufferPool.BufferType type, ByteBuffer existing, int desiredCapacity) {
        return this.bufferPool.expandWriteBufferIfNeeded(type, existing, desiredCapacity);
    }

    void checkClosed() {
        if (this.closed) {
            throw new IllegalStateException("NioSslEngine has been closed");
        }
    }

    void handleBlockingTasks() {
        Runnable task;
        while ((task = this.engine.getDelegatedTask()) != null) {
            task.run();
        }
    }

    @Override
    public synchronized ByteBuffer wrap(ByteBuffer appData) throws IOException {
        this.checkClosed();
        this.myNetData.clear();
        while (appData.hasRemaining()) {
            SSLEngineResult wrapResult;
            int remaining = this.myNetData.capacity() - this.myNetData.position();
            if (remaining < appData.remaining() * 2) {
                int newCapacity = this.expandedCapacity(appData, this.myNetData);
                this.myNetData = this.expandWriteBuffer(BufferPool.BufferType.TRACKED_SENDER, this.myNetData, newCapacity);
            }
            if ((wrapResult = this.engine.wrap(appData, this.myNetData)).getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                this.handleBlockingTasks();
            }
            if (wrapResult.getStatus() == SSLEngineResult.Status.OK) continue;
            throw new SSLException("Error encrypting data: " + wrapResult);
        }
        this.myNetData.flip();
        return this.myNetData;
    }

    @Override
    public synchronized ByteBuffer unwrap(ByteBuffer wrappedBuffer) throws IOException {
        this.checkClosed();
        this.peerAppData.limit(this.peerAppData.capacity());
        block5: while (wrappedBuffer.hasRemaining()) {
            SSLEngineResult unwrapResult = this.engine.unwrap(wrappedBuffer, this.peerAppData);
            switch (unwrapResult.getStatus()) {
                case BUFFER_OVERFLOW: {
                    int newCapacity = (this.peerAppData.capacity() - this.peerAppData.position()) * 2 + this.peerAppData.position();
                    newCapacity = Math.max(newCapacity, this.peerAppData.capacity() / 2 * 3);
                    this.peerAppData = this.bufferPool.expandWriteBufferIfNeeded(BufferPool.BufferType.TRACKED_RECEIVER, this.peerAppData, newCapacity);
                    this.peerAppData.limit(this.peerAppData.capacity());
                    continue block5;
                }
                case BUFFER_UNDERFLOW: {
                    wrappedBuffer.compact();
                    return this.peerAppData;
                }
                case OK: {
                    continue block5;
                }
            }
            throw new SSLException("Error decrypting data: " + unwrapResult);
        }
        wrappedBuffer.clear();
        return this.peerAppData;
    }

    @Override
    public ByteBuffer ensureWrappedCapacity(int amount, ByteBuffer wrappedBuffer, BufferPool.BufferType bufferType) {
        ByteBuffer buffer = wrappedBuffer;
        int requiredSize = this.engine.getSession().getPacketBufferSize();
        if (buffer == null) {
            buffer = this.bufferPool.acquireDirectBuffer(bufferType, requiredSize);
        } else if (buffer.capacity() < requiredSize) {
            buffer = this.bufferPool.expandWriteBufferIfNeeded(bufferType, buffer, requiredSize);
        }
        return buffer;
    }

    @Override
    public ByteBuffer readAtLeast(SocketChannel channel, int bytes, ByteBuffer wrappedBuffer) throws IOException {
        if (this.peerAppData.capacity() > bytes && this.peerAppData.capacity() - this.peerAppData.position() < bytes) {
            this.peerAppData.compact();
            this.peerAppData.flip();
        }
        while (this.peerAppData.remaining() < bytes) {
            wrappedBuffer.limit(wrappedBuffer.capacity());
            int amountRead = channel.read(wrappedBuffer);
            if (amountRead < 0) {
                throw new EOFException();
            }
            if (amountRead <= 0) continue;
            wrappedBuffer.flip();
            this.peerAppData.compact();
            this.peerAppData = this.unwrap(wrappedBuffer);
            this.peerAppData.flip();
        }
        return this.peerAppData;
    }

    @Override
    public ByteBuffer getUnwrappedBuffer(ByteBuffer wrappedBuffer) {
        return this.peerAppData;
    }

    public ByteBuffer ensureUnwrappedCapacity(int amount) {
        this.peerAppData = this.bufferPool.expandReadBufferIfNeeded(BufferPool.BufferType.TRACKED_RECEIVER, this.peerAppData, amount);
        return this.peerAppData;
    }

    @Override
    public void doneReadingDirectAck(ByteBuffer unwrappedBuffer) {
    }

    @Override
    public void close(SocketChannel socketChannel) {
        if (this.closed) {
            return;
        }
        try {
            if (!this.engine.isOutboundDone()) {
                ByteBuffer empty = ByteBuffer.wrap(new byte[0]);
                this.engine.closeOutbound();
                this.myNetData.clear();
                SSLEngineResult result = this.engine.wrap(empty, this.myNetData);
                if (result.getStatus() != SSLEngineResult.Status.CLOSED) {
                    throw new SSLHandshakeException("Error closing SSL session.  Status=" + (Object)((Object)result.getStatus()));
                }
                this.myNetData.flip();
                while (this.myNetData.hasRemaining()) {
                    socketChannel.write(this.myNetData);
                }
            }
        }
        catch (ClosedChannelException empty) {
        }
        catch (IOException e) {
            throw new GemFireIOException("exception closing SSL session", e);
        }
        finally {
            this.bufferPool.releaseBuffer(BufferPool.BufferType.TRACKED_SENDER, this.myNetData);
            this.bufferPool.releaseBuffer(BufferPool.BufferType.TRACKED_RECEIVER, this.peerAppData);
            this.closed = true;
        }
    }

    private int expandedCapacity(ByteBuffer sourceBuffer, ByteBuffer targetBuffer) {
        return Math.max(targetBuffer.position() + sourceBuffer.remaining() * 2, targetBuffer.capacity() * 2);
    }
}

