/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.net;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.net.BufferPool;
import org.apache.geode.internal.net.NioFilter;

public class NioPlainEngine
implements NioFilter {
    private final BufferPool bufferPool;
    int lastReadPosition;
    int lastProcessedPosition;

    public NioPlainEngine(BufferPool bufferPool) {
        this.bufferPool = bufferPool;
    }

    @Override
    public ByteBuffer wrap(ByteBuffer buffer) {
        return buffer;
    }

    @Override
    public ByteBuffer unwrap(ByteBuffer wrappedBuffer) {
        wrappedBuffer.position(wrappedBuffer.limit());
        return wrappedBuffer;
    }

    @Override
    public ByteBuffer ensureWrappedCapacity(int amount, ByteBuffer wrappedBuffer, BufferPool.BufferType bufferType) {
        ByteBuffer buffer = wrappedBuffer;
        if (buffer == null) {
            buffer = this.bufferPool.acquireDirectBuffer(bufferType, amount);
            buffer.clear();
            this.lastProcessedPosition = 0;
            this.lastReadPosition = 0;
        } else if (buffer.capacity() > amount) {
            if (buffer.capacity() - this.lastProcessedPosition < amount) {
                buffer.limit(this.lastReadPosition);
                buffer.position(this.lastProcessedPosition);
                buffer.compact();
                this.lastReadPosition = buffer.position();
                this.lastProcessedPosition = 0;
            }
        } else {
            ByteBuffer oldBuffer = buffer;
            oldBuffer.limit(this.lastReadPosition);
            oldBuffer.position(this.lastProcessedPosition);
            buffer = this.bufferPool.acquireDirectBuffer(bufferType, amount);
            buffer.clear();
            buffer.put(oldBuffer);
            this.bufferPool.releaseBuffer(bufferType, oldBuffer);
            this.lastReadPosition = buffer.position();
            this.lastProcessedPosition = 0;
        }
        return buffer;
    }

    @Override
    public ByteBuffer readAtLeast(SocketChannel channel, int bytes, ByteBuffer wrappedBuffer) throws IOException {
        ByteBuffer buffer = wrappedBuffer;
        Assert.assertTrue(buffer.capacity() - this.lastProcessedPosition >= bytes);
        buffer.limit(buffer.capacity());
        buffer.position(this.lastReadPosition);
        while (buffer.position() < this.lastProcessedPosition + bytes) {
            int amountRead = channel.read(buffer);
            if (amountRead >= 0) continue;
            throw new EOFException();
        }
        this.lastReadPosition = buffer.position();
        buffer.limit(this.lastProcessedPosition + bytes);
        buffer.position(this.lastProcessedPosition);
        this.lastProcessedPosition += bytes;
        return buffer;
    }

    @Override
    public void doneReading(ByteBuffer unwrappedBuffer) {
        if (unwrappedBuffer.position() != 0) {
            unwrappedBuffer.compact();
        } else {
            unwrappedBuffer.position(unwrappedBuffer.limit());
            unwrappedBuffer.limit(unwrappedBuffer.capacity());
        }
    }

    @Override
    public ByteBuffer getUnwrappedBuffer(ByteBuffer wrappedBuffer) {
        return wrappedBuffer;
    }
}

