/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.wan;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.geode.CancelException;
import org.apache.geode.GemFireException;
import org.apache.geode.SystemFailure;
import org.apache.geode.cache.CacheException;
import org.apache.geode.cache.EntryEvent;
import org.apache.geode.cache.Operation;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.cache.wan.GatewayEventFilter;
import org.apache.geode.cache.wan.GatewayQueueEvent;
import org.apache.geode.cache.wan.GatewaySender;
import org.apache.geode.internal.cache.BucketRegion;
import org.apache.geode.internal.cache.Conflatable;
import org.apache.geode.internal.cache.DistributedRegion;
import org.apache.geode.internal.cache.EntryEventImpl;
import org.apache.geode.internal.cache.EnumListenerEvent;
import org.apache.geode.internal.cache.EventID;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.InternalRegion;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.RegionQueue;
import org.apache.geode.internal.cache.wan.AbstractGatewaySender;
import org.apache.geode.internal.cache.wan.GatewaySenderConfigurationException;
import org.apache.geode.internal.cache.wan.GatewaySenderEventCallbackArgument;
import org.apache.geode.internal.cache.wan.GatewaySenderEventCallbackDispatcher;
import org.apache.geode.internal.cache.wan.GatewaySenderEventDispatcher;
import org.apache.geode.internal.cache.wan.GatewaySenderEventImpl;
import org.apache.geode.internal.cache.wan.GatewaySenderEventProcessor;
import org.apache.geode.internal.cache.wan.GatewaySenderException;
import org.apache.geode.internal.cache.wan.GatewaySenderStats;
import org.apache.geode.internal.cache.wan.parallel.ConcurrentParallelGatewaySenderQueue;
import org.apache.geode.internal.cache.wan.parallel.ParallelGatewaySenderQueue;
import org.apache.geode.internal.cache.wan.serial.SerialGatewaySenderQueue;
import org.apache.geode.internal.monitoring.ThreadsMonitoring;
import org.apache.geode.logging.internal.executors.LoggingThread;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public abstract class AbstractGatewaySenderEventProcessor
extends LoggingThread
implements GatewaySenderEventProcessor {
    private static final Logger logger = LogService.getLogger();
    protected RegionQueue queue;
    protected GatewaySenderEventDispatcher dispatcher;
    protected final AbstractGatewaySender sender;
    protected int batchId = 0;
    private volatile boolean isStopped = true;
    protected volatile boolean isPaused = false;
    protected boolean isDispatcherWaiting = false;
    protected final Object pausedLock = new Object();
    private final Object runningStateLock = new Object();
    protected boolean eventQueueSizeWarning = false;
    private Exception exception;
    private final ThreadsMonitoring threadMonitoring;
    private Map<Integer, List<GatewaySenderEventImpl>[]> batchIdToEventsMap = Collections.synchronizedMap(new HashMap());
    private Map<Integer, List<GatewaySenderEventImpl>> batchIdToPDXEventsMap = Collections.synchronizedMap(new HashMap());
    private List<GatewaySenderEventImpl> pdxSenderEventsList = new ArrayList<GatewaySenderEventImpl>();
    private Map<Object, GatewaySenderEventImpl> pdxEventsMap = new HashMap<Object, GatewaySenderEventImpl>();
    private volatile boolean rebuildPdxList = false;
    private volatile boolean resetLastPeekedEvents;
    private long numEventsDispatched;
    private int batchSize;
    private final ConcurrentHashMap<Integer, long[]> failureLogInterval = new ConcurrentHashMap();
    protected static final int FAILURE_MAP_MAXSIZE = Integer.getInteger("gemfire.GatewaySender.FAILURE_MAP_MAXSIZE", 1000000);
    protected static final int FAILURE_LOG_MAX_INTERVAL = Integer.getInteger("gemfire.GatewaySender.FAILURE_LOG_MAX_INTERVAL", 300000);

    public AbstractGatewaySenderEventProcessor(String string, GatewaySender sender, ThreadsMonitoring tMonitoring) {
        super(string);
        this.sender = (AbstractGatewaySender)sender;
        this.batchSize = sender.getBatchSize();
        this.threadMonitoring = tMonitoring;
    }

    public Object getRunningStateLock() {
        return this.runningStateLock;
    }

    @Override
    public int getTotalQueueSize() {
        return this.getQueue().size();
    }

    protected abstract void initializeMessageQueue(String var1);

    public abstract void enqueueEvent(EnumListenerEvent var1, EntryEvent var2, Object var3) throws IOException, CacheException;

    protected abstract void rebalance();

    public boolean isStopped() {
        return this.isStopped;
    }

    protected void setIsStopped(boolean isStopped) {
        if (isStopped) {
            this.isStopped = true;
            this.failureLogInterval.clear();
        } else {
            this.isStopped = isStopped;
        }
    }

    public boolean isPaused() {
        return this.isPaused;
    }

    public RegionQueue getQueue() {
        return this.queue;
    }

    public void incrementBatchId() {
        if (this.batchId + 1 == Integer.MAX_VALUE) {
            this.batchId = -1;
        }
        ++this.batchId;
    }

    protected void resetBatchId() {
        this.batchId = 0;
        this.resetLastPeekedEvents = true;
    }

    protected int getBatchSize() {
        return this.batchSize;
    }

    protected void setBatchSize(int batchSize) {
        int currentBatchSize = this.batchSize;
        if (batchSize <= 0) {
            this.batchSize = 1;
            logger.warn("Attempting to set the batch size from {} to {} events failed. Instead it was set to 1.", new Object[]{currentBatchSize, batchSize});
        } else {
            this.batchSize = batchSize;
            logger.info("Set the batch size from {} to {} events", new Object[]{currentBatchSize, this.batchSize});
        }
    }

    protected int getBatchId() {
        return this.batchId;
    }

    protected boolean isConnectionReset() {
        return this.resetLastPeekedEvents;
    }

    protected void eventQueueRemove(int size) throws CacheException {
        this.queue.remove(size);
    }

    protected Object eventQueueTake() throws CacheException, InterruptedException {
        throw new UnsupportedOperationException();
    }

    public int eventQueueSize() {
        return this.getQueue() == null ? 0 : this.getQueue().size();
    }

    public int secondaryEventQueueSize() {
        if (this.queue == null) {
            return 0;
        }
        if (this.queue instanceof ConcurrentParallelGatewaySenderQueue) {
            int size = ((ConcurrentParallelGatewaySenderQueue)this.queue).localSize(true) - ((ConcurrentParallelGatewaySenderQueue)this.queue).localSize(false);
            return size;
        }
        return this.queue.size();
    }

    protected abstract void registerEventDroppedInPrimaryQueue(EntryEventImpl var1);

    public AbstractGatewaySender getSender() {
        return this.sender;
    }

    public void pauseDispatching() {
        if (this.isPaused) {
            return;
        }
        this.isPaused = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForDispatcherToPause() {
        if (!this.isPaused) {
            throw new IllegalStateException("Should be trying to pause!");
        }
        boolean interrupted = false;
        Object object = this.pausedLock;
        synchronized (object) {
            while (!this.isDispatcherWaiting && !this.isStopped() && this.sender.getSenderAdvisor().isPrimary()) {
                try {
                    this.pausedLock.wait();
                }
                catch (InterruptedException e) {
                    interrupted = true;
                }
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeDispatching() {
        if (!this.isPaused) {
            return;
        }
        this.isPaused = false;
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Resumed dispatching", (Object)this);
        }
        Object object = this.pausedLock;
        synchronized (object) {
            this.pausedLock.notifyAll();
        }
    }

    protected boolean stopped() {
        if (this.isStopped) {
            return true;
        }
        return this.sender.getStopper().isCancelInProgress();
    }

    public boolean skipFailureLogging(Integer batchId) {
        boolean skipLogging = false;
        if (this.failureLogInterval.size() < FAILURE_MAP_MAXSIZE) {
            long[] logInterval = this.failureLogInterval.get(batchId);
            if (logInterval == null) {
                logInterval = this.failureLogInterval.putIfAbsent(batchId, new long[]{System.currentTimeMillis(), 1000L});
            }
            if (logInterval != null) {
                long currentTime = System.currentTimeMillis();
                if (currentTime - logInterval[0] < logInterval[1]) {
                    skipLogging = true;
                } else {
                    logInterval[0] = currentTime;
                    if (logInterval[1] <= (long)(FAILURE_LOG_MAX_INTERVAL / 4)) {
                        logInterval[1] = logInterval[1] * 4L;
                    }
                }
            }
        }
        return skipLogging;
    }

    public boolean removeEventFromFailureMap(Integer batchId) {
        return this.failureLogInterval.remove(batchId) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     */
    protected void processQueue() {
        boolean isDebugEnabled = logger.isDebugEnabled();
        boolean isTraceEnabled = logger.isTraceEnabled();
        int batchTimeInterval = this.sender.getBatchTimeInterval();
        GatewaySenderStats statistics = this.sender.getStatistics();
        if (isDebugEnabled) {
            logger.debug("STARTED processQueue {}", (Object)this.getId());
        }
        List events = null;
        ArrayList filteredList = new ArrayList();
        List<Object> pdxEventsToBeDispatched = new ArrayList();
        ArrayList<GatewaySenderEventImpl> eventsToBeDispatched = new ArrayList<GatewaySenderEventImpl>();
        block16: while (!this.stopped()) {
            try {
                if (this.isPaused) {
                    this.waitForResumption();
                }
                if (isDebugEnabled) {
                    logger.debug("Attempting to peek a batch of {} events", (Object)this.batchSize);
                }
                while (true) {
                    boolean success;
                    GatewaySenderEventImpl event;
                    if (this.stopped()) {
                        if (!isDebugEnabled) continue block16;
                        logger.debug("GatewaySenderEventProcessor is stopped. Returning without peeking events.");
                        continue block16;
                    }
                    if (this.isPaused) {
                        this.waitForResumption();
                    }
                    boolean sendUpdateVersionEvents = this.shouldSendVersionEvents(this.dispatcher);
                    boolean interrupted = Thread.interrupted();
                    try {
                        if (this.resetLastPeekedEvents) {
                            this.resetLastPeekedEvents();
                            this.resetLastPeekedEvents = false;
                        }
                        events = this.queue.peek(this.batchSize, batchTimeInterval);
                    }
                    catch (InterruptedException e) {
                        interrupted = true;
                        this.sender.getCancelCriterion().checkCancelInProgress(e);
                        continue;
                    }
                    finally {
                        if (!interrupted) continue;
                        Thread.currentThread().interrupt();
                        continue;
                    }
                    if (events.isEmpty()) continue;
                    this.beforeExecute();
                    filteredList = new ArrayList(events);
                    if (this.exception != null && this.exception.getCause() != null && this.exception.getCause() instanceof IllegalStateException) {
                        Iterator<GatewayEventFilter> i = filteredList.iterator();
                        while (i.hasNext()) {
                            event = (GatewaySenderEventImpl)((Object)i.next());
                            if (!event.isSerializedValueNotAvailable()) continue;
                            i.remove();
                        }
                        this.exception = null;
                    }
                    for (GatewayEventFilter filter : this.sender.getGatewayEventFilters()) {
                        Iterator itr = filteredList.iterator();
                        while (itr.hasNext()) {
                            GatewayQueueEvent event2 = (GatewayQueueEvent)itr.next();
                            if (!sendUpdateVersionEvents && event2.getOperation() == Operation.UPDATE_VERSION_STAMP) {
                                if (isTraceEnabled) {
                                    logger.trace("Update Event Version event: {} removed from Gateway Sender queue: {}", (Object)event2, (Object)this.sender);
                                }
                                itr.remove();
                                statistics.incEventsNotQueued();
                                continue;
                            }
                            boolean transmit = filter.beforeTransmit(event2);
                            if (transmit) continue;
                            if (isDebugEnabled) {
                                logger.debug("{}: Did not transmit event due to filtering: {}", (Object)this.sender.getId(), (Object)event2);
                            }
                            itr.remove();
                            statistics.incEventsFiltered();
                        }
                    }
                    Iterator cmeItr = filteredList.iterator();
                    while (cmeItr.hasNext()) {
                        event = (GatewaySenderEventImpl)cmeItr.next();
                        if (!event.isConcurrencyConflict()) continue;
                        cmeItr.remove();
                        logger.debug("The CME event: {} is removed from Gateway Sender queue: {}", (Object)event, (Object)this.sender);
                        statistics.incEventsNotQueued();
                    }
                    if (this.getSender().isParallel() && this.getDispatcher() instanceof GatewaySenderEventCallbackDispatcher) {
                        for (GatewaySenderEventImpl event3 : filteredList) {
                            BucketRegion bucket;
                            Object qpr = null;
                            qpr = this.getQueue() instanceof ConcurrentParallelGatewaySenderQueue ? ((ConcurrentParallelGatewaySenderQueue)this.getQueue()).getRegion(event3.getRegionPath()) : ((ParallelGatewaySenderQueue)this.getQueue()).getRegion(event3.getRegionPath());
                            int bucketId = event3.getBucketId();
                            if (qpr == null || (bucket = ((PartitionedRegion)qpr).getDataStore().getLocalBucketById(bucketId)) != null && bucket.getBucketAdvisor().isPrimary()) continue;
                            event3.setPossibleDuplicate(true);
                            if (!isDebugEnabled) continue;
                            logger.debug("Bucket id: {} is no longer primary on this node. The event: {} will be dispatched from this node with possibleDuplicate set to true.", (Object)bucketId, (Object)event3);
                        }
                    }
                    eventsToBeDispatched.clear();
                    if (!(this.dispatcher instanceof GatewaySenderEventCallbackDispatcher)) {
                        List[] eventsArr = new List[]{events, filteredList};
                        this.batchIdToEventsMap.put(this.getBatchId(), eventsArr);
                        pdxEventsToBeDispatched = this.addPDXEvent();
                        eventsToBeDispatched.addAll(pdxEventsToBeDispatched);
                        if (!pdxEventsToBeDispatched.isEmpty()) {
                            this.batchIdToPDXEventsMap.put(this.getBatchId(), pdxEventsToBeDispatched);
                        }
                    }
                    eventsToBeDispatched.addAll(filteredList);
                    List conflatedEventsToBeDispatched = this.conflate(eventsToBeDispatched);
                    if (isDebugEnabled) {
                        this.logBatchFine("During normal processing, dispatching the following ", conflatedEventsToBeDispatched);
                    }
                    if (success = this.dispatcher.dispatchBatch(conflatedEventsToBeDispatched, this.sender.isRemoveFromQueueOnException(), false)) {
                        if (isDebugEnabled) {
                            logger.debug("During normal processing, successfully dispatched {} events (batch #{})", (Object)conflatedEventsToBeDispatched.size(), (Object)this.getBatchId());
                        }
                        this.removeEventFromFailureMap(this.getBatchId());
                    } else if (!this.skipFailureLogging(this.getBatchId())) {
                        logger.warn("During normal processing, unsuccessfully dispatched {} events (batch #{})", new Object[]{filteredList.size(), this.getBatchId()});
                    }
                    if (this.stopped()) continue block16;
                    if (success) {
                        if (this.dispatcher instanceof GatewaySenderEventCallbackDispatcher) {
                            this.handleSuccessfulBatchDispatch(conflatedEventsToBeDispatched, events);
                        } else {
                            this.incrementBatchId();
                        }
                        for (GatewaySenderEventImpl pdxGatewaySenderEvent : pdxEventsToBeDispatched) {
                            pdxGatewaySenderEvent.isDispatched = true;
                        }
                        this.increaseNumEventsDispatched(conflatedEventsToBeDispatched.size());
                    } else if (this.dispatcher instanceof GatewaySenderEventCallbackDispatcher) {
                        this.handleUnSuccessfulBatchDispatch(events);
                        this.resetLastPeekedEvents = true;
                    } else {
                        this.handleUnSuccessfulBatchDispatch(events);
                        if (!this.resetLastPeekedEvents) {
                            while (!this.dispatcher.dispatchBatch(conflatedEventsToBeDispatched, this.sender.isRemoveFromQueueOnException(), true)) {
                                if (isDebugEnabled) {
                                    logger.debug("During normal processing, unsuccessfully dispatched {} events (batch #{})", (Object)conflatedEventsToBeDispatched.size(), (Object)this.getBatchId());
                                }
                                if (this.stopped() || this.resetLastPeekedEvents) break;
                                try {
                                    if (this.threadMonitoring != null) {
                                        this.threadMonitoring.updateThreadStatus();
                                    }
                                    Thread.sleep(100L);
                                }
                                catch (InterruptedException ie) {
                                    Thread.currentThread().interrupt();
                                }
                            }
                            this.incrementBatchId();
                        }
                    }
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("Finished processing events (batch #{})", (Object)(this.getBatchId() - 1));
                    continue;
                    break;
                }
                finally {
                    this.afterExecute();
                }
            }
            catch (RegionDestroyedException e) {
                this.resetLastPeekedEvents = true;
                if (!logger.isDebugEnabled()) continue;
                logger.debug("Observed RegionDestroyedException on Queue's region.");
            }
            catch (CancelException e) {
                logger.debug("Caught cancel exception", (Throwable)e);
                this.setIsStopped(true);
            }
            catch (VirtualMachineError err) {
                SystemFailure.initiateFailure(err);
                throw err;
            }
            catch (Throwable e) {
                Throwable cause;
                SystemFailure.checkFailure();
                if (this.stopped()) {
                    return;
                }
                if (events != null) {
                    this.handleUnSuccessfulBatchDispatch(events);
                }
                this.resetLastPeekedEvents = true;
                if (e instanceof GatewaySenderException && ((cause = e.getCause()) instanceof IOException || e instanceof GatewaySenderConfigurationException)) continue;
                logger.warn("An Exception occurred. The dispatcher will continue.", e);
            }
        }
    }

    private boolean shouldSendVersionEvents(GatewaySenderEventDispatcher dispatcher) {
        return false;
    }

    public List conflate(List<GatewaySenderEventImpl> events) {
        List<GatewaySenderEventImpl> conflatedEvents = null;
        if (this.sender.isBatchConflationEnabled() && events.size() > 1) {
            if (logger.isDebugEnabled()) {
                this.logEvents("original", events);
            }
            LinkedHashMap<ConflationKey, GatewaySenderEventImpl> conflatedEventsMap = new LinkedHashMap<ConflationKey, GatewaySenderEventImpl>();
            conflatedEvents = new ArrayList<GatewaySenderEventImpl>();
            for (GatewaySenderEventImpl gsEvent : events) {
                ConflationKey key;
                if (gsEvent.shouldBeConflated()) {
                    key = new ConflationKey(gsEvent.getRegionPath(), gsEvent.getKeyToConflate(), gsEvent.getOperation());
                    GatewaySenderEventImpl existingEvent = (GatewaySenderEventImpl)conflatedEventsMap.get(key);
                    if (gsEvent.equals(existingEvent)) continue;
                    conflatedEventsMap.remove(key);
                    conflatedEventsMap.put(key, gsEvent);
                    continue;
                }
                key = new ConflationKey(gsEvent.getRegionPath(), gsEvent.getKeyToConflate(), gsEvent.getOperation(), gsEvent.getEventId());
                conflatedEventsMap.put(key, gsEvent);
            }
            for (GatewaySenderEventImpl gei : conflatedEventsMap.values()) {
                conflatedEvents.add(gei);
            }
            this.sender.getStatistics().incEventsConflatedFromBatches(events.size() - conflatedEvents.size());
            if (logger.isDebugEnabled()) {
                this.logEvents("conflated", conflatedEvents);
            }
        } else {
            conflatedEvents = events;
        }
        return conflatedEvents;
    }

    private void logEvents(String message, List<GatewaySenderEventImpl> events) {
        StringBuilder builder = new StringBuilder();
        builder.append("The batch contains the following ").append(events.size()).append(" ").append(message).append(" events:");
        for (GatewaySenderEventImpl event : events) {
            builder.append("\t\n").append(event.toSmallString());
        }
        logger.debug((CharSequence)builder);
    }

    private List<GatewaySenderEventImpl> addPDXEvent() throws IOException {
        ArrayList<GatewaySenderEventImpl> pdxEventsToBeDispatched = new ArrayList<GatewaySenderEventImpl>();
        InternalCache cache = this.sender.getCache();
        Region pdxRegion = cache.getRegion("PdxTypes");
        if (this.rebuildPdxList) {
            this.pdxEventsMap.clear();
            this.pdxSenderEventsList.clear();
            this.rebuildPdxList = false;
        }
        if (pdxRegion != null && pdxRegion.size() != this.pdxEventsMap.size()) {
            for (Map.Entry typeEntry : pdxRegion.entrySet()) {
                if (this.pdxEventsMap.containsKey(typeEntry.getKey())) continue;
                EntryEventImpl event = EntryEventImpl.create((InternalRegion)((LocalRegion)pdxRegion), Operation.UPDATE, typeEntry.getKey(), typeEntry.getValue(), null, false, cache.getMyId());
                event.disallowOffHeapValues();
                event.setEventId(new EventID(cache.getInternalDistributedSystem()));
                ArrayList<Integer> allRemoteDSIds = new ArrayList<Integer>();
                for (GatewaySender sender : cache.getGatewaySenders()) {
                    allRemoteDSIds.add(sender.getRemoteDSId());
                }
                GatewaySenderEventCallbackArgument geCallbackArg = new GatewaySenderEventCallbackArgument(event.getRawCallbackArgument(), this.sender.getMyDSId(), allRemoteDSIds);
                event.setCallbackArgument(geCallbackArg);
                GatewaySenderEventImpl pdxSenderEvent = new GatewaySenderEventImpl(EnumListenerEvent.AFTER_UPDATE, event, null);
                this.pdxEventsMap.put(typeEntry.getKey(), pdxSenderEvent);
                this.pdxSenderEventsList.add(pdxSenderEvent);
            }
        }
        Iterator<GatewaySenderEventImpl> iterator = this.pdxSenderEventsList.iterator();
        while (iterator.hasNext()) {
            GatewaySenderEventImpl pdxEvent = iterator.next();
            if (pdxEvent.isAcked) {
                iterator.remove();
                continue;
            }
            if (pdxEvent.isDispatched) continue;
            pdxEventsToBeDispatched.add(pdxEvent);
        }
        if (!pdxEventsToBeDispatched.isEmpty() && logger.isDebugEnabled()) {
            logger.debug("List of PDX Event to be dispatched : {}", pdxEventsToBeDispatched);
        }
        return pdxEventsToBeDispatched;
    }

    public void checkIfPdxNeedsResend(int remotePdxSize) {
        InternalCache cache = this.sender.getCache();
        Region pdxRegion = cache.getRegion("PdxTypes");
        if (pdxRegion != null && pdxRegion.size() > remotePdxSize) {
            this.rebuildPdxList = true;
        }
    }

    private void resetLastPeekedEvents() {
        this.batchIdToEventsMap.clear();
        for (Map.Entry<Integer, List<GatewaySenderEventImpl>> entry : this.batchIdToPDXEventsMap.entrySet()) {
            for (GatewaySenderEventImpl event : entry.getValue()) {
                event.isDispatched = false;
            }
        }
        this.batchIdToPDXEventsMap.clear();
        if (this.queue instanceof SerialGatewaySenderQueue) {
            ((SerialGatewaySenderQueue)this.queue).resetLastPeeked();
        } else if (this.queue instanceof ParallelGatewaySenderQueue) {
            ((ParallelGatewaySenderQueue)this.queue).resetLastPeeked();
        } else {
            throw new RuntimeException("resetLastPeekedEvents : no matching queue found " + this);
        }
    }

    private void handleSuccessfulBatchDispatch(List filteredList, List events) {
        if (filteredList != null) {
            for (GatewayEventFilter filter : this.sender.getGatewayEventFilters()) {
                for (Object o : filteredList) {
                    if (o == null || !(o instanceof GatewaySenderEventImpl)) continue;
                    try {
                        filter.afterAcknowledgement((GatewaySenderEventImpl)o);
                    }
                    catch (Exception e) {
                        logger.fatal(String.format("Exception occurred while handling call to %s.afterAcknowledgement for event %s:", filter.toString(), o), (Throwable)e);
                    }
                }
            }
        }
        filteredList.clear();
        this.eventQueueRemove(events.size());
        GatewaySenderStats statistics = this.sender.getStatistics();
        int queueSize = this.eventQueueSize();
        if (this.eventQueueSizeWarning && queueSize <= AbstractGatewaySender.QUEUE_SIZE_THRESHOLD) {
            logger.info("The event queue size has dropped below {} events.", (Object)AbstractGatewaySender.QUEUE_SIZE_THRESHOLD);
            this.eventQueueSizeWarning = false;
        }
        this.incrementBatchId();
    }

    private void handleUnSuccessfulBatchDispatch(List events) {
        GatewaySenderStats statistics = this.sender.getStatistics();
        statistics.incBatchesRedistributed();
        Iterator it = events.iterator();
        while (it.hasNext() && !this.isStopped) {
            Object o = it.next();
            if (o == null || !(o instanceof GatewaySenderEventImpl)) continue;
            GatewaySenderEventImpl ge = (GatewaySenderEventImpl)o;
            ge.setPossibleDuplicate(true);
        }
    }

    public void handleException() {
        GatewaySenderStats statistics = this.sender.getStatistics();
        statistics.incBatchesRedistributed();
        this.resetLastPeekedEvents = true;
    }

    public void handleSuccessBatchAck(int batchId) {
        List<GatewaySenderEventImpl>[] eventsArr;
        List<GatewaySenderEventImpl> pdxEvents = this.batchIdToPDXEventsMap.remove(batchId);
        if (pdxEvents != null) {
            for (GatewaySenderEventImpl senderEvent : pdxEvents) {
                senderEvent.isAcked = true;
            }
        }
        if ((eventsArr = this.batchIdToEventsMap.remove(batchId)) != null) {
            List<GatewaySenderEventImpl> filteredEvents = eventsArr[1];
            for (GatewayEventFilter filter : this.sender.getGatewayEventFilters()) {
                for (GatewaySenderEventImpl event : filteredEvents) {
                    try {
                        filter.afterAcknowledgement(event);
                    }
                    catch (Exception e) {
                        logger.fatal(String.format("Exception occurred while handling call to %s.afterAcknowledgement for event %s:", filter.toString(), event), (Throwable)e);
                    }
                }
            }
            List<GatewaySenderEventImpl> events = eventsArr[0];
            if (logger.isDebugEnabled()) {
                logger.debug("Removing events from the queue {}", (Object)events.size());
            }
            this.eventQueueRemove(events.size());
            GatewaySenderStats statistics = this.sender.getStatistics();
            if (this.sender.getAlertThreshold() > 0) {
                Iterator<GatewaySenderEventImpl> it = events.iterator();
                long currentTime = System.currentTimeMillis();
                while (it.hasNext()) {
                    GatewaySenderEventImpl ge;
                    GatewaySenderEventImpl o = it.next();
                    if (o == null || !(o instanceof GatewaySenderEventImpl) || (ge = o).getCreationTime() + (long)this.sender.getAlertThreshold() >= currentTime) continue;
                    logger.warn("{} event for region={} key={} value={} was in the queue for {} milliseconds", new Object[]{ge.getOperation(), ge.getRegionPath(), ge.getKey(), ge.getValueAsString(true), currentTime - ge.getCreationTime()});
                    statistics.incEventsExceedingAlertThreshold();
                }
            }
        }
    }

    public void handleUnSuccessBatchAck(int bId) {
        this.sender.getStatistics().incBatchesRedistributed();
        List<GatewaySenderEventImpl>[] eventsArr = this.batchIdToEventsMap.get(bId);
        if (eventsArr != null) {
            List<GatewaySenderEventImpl> events = eventsArr[0];
            Iterator<GatewaySenderEventImpl> it = events.iterator();
            while (it.hasNext() && !this.isStopped) {
                GatewaySenderEventImpl o = it.next();
                if (o == null || !(o instanceof GatewaySenderEventImpl)) continue;
                GatewaySenderEventImpl ge = o;
                ge.setPossibleDuplicate(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForResumption() throws InterruptedException {
        Object object = this.pausedLock;
        synchronized (object) {
            if (!this.isPaused) {
                return;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("GatewaySenderEventProcessor is paused. Waiting for Resumption");
            }
            this.isDispatcherWaiting = true;
            this.pausedLock.notifyAll();
            while (this.isPaused) {
                this.pausedLock.wait();
            }
            this.isDispatcherWaiting = false;
        }
    }

    public abstract void initializeEventDispatcher();

    public GatewaySenderEventDispatcher getDispatcher() {
        return this.dispatcher;
    }

    public Map<Integer, List<GatewaySenderEventImpl>[]> getBatchIdToEventsMap() {
        return this.batchIdToEventsMap;
    }

    public Map<Integer, List<GatewaySenderEventImpl>> getBatchIdToPDXEventsMap() {
        return this.batchIdToPDXEventsMap;
    }

    public void run() {
        try {
            this.setRunningStatus();
            this.processQueue();
        }
        catch (CancelException e) {
            if (!this.isStopped()) {
                logger.info("A cancellation occurred. Stopping the dispatcher.");
                this.setIsStopped(true);
            }
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Throwable e) {
            SystemFailure.checkFailure();
            logger.fatal("Message dispatch failed due to unexpected exception..", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRunningStatus() throws Exception {
        GemFireException ex = null;
        try {
            this.initializeEventDispatcher();
        }
        catch (GemFireException e) {
            ex = e;
        }
        Object object = this.runningStateLock;
        synchronized (object) {
            if (ex != null) {
                this.setException(ex);
                this.setIsStopped(true);
            } else {
                this.setIsStopped(false);
            }
            this.runningStateLock.notifyAll();
        }
        if (ex != null) {
            throw ex;
        }
    }

    public void setException(GemFireException ex) {
        this.exception = ex;
    }

    public Exception getException() {
        return this.exception;
    }

    public void stopProcessing() {
        if (!this.isAlive()) {
            return;
        }
        this.resumeDispatching();
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Notifying the dispatcher to terminate", (Object)this);
        }
        if (this.sender.isPrimary()) {
            if (AbstractGatewaySender.MAXIMUM_SHUTDOWN_WAIT_TIME == -1) {
                try {
                    while (this.queue.size() != 0) {
                        Thread.sleep(5000L);
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug("{}: Waiting for the queue to get empty.", (Object)this);
                    }
                }
                catch (InterruptedException interruptedException) {
                }
                catch (CancelException cancelException) {}
            } else {
                try {
                    Thread.sleep((long)AbstractGatewaySender.MAXIMUM_SHUTDOWN_WAIT_TIME * 1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        } else {
            this.sender.getSenderAdvisor().notifyPrimaryLock();
        }
        this.setIsStopped(true);
        this.dispatcher.stop();
        if (this.isAlive()) {
            if (logger.isDebugEnabled()) {
                logger.debug("{}: Joining with the dispatcher thread upto limit of 5 seconds", (Object)this);
            }
            try {
                this.join(5000L);
                if (this.isAlive()) {
                    logger.warn("{}:Dispatcher still alive even after join of 5 seconds.", (Object)this);
                    this.dispatcher.stop();
                    this.batchIdToEventsMap.clear();
                }
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                logger.warn("{}: InterruptedException in joining with dispatcher thread.", (Object)this);
            }
        }
        this.closeProcessor();
        if (logger.isDebugEnabled()) {
            logger.debug("Stopped dispatching: {}", (Object)this);
        }
    }

    public void closeProcessor() {
        if (logger.isDebugEnabled()) {
            logger.debug("Closing dispatcher");
        }
        try {
            if (this.sender.isPrimary() && this.queue.size() > 0) {
                logger.warn("Destroying GatewayEventDispatcher with actively queued data.");
            }
        }
        catch (RegionDestroyedException regionDestroyedException) {
        }
        catch (CancelException cancelException) {
        }
        catch (CacheException cacheException) {
        }
        finally {
            this.queue.close();
            if (logger.isDebugEnabled()) {
                logger.debug("Closed dispatcher");
            }
        }
    }

    protected void destroyProcessor() {
        if (logger.isDebugEnabled()) {
            logger.debug("Destroying dispatcher");
        }
        try {
            try {
                if (this.queue.peek() != null) {
                    logger.warn("Destroying GatewayEventDispatcher with actively queued data.");
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        catch (CacheException cacheException) {
        }
        finally {
            this.queue.getRegion().localDestroyRegion();
            if (logger.isDebugEnabled()) {
                logger.debug("Destroyed dispatcher");
            }
        }
    }

    public void removeCacheListener() {
    }

    public void logBatchFine(String message, List<GatewaySenderEventImpl> events) {
        if (events != null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(message);
            buffer.append(events.size()).append(" events");
            buffer.append(" (batch #" + this.getBatchId());
            buffer.append("):\n");
            for (GatewaySenderEventImpl ge : events) {
                buffer.append("\tEvent ").append(ge.getEventId()).append(":");
                buffer.append(ge.getKey()).append("->");
                buffer.append(ge.getValueAsString(true)).append(",");
                buffer.append(ge.getShadowKey());
                buffer.append("\n");
            }
            logger.debug((CharSequence)buffer);
        }
    }

    public long getNumEventsDispatched() {
        return this.numEventsDispatched;
    }

    public void increaseNumEventsDispatched(long newEventsDispatched) {
        this.numEventsDispatched += newEventsDispatched;
    }

    public void clear(PartitionedRegion pr, int bucketId) {
        ((ParallelGatewaySenderQueue)this.queue).clear(pr, bucketId);
    }

    public void notifyEventProcessorIfRequired(int bucketId) {
        ((ParallelGatewaySenderQueue)this.queue).notifyEventProcessorIfRequired();
    }

    public BlockingQueue<GatewaySenderEventImpl> getBucketTmpQueue(int bucketId) {
        return ((ParallelGatewaySenderQueue)this.queue).getBucketToTempQueueMap().get(bucketId);
    }

    public PartitionedRegion getRegion(String prRegionName) {
        return ((ParallelGatewaySenderQueue)this.queue).getRegion(prRegionName);
    }

    public void removeShadowPR(String prRegionName) {
        ((ParallelGatewaySenderQueue)this.queue).removeShadowPR(prRegionName);
    }

    public void conflateEvent(Conflatable conflatableObject, int bucketId, Long tailKey) {
        ((ParallelGatewaySenderQueue)this.queue).conflateEvent(conflatableObject, bucketId, tailKey);
    }

    public void addShadowPartitionedRegionForUserPR(PartitionedRegion pr) {
        ((ParallelGatewaySenderQueue)this.queue).addShadowPartitionedRegionForUserPR(pr);
    }

    public void addShadowPartitionedRegionForUserRR(DistributedRegion userRegion) {
        ((ParallelGatewaySenderQueue)this.queue).addShadowPartitionedRegionForUserRR(userRegion);
    }

    protected void beforeExecute() {
        if (this.threadMonitoring != null) {
            this.threadMonitoring.startMonitor(ThreadsMonitoring.Mode.AGSExecutor);
        }
    }

    protected void afterExecute() {
        if (this.threadMonitoring != null) {
            this.threadMonitoring.endMonitor();
        }
    }

    protected abstract void enqueueEvent(GatewayQueueEvent var1);

    public String printUnprocessedEvents() {
        return null;
    }

    public String printUnprocessedTokens() {
        return null;
    }

    private static class ConflationKey {
        private Object key;
        private Operation operation;
        private String regionName;
        private EventID eventId;

        private ConflationKey(String region, Object key, Operation operation) {
            this(region, key, operation, (EventID)null);
        }

        private ConflationKey(String region, Object key, Operation operation, EventID eventId) {
            this.key = key;
            this.operation = operation;
            this.regionName = region;
            this.eventId = eventId;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.key.hashCode();
            result = 31 * result + this.operation.hashCode();
            result = 31 * result + this.regionName.hashCode();
            result = 31 * result + (this.eventId == null ? 0 : this.eventId.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ConflationKey that = (ConflationKey)obj;
            if (!this.regionName.equals(that.regionName)) {
                return false;
            }
            if (!this.key.equals(that.key)) {
                return false;
            }
            if (!this.operation.equals(that.operation)) {
                return false;
            }
            return Objects.equals(this.eventId, that.eventId);
        }
    }

    protected class SenderStopperCallable
    implements Callable<Boolean> {
        private final AbstractGatewaySenderEventProcessor p;

        public SenderStopperCallable(AbstractGatewaySenderEventProcessor processor) {
            this.p = processor;
        }

        @Override
        public Boolean call() {
            this.p.stopProcessing();
            return true;
        }
    }
}

