/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tx;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.DataSerializer;
import org.apache.geode.cache.Operation;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.cache.DistributedPutAllOperation;
import org.apache.geode.internal.cache.DistributedRemoveAllOperation;
import org.apache.geode.internal.cache.EntryEventImpl;
import org.apache.geode.internal.cache.EventID;
import org.apache.geode.internal.cache.tx.DistTxKeyInfo;
import org.apache.geode.internal.cache.versions.VersionTag;
import org.apache.geode.internal.serialization.ByteArrayDataInput;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;
import org.apache.geode.internal.serialization.StaticSerialization;
import org.apache.geode.internal.serialization.Version;

public class DistTxEntryEvent
extends EntryEventImpl {
    protected static final byte HAS_PUTALL_OP = 1;
    protected static final byte HAS_REMOVEALL_OP = 2;
    private String regionName;

    public DistTxEntryEvent(EntryEventImpl entry) {
        super(entry);
    }

    public DistTxEntryEvent() {
    }

    public String getRegionName() {
        return this.regionName;
    }

    @Override
    public Version[] getSerializationVersions() {
        return null;
    }

    @Override
    public int getDSFID() {
        return 2166;
    }

    @Override
    public void toData(DataOutput out, SerializationContext context) throws IOException {
        DataSerializer.writeObject(this.eventID, out);
        DataSerializer.writeObject(this.getRegion().getFullPath(), out);
        out.writeByte(this.op.ordinal);
        DataSerializer.writeObject(this.getKey(), out);
        DataSerializer.writeInteger(this.keyInfo.getBucketId(), out);
        DataSerializer.writeObject(this.basicGetNewValue(), out);
        byte flags = 0;
        if (this.putAllOp != null) {
            flags = (byte)(flags | 1);
        }
        if (this.removeAllOp != null) {
            flags = (byte)(flags | 2);
        }
        DataSerializer.writeByte(flags, out);
        if (this.putAllOp != null) {
            this.putAllToData(out, context);
        }
        if (this.removeAllOp != null) {
            this.removeAllToData(out, context);
        }
    }

    @Override
    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        this.eventID = (EventID)DataSerializer.readObject(in);
        this.regionName = DataSerializer.readString(in);
        this.op = Operation.fromOrdinal(in.readByte());
        Object key = DataSerializer.readObject(in);
        Integer bucketId = DataSerializer.readInteger(in);
        this.keyInfo = new DistTxKeyInfo(key, null, null, bucketId);
        this.basicSetNewValue(DataSerializer.readObject(in), true);
        byte flags = DataSerializer.readByte(in);
        if ((flags & 1) != 0) {
            this.putAllFromData(in, context);
        }
        if ((flags & 2) != 0) {
            this.removeAllFromData(in, context);
        }
    }

    private void putAllToData(DataOutput out, SerializationContext context) throws IOException {
        DataSerializer.writeInteger(this.putAllOp.putAllDataSize, out);
        DistributedPutAllOperation.EntryVersionsList versionTags = new DistributedPutAllOperation.EntryVersionsList(this.putAllOp.putAllDataSize);
        boolean hasTags = false;
        DistributedPutAllOperation.PutAllEntryData[] putAllData = this.putAllOp.getPutAllEntryData();
        for (int i = 0; i < this.putAllOp.putAllDataSize; ++i) {
            if (!hasTags && putAllData[i].versionTag != null) {
                hasTags = true;
            }
            VersionTag tag = putAllData[i].versionTag;
            versionTags.add(tag);
            putAllData[i].versionTag = null;
            putAllData[i].toData(out, context);
            putAllData[i].versionTag = tag;
        }
        out.writeBoolean(hasTags);
        if (hasTags) {
            InternalDataSerializer.invokeToData(versionTags, out);
        }
    }

    private void putAllFromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        int putAllSize = DataSerializer.readInteger(in);
        DistributedPutAllOperation.PutAllEntryData[] putAllEntries = new DistributedPutAllOperation.PutAllEntryData[putAllSize];
        if (putAllSize > 0) {
            Version version = StaticSerialization.getVersionForDataStreamOrNull((DataInput)in);
            ByteArrayDataInput bytesIn = new ByteArrayDataInput();
            for (int i = 0; i < putAllSize; ++i) {
                putAllEntries[i] = new DistributedPutAllOperation.PutAllEntryData(in, context, this.eventID, i, version, bytesIn);
            }
            boolean hasTags = in.readBoolean();
            if (hasTags) {
                DistributedPutAllOperation.EntryVersionsList versionTags = DistributedPutAllOperation.EntryVersionsList.create(in);
                for (int i = 0; i < putAllSize; ++i) {
                    putAllEntries[i].versionTag = (VersionTag)versionTags.get(i);
                }
            }
        }
        this.op = Operation.PUTALL_CREATE;
        this.setOriginRemote(true);
        this.setGenerateCallbacks(true);
        this.putAllOp = new DistributedPutAllOperation(this, putAllSize, false);
        this.putAllOp.setPutAllEntryData(putAllEntries);
    }

    private void removeAllToData(DataOutput out, SerializationContext context) throws IOException {
        DataSerializer.writeInteger(this.removeAllOp.removeAllDataSize, out);
        DistributedPutAllOperation.EntryVersionsList versionTags = new DistributedPutAllOperation.EntryVersionsList(this.removeAllOp.removeAllDataSize);
        boolean hasTags = false;
        DistributedRemoveAllOperation.RemoveAllEntryData[] removeAllData = this.removeAllOp.getRemoveAllEntryData();
        for (int i = 0; i < this.removeAllOp.removeAllDataSize; ++i) {
            if (!hasTags && removeAllData[i].versionTag != null) {
                hasTags = true;
            }
            VersionTag tag = removeAllData[i].versionTag;
            versionTags.add(tag);
            removeAllData[i].versionTag = null;
            removeAllData[i].serializeTo(out, context);
            removeAllData[i].versionTag = tag;
        }
        out.writeBoolean(hasTags);
        if (hasTags) {
            InternalDataSerializer.invokeToData(versionTags, out);
        }
    }

    private void removeAllFromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        int removeAllSize = DataSerializer.readInteger(in);
        DistributedRemoveAllOperation.RemoveAllEntryData[] removeAllData = new DistributedRemoveAllOperation.RemoveAllEntryData[removeAllSize];
        Version version = StaticSerialization.getVersionForDataStreamOrNull((DataInput)in);
        ByteArrayDataInput bytesIn = new ByteArrayDataInput();
        for (int i = 0; i < removeAllSize; ++i) {
            removeAllData[i] = new DistributedRemoveAllOperation.RemoveAllEntryData(in, this.eventID, i, version, bytesIn, context);
        }
        boolean hasTags = in.readBoolean();
        if (hasTags) {
            DistributedPutAllOperation.EntryVersionsList versionTags = DistributedPutAllOperation.EntryVersionsList.create(in);
            for (int i = 0; i < removeAllSize; ++i) {
                removeAllData[i].versionTag = (VersionTag)versionTags.get(i);
            }
        }
        this.op = Operation.REMOVEALL_DESTROY;
        this.setOriginRemote(true);
        this.setGenerateCallbacks(true);
        this.removeAllOp = new DistributedRemoveAllOperation(this, removeAllSize, false);
        this.removeAllOp.setRemoveAllEntryData(removeAllData);
    }

    public void setDistributedMember(DistributedMember sender) {
        this.distributedMember = sender;
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getShortClassName());
        buf.append("[");
        buf.append("eventID=");
        buf.append(this.eventID);
        if (this.getRegion() != null) {
            buf.append(";r=").append(this.getRegion().getName());
        }
        buf.append(";op=");
        buf.append(this.getOperation());
        buf.append(";key=");
        buf.append(this.getKey());
        buf.append(";bucket=");
        buf.append(this.getKeyInfo().getBucketId());
        buf.append(";oldValue=");
        if (this.putAllOp != null) {
            buf.append(";putAllDataSize :" + this.putAllOp.putAllDataSize);
        }
        if (this.removeAllOp != null) {
            buf.append(";removeAllDataSize :" + this.removeAllOp.removeAllDataSize);
        }
        buf.append("]");
        return buf.toString();
    }
}

