/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets.command;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.cache.operations.RegionDestroyOperationContext;
import org.apache.geode.distributed.DistributedSystemDisconnectedException;
import org.apache.geode.distributed.internal.DistributionStats;
import org.apache.geode.internal.cache.EventID;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.MessageType;
import org.apache.geode.internal.cache.tier.sockets.BaseCommand;
import org.apache.geode.internal.cache.tier.sockets.CacheServerStats;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.Part;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.security.AuthorizeRequest;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.security.ResourcePermission;

public class DestroyRegion
extends BaseCommand {
    @Immutable
    private static final DestroyRegion singleton = new DestroyRegion();

    public static Command getCommand() {
        return singleton;
    }

    @Override
    public void cmdExecute(Message clientMessage, ServerConnection serverConnection, SecurityService securityService, long start) throws IOException, InterruptedException {
        Part regionNamePart = null;
        Part callbackArgPart = null;
        String regionName = null;
        Object callbackArg = null;
        Part eventPart = null;
        StringBuilder errMessage = new StringBuilder();
        CacheServerStats stats = serverConnection.getCacheServerStats();
        serverConnection.setAsTrue(2);
        long oldStart = start;
        start = DistributionStats.getStatTime();
        stats.incReadDestroyRegionRequestTime(start - oldStart);
        regionNamePart = clientMessage.getPart(0);
        eventPart = clientMessage.getPart(1);
        if (clientMessage.getNumberOfParts() > 2) {
            callbackArgPart = clientMessage.getPart(2);
            try {
                callbackArg = callbackArgPart.getObject();
            }
            catch (DistributedSystemDisconnectedException se) {
                if (logger.isDebugEnabled()) {
                    logger.debug("{} ignoring message of type {} from client {} because shutdown occurred during message processing.", (Object)serverConnection.getName(), (Object)MessageType.getString(clientMessage.getMessageType()), (Object)serverConnection.getProxyID());
                }
                serverConnection.setFlagProcessMessagesAsFalse();
                serverConnection.setClientDisconnectedException(se);
                return;
            }
            catch (Exception e) {
                DestroyRegion.writeException(clientMessage, e, false, serverConnection);
                serverConnection.setAsTrue(1);
                return;
            }
        }
        regionName = regionNamePart.getCachedString();
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Received destroy region request ({} bytes) from {} for region {}", (Object)serverConnection.getName(), (Object)clientMessage.getPayloadLength(), (Object)serverConnection.getSocketString(), (Object)regionName);
        }
        if (regionName == null) {
            logger.warn("{}: The input region name for the destroy region request is null", (Object)serverConnection.getName());
            errMessage.append("The input region name for the destroy region request is null.");
            DestroyRegion.writeErrorResponse(clientMessage, 12, errMessage.toString(), serverConnection);
            serverConnection.setAsTrue(1);
            return;
        }
        LocalRegion region = (LocalRegion)serverConnection.getCache().getRegion(regionName);
        if (region == null) {
            String reason = "Region was not found during destroy region request";
            DestroyRegion.writeRegionDestroyedEx(clientMessage, regionName, reason, serverConnection);
            serverConnection.setAsTrue(1);
            return;
        }
        ByteBuffer eventIdPartsBuffer = ByteBuffer.wrap(eventPart.getSerializedForm());
        long threadId = EventID.readEventIdPartsFromOptmizedByteArray(eventIdPartsBuffer);
        long sequenceId = EventID.readEventIdPartsFromOptmizedByteArray(eventIdPartsBuffer);
        EventID eventId = new EventID(serverConnection.getEventMemberIDByteArray(), threadId, sequenceId);
        try {
            securityService.authorize(ResourcePermission.Resource.DATA, ResourcePermission.Operation.MANAGE);
            AuthorizeRequest authzRequest = serverConnection.getAuthzRequest();
            if (authzRequest != null) {
                RegionDestroyOperationContext destroyContext = authzRequest.destroyRegionAuthorize(regionName, callbackArg);
                callbackArg = destroyContext.getCallbackArg();
            }
            region.basicBridgeDestroyRegion(callbackArg, serverConnection.getProxyID(), true, eventId);
        }
        catch (DistributedSystemDisconnectedException e) {
            if (serverConnection.getCachedRegionHelper().getCache().getCancelCriterion().cancelInProgress() != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("{} ignoring message of type {} from client {} because shutdown occurred during message processing.", (Object)serverConnection.getName(), (Object)MessageType.getString(clientMessage.getMessageType()), (Object)serverConnection.getProxyID());
                }
                serverConnection.setFlagProcessMessagesAsFalse();
                serverConnection.setClientDisconnectedException(e);
            } else {
                DestroyRegion.writeException(clientMessage, e, false, serverConnection);
                serverConnection.setAsTrue(1);
            }
            return;
        }
        catch (Exception e) {
            DestroyRegion.checkForInterrupt(serverConnection, e);
            DestroyRegion.writeException(clientMessage, e, false, serverConnection);
            serverConnection.setAsTrue(1);
            return;
        }
        long oldStart2 = start;
        start = DistributionStats.getStatTime();
        stats.incProcessDestroyRegionTime(start - oldStart2);
        this.writeReply(clientMessage, serverConnection);
        serverConnection.setAsTrue(1);
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Sent destroy region response for region {}", (Object)serverConnection.getName(), (Object)regionName);
        }
        stats.incWriteDestroyRegionResponseTime(DistributionStats.getStatTime() - start);
    }
}

