/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets.command;

import java.io.IOException;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.distributed.internal.DistributionStats;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.sockets.BaseCommand;
import org.apache.geode.internal.cache.tier.sockets.CacheServerStats;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.Part;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.internal.serialization.Version;

public class CloseConnection
extends BaseCommand {
    @Immutable
    private static final CloseConnection singleton = new CloseConnection();

    public static Command getCommand() {
        return singleton;
    }

    private CloseConnection() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cmdExecute(Message clientMessage, ServerConnection serverConnection, SecurityService securityService, long start) throws IOException {
        CacheServerStats stats = serverConnection.getCacheServerStats();
        long oldStart = start;
        boolean respondToClient = serverConnection.getClientVersion().compareTo(Version.GFE_90) >= 0;
        start = DistributionStats.getStatTime();
        stats.incReadCloseConnectionRequestTime(start - oldStart);
        if (respondToClient) {
            serverConnection.setAsTrue(2);
        }
        try {
            Part keepalivePart;
            byte[] keepaliveByte;
            serverConnection.setClientDisconnectCleanly();
            String clientHost = serverConnection.getSocketHost();
            int clientPort = serverConnection.getSocketPort();
            if (logger.isDebugEnabled()) {
                logger.debug("{}: Received close request ({} bytes) from {}:{}", (Object)serverConnection.getName(), (Object)clientMessage.getPayloadLength(), (Object)clientHost, (Object)clientPort);
            }
            boolean keepalive = (keepaliveByte = (keepalivePart = clientMessage.getPart(0)).getSerializedForm()) != null && keepaliveByte[0] != 0;
            serverConnection.getAcceptor().getCacheClientNotifier().setKeepAlive(serverConnection.getProxyID(), keepalive);
            if (logger.isDebugEnabled()) {
                logger.debug("{}: Processed close request from {}:{}, keepAlive: {}", (Object)serverConnection.getName(), (Object)clientHost, (Object)clientPort, (Object)keepalive);
            }
        }
        finally {
            if (respondToClient) {
                this.writeReply(clientMessage, serverConnection);
            }
            serverConnection.setFlagProcessMessagesAsFalse();
            stats.incProcessCloseConnectionTime(DistributionStats.getStatTime() - start);
        }
    }
}

