/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.apache.geode.SerializationException;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.annotations.internal.MakeNotStatic;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.HeapDataOutputStream;
import org.apache.geode.internal.cache.tier.MessageType;
import org.apache.geode.internal.cache.tier.sockets.CacheServerStats;
import org.apache.geode.internal.cache.tier.sockets.MessageStats;
import org.apache.geode.internal.cache.tier.sockets.MessageTooLargeException;
import org.apache.geode.internal.cache.tier.sockets.Part;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.offheap.StoredObject;
import org.apache.geode.internal.serialization.Version;
import org.apache.geode.internal.util.BlobHelper;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class Message {
    public static final ThreadLocal<Integer> MESSAGE_TYPE = new ThreadLocal();
    public static final String MAX_MESSAGE_SIZE_PROPERTY = "gemfire.client.max-message-size";
    static final int DEFAULT_MAX_MESSAGE_SIZE = 0x40000000;
    private static final Logger logger = LogService.getLogger();
    private static final int PART_HEADER_SIZE = 5;
    private static final int FIXED_LENGTH = 17;
    private static final ThreadLocal<ByteBuffer> tlCommBuffer = new ThreadLocal();
    private static final byte MESSAGE_HAS_SECURE_PART = 2;
    private static final byte MESSAGE_IS_RETRY = 4;
    private static final byte MESSAGE_IS_RETRY_MASK = -5;
    private static final int DEFAULT_CHUNK_SIZE = 1024;
    @Immutable
    private static final byte[] TRUE = Message.defineTrue();
    @Immutable
    private static final byte[] FALSE = Message.defineFalse();
    private static final int maxMessageSize = Integer.getInteger("gemfire.client.max-message-size", 0x40000000);
    protected int messageType;
    private int payloadLength = 0;
    int numberOfParts = 0;
    protected int transactionId = -1;
    int currentPart = 0;
    private Part[] partsList = null;
    private ByteBuffer cachedCommBuffer;
    protected Socket socket = null;
    private SocketChannel socketChannel = null;
    private OutputStream outputStream = null;
    protected InputStream inputStream = null;
    private boolean messageModified = true;
    private boolean isRetry;
    private byte flags = 0;
    MessageStats messageStats = null;
    protected ServerConnection serverConnection = null;
    private int maxIncomingMessageLength = -1;
    private Semaphore dataLimiter = null;
    private Semaphore messageLimiter = null;
    private boolean readHeader = false;
    private int chunkSize = 1024;
    Part securePart = null;
    private boolean isMetaRegion = false;
    private Version version;
    @MakeNotStatic(value="not tied to the cache lifecycle")
    private static final Map<String, byte[]> CACHED_STRINGS = new ConcurrentHashMap<String, byte[]>();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static byte[] defineTrue() {
        try (HeapDataOutputStream hdos = new HeapDataOutputStream(10, null);){
            BlobHelper.serializeTo(Boolean.TRUE, hdos);
            byte[] byArray = hdos.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static byte[] defineFalse() {
        try (HeapDataOutputStream hdos = new HeapDataOutputStream(10, null);){
            BlobHelper.serializeTo(Boolean.FALSE, hdos);
            byte[] byArray = hdos.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public Message(int numberOfParts, Version destVersion) {
        this.version = destVersion;
        Assert.assertTrue(destVersion != null, "Attempt to create an unversioned message");
        this.partsList = new Part[numberOfParts];
        this.numberOfParts = numberOfParts;
        int partsListLength = this.partsList.length;
        for (int i = 0; i < partsListLength; ++i) {
            this.partsList[i] = new Part();
        }
    }

    public boolean isSecureMode() {
        return this.securePart != null;
    }

    public byte[] getSecureBytes() throws IOException, ClassNotFoundException {
        return (byte[])this.securePart.getObject();
    }

    public void setMessageType(int msgType) {
        this.messageModified = true;
        if (!MessageType.validate(msgType)) {
            throw new IllegalArgumentException("Invalid MessageType");
        }
        this.messageType = msgType;
    }

    public void setVersion(Version clientVersion) {
        this.version = clientVersion;
    }

    public void setMessageHasSecurePartFlag() {
        this.flags = (byte)(this.flags | 2);
    }

    public void clearMessageHasSecurePartFlag() {
        this.flags = (byte)(this.flags & 2);
    }

    public void setNumberOfParts(int numberOfParts) {
        this.messageModified = true;
        this.currentPart = 0;
        this.numberOfParts = numberOfParts;
        if (numberOfParts > this.partsList.length) {
            Part[] newPartsList = new Part[numberOfParts];
            for (int i = 0; i < numberOfParts; ++i) {
                newPartsList[i] = i < this.partsList.length ? this.partsList[i] : new Part();
            }
            this.partsList = newPartsList;
        }
    }

    void setParts(Part[] parts) {
        this.partsList = parts;
    }

    public void setTransactionId(int transactionId) {
        this.messageModified = true;
        this.transactionId = transactionId;
    }

    public void setIsRetry() {
        this.isRetry = true;
    }

    public boolean isRetry() {
        return this.isRetry;
    }

    public void setChunkSize(int chunkSize) {
        this.chunkSize = chunkSize;
    }

    int getNextPartNumber() {
        return this.currentPart;
    }

    public void addStringPart(String str) {
        this.addStringPart(str, false);
    }

    public void addStringPart(String str, boolean enableCaching) {
        if (str == null) {
            this.addRawPart(null, false);
            return;
        }
        Part part = this.partsList[this.currentPart];
        if (enableCaching) {
            byte[] bytes = CACHED_STRINGS.get(str);
            if (bytes == null) {
                try (HeapDataOutputStream hdos = new HeapDataOutputStream(str);){
                    bytes = hdos.toByteArray();
                    CACHED_STRINGS.put(str, bytes);
                }
            }
            part.setPartState(bytes, false);
        } else {
            this.messageModified = true;
            part.setPartState(new HeapDataOutputStream(str), false);
        }
        ++this.currentPart;
    }

    public void addBytesPart(byte[] newPart) {
        this.addRawPart(newPart, false);
    }

    public void addStringOrObjPart(Object o) {
        if (o instanceof String || o == null) {
            this.addStringPart((String)o);
        } else {
            this.serializeAndAddPart(o, false);
        }
    }

    public void addObjPart(Object o) {
        this.addObjPart(o, false);
    }

    public void addObjPartNoCopying(Object o) {
        if (o == null || o instanceof byte[]) {
            this.addRawPart((byte[])o, false);
        } else {
            this.serializeAndAddPartNoCopying(o);
        }
    }

    public void addObjPart(Object o, boolean zipValues) {
        if (o == null || o instanceof byte[]) {
            this.addRawPart((byte[])o, false);
        } else if (o instanceof Boolean) {
            this.addRawPart((Boolean)o != false ? TRUE : FALSE, true);
        } else {
            this.serializeAndAddPart(o, zipValues);
        }
    }

    public void addPartInAnyForm(Object o, boolean isObject) {
        if (o == null) {
            this.addRawPart((byte[])o, false);
        } else if (o instanceof byte[]) {
            this.addRawPart((byte[])o, isObject);
        } else if (o instanceof StoredObject) {
            this.messageModified = true;
            Part part = this.partsList[this.currentPart];
            part.setPartState((StoredObject)o, isObject);
            ++this.currentPart;
        } else {
            this.serializeAndAddPart(o, false);
        }
    }

    private void serializeAndAddPartNoCopying(Object o) {
        Version v = this.version;
        if (this.version.equals(Version.CURRENT)) {
            v = null;
        }
        HeapDataOutputStream hdos = new HeapDataOutputStream(this.chunkSize, v, true);
        try {
            BlobHelper.serializeTo(o, hdos);
        }
        catch (IOException ex) {
            throw new SerializationException("failed serializing object", ex);
        }
        this.messageModified = true;
        Part part = this.partsList[this.currentPart];
        part.setPartState(hdos, true);
        ++this.currentPart;
    }

    private void serializeAndAddPart(Object o, boolean zipValues) {
        if (zipValues) {
            throw new UnsupportedOperationException("zipValues no longer supported");
        }
        Version v = this.version;
        if (this.version.equals(Version.CURRENT)) {
            v = null;
        }
        HeapDataOutputStream hdos = new HeapDataOutputStream(this.chunkSize, v);
        try {
            BlobHelper.serializeTo(o, hdos);
        }
        catch (IOException ex) {
            throw new SerializationException("failed serializing object", ex);
        }
        this.messageModified = true;
        Part part = this.partsList[this.currentPart];
        part.setPartState(hdos, true);
        ++this.currentPart;
    }

    public void addIntPart(int v) {
        this.messageModified = true;
        Part part = this.partsList[this.currentPart];
        part.setInt(v);
        ++this.currentPart;
    }

    public void addLongPart(long v) {
        this.messageModified = true;
        Part part = this.partsList[this.currentPart];
        part.setLong(v);
        ++this.currentPart;
    }

    public void addBytePart(byte v) {
        this.messageModified = true;
        Part part = this.partsList[this.currentPart];
        part.setByte(v);
        ++this.currentPart;
    }

    public void addRawPart(byte[] newPart, boolean isObject) {
        this.messageModified = true;
        Part part = this.partsList[this.currentPart];
        part.setPartState(newPart, isObject);
        ++this.currentPart;
    }

    public int getMessageType() {
        return this.messageType;
    }

    public int getPayloadLength() {
        return this.payloadLength;
    }

    public int getHeaderLength() {
        return 17;
    }

    public int getNumberOfParts() {
        return this.numberOfParts;
    }

    public int getTransactionId() {
        return this.transactionId;
    }

    public Part getPart(int index) {
        if (index < this.numberOfParts) {
            Part p = this.partsList[index];
            if (this.version != null) {
                p.setVersion(this.version);
            }
            return p;
        }
        return null;
    }

    public static ByteBuffer setTLCommBuffer(ByteBuffer bb) {
        ByteBuffer result = tlCommBuffer.get();
        tlCommBuffer.set(bb);
        return result;
    }

    public ByteBuffer getCommBuffer() {
        if (this.cachedCommBuffer != null) {
            return this.cachedCommBuffer;
        }
        return tlCommBuffer.get();
    }

    public void clear() {
        ByteBuffer buffer;
        this.isRetry = false;
        int len = this.payloadLength;
        if (len != 0) {
            this.payloadLength = 0;
        }
        if (this.readHeader && this.messageStats != null) {
            this.messageStats.decMessagesBeingReceived(len);
        }
        if ((buffer = this.getCommBuffer()) != null) {
            buffer.clear();
        }
        this.clearParts();
        if (len != 0 && this.dataLimiter != null) {
            this.dataLimiter.release(len);
            this.dataLimiter = null;
            this.maxIncomingMessageLength = 0;
        }
        if (this.readHeader) {
            if (this.messageLimiter != null) {
                this.messageLimiter.release(1);
                this.messageLimiter = null;
            }
            this.readHeader = false;
        }
        this.flags = 0;
    }

    protected void packHeaderInfoForSending(int msgLen, boolean isSecurityHeader) {
        byte flagsByte = this.flags;
        if (isSecurityHeader) {
            flagsByte = (byte)(flagsByte | 2);
        }
        if (this.isRetry) {
            flagsByte = (byte)(flagsByte | 4);
        }
        this.getCommBuffer().putInt(this.messageType).putInt(msgLen).putInt(this.numberOfParts).putInt(this.transactionId).put(flagsByte);
    }

    protected Part getSecurityPart() {
        if (this.serverConnection != null) {
            return this.serverConnection.updateAndGetSecurityPart();
        }
        return null;
    }

    public void setSecurePart(byte[] bytes) {
        this.securePart = new Part();
        this.securePart.setPartState(bytes, false);
    }

    public void setMetaRegion(boolean isMetaRegion) {
        this.isMetaRegion = isMetaRegion;
    }

    boolean getAndResetIsMetaRegion() {
        boolean isMetaRegion = this.isMetaRegion;
        this.isMetaRegion = false;
        return isMetaRegion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendBytes(boolean clearMessage) throws IOException {
        if (this.serverConnection != null) {
            this.serverConnection.updateProcessingMessage();
        }
        if (this.socket == null) {
            throw new IOException("Dead Connection");
        }
        try {
            ByteBuffer commBuffer = this.getCommBuffer();
            if (commBuffer == null) {
                throw new IOException("No buffer");
            }
            ByteBuffer byteBuffer = commBuffer;
            synchronized (byteBuffer) {
                long totalPartLen = 0L;
                long headerLen = 0L;
                int partsToTransmit = this.numberOfParts;
                for (int i = 0; i < this.numberOfParts; ++i) {
                    Part part = this.partsList[i];
                    headerLen += 5L;
                    totalPartLen += (long)part.getLength();
                }
                Part securityPart = this.getSecurityPart();
                if (securityPart == null) {
                    securityPart = this.securePart;
                }
                if (securityPart != null) {
                    headerLen += 5L;
                    totalPartLen += (long)securityPart.getLength();
                    ++partsToTransmit;
                }
                if (headerLen + totalPartLen > Integer.MAX_VALUE) {
                    throw new MessageTooLargeException("Message size (" + (headerLen + totalPartLen) + ") exceeds maximum integer value");
                }
                int msgLen = (int)(headerLen + totalPartLen);
                if (msgLen > maxMessageSize) {
                    throw new MessageTooLargeException("Message size (" + msgLen + ") exceeds gemfire.client.max-message-size setting (" + maxMessageSize + ")");
                }
                commBuffer.clear();
                this.packHeaderInfoForSending(msgLen, securityPart != null);
                for (int i = 0; i < partsToTransmit; ++i) {
                    Part part;
                    Part part2 = part = i == this.numberOfParts ? securityPart : this.partsList[i];
                    if (commBuffer.remaining() < 5) {
                        this.flushBuffer();
                    }
                    int partLen = part.getLength();
                    commBuffer.putInt(partLen);
                    commBuffer.put(part.getTypeCode());
                    if (partLen <= commBuffer.remaining()) {
                        part.writeTo(commBuffer);
                        continue;
                    }
                    this.flushBuffer();
                    if (this.socketChannel != null) {
                        part.writeTo(this.socketChannel, commBuffer);
                    } else {
                        part.writeTo(this.outputStream, commBuffer);
                    }
                    if (this.messageStats == null) continue;
                    this.messageStats.incSentBytes(partLen);
                }
                if (commBuffer.position() != 0) {
                    this.flushBuffer();
                }
                this.messageModified = false;
                if (this.socketChannel == null) {
                    this.outputStream.flush();
                }
            }
        }
        finally {
            if (clearMessage) {
                this.clearParts();
            }
        }
    }

    void flushBuffer() throws IOException {
        ByteBuffer cb = this.getCommBuffer();
        if (this.socketChannel != null) {
            cb.flip();
            do {
                this.socketChannel.write(cb);
            } while (cb.remaining() > 0);
        } else {
            this.outputStream.write(cb.array(), 0, cb.position());
        }
        if (this.messageStats != null) {
            this.messageStats.incSentBytes(cb.position());
        }
        cb.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readHeaderAndBody(boolean setHeaderReadTimeout, int headerReadTimeoutMillis) throws IOException {
        boolean interrupted;
        this.clearParts();
        int oldTimeout = -1;
        if (setHeaderReadTimeout) {
            oldTimeout = this.socket.getSoTimeout();
            this.socket.setSoTimeout(headerReadTimeoutMillis);
        }
        try {
            this.fetchHeader();
        }
        finally {
            if (setHeaderReadTimeout) {
                this.socket.setSoTimeout(oldTimeout);
            }
        }
        ByteBuffer cb = this.getCommBuffer();
        int type = cb.getInt();
        int len = cb.getInt();
        int numParts = cb.getInt();
        int txid = cb.getInt();
        byte bits = cb.get();
        cb.clear();
        if (!MessageType.validate(type)) {
            throw new IOException(String.format("Invalid message type %s while reading header", type));
        }
        int timeToWait = 0;
        if (this.serverConnection != null) {
            this.serverConnection.setProcessingMessage();
            timeToWait = this.serverConnection.getClientReadTimeout();
        }
        this.readHeader = true;
        if (this.messageLimiter != null) {
            while (true) {
                this.serverConnection.getCachedRegionHelper().checkCancelInProgress(null);
                interrupted = Thread.interrupted();
                try {
                    if (timeToWait == 0) {
                        this.messageLimiter.acquire(1);
                    } else if (!this.messageLimiter.tryAcquire(1, timeToWait, TimeUnit.MILLISECONDS)) {
                        if (this.messageStats instanceof CacheServerStats) {
                            ((CacheServerStats)this.messageStats).incConnectionsTimedOut();
                        }
                        throw new IOException(String.format("Operation timed out on server waiting on concurrent message limiter after waiting %s milliseconds", timeToWait));
                    }
                }
                catch (InterruptedException ignore) {
                    interrupted = true;
                    continue;
                }
                finally {
                    if (!interrupted) continue;
                    Thread.currentThread().interrupt();
                    continue;
                }
                break;
            }
        }
        if (len > 0) {
            if (this.maxIncomingMessageLength > 0 && len > this.maxIncomingMessageLength) {
                throw new IOException(String.format("Message size %s exceeded max limit of %s", len, this.maxIncomingMessageLength));
            }
            if (this.dataLimiter != null) {
                while (true) {
                    if (this.serverConnection != null) {
                        this.serverConnection.getCachedRegionHelper().checkCancelInProgress(null);
                    }
                    interrupted = Thread.interrupted();
                    try {
                        if (timeToWait == 0) {
                            this.dataLimiter.acquire(len);
                        } else {
                            int newTimeToWait = timeToWait;
                            if (this.messageLimiter != null) {
                                newTimeToWait -= (int)this.serverConnection.getCurrentMessageProcessingTime();
                            }
                            if (newTimeToWait <= 0 || !this.messageLimiter.tryAcquire(1, newTimeToWait, TimeUnit.MILLISECONDS)) {
                                throw new IOException(String.format("Operation timed out on server waiting on concurrent data limiter after waiting %s milliseconds", timeToWait));
                            }
                        }
                        this.payloadLength = len;
                    }
                    catch (InterruptedException ignore) {
                        interrupted = true;
                        continue;
                    }
                    finally {
                        if (!interrupted) continue;
                        Thread.currentThread().interrupt();
                        continue;
                    }
                    break;
                }
            }
        }
        if (this.messageStats != null) {
            this.messageStats.incMessagesBeingReceived(len);
            this.payloadLength = len;
        }
        this.isRetry = (bits & 4) != 0;
        this.flags = bits = (byte)(bits & 0xFFFFFFFB);
        this.messageType = type;
        this.readPayloadFields(numParts, len);
        this.payloadLength = len;
        this.transactionId = txid;
        this.flags = bits;
        if (this.serverConnection != null) {
            this.serverConnection.updateProcessingMessage();
        }
    }

    void fetchHeader() throws IOException {
        ByteBuffer cb = this.getCommBuffer();
        cb.clear();
        this.messageType = -1;
        int headerLength = this.getHeaderLength();
        if (this.socketChannel != null) {
            cb.limit(headerLength);
            do {
                int bytesRead;
                if ((bytesRead = this.socketChannel.read(cb)) == -1) {
                    throw new EOFException("The connection has been reset while reading the header");
                }
                if (this.messageStats == null) continue;
                this.messageStats.incReceivedBytes(bytesRead);
            } while (cb.remaining() > 0);
            cb.flip();
        } else {
            int hdr = 0;
            do {
                int bytesRead;
                if ((bytesRead = this.inputStream.read(cb.array(), hdr, headerLength - hdr)) == -1) {
                    throw new EOFException("The connection has been reset while reading the header");
                }
                hdr += bytesRead;
                if (this.messageStats == null) continue;
                this.messageStats.incReceivedBytes(bytesRead);
            } while (hdr < headerLength);
            cb.rewind();
        }
    }

    void readPayloadFields(int numParts, int len) throws IOException {
        if (len > 0 && numParts <= 0 || len <= 0 && numParts > 0) {
            throw new IOException(String.format("Part length ( %s ) and number of parts ( %s ) inconsistent", len, numParts));
        }
        Integer msgType = MESSAGE_TYPE.get();
        if (msgType != null && msgType == 5) {
            MESSAGE_TYPE.set(null);
            int pingParts = 10;
            if (numParts > pingParts) {
                throw new IOException("Part length ( " + numParts + " ) is  inconsistent for " + MessageType.getString(msgType) + " operation.");
            }
        }
        this.setNumberOfParts(numParts);
        if (numParts <= 0) {
            return;
        }
        if (len < 0) {
            logger.info("rpl: neg len: {}", (Object)len);
            throw new IOException("Dead Connection");
        }
        ByteBuffer cb = this.getCommBuffer();
        cb.clear();
        cb.flip();
        int readSecurePart = this.checkAndSetSecurityPart();
        int bytesRemaining = len;
        for (int i = 0; i < numParts + readSecurePart || readSecurePart == 1 && cb.remaining() > 0; ++i) {
            int bytesReadThisTime = this.readPartChunk(bytesRemaining);
            bytesRemaining -= bytesReadThisTime;
            Part part = i < numParts ? this.partsList[i] : this.securePart;
            int partLen = cb.getInt();
            byte partType = cb.get();
            byte[] partBytes = null;
            if (partLen > 0) {
                partBytes = new byte[partLen];
                int alreadyReadBytes = cb.remaining();
                if (alreadyReadBytes > 0) {
                    if (partLen < alreadyReadBytes) {
                        alreadyReadBytes = partLen;
                    }
                    cb.get(partBytes, 0, alreadyReadBytes);
                }
                int off = alreadyReadBytes;
                int remaining = partLen - off;
                while (remaining > 0) {
                    if (this.socketChannel != null) {
                        int bytesThisTime = remaining;
                        cb.clear();
                        if (bytesThisTime > cb.capacity()) {
                            bytesThisTime = cb.capacity();
                        }
                        cb.limit(bytesThisTime);
                        int res = this.socketChannel.read(cb);
                        if (res != -1) {
                            cb.flip();
                            bytesRemaining -= res;
                            remaining -= res;
                            cb.get(partBytes, off, res);
                            off += res;
                            if (this.messageStats == null) continue;
                            this.messageStats.incReceivedBytes(res);
                            continue;
                        }
                        throw new EOFException("The connection has been reset while reading a part");
                    }
                    int res = this.inputStream.read(partBytes, off, remaining);
                    if (res != -1) {
                        bytesRemaining -= res;
                        remaining -= res;
                        off += res;
                        if (this.messageStats == null) continue;
                        this.messageStats.incReceivedBytes(res);
                        continue;
                    }
                    throw new EOFException("The connection has been reset while reading a part");
                }
            }
            part.init(partBytes, partType);
        }
    }

    protected int checkAndSetSecurityPart() {
        if ((this.flags | 2) == this.flags) {
            this.securePart = new Part();
            return 1;
        }
        this.securePart = null;
        return 0;
    }

    private int readPartChunk(int bytesRemaining) throws IOException {
        ByteBuffer commBuffer = this.getCommBuffer();
        if (commBuffer.remaining() >= 5) {
            return 0;
        }
        if (commBuffer.position() != 0) {
            commBuffer.compact();
        } else {
            commBuffer.position(commBuffer.limit());
            commBuffer.limit(commBuffer.capacity());
        }
        if (this.serverConnection != null) {
            this.serverConnection.updateProcessingMessage();
        }
        int bytesRead = 0;
        if (this.socketChannel != null) {
            int remaining = commBuffer.remaining();
            if (remaining > bytesRemaining) {
                remaining = bytesRemaining;
                commBuffer.limit(commBuffer.position() + bytesRemaining);
            }
            while (remaining > 0) {
                int res = this.socketChannel.read(commBuffer);
                if (res != -1) {
                    remaining -= res;
                    bytesRead += res;
                    if (this.messageStats == null) continue;
                    this.messageStats.incReceivedBytes(res);
                    continue;
                }
                throw new EOFException("The connection has been reset while reading the payload");
            }
        } else {
            int bytesToRead = commBuffer.capacity() - commBuffer.position();
            if (bytesRemaining < bytesToRead) {
                bytesToRead = bytesRemaining;
            }
            int pos = commBuffer.position();
            while (bytesToRead > 0) {
                int res = this.inputStream.read(commBuffer.array(), pos, bytesToRead);
                if (res != -1) {
                    bytesToRead -= res;
                    pos += res;
                    bytesRead += res;
                    if (this.messageStats == null) continue;
                    this.messageStats.incReceivedBytes(res);
                    continue;
                }
                throw new EOFException("The connection has been reset while reading the payload");
            }
            commBuffer.position(pos);
        }
        commBuffer.flip();
        return bytesRead;
    }

    public void clearParts() {
        for (Part part : this.partsList) {
            part.clear();
        }
        this.currentPart = 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("type=").append(MessageType.getString(this.messageType));
        sb.append("; payloadLength=").append(this.payloadLength);
        sb.append("; numberOfParts=").append(this.numberOfParts);
        sb.append("; hasSecurePart=").append(this.isSecureMode());
        sb.append("; transactionId=").append(this.transactionId);
        sb.append("; currentPart=").append(this.currentPart);
        sb.append("; messageModified=").append(this.messageModified);
        sb.append("; flags=").append(Integer.toHexString(this.flags));
        for (int i = 0; i < this.numberOfParts; ++i) {
            sb.append("; part[").append(i).append("]={");
            sb.append(this.partsList[i]);
            sb.append("}");
        }
        return sb.toString();
    }

    void setComms(ServerConnection sc, Socket socket, ByteBuffer bb, MessageStats msgStats) throws IOException {
        this.serverConnection = sc;
        this.setComms(socket, bb, msgStats);
    }

    void setComms(Socket socket, ByteBuffer bb, MessageStats msgStats) throws IOException {
        this.socketChannel = socket.getChannel();
        if (this.socketChannel == null) {
            this.setComms(socket, socket.getInputStream(), socket.getOutputStream(), bb, msgStats);
        } else {
            this.setComms(socket, null, null, bb, msgStats);
        }
    }

    public void setComms(Socket socket, InputStream is, OutputStream os, ByteBuffer bb, MessageStats msgStats) {
        Assert.assertTrue(socket != null);
        this.socket = socket;
        this.socketChannel = socket.getChannel();
        this.inputStream = is;
        this.outputStream = os;
        this.cachedCommBuffer = bb;
        this.messageStats = msgStats;
    }

    public void unsetComms() {
        this.socket = null;
        this.socketChannel = null;
        this.inputStream = null;
        this.outputStream = null;
        this.cachedCommBuffer = null;
        this.messageStats = null;
    }

    public void send() throws IOException {
        this.send(true);
    }

    public void send(ServerConnection servConn) throws IOException {
        if (this.serverConnection != servConn) {
            throw new IllegalStateException("this.sc was not correctly set");
        }
        this.send(true);
    }

    public void send(boolean clearMessage) throws IOException {
        this.sendBytes(clearMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveWithHeaderReadTimeout(int timeoutMillis) throws IOException {
        if (this.socket != null) {
            ByteBuffer byteBuffer = this.getCommBuffer();
            synchronized (byteBuffer) {
                this.readHeaderAndBody(true, timeoutMillis);
            }
        } else {
            throw new IOException("Dead Connection");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receive() throws IOException {
        if (this.socket != null) {
            ByteBuffer byteBuffer = this.getCommBuffer();
            synchronized (byteBuffer) {
                this.readHeaderAndBody(false, -1);
            }
        } else {
            throw new IOException("Dead Connection");
        }
    }

    public void receive(ServerConnection sc, int maxMessageLength, Semaphore dataLimiter, Semaphore msgLimiter) throws IOException {
        this.serverConnection = sc;
        this.maxIncomingMessageLength = maxMessageLength;
        this.dataLimiter = dataLimiter;
        this.messageLimiter = msgLimiter;
        this.receive();
    }
}

