/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.Socket;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import org.apache.geode.CancelException;
import org.apache.geode.InternalGemFireError;
import org.apache.geode.StatisticsFactory;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.annotations.internal.MakeNotStatic;
import org.apache.geode.cache.CacheEvent;
import org.apache.geode.cache.CacheException;
import org.apache.geode.cache.EntryEvent;
import org.apache.geode.cache.InterestRegistrationEvent;
import org.apache.geode.cache.InterestRegistrationListener;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.cache.RegionExistsException;
import org.apache.geode.cache.client.internal.PoolImpl;
import org.apache.geode.cache.query.CqException;
import org.apache.geode.cache.query.Query;
import org.apache.geode.cache.query.internal.DefaultQuery;
import org.apache.geode.cache.query.internal.cq.CqService;
import org.apache.geode.cache.query.internal.cq.ServerCQ;
import org.apache.geode.cache.server.CacheServer;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.DistributedSystem;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.ClassLoadUtil;
import org.apache.geode.internal.SystemTimer;
import org.apache.geode.internal.cache.CacheClientStatus;
import org.apache.geode.internal.cache.CacheDistributionAdvisor;
import org.apache.geode.internal.cache.CacheServerImpl;
import org.apache.geode.internal.cache.ClientRegionEventImpl;
import org.apache.geode.internal.cache.ClientServerObserver;
import org.apache.geode.internal.cache.ClientServerObserverHolder;
import org.apache.geode.internal.cache.Conflatable;
import org.apache.geode.internal.cache.EntryEventImpl;
import org.apache.geode.internal.cache.EnumListenerEvent;
import org.apache.geode.internal.cache.EventID;
import org.apache.geode.internal.cache.FilterProfile;
import org.apache.geode.internal.cache.FilterRoutingInfo;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.InternalCacheEvent;
import org.apache.geode.internal.cache.InternalRegion;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.RegionEventImpl;
import org.apache.geode.internal.cache.ha.HAContainerMap;
import org.apache.geode.internal.cache.ha.HAContainerRegion;
import org.apache.geode.internal.cache.ha.HAContainerWrapper;
import org.apache.geode.internal.cache.ha.HARegionQueue;
import org.apache.geode.internal.cache.ha.ThreadIdentifier;
import org.apache.geode.internal.cache.tier.CommunicationMode;
import org.apache.geode.internal.cache.tier.OverflowAttributes;
import org.apache.geode.internal.cache.tier.sockets.CacheClientNotifierStats;
import org.apache.geode.internal.cache.tier.sockets.CacheClientProxy;
import org.apache.geode.internal.cache.tier.sockets.CacheServerStats;
import org.apache.geode.internal.cache.tier.sockets.ClientDenylistProcessor;
import org.apache.geode.internal.cache.tier.sockets.ClientHealthMonitor;
import org.apache.geode.internal.cache.tier.sockets.ClientInterestMessageImpl;
import org.apache.geode.internal.cache.tier.sockets.ClientPingMessageImpl;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.internal.cache.tier.sockets.ClientRegistrationEventQueueManager;
import org.apache.geode.internal.cache.tier.sockets.ClientRegistrationMetadata;
import org.apache.geode.internal.cache.tier.sockets.ClientTombstoneMessage;
import org.apache.geode.internal.cache.tier.sockets.ClientUpdateMessage;
import org.apache.geode.internal.cache.tier.sockets.ClientUpdateMessageImpl;
import org.apache.geode.internal.cache.tier.sockets.ConnectionListener;
import org.apache.geode.internal.cache.tier.sockets.HAEventWrapper;
import org.apache.geode.internal.cache.tier.sockets.Handshake;
import org.apache.geode.internal.cache.tier.sockets.RemoveClientFromDenylistMessage;
import org.apache.geode.internal.cache.tier.sockets.ServerInterestRegistrationMessage;
import org.apache.geode.internal.cache.tier.sockets.SocketMessageWriter;
import org.apache.geode.internal.cache.versions.VersionTag;
import org.apache.geode.internal.logging.InternalLogWriter;
import org.apache.geode.internal.net.SocketCloser;
import org.apache.geode.internal.serialization.DataSerializableFixedID;
import org.apache.geode.internal.serialization.Version;
import org.apache.geode.internal.statistics.DummyStatisticsFactory;
import org.apache.geode.internal.statistics.StatisticsClock;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.security.AccessControl;
import org.apache.geode.security.AuthenticationFailedException;
import org.apache.geode.security.AuthenticationRequiredException;
import org.apache.geode.security.GemFireSecurityException;
import org.apache.logging.log4j.Logger;
import org.apache.shiro.subject.Subject;

public class CacheClientNotifier {
    private static final Logger logger = LogService.getLogger();
    @MakeNotStatic
    private static volatile CacheClientNotifier ccnSingleton;
    private final SocketMessageWriter socketMessageWriter = new SocketMessageWriter();
    private final ClientRegistrationEventQueueManager clientRegistrationEventQueueManager;
    private final ConcurrentMap _clientProxies = new ConcurrentHashMap();
    private final ConcurrentMap _initClientProxies = new ConcurrentHashMap();
    private final Set<ClientProxyMembershipID> timedOutDurableClientProxies = new HashSet<ClientProxyMembershipID>();
    private InternalCache cache;
    private InternalLogWriter logWriter;
    private InternalLogWriter securityLogWriter;
    private final int maximumMessageCount;
    private final int messageTimeToLive;
    private final ConnectionListener _connectionListener;
    private final StatisticsClock statisticsClock;
    private final CacheServerStats acceptorStats;
    private volatile HAContainerWrapper haContainer;
    private static final int socketBufferSize;
    protected final CacheClientNotifierStats statistics;
    private final Set writableInterestRegistrationListeners = new CopyOnWriteArraySet();
    private final Set readableInterestRegistrationListeners = Collections.unmodifiableSet(this.writableInterestRegistrationListeners);
    private static final String MAX_QUEUE_LOG_FREQUENCY = "gemfire.logFrequency.clientQueueReachedMaxLimit";
    public static final long DEFAULT_LOG_FREQUENCY = 1000L;
    private static final String EVENT_ENQUEUE_WAIT_TIME_NAME = "gemfire.subscription.EVENT_ENQUEUE_WAIT_TIME";
    private static final int DEFAULT_EVENT_ENQUEUE_WAIT_TIME = 100;
    @MakeNotStatic
    public static int eventEnqueueWaitTime;
    private long logFrequency;
    private final ConcurrentHashMap<String, DefaultQuery> compiledQueries = new ConcurrentHashMap();
    private volatile boolean isCompiledQueryCleanupThreadStarted = false;
    private final Object lockIsCompiledQueryCleanupThreadStarted = new Object();
    private SystemTimer.SystemTimerTask clientPingTask;
    private final SocketCloser socketCloser;
    private static final int CLIENT_PING_TASK_PERIOD;
    private static final long CLIENT_PING_TASK_COUNTER;
    private final Set denyListedClients = new CopyOnWriteArraySet();

    public static synchronized CacheClientNotifier getInstance(InternalCache cache, ClientRegistrationEventQueueManager clientRegistrationEventQueueManager, StatisticsClock statisticsClock, CacheServerStats acceptorStats, int maximumMessageCount, int messageTimeToLive, ConnectionListener listener, OverflowAttributes overflowAttributes, boolean isGatewayReceiver) {
        if (ccnSingleton == null) {
            ccnSingleton = new CacheClientNotifier(cache, clientRegistrationEventQueueManager, statisticsClock, acceptorStats, maximumMessageCount, messageTimeToLive, listener, isGatewayReceiver);
        }
        if (!isGatewayReceiver && ccnSingleton.getHaContainer() == null) {
            ccnSingleton.initHaContainer(overflowAttributes);
        }
        return ccnSingleton;
    }

    public static CacheClientNotifier getInstance() {
        return ccnSingleton;
    }

    @VisibleForTesting
    public static void resetInstance() {
        ccnSingleton = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerClient(ClientRegistrationMetadata clientRegistrationMetadata, Socket socket, boolean isPrimary, long acceptorId, boolean notifyBySubscription) throws IOException {
        long startTime;
        block8: {
            startTime = this.statistics.startTime();
            ClientProxyMembershipID clientProxyMembershipID = clientRegistrationMetadata.getClientProxyMembershipID();
            DataOutputStream dataOutputStream = clientRegistrationMetadata.getDataOutputStream();
            Version clientVersion = clientRegistrationMetadata.getClientVersion();
            try {
                if (!this.isClientPermitted(clientRegistrationMetadata, clientProxyMembershipID)) break block8;
                ClientRegistrationEventQueueManager.ClientRegistrationEventQueue clientRegistrationEventQueue = this.clientRegistrationEventQueueManager.create(clientProxyMembershipID, new ConcurrentLinkedQueue<ClientRegistrationEventQueueManager.ClientRegistrationEvent>(), new ReentrantReadWriteLock());
                try {
                    this.registerClientInternal(clientRegistrationMetadata, socket, isPrimary, acceptorId, notifyBySubscription);
                }
                finally {
                    this.clientRegistrationEventQueueManager.drain(clientRegistrationEventQueue, this);
                }
            }
            catch (AuthenticationRequiredException ex) {
                this.handleAuthenticationException(clientProxyMembershipID, dataOutputStream, clientVersion, ex, (byte)62);
            }
            catch (AuthenticationFailedException ex) {
                this.handleAuthenticationException(clientProxyMembershipID, dataOutputStream, clientVersion, ex, (byte)63);
            }
            catch (CacheException e) {
                logger.warn(String.format("%s :registerClient: Exception encountered in registration %s", this, e), (Throwable)e);
                throw new IOException(String.format("Exception occurred while trying to register interest due to : %s", e.getMessage()), e);
            }
            catch (Exception ex) {
                logger.warn(String.format("An exception was thrown for client [%s].", clientProxyMembershipID != null ? clientProxyMembershipID : "unknown"), (Throwable)ex);
                this.socketMessageWriter.writeException(dataOutputStream, CommunicationMode.UnsuccessfulServerToClient.getModeNumber(), ex, clientVersion);
            }
        }
        this.statistics.endClientRegistration(startTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    void registerClientInternal(ClientRegistrationMetadata clientRegistrationMetadata, Socket socket, boolean isPrimary, long acceptorId, boolean notifyBySubscription) throws IOException, CacheException, ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        clientProxyMembershipID = clientRegistrationMetadata.getClientProxyMembershipID();
        clientConflation = clientRegistrationMetadata.getClientConflation();
        clientVersion = clientRegistrationMetadata.getClientVersion();
        cacheClientProxy = this.getClientProxy(clientProxyMembershipID);
        member = clientProxyMembershipID.getDistributedMember();
        subjectOrPrincipal = this.getSubjectOrPrincipal(clientRegistrationMetadata, member, system = this.getCache().getDistributedSystem(), authenticator = (sysProps = system.getProperties()).getProperty("security-client-authenticator"));
        subject = subjectOrPrincipal instanceof Subject != false ? (Subject)subjectOrPrincipal : null;
        socket.setTcpNoDelay(true);
        socket.setSendBufferSize(CacheClientNotifier.socketBufferSize);
        socket.setReceiveBufferSize(CacheClientNotifier.socketBufferSize);
        if (CacheClientNotifier.logger.isDebugEnabled()) {
            CacheClientNotifier.logger.debug("CacheClientNotifier: Initialized server-to-client socket with send buffer size: {} bytes and receive buffer size: {} bytes", (Object)socket.getSendBufferSize(), (Object)socket.getReceiveBufferSize());
        }
        responseByte = CommunicationMode.SuccessfulServerToClient.getModeNumber();
        successful = true;
        clientIsDurable = clientProxyMembershipID.isDurable();
        if (CacheClientNotifier.logger.isDebugEnabled()) {
            if (clientIsDurable) {
                CacheClientNotifier.logger.debug("CacheClientNotifier: Attempting to register durable client: {}", (Object)clientProxyMembershipID.getDurableId());
            } else {
                CacheClientNotifier.logger.debug("CacheClientNotifier: Attempting to register non-durable client");
            }
        }
        endpointType = 0;
        queueSize = 0;
        unsuccessfulMsg = null;
        if (clientIsDurable) {
            if (cacheClientProxy == null) {
                queueSize = this.isTimedOut(clientProxyMembershipID) != false ? -1 : -2;
                if (CacheClientNotifier.logger.isDebugEnabled()) {
                    CacheClientNotifier.logger.debug("CacheClientNotifier: No proxy exists for durable client with id {}. It must be created.", (Object)clientProxyMembershipID.getDurableId());
                }
                cacheClientProxy = new CacheClientProxy(this, socket, clientProxyMembershipID, isPrimary, clientConflation, clientVersion, acceptorId, notifyBySubscription, this.cache.getSecurityService(), subject, this.statisticsClock);
                successful = this.initializeProxy(cacheClientProxy);
            } else {
                cacheClientProxy.setSubject(subject);
                endpointType = cacheClientProxy.isPrimary() != false ? 2 : 1;
                queueSize = cacheClientProxy.getQueueSize();
                if (cacheClientProxy.isPaused()) {
                    if (CacheClientProxy.testHook != null) {
                        CacheClientProxy.testHook.doTestHook("CLIENT_PRE_RECONNECT");
                    }
                    if (cacheClientProxy.lockDrain()) {
                        try {
                            if (CacheClientNotifier.logger.isDebugEnabled()) {
                                CacheClientNotifier.logger.debug("CacheClientNotifier: A proxy exists for durable client with id {}. This proxy will be reinitialized: {}", (Object)clientProxyMembershipID.getDurableId(), (Object)cacheClientProxy);
                            }
                            this.statistics.incDurableReconnectionCount();
                            cacheClientProxy.getProxyID().updateDurableTimeout(clientProxyMembershipID.getDurableTimeout());
                            cacheClientProxy.reinitialize(socket, clientProxyMembershipID, this.getCache(), isPrimary, clientConflation, clientVersion);
                            cacheClientProxy.setMarkerEnqueued(true);
                            if (CacheClientProxy.testHook == null) ** GOTO lbl75
                            CacheClientProxy.testHook.doTestHook("CLIENT_RECONNECTED");
                        }
                        finally {
                            cacheClientProxy.unlockDrain();
                        }
                    } else {
                        unsuccessfulMsg = "CacheClientNotifier: Connection refused due to cq queue being drained from admin command, please wait...";
                        CacheClientNotifier.logger.warn(unsuccessfulMsg);
                        responseByte = 60;
                        if (CacheClientProxy.testHook != null) {
                            CacheClientProxy.testHook.doTestHook("CLIENT_REJECTED_DUE_TO_CQ_BEING_DRAINED");
                        }
                    }
                } else {
                    unsuccessfulMsg = String.format("The requested durable client has the same identifier ( %s ) as an existing durable client ( %s ). Duplicate durable clients are not allowed.", new Object[]{clientProxyMembershipID.getDurableId(), cacheClientProxy});
                    CacheClientNotifier.logger.warn(unsuccessfulMsg);
                    responseByte = 64;
                }
            }
        } else {
            staleClientProxy = this.getClientProxy(clientProxyMembershipID);
            if (staleClientProxy != null) {
                if (CacheClientNotifier.logger.isDebugEnabled()) {
                    CacheClientNotifier.logger.debug("CacheClientNotifier: A proxy exists for this non-durable client. It must be closed.");
                }
                if (staleClientProxy.startRemoval()) {
                    staleClientProxy.waitRemoval();
                } else {
                    staleClientProxy.close(false, false);
                    this.removeClientProxy(staleClientProxy);
                }
            }
            cacheClientProxy = new CacheClientProxy(this, socket, clientProxyMembershipID, isPrimary, clientConflation, clientVersion, acceptorId, notifyBySubscription, this.cache.getSecurityService(), subject, this.statisticsClock);
            successful = this.initializeProxy(cacheClientProxy);
        }
lbl75:
        // 6 sources

        if (!successful) {
            cacheClientProxy = null;
            responseByte = 60;
            unsuccessfulMsg = String.format("A previous connection attempt from this client is still being processed: %s", new Object[]{clientProxyMembershipID});
            CacheClientNotifier.logger.warn(unsuccessfulMsg);
        }
        try {
            dos = new DataOutputStream(new BufferedOutputStream(socket.getOutputStream()));
            this.socketMessageWriter.writeHandshakeMessage(dos, responseByte, unsuccessfulMsg, clientVersion, endpointType, queueSize);
        }
        catch (IOException ioe) {
            if (cacheClientProxy != null && !(keepProxy = cacheClientProxy.close(false, false))) {
                this.removeClientProxy(cacheClientProxy);
            }
            throw ioe;
        }
        if (unsuccessfulMsg != null && CacheClientNotifier.logger.isDebugEnabled()) {
            CacheClientNotifier.logger.debug(unsuccessfulMsg);
        }
        if (!clientIsDurable && cacheClientProxy != null && responseByte == CommunicationMode.SuccessfulServerToClient.getModeNumber()) {
            cacheClientProxy.startOrResumeMessageDispatcher(false);
        }
        if (responseByte == CommunicationMode.SuccessfulServerToClient.getModeNumber()) {
            if (CacheClientNotifier.logger.isDebugEnabled()) {
                CacheClientNotifier.logger.debug("CacheClientNotifier: Successfully registered {}", (Object)cacheClientProxy);
            }
        } else {
            CacheClientNotifier.logger.warn("CacheClientNotifier: Unsuccessfully registered client with identifier {} and response code {}", new Object[]{clientProxyMembershipID, responseByte});
        }
        this.performPostAuthorization(cacheClientProxy, clientProxyMembershipID, member, sysProps, subjectOrPrincipal);
    }

    private void handleAuthenticationException(ClientProxyMembershipID clientProxyMembershipID, DataOutputStream dataOutputStream, Version clientVersion, GemFireSecurityException ex, byte replyExceptionAuthenticationFailed) throws IOException {
        this.securityLogWriter.warning(String.format("An exception was thrown for client [%s]. %s", clientProxyMembershipID, ex));
        this.socketMessageWriter.writeException(dataOutputStream, replyExceptionAuthenticationFailed, ex, clientVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initializeProxy(CacheClientProxy l_proxy) throws CacheException {
        if (!this.isProxyInInitializationMode(l_proxy)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Initializing proxy: {}", (Object)l_proxy);
            }
            try {
                this.addClientInitProxy(l_proxy);
                l_proxy.initializeMessageDispatcher();
                this.addClientProxy(l_proxy);
                boolean bl = true;
                return bl;
            }
            catch (RegionExistsException ree) {
                if (logger.isDebugEnabled()) {
                    String name = ree.getRegion() != null ? ree.getRegion().getFullPath() : "null region";
                    logger.debug("Found RegionExistsException while initializing proxy. Region name: {}", (Object)name);
                }
            }
            finally {
                this.removeClientInitProxy(l_proxy);
            }
        }
        boolean status = false;
        return status;
    }

    public void makePrimary(ClientProxyMembershipID proxyId, boolean isClientReady) {
        CacheClientProxy proxy = this.getClientProxy(proxyId);
        if (proxy != null) {
            proxy.setPrimary(true);
            if (isClientReady || !proxy.isDurable()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("CacheClientNotifier: Notifying proxy to start dispatcher for: {}", (Object)proxy);
                }
                proxy.startOrResumeMessageDispatcher(false);
            }
        } else {
            throw new InternalGemFireError("No cache client proxy on this node for proxyId " + proxyId);
        }
    }

    public boolean processDispatchedMessage(ClientProxyMembershipID proxyId, EventID eid) {
        boolean success = false;
        CacheClientProxy proxy = this.getClientProxy(proxyId);
        if (proxy != null) {
            HARegionQueue harq = proxy.getHARegionQueue();
            harq.addDispatchedMessage(new ThreadIdentifier(eid.getMembershipID(), eid.getThreadID()), eid.getSequenceID());
            success = true;
        }
        return success;
    }

    public void setKeepAlive(ClientProxyMembershipID membershipID, boolean keepAlive) {
        CacheClientProxy proxy;
        if (logger.isDebugEnabled()) {
            logger.debug("CacheClientNotifier: setKeepAlive client: {}", (Object)membershipID);
        }
        if ((proxy = this.getClientProxy(membershipID)) != null) {
            proxy.setKeepAlive(keepAlive);
        }
    }

    void unregisterClient(ClientProxyMembershipID memberId, boolean normalShutdown) {
        CacheClientProxy proxy;
        if (logger.isDebugEnabled()) {
            logger.debug("CacheClientNotifier: Unregistering all clients with member id: {}", (Object)memberId);
        }
        if ((proxy = this.getClientProxy(memberId)) != null) {
            boolean isTraceEnabled = logger.isTraceEnabled();
            if (isTraceEnabled) {
                logger.trace("CacheClientNotifier: Potential client: {}", (Object)proxy);
            }
            if (!proxy.startRemoval()) {
                if (isTraceEnabled) {
                    logger.trace("CacheClientNotifier: Potential client: {} matches {}", (Object)proxy, (Object)memberId);
                }
                this.closeDeadProxies(Collections.singletonList(proxy), normalShutdown);
            }
        }
    }

    public void readyForEvents(ClientProxyMembershipID proxyId) {
        CacheClientProxy proxy = this.getClientProxy(proxyId);
        if (proxy != null) {
            proxy.startOrResumeMessageDispatcher(false);
        }
    }

    ClientUpdateMessageImpl constructClientMessage(InternalCacheEvent event) {
        ClientUpdateMessageImpl clientMessage = null;
        EnumListenerEvent operation = event.getEventType();
        try {
            clientMessage = this.initializeMessage(operation, event);
        }
        catch (Exception e) {
            logger.fatal(String.format("CacheClientNotifier: Cannot notify clients to perform operation %s on event %s", operation, event), (Throwable)e);
        }
        return clientMessage;
    }

    public static void notifyClients(InternalCacheEvent event) {
        CacheClientNotifier instance = ccnSingleton;
        if (instance != null) {
            instance.singletonNotifyClients(event, null);
        }
    }

    public static boolean singletonHasClientProxies() {
        CacheClientNotifier instance = ccnSingleton;
        if (instance != null) {
            return instance.hasClientProxies();
        }
        return false;
    }

    private boolean hasClientProxies() {
        return !this._initClientProxies.isEmpty() || !this._clientProxies.isEmpty();
    }

    public static void notifyClients(InternalCacheEvent event, ClientUpdateMessage cmsg) {
        CacheClientNotifier instance = ccnSingleton;
        if (instance != null) {
            instance.singletonNotifyClients(event, cmsg);
        }
    }

    private void singletonNotifyClients(InternalCacheEvent event, ClientUpdateMessage cmsg) {
        DataSerializableFixedID conflatable;
        if (!this.hasClientProxies()) {
            return;
        }
        FilterRoutingInfo.FilterInfo filterInfo = event.getLocalFilterInfo();
        if (filterInfo != null && logger.isTraceEnabled()) {
            logger.trace("Event isOriginRemote={}", (Object)event.isOriginRemote());
        }
        if (filterInfo == null || filterInfo.getCQs() == null && filterInfo.getInterestedClients() == null && filterInfo.getInterestedClientsInv() == null) {
            return;
        }
        long startTime = this.statistics.startTime();
        ClientUpdateMessageImpl clientMessage = cmsg == null ? this.constructClientMessage(event) : (ClientUpdateMessageImpl)cmsg;
        if (clientMessage == null) {
            return;
        }
        FilterProfile regionProfile = ((InternalRegion)event.getRegion()).getFilterProfile();
        Set<ClientProxyMembershipID> filterClients = this.getFilterClientIDs(event, regionProfile, filterInfo, clientMessage);
        if (clientMessage instanceof ClientTombstoneMessage) {
            Object[] objects;
            conflatable = clientMessage;
            for (Object id : objects = filterClients.toArray()) {
                CacheClientProxy ccp = this.getClientProxy((ClientProxyMembershipID)id, true);
                if (ccp == null || ccp.getVersion().compareTo(Version.GFE_70) >= 0) continue;
                filterClients.remove(id);
            }
        } else {
            HAEventWrapper wrapper = new HAEventWrapper(clientMessage);
            wrapper.incrementPutInProgressCounter("notify clients");
            conflatable = wrapper;
        }
        if (!filterClients.isEmpty() && event.getOperation().isEntry()) {
            EntryEventImpl entryEvent = (EntryEventImpl)event;
            entryEvent.exportNewValue(clientMessage);
        }
        this.clientRegistrationEventQueueManager.add(event, (Conflatable)conflatable, filterClients, this);
        this.singletonRouteClientMessage((Conflatable)conflatable, (Collection<ClientProxyMembershipID>)filterClients);
        this.statistics.endEvent(startTime);
        if (filterInfo.filterProcessedLocally) {
            this.removeDestroyTokensFromCqResultKeys(event, filterInfo);
        }
    }

    Set<ClientProxyMembershipID> getFilterClientIDs(InternalCacheEvent event, FilterProfile regionProfile, FilterRoutingInfo.FilterInfo filterInfo, ClientUpdateMessageImpl clientMessage) {
        Set<ClientProxyMembershipID> ids;
        Set rawIDs;
        HashSet<ClientProxyMembershipID> filterClients = new HashSet<ClientProxyMembershipID>();
        if (filterInfo.getCQs() != null) {
            for (Map.Entry<Long, Integer> e : filterInfo.getCQs().entrySet()) {
                ServerCQ cq;
                Long cqID = e.getKey();
                String cqName = regionProfile.getRealCqID(cqID);
                if (cqName == null || (cq = regionProfile.getCq(cqName)) == null) continue;
                ClientProxyMembershipID id = cq.getClientProxyId();
                filterClients.add(id);
                if (logger.isDebugEnabled()) {
                    logger.debug("Adding cq routing info to message for id: {} and cq: {}", (Object)id, (Object)cqName);
                }
                clientMessage.addClientCq(id, cq.getName(), e.getValue());
            }
        }
        if (filterInfo.getInterestedClientsInv() != null) {
            rawIDs = regionProfile.getRealClientIDs(filterInfo.getInterestedClientsInv());
            ids = this.getProxyIDs(rawIDs);
            this.incMessagesNotQueuedOriginatorStat(event, ids);
            if (!ids.isEmpty()) {
                if (logger.isTraceEnabled()) {
                    logger.trace("adding invalidation routing to message for {}", ids);
                }
                clientMessage.addClientInterestList(ids, false);
                filterClients.addAll(ids);
            }
        }
        if (filterInfo.getInterestedClients() != null) {
            rawIDs = regionProfile.getRealClientIDs(filterInfo.getInterestedClients());
            ids = this.getProxyIDs(rawIDs);
            this.incMessagesNotQueuedOriginatorStat(event, ids);
            if (!ids.isEmpty()) {
                if (logger.isTraceEnabled()) {
                    logger.trace("adding routing to message for {}", ids);
                }
                clientMessage.addClientInterestList(ids, true);
                filterClients.addAll(ids);
            }
        }
        return filterClients;
    }

    private boolean isClientPermitted(ClientRegistrationMetadata clientRegistrationMetadata, ClientProxyMembershipID clientProxyMembershipID) throws IOException {
        if (this.getDenylistedClient().contains(clientProxyMembershipID)) {
            Exception deniedException = new Exception("This client is denylisted by server");
            this.socketMessageWriter.writeException(clientRegistrationMetadata.getDataOutputStream(), (byte)61, deniedException, clientRegistrationMetadata.getClientVersion());
            return false;
        }
        return true;
    }

    private void incMessagesNotQueuedOriginatorStat(InternalCacheEvent event, Set<ClientProxyMembershipID> ids) {
        CacheClientProxy ccp;
        ClientProxyMembershipID eventOriginator = event.getContext();
        if (eventOriginator != null && ids.remove(eventOriginator) && (ccp = this.getClientProxy(eventOriginator)) != null) {
            ccp.getStatistics().incMessagesNotQueuedOriginator();
        }
    }

    private void removeDestroyTokensFromCqResultKeys(InternalCacheEvent event, FilterRoutingInfo.FilterInfo filterInfo) {
        FilterProfile regionProfile = ((InternalRegion)event.getRegion()).getFilterProfile();
        if (event.getOperation().isEntry() && filterInfo.getCQs() != null) {
            EntryEvent entryEvent = (EntryEvent)((Object)event);
            for (Map.Entry<Long, Integer> e : filterInfo.getCQs().entrySet()) {
                ServerCQ cq;
                Long cqID = e.getKey();
                String cqName = regionProfile.getRealCqID(cqID);
                if (cqName == null || (cq = regionProfile.getCq(cqName)) == null || !e.getValue().equals(16)) continue;
                cq.removeFromCqResultKeys(entryEvent.getKey(), true);
            }
        }
    }

    private void performPostAuthorization(CacheClientProxy proxy, ClientProxyMembershipID clientProxyMembershipID, DistributedMember member, Properties sysProps, Object subjectOrPrincipal) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (proxy != null && subjectOrPrincipal != null && subjectOrPrincipal instanceof Principal) {
            Principal principal = (Principal)subjectOrPrincipal;
            if (this.securityLogWriter.fineEnabled()) {
                this.securityLogWriter.fine("CacheClientNotifier: successfully verified credentials for proxyID: " + clientProxyMembershipID + " having principal: " + principal.getName());
            }
            String postAuthzFactoryName = sysProps.getProperty("security-client-accessor-pp");
            AccessControl authzCallback = null;
            if (postAuthzFactoryName != null && !postAuthzFactoryName.isEmpty()) {
                Method authzMethod = ClassLoadUtil.methodFromName(postAuthzFactoryName);
                authzCallback = (AccessControl)authzMethod.invoke(null, (Object[])null);
                authzCallback.init(principal, member, this.getCache());
            }
            proxy.setPostAuthzCallback(authzCallback);
        }
    }

    private Object getSubjectOrPrincipal(ClientRegistrationMetadata clientRegistrationMetadata, DistributedMember member, DistributedSystem system, String authenticator) {
        Object subjectOrPrincipal;
        if (clientRegistrationMetadata.getClientCredentials() != null) {
            if (this.securityLogWriter.fineEnabled()) {
                this.securityLogWriter.fine("CacheClientNotifier: verifying credentials for proxyID: " + clientRegistrationMetadata.getClientProxyMembershipID());
            }
            subjectOrPrincipal = Handshake.verifyCredentials(authenticator, clientRegistrationMetadata.getClientCredentials(), system.getSecurityProperties(), this.logWriter, this.securityLogWriter, member, this.cache.getSecurityService());
        } else {
            subjectOrPrincipal = null;
        }
        return subjectOrPrincipal;
    }

    public static void routeClientMessage(Conflatable clientMessage) {
        CacheClientNotifier instance = ccnSingleton;
        if (instance != null) {
            instance.singletonRouteClientMessage(clientMessage, instance._clientProxies.keySet());
        }
    }

    static void routeSingleClientMessage(ClientUpdateMessage clientMessage, ClientProxyMembershipID clientProxyMembershipId) {
        CacheClientNotifier instance = ccnSingleton;
        if (instance != null) {
            instance.singletonRouteClientMessage(clientMessage, Collections.singleton(clientProxyMembershipId));
        }
    }

    private void singletonRouteClientMessage(Conflatable conflatable, Collection<ClientProxyMembershipID> filterClients) {
        this.cache.getCancelCriterion().checkCancelInProgress(null);
        ArrayList<CacheClientProxy> deadProxies = null;
        for (ClientProxyMembershipID clientId : filterClients) {
            CacheClientProxy proxy = this.getClientProxy(clientId, true);
            if (proxy == null) continue;
            if (proxy.isAlive() || proxy.isPaused() || proxy.isConnected() || proxy.isDurable()) {
                proxy.deliverMessage(conflatable);
            } else {
                proxy.getStatistics().incMessagesFailedQueued();
                if (deadProxies == null) {
                    deadProxies = new ArrayList<CacheClientProxy>();
                }
                deadProxies.add(proxy);
            }
            this.denyListSlowReceiver(proxy);
        }
        if (conflatable instanceof HAEventWrapper) {
            ((HAEventWrapper)conflatable).decrementPutInProgressCounter();
        }
        if (deadProxies != null) {
            this.closeDeadProxies(deadProxies, false);
        }
    }

    Set<ClientProxyMembershipID> getProxyIDs(Set mixedDurableAndNonDurableIDs) {
        ConcurrentHashMap.KeySetView result = ConcurrentHashMap.newKeySet();
        for (Object id : mixedDurableAndNonDurableIDs) {
            if (id instanceof String) {
                CacheClientProxy clientProxy = this.getClientProxy((String)id, true);
                if (clientProxy == null) continue;
                result.add(clientProxy.getProxyID());
                continue;
            }
            CacheClientProxy proxy = this.getClientProxy((ClientProxyMembershipID)id, true);
            if (proxy == null) continue;
            result.add(proxy.getProxyID());
        }
        return result;
    }

    private void denyListSlowReceiver(CacheClientProxy clientProxy) {
        CacheClientProxy proxy = clientProxy;
        if (proxy.getHARegionQueue() != null && proxy.getHARegionQueue().isClientSlowReceiver() && !this.denyListedClients.contains(proxy.getProxyID())) {
            logger.warn("Client {} is a slow receiver.", new Object[]{proxy.getProxyID()});
            this.addToDenylistedClient(proxy.getProxyID());
            InternalDistributedSystem ids = (InternalDistributedSystem)this.getCache().getDistributedSystem();
            DistributionManager dm = ids.getDistributionManager();
            dm.getExecutors().getWaitingThreadPool().execute(() -> {
                CacheDistributionAdvisor advisor = proxy.getHARegionQueue().getRegion().getCacheDistributionAdvisor();
                Set<InternalDistributedMember> members = advisor.adviseCacheOp();
                ClientDenylistProcessor.sendDenylistedClient(proxy.getProxyID(), dm, members);
                proxy.close(false, false);
                this.removeClientProxy(proxy);
                if (PoolImpl.AFTER_QUEUE_DESTROY_MESSAGE_FLAG) {
                    ClientServerObserver bo = ClientServerObserverHolder.getInstance();
                    bo.afterQueueDestroyMessage();
                }
                RemoveClientFromDenylistMessage rcm = new RemoveClientFromDenylistMessage();
                rcm.setProxyID(proxy.getProxyID());
                dm.putOutgoing(rcm);
                this.denyListedClients.remove(proxy.getProxyID());
            });
        }
    }

    private ClientUpdateMessageImpl initializeMessage(EnumListenerEvent operation, CacheEvent event) throws Exception {
        EventID eventIdentifier;
        Object callbackArgument;
        if (!this.supportsOperation(operation)) {
            throw new Exception(String.format("The cache client notifier does not support operations of type %s", operation));
        }
        Object keyOfInterest = null;
        ClientProxyMembershipID membershipID = null;
        boolean isNetLoad = false;
        byte[] delta = null;
        VersionTag versionTag = null;
        if (event.getOperation().isEntry()) {
            EntryEventImpl entryEvent = (EntryEventImpl)event;
            versionTag = entryEvent.getVersionTag();
            delta = entryEvent.getDeltaBytes();
            callbackArgument = entryEvent.getRawCallbackArgument();
            if (entryEvent.isBridgeEvent()) {
                membershipID = entryEvent.getContext();
            }
            keyOfInterest = entryEvent.getKey();
            eventIdentifier = entryEvent.getEventId();
            isNetLoad = entryEvent.isNetLoad();
        } else {
            RegionEventImpl regionEvent = (RegionEventImpl)event;
            callbackArgument = regionEvent.getRawCallbackArgument();
            eventIdentifier = regionEvent.getEventId();
            if (event instanceof ClientRegionEventImpl) {
                ClientRegionEventImpl bridgeEvent = (ClientRegionEventImpl)event;
                membershipID = bridgeEvent.getContext();
            }
        }
        ClientUpdateMessageImpl clientUpdateMsg = new ClientUpdateMessageImpl(operation, (LocalRegion)event.getRegion(), keyOfInterest, null, delta, 1, callbackArgument, membershipID, eventIdentifier, versionTag);
        if (isNetLoad) {
            clientUpdateMsg.setIsNetLoad(isNetLoad);
        }
        return clientUpdateMsg;
    }

    private boolean supportsOperation(EnumListenerEvent operation) {
        return operation == EnumListenerEvent.AFTER_CREATE || operation == EnumListenerEvent.AFTER_UPDATE || operation == EnumListenerEvent.AFTER_DESTROY || operation == EnumListenerEvent.AFTER_INVALIDATE || operation == EnumListenerEvent.AFTER_REGION_DESTROY || operation == EnumListenerEvent.AFTER_REGION_CLEAR || operation == EnumListenerEvent.AFTER_REGION_INVALIDATE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerClientInterest(String regionName, Object keyOfInterest, ClientProxyMembershipID membershipID, int interestType2, boolean isDurable, boolean sendUpdatesAsInvalidates, boolean manageEmptyRegions, int regionDataPolicy, boolean flushState) throws IOException, RegionDestroyedException {
        CacheClientProxy proxy = this.getClientProxy(membershipID, true);
        if (logger.isDebugEnabled()) {
            logger.debug("CacheClientNotifier: Client {} registering interest in: {} -> {} (an instance of {})", (Object)proxy, (Object)regionName, keyOfInterest, (Object)keyOfInterest.getClass().getName());
        }
        if (proxy == null) {
            throw new IOException("CacheClientProxy for this client is no longer on the server , so registerInterest operation is unsuccessful");
        }
        boolean done = false;
        try {
            proxy.registerClientInterest(regionName, keyOfInterest, interestType2, isDurable, sendUpdatesAsInvalidates, flushState);
            if (manageEmptyRegions) {
                this.updateMapOfEmptyRegions(proxy.getRegionsWithEmptyDataPolicy(), regionName, regionDataPolicy);
            }
            done = true;
        }
        finally {
            if (!done) {
                proxy.unregisterClientInterest(regionName, keyOfInterest, interestType2, false);
            }
        }
    }

    public void updateMapOfEmptyRegions(Map regionsWithEmptyDataPolicy, String regionName, int regionDataPolicy) {
        if (regionDataPolicy == 0 && !regionsWithEmptyDataPolicy.containsKey(regionName)) {
            regionsWithEmptyDataPolicy.put(regionName, 0);
        }
    }

    public void unregisterClientInterest(String regionName, Object keyOfInterest, int interestType2, boolean isClosing, ClientProxyMembershipID membershipID, boolean keepalive) {
        CacheClientProxy proxy;
        if (logger.isDebugEnabled()) {
            logger.debug("CacheClientNotifier: Client {} unregistering interest in: {} -> {} (an instance of {})", (Object)membershipID, (Object)regionName, keyOfInterest, (Object)keyOfInterest.getClass().getName());
        }
        if ((proxy = this.getClientProxy(membershipID)) != null) {
            proxy.setKeepAlive(keepalive);
            proxy.unregisterClientInterest(regionName, keyOfInterest, interestType2, isClosing);
        }
    }

    public void registerClientInterest(String regionName, List keysOfInterest, ClientProxyMembershipID membershipID, boolean isDurable, boolean sendUpdatesAsInvalidates, boolean manageEmptyRegions, int regionDataPolicy, boolean flushState) throws IOException, RegionDestroyedException {
        CacheClientProxy proxy = this.getClientProxy(membershipID, true);
        if (logger.isDebugEnabled()) {
            logger.debug("CacheClientNotifier: Client {} registering interest in: {} -> {}", (Object)proxy, (Object)regionName, (Object)keysOfInterest);
        }
        if (proxy == null) {
            throw new IOException("CacheClientProxy for this client is no longer on the server , so registerInterest operation is unsuccessful");
        }
        proxy.registerClientInterestList(regionName, keysOfInterest, isDurable, sendUpdatesAsInvalidates, flushState);
        if (manageEmptyRegions) {
            this.updateMapOfEmptyRegions(proxy.getRegionsWithEmptyDataPolicy(), regionName, regionDataPolicy);
        }
    }

    public void unregisterClientInterest(String regionName, List keysOfInterest, boolean isClosing, ClientProxyMembershipID membershipID, boolean keepalive) {
        CacheClientProxy proxy;
        if (logger.isDebugEnabled()) {
            logger.debug("CacheClientNotifier: Client {} unregistering interest in: {} -> {}", (Object)membershipID, (Object)regionName, (Object)keysOfInterest);
        }
        if ((proxy = this.getClientProxy(membershipID)) != null) {
            proxy.setKeepAlive(keepalive);
            proxy.unregisterClientInterest(regionName, keysOfInterest, isClosing);
        }
    }

    public CacheClientProxy getClientProxy(ClientProxyMembershipID membershipID) {
        return (CacheClientProxy)this._clientProxies.get(membershipID);
    }

    public CacheClientProxy getClientProxy(ClientProxyMembershipID membershipID, boolean proxyInInitMode) {
        CacheClientProxy proxy = this.getClientProxy(membershipID);
        if (proxyInInitMode && proxy == null) {
            proxy = (CacheClientProxy)this._initClientProxies.get(membershipID);
        }
        return proxy;
    }

    public CacheClientProxy getClientProxy(String durableClientId) {
        return this.getClientProxy(durableClientId, false);
    }

    public CacheClientProxy getClientProxy(String durableClientId, boolean proxyInInitMode) {
        boolean isDebugEnabled = logger.isDebugEnabled();
        boolean isTraceEnabled = logger.isTraceEnabled();
        if (isDebugEnabled) {
            logger.debug("CacheClientNotifier: Determining client for {}", (Object)durableClientId);
        }
        CacheClientProxy proxy = null;
        for (CacheClientProxy clientProxy : this.getClientProxies()) {
            if (isTraceEnabled) {
                logger.trace("CacheClientNotifier: Checking client {}", (Object)clientProxy);
            }
            if (!clientProxy.getDurableId().equals(durableClientId)) continue;
            proxy = clientProxy;
            if (!isDebugEnabled) break;
            logger.debug("CacheClientNotifier: {} represents the durable client {}", (Object)proxy, (Object)durableClientId);
            break;
        }
        if (proxy == null && proxyInInitMode) {
            Iterator<CacheClientProxy> iterator = this._initClientProxies.values().iterator();
            while (iterator.hasNext()) {
                CacheClientProxy o;
                CacheClientProxy clientProxy = o = iterator.next();
                if (isTraceEnabled) {
                    logger.trace("CacheClientNotifier: Checking initializing client {}", (Object)clientProxy);
                }
                if (!clientProxy.getDurableId().equals(durableClientId)) continue;
                proxy = clientProxy;
                if (!isDebugEnabled) break;
                logger.debug("CacheClientNotifier: initializing client {} represents the durable client {}", (Object)proxy, (Object)durableClientId);
                break;
            }
        }
        return proxy;
    }

    public synchronized void shutdown(long acceptorId) {
        boolean isDebugEnabled = logger.isDebugEnabled();
        if (isDebugEnabled) {
            logger.debug("At cache server shutdown time, the number of cache servers in the cache is {}", (Object)this.getCache().getCacheServers().size());
        }
        Iterator it = this._clientProxies.values().iterator();
        while (it.hasNext()) {
            CacheClientProxy proxy = (CacheClientProxy)it.next();
            if (proxy.getAcceptorId() != acceptorId) continue;
            it.remove();
            try {
                if (isDebugEnabled) {
                    logger.debug("CacheClientNotifier: Closing {}", (Object)proxy);
                }
                proxy.terminateDispatching(true);
            }
            catch (Exception ignore) {
                if (!isDebugEnabled) continue;
                logger.debug("{}: Exception in closing down the CacheClientProxy", (Object)this, (Object)ignore);
            }
        }
        if (this.noActiveServer() && ccnSingleton != null) {
            ccnSingleton = null;
            if (this.haContainer != null) {
                this.haContainer.cleanUp();
                if (isDebugEnabled) {
                    logger.debug("haContainer ({}) is now cleaned up.", (Object)this.haContainer.getName());
                }
            }
            this.clearCompiledQueries();
            this.denyListedClients.clear();
            this.clientPingTask.cancel();
            this.statistics.close();
            this.socketCloser.close();
        }
    }

    private boolean noActiveServer() {
        for (CacheServer server : this.getCache().getCacheServers()) {
            if (!server.isRunning()) continue;
            return false;
        }
        return true;
    }

    void addClientProxy(CacheClientProxy proxy) {
        ClientHealthMonitor chm;
        this.getCache();
        this._clientProxies.put(proxy.getProxyID(), proxy);
        this.removeClientInitProxy(proxy);
        this._connectionListener.queueAdded(proxy.getProxyID());
        if (proxy.clientConflation != 1 && (chm = ClientHealthMonitor.getInstance()) != null) {
            chm.numOfClientsPerVersion.incrementAndGet(proxy.getVersion().ordinal());
        }
        this.timedOutDurableClientProxies.remove(proxy.getProxyID());
    }

    void addClientInitProxy(CacheClientProxy proxy) {
        this._initClientProxies.put(proxy.getProxyID(), proxy);
    }

    private void removeClientInitProxy(CacheClientProxy proxy) {
        this._initClientProxies.remove(proxy.getProxyID());
    }

    private boolean isProxyInInitializationMode(CacheClientProxy proxy) {
        return this._initClientProxies.containsKey(proxy.getProxyID());
    }

    public Set getActiveClients() {
        HashSet<ClientProxyMembershipID> clients = new HashSet<ClientProxyMembershipID>();
        for (CacheClientProxy proxy : this.getClientProxies()) {
            if (!proxy.hasRegisteredInterested()) continue;
            ClientProxyMembershipID proxyID = proxy.getProxyID();
            clients.add(proxyID);
        }
        return clients;
    }

    public Map getAllClients() {
        HashMap<ClientProxyMembershipID, CacheClientStatus> clients = new HashMap<ClientProxyMembershipID, CacheClientStatus>();
        for (Object o : this._clientProxies.values()) {
            CacheClientProxy proxy = (CacheClientProxy)o;
            ClientProxyMembershipID proxyID = proxy.getProxyID();
            clients.put(proxyID, new CacheClientStatus(proxyID));
        }
        return clients;
    }

    public boolean hasDurableClient(String durableId) {
        for (Object o : this._clientProxies.values()) {
            CacheClientProxy proxy = (CacheClientProxy)o;
            ClientProxyMembershipID proxyID = proxy.getProxyID();
            if (!durableId.equals(proxyID.getDurableId())) continue;
            return true;
        }
        return false;
    }

    public boolean hasPrimaryForDurableClient(String durableId) {
        for (Object o : this._clientProxies.values()) {
            CacheClientProxy proxy = (CacheClientProxy)o;
            ClientProxyMembershipID proxyID = proxy.getProxyID();
            if (!durableId.equals(proxyID.getDurableId())) continue;
            return proxy.isPrimary();
        }
        return false;
    }

    public Map getClientQueueSizes() {
        HashMap<ClientProxyMembershipID, Integer> queueSizes = new HashMap<ClientProxyMembershipID, Integer>();
        for (Object o : this._clientProxies.values()) {
            CacheClientProxy proxy = (CacheClientProxy)o;
            queueSizes.put(proxy.getProxyID(), proxy.getQueueSize());
        }
        return queueSizes;
    }

    public int getDurableClientHAQueueSize(String durableClientId) {
        CacheClientProxy ccp = this.getClientProxy(durableClientId);
        if (ccp == null) {
            return -1;
        }
        return ccp.getQueueSizeStat();
    }

    public boolean closeClientCq(String durableClientId, String clientCQName) throws CqException {
        CacheClientProxy proxy = this.getClientProxy(durableClientId);
        if (proxy != null) {
            return proxy.closeClientCq(clientCQName);
        }
        return false;
    }

    void removeClientProxy(CacheClientProxy proxy) {
        ClientHealthMonitor chm;
        ClientProxyMembershipID client = proxy.getProxyID();
        this._clientProxies.remove(client);
        this._connectionListener.queueRemoved();
        this.getCache().cleanupForClient(this, client);
        if (proxy.clientConflation != 1 && (chm = ClientHealthMonitor.getInstance()) != null) {
            chm.numOfClientsPerVersion.decrementAndGet(proxy.getVersion().ordinal());
        }
    }

    void durableClientTimedOut(ClientProxyMembershipID client) {
        this.timedOutDurableClientProxies.add(client);
    }

    private boolean isTimedOut(ClientProxyMembershipID client) {
        return this.timedOutDurableClientProxies.contains(client);
    }

    public Collection<CacheClientProxy> getClientProxies() {
        return Collections.unmodifiableCollection(this._clientProxies.values());
    }

    private void closeAllClientCqs(CacheClientProxy proxy) {
        block4: {
            CqService cqService = proxy.getCache().getCqService();
            if (cqService != null) {
                boolean isDebugEnabled = logger.isDebugEnabled();
                try {
                    if (isDebugEnabled) {
                        logger.debug("CacheClientNotifier: Closing client CQs: {}", (Object)proxy);
                    }
                    cqService.closeClientCqs(proxy.getProxyID());
                }
                catch (CqException e1) {
                    logger.warn("Unable to close CQs for the client: {}", (Object)proxy.getProxyID());
                    if (!isDebugEnabled) break block4;
                    logger.debug(e1.getMessage(), (Throwable)e1);
                }
            }
        }
    }

    public boolean closeDurableClientProxy(String durableClientId) throws CacheException {
        CacheClientProxy ccp = this.getClientProxy(durableClientId);
        if (ccp == null) {
            return false;
        }
        if (ccp.isPaused() && !ccp.isConnected()) {
            ccp.setKeepAlive(false);
            this.closeDeadProxies(Collections.singletonList(ccp), true);
            return true;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Cannot close running durable client: {}", (Object)durableClientId);
        }
        throw new CacheException("Cannot close a running durable client : " + durableClientId){};
    }

    private void closeDeadProxies(List deadProxies, boolean stoppedNormally) {
        boolean isDebugEnabled = logger.isDebugEnabled();
        for (Object deadProxy : deadProxies) {
            CacheClientProxy proxy = (CacheClientProxy)deadProxy;
            if (isDebugEnabled) {
                logger.debug("CacheClientNotifier: Closing dead client: {}", (Object)proxy);
            }
            boolean keepProxy = false;
            try {
                keepProxy = proxy.close(false, stoppedNormally);
            }
            catch (CancelException e) {
                throw e;
            }
            catch (Exception e) {
                logger.warn("CacheClientNotifier: Caught exception attempting to close client: {}", (Object)proxy, (Object)e);
            }
            if (keepProxy) {
                logger.info("CacheClientNotifier: Keeping proxy for durable client named {} for {} seconds {}.", (Object)proxy.getDurableId(), (Object)proxy.getDurableTimeout(), (Object)proxy);
            } else {
                this.closeAllClientCqs(proxy);
                if (isDebugEnabled) {
                    logger.debug("CacheClientNotifier: Not keeping proxy for non-durable client: {}", (Object)proxy);
                }
                this.removeClientProxy(proxy);
            }
            proxy.notifyRemoval();
        }
    }

    public void registerInterestRegistrationListener(InterestRegistrationListener listener) {
        this.writableInterestRegistrationListeners.add(listener);
    }

    public void unregisterInterestRegistrationListener(InterestRegistrationListener listener) {
        this.writableInterestRegistrationListeners.remove(listener);
    }

    public Set getInterestRegistrationListeners() {
        return this.readableInterestRegistrationListeners;
    }

    boolean containsInterestRegistrationListeners() {
        return !this.writableInterestRegistrationListeners.isEmpty();
    }

    void notifyInterestRegistrationListeners(InterestRegistrationEvent event) {
        for (Object writableInterestRegistrationListener : this.writableInterestRegistrationListeners) {
            InterestRegistrationListener listener = (InterestRegistrationListener)writableInterestRegistrationListener;
            if (event.isRegister()) {
                listener.afterRegisterInterest(event);
                continue;
            }
            listener.afterUnregisterInterest(event);
        }
    }

    public CacheClientNotifierStats getStats() {
        return this.statistics;
    }

    protected InternalCache getCache() {
        GemFireCacheImpl cache;
        if (this.cache != null && this.cache.isClosed() && (cache = GemFireCacheImpl.getInstance()) != null) {
            this.cache = cache;
            this.logWriter = cache.getInternalLogWriter();
            this.securityLogWriter = cache.getSecurityInternalLogWriter();
        }
        return this.cache;
    }

    protected int getMaximumMessageCount() {
        return this.maximumMessageCount;
    }

    protected int getMessageTimeToLive() {
        return this.messageTimeToLive;
    }

    protected void handleInterestEvent(InterestRegistrationEvent event) {
        LocalRegion region = (LocalRegion)event.getRegion();
        region.handleInterestEvent(event);
    }

    private CacheClientNotifier(InternalCache cache, ClientRegistrationEventQueueManager clientRegistrationEventQueueManager, StatisticsClock statisticsClock, CacheServerStats acceptorStats, int maximumMessageCount, int messageTimeToLive, ConnectionListener listener, boolean isGatewayReceiver) {
        this.setCache(cache);
        this.clientRegistrationEventQueueManager = clientRegistrationEventQueueManager;
        this.statisticsClock = statisticsClock;
        this.acceptorStats = acceptorStats;
        this.socketCloser = new SocketCloser(1, 50L);
        this.logWriter = (InternalLogWriter)cache.getLogger();
        this._connectionListener = listener;
        this.securityLogWriter = (InternalLogWriter)cache.getSecurityLogger();
        this.maximumMessageCount = maximumMessageCount;
        this.messageTimeToLive = messageTimeToLive;
        StatisticsFactory factory = isGatewayReceiver ? new DummyStatisticsFactory() : this.getCache().getInternalDistributedSystem().getStatisticsManager();
        this.statistics = new CacheClientNotifierStats(factory);
        try {
            this.logFrequency = Long.valueOf(System.getProperty(MAX_QUEUE_LOG_FREQUENCY));
            if (this.logFrequency <= 0L) {
                this.logFrequency = 1000L;
            }
        }
        catch (Exception e) {
            this.logFrequency = 1000L;
        }
        eventEnqueueWaitTime = Integer.getInteger(EVENT_ENQUEUE_WAIT_TIME_NAME, 100);
        if (eventEnqueueWaitTime < 0) {
            eventEnqueueWaitTime = 100;
        }
        this.scheduleClientPingTask();
    }

    void deliverInterestChange(ClientProxyMembershipID proxyID, ClientInterestMessageImpl message) {
        DistributionManager dm = ((InternalDistributedSystem)this.getCache().getDistributedSystem()).getDistributionManager();
        ServerInterestRegistrationMessage.sendInterestChange(dm, proxyID, message);
    }

    CacheServerStats getAcceptorStats() {
        return this.acceptorStats;
    }

    SocketCloser getSocketCloser() {
        return this.socketCloser;
    }

    public void addCompiledQuery(DefaultQuery query) {
        if (this.compiledQueries.putIfAbsent(query.getQueryString(), query) == null) {
            this.statistics.incCompiledQueryCount(1L);
            if (logger.isDebugEnabled()) {
                logger.debug("Added compiled query into ccn.compliedQueries list. Query: {}. Total compiled queries: {}", (Object)query.getQueryString(), (Object)this.statistics.getCompiledQueryCount());
            }
            this.startCompiledQueryCleanupThread();
        }
    }

    public Query getCompiledQuery(String queryString) {
        return this.compiledQueries.get(queryString);
    }

    private void clearCompiledQueries() {
        if (!this.compiledQueries.isEmpty()) {
            this.statistics.incCompiledQueryCount(-this.compiledQueries.size());
            this.compiledQueries.clear();
            if (logger.isDebugEnabled()) {
                logger.debug("Removed all compiled queries from ccn.compliedQueries list. Total compiled queries: {}", (Object)this.statistics.getCompiledQueryCount());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startCompiledQueryCleanupThread() {
        if (this.isCompiledQueryCleanupThreadStarted) {
            return;
        }
        SystemTimer.SystemTimerTask task = new SystemTimer.SystemTimerTask(){

            @Override
            public void run2() {
                boolean isDebugEnabled = logger.isDebugEnabled();
                for (Map.Entry e : CacheClientNotifier.this.compiledQueries.entrySet()) {
                    DefaultQuery q = (DefaultQuery)e.getValue();
                    if (q.getLastUsed()) {
                        q.setLastUsed(false);
                        continue;
                    }
                    if (CacheClientNotifier.this.compiledQueries.remove(e.getKey()) == null) continue;
                    CacheClientNotifier.this.statistics.incCompiledQueryCount(-1L);
                    if (!isDebugEnabled) continue;
                    logger.debug("Removed compiled query from ccn.compliedQueries list. Query: " + q.getQueryString() + ". Total compiled queries are : " + CacheClientNotifier.this.statistics.getCompiledQueryCount());
                }
            }
        };
        Object object = this.lockIsCompiledQueryCleanupThreadStarted;
        synchronized (object) {
            if (!this.isCompiledQueryCleanupThreadStarted) {
                long period = DefaultQuery.TEST_COMPILED_QUERY_CLEAR_TIME > 0 ? (long)DefaultQuery.TEST_COMPILED_QUERY_CLEAR_TIME : (long)DefaultQuery.COMPILED_QUERY_CLEAR_TIME;
                this.cache.getCCPTimer().scheduleAtFixedRate(task, period, period);
            }
            this.isCompiledQueryCleanupThreadStarted = true;
        }
    }

    void scheduleClientPingTask() {
        this.clientPingTask = new SystemTimer.SystemTimerTask(){

            @Override
            public void run2() {
                if (CacheClientNotifier.this._clientProxies.isEmpty()) {
                    return;
                }
                ClientPingMessageImpl message = new ClientPingMessageImpl();
                for (CacheClientProxy proxy : CacheClientNotifier.this.getClientProxies()) {
                    logger.debug("Checking whether to ping {}", (Object)proxy);
                    if (proxy.getVersion().compareTo(Version.GFE_6622) >= 0) {
                        if ((long)proxy.incrementAndGetPingCounter() >= CLIENT_PING_TASK_COUNTER) {
                            logger.debug("Pinging {}", (Object)proxy);
                            proxy.sendMessageDirectly(message);
                            logger.debug("Done pinging {}", (Object)proxy);
                            continue;
                        }
                        logger.debug("Not pinging because not idle: {}", (Object)proxy);
                        continue;
                    }
                    logger.debug("Ignoring because of version: {}", (Object)proxy);
                }
            }
        };
        if (logger.isDebugEnabled()) {
            logger.debug("Scheduling client ping task with period={} ms", (Object)CLIENT_PING_TASK_PERIOD);
        }
        this.cache.getCCPTimer().scheduleAtFixedRate(this.clientPingTask, CLIENT_PING_TASK_PERIOD, CLIENT_PING_TASK_PERIOD);
    }

    public long getLogFrequency() {
        return this.logFrequency;
    }

    static int getClientPingInterval() {
        return CLIENT_PING_TASK_PERIOD;
    }

    public Map getHaContainer() {
        return this.haContainer;
    }

    private void initHaContainer(OverflowAttributes overflowAttributes) {
        this.haContainer = overflowAttributes != null && !"none".equals(overflowAttributes.getEvictionPolicy()) ? new HAContainerRegion(this.cache.getRegion("/" + CacheServerImpl.clientMessagesRegion(this.cache, overflowAttributes.getEvictionPolicy(), overflowAttributes.getQueueCapacity(), overflowAttributes.getPort(), overflowAttributes.isDiskStore() ? overflowAttributes.getDiskStoreName() : overflowAttributes.getOverflowDirectory(), overflowAttributes.isDiskStore()))) : new HAContainerMap(new ConcurrentHashMap());
        assert (this.haContainer != null);
        if (logger.isDebugEnabled()) {
            logger.debug("ha container ({}) has been created.", (Object)this.haContainer.getName());
        }
    }

    void addToDenylistedClient(ClientProxyMembershipID proxyID) {
        this.denyListedClients.add(proxyID);
        this.getCache();
        new ScheduledThreadPoolExecutor(1).schedule(new ExpireDenyListTask(proxyID), 120L, TimeUnit.SECONDS);
    }

    Set getDenylistedClient() {
        return this.denyListedClients;
    }

    private void setCache(InternalCache _cache) {
        this.cache = _cache;
    }

    @VisibleForTesting
    public static CacheClientNotifierProvider singletonProvider() {
        return CacheClientNotifier::getInstance;
    }

    @VisibleForTesting
    public static Supplier<CacheClientNotifier> singletonGetter() {
        return CacheClientNotifier::getInstance;
    }

    @VisibleForTesting
    public void addClientProxyToMap(CacheClientProxy proxy) {
        this._clientProxies.put(proxy.getProxyID(), proxy);
    }

    static {
        socketBufferSize = Integer.getInteger("BridgeServer.SOCKET_BUFFER_SIZE", 32768);
        CLIENT_PING_TASK_PERIOD = Integer.getInteger("gemfire.serverToClientPingPeriod", 60000);
        CLIENT_PING_TASK_COUNTER = Long.getLong("gemfire.serverToClientPingCounter", 3L);
    }

    @FunctionalInterface
    @VisibleForTesting
    public static interface CacheClientNotifierProvider {
        public CacheClientNotifier get(InternalCache var1, ClientRegistrationEventQueueManager var2, StatisticsClock var3, CacheServerStats var4, int var5, int var6, ConnectionListener var7, OverflowAttributes var8, boolean var9);
    }

    private class ExpireDenyListTask
    extends PoolImpl.PoolTask {
        private final ClientProxyMembershipID proxyID;

        ExpireDenyListTask(ClientProxyMembershipID proxyID) {
            this.proxyID = proxyID;
        }

        @Override
        public void run2() {
            if (CacheClientNotifier.this.denyListedClients.remove(this.proxyID) && logger.isDebugEnabled()) {
                logger.debug("{} client is no longer denylisted", (Object)this.proxyID);
            }
        }
    }
}

