/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.regex.Pattern;
import org.apache.geode.CopyException;
import org.apache.geode.InternalGemFireError;
import org.apache.geode.SerializationException;
import org.apache.geode.SystemFailure;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.annotations.internal.MakeNotStatic;
import org.apache.geode.cache.CacheLoaderException;
import org.apache.geode.cache.CacheWriterException;
import org.apache.geode.cache.InterestResultPolicy;
import org.apache.geode.cache.Operation;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.cache.TransactionException;
import org.apache.geode.cache.persistence.PartitionOfflineException;
import org.apache.geode.cache.query.types.CollectionType;
import org.apache.geode.distributed.DistributedSystemDisconnectedException;
import org.apache.geode.distributed.internal.DistributionStats;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.cache.CachedDeserializable;
import org.apache.geode.internal.cache.DistributedRegion;
import org.apache.geode.internal.cache.EntryEventImpl;
import org.apache.geode.internal.cache.EntrySnapshot;
import org.apache.geode.internal.cache.EventID;
import org.apache.geode.internal.cache.FindVersionTagOperation;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.InternalRegion;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.NonTXEntry;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.PartitionedRegionHelper;
import org.apache.geode.internal.cache.TXManagerImpl;
import org.apache.geode.internal.cache.TXStateProxy;
import org.apache.geode.internal.cache.Token;
import org.apache.geode.internal.cache.VersionTagHolder;
import org.apache.geode.internal.cache.execute.ServerToClientFunctionResultSender;
import org.apache.geode.internal.cache.tier.CachedRegionHelper;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.sockets.CacheServerStats;
import org.apache.geode.internal.cache.tier.sockets.ChunkedMessage;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.MessageTooLargeException;
import org.apache.geode.internal.cache.tier.sockets.OldClientSupportService;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.cache.tier.sockets.VersionedObjectList;
import org.apache.geode.internal.cache.versions.VersionStamp;
import org.apache.geode.internal.cache.versions.VersionTag;
import org.apache.geode.internal.offheap.OffHeapHelper;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.internal.sequencelog.EntryLogger;
import org.apache.geode.internal.serialization.Version;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.security.GemFireSecurityException;
import org.apache.logging.log4j.Logger;

public abstract class BaseCommand
implements Command {
    protected static final Logger logger = LogService.getLogger();
    @Immutable
    private static final byte[] OK_BYTES = new byte[]{0};
    public static final int MAXIMUM_CHUNK_SIZE = Integer.getInteger("BridgeServer.MAXIMUM_CHUNK_SIZE", 100);
    private static final boolean SUPPRESS_IO_EXCEPTION_LOGGING = Boolean.getBoolean("gemfire.bridge.suppressIOExceptionLogging");
    private static final int MAX_INCOMING_DATA = Integer.getInteger("BridgeServer.MAX_INCOMING_DATA", -1);
    private static final int MAX_INCOMING_MESSAGES = Integer.getInteger("BridgeServer.MAX_INCOMING_MSGS", -1);
    @MakeNotStatic
    private static final Semaphore INCOMING_DATA_LIMITER;
    @MakeNotStatic
    private static final Semaphore INCOMING_MSG_LIMITER;

    protected static byte[] okBytes() {
        return OK_BYTES;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean setLastResultReceived(ServerToClientFunctionResultSender resultSender) {
        if (resultSender != null) {
            ServerToClientFunctionResultSender serverToClientFunctionResultSender = resultSender;
            synchronized (serverToClientFunctionResultSender) {
                if (resultSender.isLastResultReceived()) {
                    return false;
                }
                resultSender.setLastResultReceived(true);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Message clientMessage, ServerConnection serverConnection, SecurityService securityService) {
        block20: {
            long start = DistributionStats.getStatTime();
            if (EntryLogger.isEnabled() && serverConnection != null) {
                EntryLogger.setSource(serverConnection.getMembershipID(), "c2s");
            }
            boolean shouldMasquerade = this.shouldMasqueradeForTx(clientMessage, serverConnection);
            try {
                if (shouldMasquerade) {
                    InternalCache cache = serverConnection.getCache();
                    InternalDistributedMember member = (InternalDistributedMember)serverConnection.getProxyID().getDistributedMember();
                    TXManagerImpl txMgr = cache.getTxManager();
                    TXStateProxy tx = null;
                    try {
                        tx = txMgr.masqueradeAs(clientMessage, member, false);
                        this.cmdExecute(clientMessage, serverConnection, securityService, start);
                        tx.updateProxyServer(txMgr.getMemberId());
                        txMgr.unmasquerade(tx);
                        break block20;
                    }
                    catch (Throwable throwable) {
                        txMgr.unmasquerade(tx);
                        throw throwable;
                    }
                }
                this.cmdExecute(clientMessage, serverConnection, securityService, start);
            }
            catch (CopyException | SerializationException | CacheLoaderException | CacheWriterException | TransactionException | PartitionOfflineException | MessageTooLargeException | GemFireSecurityException e) {
                BaseCommand.handleExceptionNoDisconnect(clientMessage, serverConnection, e);
            }
            catch (EOFException eof) {
                BaseCommand.handleEOFException(clientMessage, serverConnection, eof);
            }
            catch (InterruptedIOException e) {
                BaseCommand.handleInterruptedIOException(serverConnection, e);
            }
            catch (IOException e) {
                BaseCommand.handleIOException(clientMessage, serverConnection, e);
            }
            catch (DistributedSystemDisconnectedException e) {
                BaseCommand.handleShutdownException(clientMessage, serverConnection, e);
            }
            catch (VirtualMachineError err) {
                SystemFailure.initiateFailure(err);
                throw err;
            }
            catch (Throwable e) {
                BaseCommand.handleThrowable(clientMessage, serverConnection, e);
            }
            finally {
                EntryLogger.clearSource();
            }
        }
    }

    protected boolean shouldMasqueradeForTx(Message clientMessage, ServerConnection serverConnection) {
        return serverConnection.getClientVersion().compareTo(Version.GFE_66) >= 0 && clientMessage.getTransactionId() > -1;
    }

    public boolean recoverVersionTagForRetriedOperation(EntryEventImpl clientEvent) {
        InternalRegion r = clientEvent.getRegion();
        VersionTag tag = r.findVersionTagForEvent(clientEvent.getEventId());
        if (tag == null && (r instanceof DistributedRegion || r instanceof PartitionedRegion)) {
            tag = FindVersionTagOperation.findVersionTag(r, clientEvent.getEventId(), false);
        }
        if (tag != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("recovered version tag {} for replayed operation {}", (Object)tag, (Object)clientEvent.getEventId());
            }
            clientEvent.setVersionTag(tag);
        }
        return tag != null;
    }

    protected VersionTag findVersionTagsForRetriedBulkOp(LocalRegion region, EventID eventID) {
        VersionTag tag = region.findVersionTagForClientBulkOp(eventID);
        if (tag != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("recovered version tag {} for replayed bulk operation {}", (Object)tag, (Object)eventID);
            }
            return tag;
        }
        if (region instanceof DistributedRegion || region instanceof PartitionedRegion) {
            tag = FindVersionTagOperation.findVersionTag(region, eventID, true);
        }
        if (tag != null && logger.isDebugEnabled()) {
            logger.debug("recovered version tag {} for replayed bulk operation {}", (Object)tag, (Object)eventID);
        }
        return tag;
    }

    public abstract void cmdExecute(Message var1, ServerConnection var2, SecurityService var3, long var4) throws IOException, ClassNotFoundException, InterruptedException;

    protected void writeReply(Message origMsg, ServerConnection serverConnection) throws IOException {
        Message replyMsg = serverConnection.getReplyMessage();
        serverConnection.getCache().getCancelCriterion().checkCancelInProgress(null);
        replyMsg.setMessageType(6);
        replyMsg.setNumberOfParts(1);
        replyMsg.setTransactionId(origMsg.getTransactionId());
        replyMsg.addBytesPart(BaseCommand.okBytes());
        replyMsg.send(serverConnection);
        if (logger.isTraceEnabled()) {
            logger.trace("{}: rpl tx: {}", (Object)serverConnection.getName(), (Object)origMsg.getTransactionId());
        }
    }

    protected void writeReplyWithRefreshMetadata(Message origMsg, ServerConnection serverConnection, PartitionedRegion pr, byte nwHop) throws IOException {
        Message replyMsg = serverConnection.getReplyMessage();
        serverConnection.getCache().getCancelCriterion().checkCancelInProgress(null);
        replyMsg.setMessageType(6);
        replyMsg.setNumberOfParts(1);
        replyMsg.setTransactionId(origMsg.getTransactionId());
        replyMsg.addBytesPart(new byte[]{pr.getMetadataVersion(), nwHop});
        replyMsg.send(serverConnection);
        pr.getPrStats().incPRMetaDataSentCount();
        if (logger.isTraceEnabled()) {
            logger.trace("{}: rpl with REFRESH_METADATA tx: {}", (Object)serverConnection.getName(), (Object)origMsg.getTransactionId());
        }
    }

    private static void handleEOFException(Message msg, ServerConnection serverConnection, Exception eof) {
        CachedRegionHelper crHelper = serverConnection.getCachedRegionHelper();
        CacheServerStats stats = serverConnection.getCacheServerStats();
        boolean potentialModification = serverConnection.getPotentialModification();
        if (!crHelper.isShutdown()) {
            if (potentialModification) {
                stats.incAbandonedWriteRequests();
            } else {
                stats.incAbandonedReadRequests();
            }
            if (!SUPPRESS_IO_EXCEPTION_LOGGING) {
                if (potentialModification) {
                    int transId = msg != null ? msg.getTransactionId() : Integer.MIN_VALUE;
                    logger.warn("{}: EOFException during a write operation on region : {} key: {} messageId: {}", new Object[]{serverConnection.getName(), serverConnection.getModRegion(), serverConnection.getModKey(), transId});
                } else {
                    logger.debug("EOF exception", (Throwable)eof);
                    logger.warn("{}: connection disconnect detected by EOF.", (Object)serverConnection.getName());
                }
            }
        }
        serverConnection.setFlagProcessMessagesAsFalse();
        serverConnection.setClientDisconnectedException(eof);
    }

    private static void handleInterruptedIOException(ServerConnection serverConnection, Exception e) {
        CachedRegionHelper crHelper = serverConnection.getCachedRegionHelper();
        if (!crHelper.isShutdown() && serverConnection.isOpen() && !SUPPRESS_IO_EXCEPTION_LOGGING && logger.isDebugEnabled()) {
            logger.debug("Aborted message due to interrupt: {}", (Object)e.getMessage(), (Object)e);
        }
        serverConnection.setFlagProcessMessagesAsFalse();
        serverConnection.setClientDisconnectedException(e);
    }

    private static void handleIOException(Message msg, ServerConnection serverConnection, Exception e) {
        CachedRegionHelper crHelper = serverConnection.getCachedRegionHelper();
        boolean potentialModification = serverConnection.getPotentialModification();
        if (!crHelper.isShutdown() && serverConnection.isOpen() && !SUPPRESS_IO_EXCEPTION_LOGGING) {
            if (potentialModification) {
                int transId = msg != null ? msg.getTransactionId() : Integer.MIN_VALUE;
                logger.warn(String.format("%s: Unexpected IOException during operation for region: %s key: %s messId: %s", serverConnection.getName(), serverConnection.getModRegion(), serverConnection.getModKey(), transId), (Throwable)e);
            } else {
                logger.warn(String.format("%s: Unexpected IOException: ", serverConnection.getName()), (Throwable)e);
            }
        }
        serverConnection.setFlagProcessMessagesAsFalse();
        serverConnection.setClientDisconnectedException(e);
    }

    private static void handleShutdownException(Message msg, ServerConnection serverConnection, Exception e) {
        CachedRegionHelper crHelper = serverConnection.getCachedRegionHelper();
        boolean potentialModification = serverConnection.getPotentialModification();
        if (!crHelper.isShutdown()) {
            if (potentialModification) {
                int transId = msg != null ? msg.getTransactionId() : Integer.MIN_VALUE;
                logger.warn(String.format("%s: Unexpected ShutdownException during operation on region: %s key: %s messageId: %s", serverConnection.getName(), serverConnection.getModRegion(), serverConnection.getModKey(), transId), (Throwable)e);
            } else {
                logger.warn(String.format("%s: Unexpected ShutdownException: ", serverConnection.getName()), (Throwable)e);
            }
        }
        serverConnection.setFlagProcessMessagesAsFalse();
        serverConnection.setClientDisconnectedException(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleExceptionNoDisconnect(Message msg, ServerConnection serverConnection, Exception e) {
        block22: {
            boolean requiresResponse = serverConnection.getTransientFlag(2);
            boolean responded = serverConnection.getTransientFlag(1);
            boolean requiresChunkedResponse = serverConnection.getTransientFlag(3);
            boolean potentialModification = serverConnection.getPotentialModification();
            try {
                boolean wroteExceptionResponse;
                block21: {
                    int transId;
                    wroteExceptionResponse = false;
                    try {
                        if (requiresResponse && !responded) {
                            if (requiresChunkedResponse) {
                                BaseCommand.writeChunkedException(msg, e, serverConnection);
                            } else {
                                BaseCommand.writeException(msg, e, false, serverConnection);
                            }
                            wroteExceptionResponse = true;
                            serverConnection.setAsTrue(1);
                        }
                        if (!potentialModification) break block21;
                        int n = transId = msg != null ? msg.getTransactionId() : Integer.MIN_VALUE;
                    }
                    catch (Throwable throwable) {
                        if (potentialModification) {
                            int transId2;
                            int n = transId2 = msg != null ? msg.getTransactionId() : Integer.MIN_VALUE;
                            if (!wroteExceptionResponse) {
                                logger.warn(String.format("%s: Unexpected Exception during operation on region: %s key: %s messageId: %s", serverConnection.getName(), serverConnection.getModRegion(), serverConnection.getModKey(), transId2), (Throwable)e);
                            } else if (logger.isDebugEnabled()) {
                                logger.debug("{}: Exception during operation on region: {} key: {} messageId: {}", (Object)serverConnection.getName(), (Object)serverConnection.getModRegion(), serverConnection.getModKey(), (Object)transId2, (Object)e);
                            }
                        } else if (!wroteExceptionResponse) {
                            logger.warn(String.format("%s: Unexpected Exception", serverConnection.getName()), (Throwable)e);
                        } else if (logger.isDebugEnabled()) {
                            logger.debug("{}: Exception: {}", (Object)serverConnection.getName(), (Object)e.getMessage(), (Object)e);
                        }
                        throw throwable;
                    }
                    if (!wroteExceptionResponse) {
                        logger.warn(String.format("%s: Unexpected Exception during operation on region: %s key: %s messageId: %s", serverConnection.getName(), serverConnection.getModRegion(), serverConnection.getModKey(), transId), (Throwable)e);
                    } else if (logger.isDebugEnabled()) {
                        logger.debug("{}: Exception during operation on region: {} key: {} messageId: {}", (Object)serverConnection.getName(), (Object)serverConnection.getModRegion(), serverConnection.getModKey(), (Object)transId, (Object)e);
                    }
                    break block22;
                }
                if (!wroteExceptionResponse) {
                    logger.warn(String.format("%s: Unexpected Exception", serverConnection.getName()), (Throwable)e);
                } else if (logger.isDebugEnabled()) {
                    logger.debug("{}: Exception: {}", (Object)serverConnection.getName(), (Object)e.getMessage(), (Object)e);
                }
            }
            catch (IOException ioe) {
                if (!logger.isDebugEnabled()) break block22;
                logger.debug("{}: Unexpected IOException writing exception: {}", (Object)serverConnection.getName(), (Object)ioe.getMessage(), (Object)ioe);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleThrowable(Message msg, ServerConnection serverConnection, Throwable th) {
        boolean requiresResponse = serverConnection.getTransientFlag(2);
        boolean responded = serverConnection.getTransientFlag(1);
        boolean requiresChunkedResponse = serverConnection.getTransientFlag(3);
        boolean potentialModification = serverConnection.getPotentialModification();
        try {
            block17: {
                try {
                    if (th instanceof Error) {
                        logger.fatal(String.format("%s : Unexpected Error on server", serverConnection.getName()), th);
                    }
                    if (!requiresResponse || responded) break block17;
                    if (requiresChunkedResponse) {
                        BaseCommand.writeChunkedException(msg, th, serverConnection);
                    } else {
                        BaseCommand.writeException(msg, th, false, serverConnection);
                    }
                    serverConnection.setAsTrue(1);
                }
                catch (Throwable throwable) {
                    if (!(th instanceof Error) && !(th instanceof CacheLoaderException)) {
                        if (potentialModification) {
                            int transId = msg != null ? msg.getTransactionId() : Integer.MIN_VALUE;
                            logger.warn(String.format("%s: Unexpected Exception during operation on region: %s key: %s messageId: %s", serverConnection.getName(), serverConnection.getModRegion(), serverConnection.getModKey(), transId), th);
                        } else {
                            logger.warn(String.format("%s: Unexpected Exception", serverConnection.getName()), th);
                        }
                    }
                    throw throwable;
                }
            }
            if (!(th instanceof Error) && !(th instanceof CacheLoaderException)) {
                if (potentialModification) {
                    int transId = msg != null ? msg.getTransactionId() : Integer.MIN_VALUE;
                    logger.warn(String.format("%s: Unexpected Exception during operation on region: %s key: %s messageId: %s", serverConnection.getName(), serverConnection.getModRegion(), serverConnection.getModKey(), transId), th);
                } else {
                    logger.warn(String.format("%s: Unexpected Exception", serverConnection.getName()), th);
                }
            }
        }
        catch (IOException ioe) {
            if (logger.isDebugEnabled()) {
                logger.debug("{}: Unexpected IOException writing exception: {}", (Object)serverConnection.getName(), (Object)ioe.getMessage(), (Object)ioe);
            }
        }
        finally {
            serverConnection.setFlagProcessMessagesAsFalse();
            serverConnection.setClientDisconnectedException(th);
        }
    }

    protected static void writeChunkedException(Message origMsg, Throwable e, ServerConnection serverConnection) throws IOException {
        BaseCommand.writeChunkedException(origMsg, e, serverConnection, serverConnection.getChunkedResponseMessage());
    }

    protected static void writeChunkedException(Message origMsg, Throwable e, ServerConnection serverConnection, ChunkedMessage originalResponse) throws IOException {
        BaseCommand.writeChunkedException(origMsg, e, serverConnection, originalResponse, 2);
    }

    private static void writeChunkedException(Message origMsg, Throwable exception, ServerConnection serverConnection, ChunkedMessage originalResponse, int numOfParts) throws IOException {
        Throwable e = BaseCommand.getClientException(serverConnection, exception);
        ChunkedMessage chunkedResponseMsg = serverConnection.getChunkedResponseMessage();
        chunkedResponseMsg.setServerConnection(serverConnection);
        if (originalResponse.headerHasBeenSent()) {
            chunkedResponseMsg.setNumberOfParts(numOfParts);
            chunkedResponseMsg.setLastChunkAndNumParts(true, numOfParts);
            chunkedResponseMsg.addObjPart(e);
            if (numOfParts == 2) {
                chunkedResponseMsg.addStringPart(BaseCommand.getExceptionTrace(e));
            }
            if (logger.isDebugEnabled()) {
                logger.debug("{}: Sending exception chunk while reply in progress: {}", (Object)serverConnection.getName(), (Object)e.getMessage(), (Object)e);
            }
        } else {
            chunkedResponseMsg.setMessageType(2);
            chunkedResponseMsg.setNumberOfParts(numOfParts);
            chunkedResponseMsg.setLastChunkAndNumParts(true, numOfParts);
            chunkedResponseMsg.setTransactionId(origMsg.getTransactionId());
            chunkedResponseMsg.sendHeader();
            chunkedResponseMsg.addObjPart(e);
            if (numOfParts == 2) {
                chunkedResponseMsg.addStringPart(BaseCommand.getExceptionTrace(e));
            }
            if (logger.isDebugEnabled()) {
                logger.debug("{}: Sending exception chunk: {}", (Object)serverConnection.getName(), (Object)e.getMessage(), (Object)e);
            }
        }
        chunkedResponseMsg.sendChunk(serverConnection);
    }

    public static String getExceptionTrace(Throwable ex) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        ex.printStackTrace(pw);
        pw.close();
        return sw.toString();
    }

    protected static void writeException(Message origMsg, Throwable e, boolean isSevere, ServerConnection serverConnection) throws IOException {
        BaseCommand.writeException(origMsg, 2, e, isSevere, serverConnection);
    }

    private static Throwable getClientException(ServerConnection serverConnection, Throwable e) {
        OldClientSupportService svc;
        InternalCache cache = serverConnection.getCache();
        if (cache != null && (svc = cache.getService(OldClientSupportService.class)) != null) {
            return svc.getThrowable(e, serverConnection.getClientVersion());
        }
        return e;
    }

    protected static void writeException(Message origMsg, int msgType, Throwable e, boolean isSevere, ServerConnection serverConnection) throws IOException {
        Throwable theException = BaseCommand.getClientException(serverConnection, e);
        Message errorMsg = serverConnection.getErrorResponseMessage();
        errorMsg.setMessageType(msgType);
        errorMsg.setNumberOfParts(2);
        errorMsg.setTransactionId(origMsg.getTransactionId());
        if (isSevere) {
            String msg = theException.getMessage();
            if (msg == null) {
                msg = theException.toString();
            }
            logger.fatal("Severe cache exception : {}", (Object)msg);
        }
        errorMsg.addObjPart(theException);
        errorMsg.addStringPart(BaseCommand.getExceptionTrace(theException));
        errorMsg.send(serverConnection);
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Wrote exception: {}", (Object)serverConnection.getName(), (Object)e.getMessage(), (Object)e);
        }
        if (e instanceof MessageTooLargeException) {
            throw (IOException)e;
        }
    }

    protected static void writeErrorResponse(Message origMsg, int messageType, ServerConnection serverConnection) throws IOException {
        Message errorMsg = serverConnection.getErrorResponseMessage();
        errorMsg.setMessageType(messageType);
        errorMsg.setNumberOfParts(1);
        errorMsg.setTransactionId(origMsg.getTransactionId());
        errorMsg.addStringPart("Invalid data received. Please see the cache server log file for additional details.");
        errorMsg.send(serverConnection);
    }

    protected static void writeErrorResponse(Message origMsg, int messageType, String msg, ServerConnection serverConnection) throws IOException {
        Message errorMsg = serverConnection.getErrorResponseMessage();
        errorMsg.setMessageType(messageType);
        errorMsg.setNumberOfParts(1);
        errorMsg.setTransactionId(origMsg.getTransactionId());
        errorMsg.addStringPart(msg);
        errorMsg.send(serverConnection);
    }

    protected static void writeRegionDestroyedEx(Message msg, String regionName, String title, ServerConnection serverConnection) throws IOException {
        String reason = serverConnection.getName() + ": Region named " + regionName + title;
        RegionDestroyedException ex = new RegionDestroyedException(reason, regionName);
        if (serverConnection.getTransientFlag(3)) {
            BaseCommand.writeChunkedException(msg, ex, serverConnection);
        } else {
            BaseCommand.writeException(msg, ex, false, serverConnection);
        }
    }

    protected static void writeResponse(Object data, Object callbackArg, Message origMsg, boolean isObject, ServerConnection serverConnection) throws IOException {
        Message responseMsg = serverConnection.getResponseMessage();
        responseMsg.setMessageType(1);
        responseMsg.setTransactionId(origMsg.getTransactionId());
        if (callbackArg == null) {
            responseMsg.setNumberOfParts(1);
        } else {
            responseMsg.setNumberOfParts(2);
        }
        if (data instanceof byte[]) {
            responseMsg.addRawPart((byte[])data, isObject);
        } else {
            Assert.assertTrue(isObject, "isObject should be true when value is not a byte[]");
            responseMsg.addObjPart(data, false);
        }
        if (callbackArg != null) {
            responseMsg.addObjPart(callbackArg);
        }
        serverConnection.getCache().getCancelCriterion().checkCancelInProgress(null);
        responseMsg.send(serverConnection);
        origMsg.clearParts();
    }

    protected static void writeResponseWithRefreshMetadata(Object data, Object callbackArg, Message origMsg, boolean isObject, ServerConnection serverConnection, PartitionedRegion pr, byte nwHop) throws IOException {
        Message responseMsg = serverConnection.getResponseMessage();
        responseMsg.setMessageType(1);
        responseMsg.setTransactionId(origMsg.getTransactionId());
        if (callbackArg == null) {
            responseMsg.setNumberOfParts(2);
        } else {
            responseMsg.setNumberOfParts(3);
        }
        if (data instanceof byte[]) {
            responseMsg.addRawPart((byte[])data, isObject);
        } else {
            Assert.assertTrue(isObject, "isObject should be true when value is not a byte[]");
            responseMsg.addObjPart(data, false);
        }
        if (callbackArg != null) {
            responseMsg.addObjPart(callbackArg);
        }
        responseMsg.addBytesPart(new byte[]{pr.getMetadataVersion(), nwHop});
        serverConnection.getCache().getCancelCriterion().checkCancelInProgress(null);
        responseMsg.send(serverConnection);
        origMsg.clearParts();
    }

    protected static void writeResponseWithFunctionAttribute(byte[] data, Message origMsg, ServerConnection serverConnection) throws IOException {
        Message responseMsg = serverConnection.getResponseMessage();
        responseMsg.setMessageType(1);
        responseMsg.setTransactionId(origMsg.getTransactionId());
        responseMsg.setNumberOfParts(1);
        responseMsg.addBytesPart(data);
        serverConnection.getCache().getCancelCriterion().checkCancelInProgress(null);
        responseMsg.send(serverConnection);
        origMsg.clearParts();
    }

    protected static void checkForInterrupt(ServerConnection serverConnection, Exception e) throws InterruptedException, InterruptedIOException {
        serverConnection.getCachedRegionHelper().checkCancelInProgress(e);
        if (e instanceof InterruptedException) {
            throw (InterruptedException)e;
        }
        if (e instanceof InterruptedIOException) {
            throw (InterruptedIOException)e;
        }
    }

    static void writeQueryResponseChunk(Object queryResponseChunk, CollectionType collectionType, boolean lastChunk, ServerConnection serverConnection) throws IOException {
        ChunkedMessage queryResponseMsg = serverConnection.getQueryResponseMessage();
        queryResponseMsg.setNumberOfParts(2);
        queryResponseMsg.setLastChunk(lastChunk);
        queryResponseMsg.addObjPart(collectionType, false);
        queryResponseMsg.addObjPart(queryResponseChunk, false);
        queryResponseMsg.sendChunk(serverConnection);
    }

    protected static void writeQueryResponseException(Message origMsg, Throwable exception, ServerConnection serverConnection) throws IOException {
        Throwable e = BaseCommand.getClientException(serverConnection, exception);
        ChunkedMessage queryResponseMsg = serverConnection.getQueryResponseMessage();
        ChunkedMessage chunkedResponseMsg = serverConnection.getChunkedResponseMessage();
        if (queryResponseMsg.headerHasBeenSent()) {
            queryResponseMsg.setServerConnection(serverConnection);
            queryResponseMsg.setNumberOfParts(2);
            queryResponseMsg.setLastChunkAndNumParts(true, 2);
            queryResponseMsg.addObjPart(e);
            queryResponseMsg.addStringPart(BaseCommand.getExceptionTrace(e));
            if (logger.isDebugEnabled()) {
                logger.debug("{}: Sending exception chunk while reply in progress: {}", (Object)serverConnection.getName(), (Object)e.getMessage(), (Object)e);
            }
            queryResponseMsg.sendChunk(serverConnection);
        } else {
            chunkedResponseMsg.setServerConnection(serverConnection);
            chunkedResponseMsg.setMessageType(2);
            chunkedResponseMsg.setNumberOfParts(2);
            chunkedResponseMsg.setLastChunkAndNumParts(true, 2);
            chunkedResponseMsg.setTransactionId(origMsg.getTransactionId());
            chunkedResponseMsg.sendHeader();
            chunkedResponseMsg.addObjPart(e);
            chunkedResponseMsg.addStringPart(BaseCommand.getExceptionTrace(e));
            if (logger.isDebugEnabled()) {
                logger.debug("{}: Sending exception chunk: {}", (Object)serverConnection.getName(), (Object)e.getMessage(), (Object)e);
            }
            chunkedResponseMsg.sendChunk(serverConnection);
        }
    }

    protected static void writeChunkedErrorResponse(Message origMsg, int messageType, String message, ServerConnection serverConnection) throws IOException {
        ChunkedMessage chunkedResponseMsg = serverConnection.getChunkedResponseMessage();
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Sending error message header type: {} transaction: {}", (Object)serverConnection.getName(), (Object)messageType, (Object)origMsg.getTransactionId());
        }
        chunkedResponseMsg.setMessageType(messageType);
        chunkedResponseMsg.setTransactionId(origMsg.getTransactionId());
        chunkedResponseMsg.sendHeader();
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Sending error message chunk: {}", (Object)serverConnection.getName(), (Object)message);
        }
        chunkedResponseMsg.setNumberOfParts(1);
        chunkedResponseMsg.setLastChunk(true);
        chunkedResponseMsg.addStringPart(message);
        chunkedResponseMsg.sendChunk(serverConnection);
    }

    protected static void writeFunctionResponseException(Message origMsg, int messageType, ServerConnection serverConnection, Throwable exception) throws IOException {
        Throwable e = BaseCommand.getClientException(serverConnection, exception);
        ChunkedMessage functionResponseMsg = serverConnection.getFunctionResponseMessage();
        ChunkedMessage chunkedResponseMsg = serverConnection.getChunkedResponseMessage();
        if (functionResponseMsg.headerHasBeenSent()) {
            functionResponseMsg.setServerConnection(serverConnection);
            functionResponseMsg.setNumberOfParts(2);
            functionResponseMsg.setLastChunkAndNumParts(true, 2);
            functionResponseMsg.addObjPart(e);
            functionResponseMsg.addStringPart(BaseCommand.getExceptionTrace(e));
            if (logger.isDebugEnabled()) {
                logger.debug("{}: Sending exception chunk while reply in progress: {}", (Object)serverConnection.getName(), (Object)e.getMessage(), (Object)e);
            }
            functionResponseMsg.sendChunk(serverConnection);
        } else {
            chunkedResponseMsg.setServerConnection(serverConnection);
            chunkedResponseMsg.setMessageType(messageType);
            chunkedResponseMsg.setNumberOfParts(2);
            chunkedResponseMsg.setLastChunkAndNumParts(true, 2);
            chunkedResponseMsg.setTransactionId(origMsg.getTransactionId());
            chunkedResponseMsg.sendHeader();
            chunkedResponseMsg.addObjPart(e);
            chunkedResponseMsg.addStringPart(BaseCommand.getExceptionTrace(e));
            if (logger.isDebugEnabled()) {
                logger.debug("{}: Sending exception chunk: {}", (Object)serverConnection.getName(), (Object)e.getMessage(), (Object)e);
            }
            chunkedResponseMsg.sendChunk(serverConnection);
        }
    }

    protected static void writeFunctionResponseError(Message origMsg, int messageType, String message, ServerConnection servConn) throws IOException {
        ChunkedMessage functionResponseMsg = servConn.getFunctionResponseMessage();
        ChunkedMessage chunkedResponseMsg = servConn.getChunkedResponseMessage();
        if (functionResponseMsg.headerHasBeenSent()) {
            functionResponseMsg.setNumberOfParts(1);
            functionResponseMsg.setLastChunk(true);
            functionResponseMsg.addStringPart(message);
            if (logger.isDebugEnabled()) {
                logger.debug("{}: Sending Error chunk while reply in progress: {}", (Object)servConn.getName(), (Object)message);
            }
            functionResponseMsg.sendChunk(servConn);
        } else {
            chunkedResponseMsg.setMessageType(messageType);
            chunkedResponseMsg.setNumberOfParts(1);
            chunkedResponseMsg.setLastChunk(true);
            chunkedResponseMsg.setTransactionId(origMsg.getTransactionId());
            chunkedResponseMsg.sendHeader();
            chunkedResponseMsg.addStringPart(message);
            if (logger.isDebugEnabled()) {
                logger.debug("{}: Sending Error chunk: {}", (Object)servConn.getName(), (Object)message);
            }
            chunkedResponseMsg.sendChunk(servConn);
        }
    }

    protected static void writeKeySetErrorResponse(Message origMsg, int messageType, String message, ServerConnection servConn) throws IOException {
        ChunkedMessage chunkedResponseMsg = servConn.getKeySetResponseMessage();
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Sending error message header type: {} transaction: {}", (Object)servConn.getName(), (Object)messageType, (Object)origMsg.getTransactionId());
        }
        chunkedResponseMsg.setMessageType(messageType);
        chunkedResponseMsg.setTransactionId(origMsg.getTransactionId());
        chunkedResponseMsg.sendHeader();
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Sending error message chunk: {}", (Object)servConn.getName(), (Object)message);
        }
        chunkedResponseMsg.setNumberOfParts(1);
        chunkedResponseMsg.setLastChunk(true);
        chunkedResponseMsg.addStringPart(message);
        chunkedResponseMsg.sendChunk(servConn);
    }

    static Message readRequest(ServerConnection servConn) {
        Message requestMsg = null;
        try {
            requestMsg = servConn.getRequestMessage();
            requestMsg.receive(servConn, MAX_INCOMING_DATA, INCOMING_DATA_LIMITER, INCOMING_MSG_LIMITER);
            return requestMsg;
        }
        catch (EOFException eof) {
            BaseCommand.handleEOFException(null, servConn, eof);
        }
        catch (InterruptedIOException e) {
            BaseCommand.handleInterruptedIOException(servConn, e);
        }
        catch (IOException e) {
            BaseCommand.handleIOException(null, servConn, e);
        }
        catch (DistributedSystemDisconnectedException e) {
            BaseCommand.handleShutdownException(null, servConn, e);
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Throwable e) {
            SystemFailure.checkFailure();
            BaseCommand.handleThrowable(null, servConn, e);
        }
        return requestMsg;
    }

    protected static void fillAndSendRegisterInterestResponseChunks(LocalRegion region, Object riKey, int interestType2, InterestResultPolicy policy, ServerConnection servConn) throws IOException {
        BaseCommand.fillAndSendRegisterInterestResponseChunks(region, riKey, interestType2, false, policy, servConn);
    }

    protected static void fillAndSendRegisterInterestResponseChunks(LocalRegion region, Object riKey, int interestType2, boolean serializeValues, InterestResultPolicy policy, ServerConnection servConn) throws IOException {
        if (policy.isNone()) {
            BaseCommand.sendRegisterInterestResponseChunk(region, riKey, new ArrayList(), true, servConn);
            return;
        }
        if (policy.isKeysValues() && servConn.getClientVersion().compareTo(Version.GFE_80) >= 0) {
            BaseCommand.handleKeysValuesPolicy(region, riKey, interestType2, serializeValues, servConn);
            return;
        }
        if (riKey instanceof List) {
            BaseCommand.handleList(region, (List)riKey, policy, servConn);
            return;
        }
        if (!(riKey instanceof String)) {
            BaseCommand.handleSingleton(region, riKey, policy, servConn);
            return;
        }
        switch (interestType2) {
            case 3: {
                throw new InternalGemFireError("not yet supported");
            }
            case 2: {
                throw new InternalGemFireError("not yet supported");
            }
            case 1: {
                String regEx = (String)riKey;
                if (regEx.equals(".*")) {
                    BaseCommand.handleAllKeys(region, policy, servConn);
                    break;
                }
                BaseCommand.handleRegEx(region, regEx, policy, servConn);
                break;
            }
            case 0: {
                if (riKey.equals("ALL_KEYS")) {
                    BaseCommand.handleAllKeys(region, policy, servConn);
                    break;
                }
                BaseCommand.handleSingleton(region, riKey, policy, servConn);
                break;
            }
            default: {
                throw new InternalGemFireError("unknown interest type");
            }
        }
    }

    private static void handleKeysValuesPolicy(LocalRegion region, Object riKey, int interestType2, boolean serializeValues, ServerConnection servConn) throws IOException {
        if (riKey instanceof List) {
            BaseCommand.handleKVList(region, (List)riKey, serializeValues, servConn);
            return;
        }
        if (!(riKey instanceof String)) {
            BaseCommand.handleKVSingleton(region, riKey, serializeValues, servConn);
            return;
        }
        switch (interestType2) {
            case 3: {
                throw new InternalGemFireError("not yet supported");
            }
            case 2: {
                throw new InternalGemFireError("not yet supported");
            }
            case 1: {
                String regEx = (String)riKey;
                if (regEx.equals(".*")) {
                    BaseCommand.handleKVAllKeys(region, null, serializeValues, servConn);
                    break;
                }
                BaseCommand.handleKVAllKeys(region, regEx, serializeValues, servConn);
                break;
            }
            case 0: {
                if (riKey.equals("ALL_KEYS")) {
                    BaseCommand.handleKVAllKeys(region, null, serializeValues, servConn);
                    break;
                }
                BaseCommand.handleKVSingleton(region, riKey, serializeValues, servConn);
                break;
            }
            default: {
                throw new InternalGemFireError("unknown interest type");
            }
        }
    }

    private static void sendRegisterInterestResponseChunk(Region region, Object riKey, List list, boolean lastChunk, ServerConnection servConn) throws IOException {
        String regionName;
        ChunkedMessage chunkedResponseMsg = servConn.getRegisterInterestResponseMessage();
        chunkedResponseMsg.setNumberOfParts(1);
        chunkedResponseMsg.setLastChunk(lastChunk);
        chunkedResponseMsg.addObjPart(list, false);
        String string = regionName = region == null ? " null " : region.getFullPath();
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Sending{}register interest response chunk for region: {} for keys: {} chunk=<{}>", (Object)servConn.getName(), (Object)(lastChunk ? " last " : " "), (Object)regionName, riKey, (Object)chunkedResponseMsg);
        }
        chunkedResponseMsg.sendChunk(servConn);
    }

    private static boolean sendTombstonesInRIResults(ServerConnection servConn, InterestResultPolicy policy) {
        return policy == InterestResultPolicy.KEYS_VALUES && servConn.getClientVersion().compareTo(Version.GFE_80) >= 0;
    }

    private static void handleList(LocalRegion region, List keyList, InterestResultPolicy policy, ServerConnection servConn) throws IOException {
        if (region instanceof PartitionedRegion) {
            BaseCommand.handleListPR((PartitionedRegion)region, keyList, policy, servConn);
            return;
        }
        ArrayList newKeyList = new ArrayList(MAXIMUM_CHUNK_SIZE);
        if (region != null) {
            for (Object entryKey : keyList) {
                if (!region.containsKey(entryKey) && (!BaseCommand.sendTombstonesInRIResults(servConn, policy) || !region.containsTombstone(entryKey))) continue;
                BaseCommand.appendInterestResponseKey(region, keyList, entryKey, newKeyList, servConn);
            }
        }
        BaseCommand.sendRegisterInterestResponseChunk(region, keyList, newKeyList, true, servConn);
    }

    @SuppressWarnings(value={"NP_NULL_PARAM_DEREF"}, justification="Null value handled in sendNewRegisterInterestResponseChunk()")
    private static void handleKVSingleton(LocalRegion region, Object entryKey, boolean serializeValues, ServerConnection servConn) throws IOException {
        VersionedObjectList values = new VersionedObjectList(MAXIMUM_CHUNK_SIZE, true, region == null || region.getAttributes().getConcurrencyChecksEnabled(), serializeValues);
        if (region != null && (region.containsKey(entryKey) || region.containsTombstone(entryKey))) {
            VersionTagHolder versionHolder = BaseCommand.createVersionTagHolder();
            ClientProxyMembershipID id = servConn == null ? null : servConn.getProxyID();
            Object data = region.get(entryKey, null, true, true, true, id, versionHolder, true);
            VersionTag vt = versionHolder.getVersionTag();
            BaseCommand.updateValues(values, entryKey, data, vt);
        }
        BaseCommand.sendNewRegisterInterestResponseChunk(region, entryKey, values, true, servConn);
    }

    private static void handleSingleton(LocalRegion region, Object entryKey, InterestResultPolicy policy, ServerConnection servConn) throws IOException {
        ArrayList keyList = new ArrayList(1);
        if (region != null && (region.containsKey(entryKey) || BaseCommand.sendTombstonesInRIResults(servConn, policy) && region.containsTombstone(entryKey))) {
            BaseCommand.appendInterestResponseKey(region, entryKey, entryKey, keyList, servConn);
        }
        BaseCommand.sendRegisterInterestResponseChunk(region, entryKey, keyList, true, servConn);
    }

    private static void handleAllKeys(LocalRegion region, InterestResultPolicy policy, ServerConnection servConn) throws IOException {
        ArrayList keyList = new ArrayList(MAXIMUM_CHUNK_SIZE);
        if (region != null) {
            for (Object entryKey : region.keySet(BaseCommand.sendTombstonesInRIResults(servConn, policy))) {
                BaseCommand.appendInterestResponseKey(region, "ALL_KEYS", entryKey, keyList, servConn);
            }
        }
        BaseCommand.sendRegisterInterestResponseChunk(region, "ALL_KEYS", keyList, true, servConn);
    }

    private static void handleKVAllKeys(LocalRegion region, String regex, boolean serializeValues, ServerConnection servConn) throws IOException {
        if (region instanceof PartitionedRegion) {
            BaseCommand.handleKVKeysPR((PartitionedRegion)region, regex, serializeValues, servConn);
            return;
        }
        VersionedObjectList values = new VersionedObjectList(MAXIMUM_CHUNK_SIZE, true, region == null || region.getAttributes().getConcurrencyChecksEnabled(), serializeValues);
        if (region != null) {
            Pattern keyPattern = null;
            if (regex != null) {
                keyPattern = Pattern.compile(regex);
            }
            for (Object key : region.keySet(true)) {
                VersionTagHolder versionHolder = BaseCommand.createVersionTagHolder();
                if (keyPattern != null && (!(key instanceof String) || !keyPattern.matcher((String)key).matches())) continue;
                ClientProxyMembershipID id = servConn == null ? null : servConn.getProxyID();
                Object data = region.get(key, null, true, true, true, id, versionHolder, true);
                VersionTag versionTag = versionHolder.getVersionTag();
                BaseCommand.updateValues(values, key, data, versionTag);
                if (values.size() != MAXIMUM_CHUNK_SIZE) continue;
                BaseCommand.sendNewRegisterInterestResponseChunk(region, regex != null ? regex : "ALL_KEYS", values, false, servConn);
                values.clear();
            }
        }
        BaseCommand.sendNewRegisterInterestResponseChunk(region, regex != null ? regex : "ALL_KEYS", values, true, servConn);
    }

    private static void handleKVKeysPR(PartitionedRegion region, Object keyInfo, boolean serializeValues, ServerConnection servConn) throws IOException {
        VersionedObjectList values = new VersionedObjectList(MAXIMUM_CHUNK_SIZE, true, region.getConcurrencyChecksEnabled(), serializeValues);
        if (keyInfo instanceof List) {
            HashMap<Integer, HashSet> bucketKeys = new HashMap<Integer, HashSet>();
            for (Object key : (List)keyInfo) {
                int id = PartitionedRegionHelper.getHashKey(region, null, key, null, null);
                if (bucketKeys.containsKey(id)) {
                    bucketKeys.get(id).add(key);
                    continue;
                }
                HashSet keys = new HashSet();
                keys.add(key);
                bucketKeys.put(id, keys);
            }
            region.fetchEntries(bucketKeys, values, servConn);
        } else {
            region.fetchEntries((String)keyInfo, values, servConn);
        }
        BaseCommand.sendNewRegisterInterestResponseChunk(region, keyInfo != null ? keyInfo : "ALL_KEYS", values, true, servConn);
    }

    private static void updateValues(VersionedObjectList values, Object key, Object value, VersionTag versionTag) {
        boolean keyNotPresent;
        boolean isObject = true;
        boolean wasInvalid = false;
        if (value instanceof CachedDeserializable) {
            value = ((CachedDeserializable)value).getValue();
        } else if (BaseCommand.isRemovalToken(value)) {
            value = null;
        } else if (value == Token.INVALID || value == Token.LOCAL_INVALID) {
            value = null;
            wasInvalid = true;
        } else if (value instanceof byte[]) {
            isObject = false;
        }
        boolean bl = keyNotPresent = !wasInvalid && (value == null || value == Token.TOMBSTONE);
        if (keyNotPresent) {
            values.addObjectPartForAbsentKey(key, value, versionTag);
        } else {
            values.addObjectPart(key, value, isObject, versionTag);
        }
    }

    private static boolean isRemovalToken(Object value) {
        return value == Token.REMOVED_PHASE1 || value == Token.REMOVED_PHASE2 || value == Token.DESTROYED || value == Token.TOMBSTONE;
    }

    public static void appendNewRegisterInterestResponseChunkFromLocal(LocalRegion region, VersionedObjectList values, Object riKeys, Set keySet, ServerConnection servConn) throws IOException {
        ClientProxyMembershipID requestingClient = servConn == null ? null : servConn.getProxyID();
        for (Object key : keySet) {
            VersionTagHolder versionHolder = BaseCommand.createVersionTagHolder();
            Object value = region.get(key, null, true, true, true, requestingClient, versionHolder, true);
            BaseCommand.updateValues(values, key, value, versionHolder.getVersionTag());
            if (values.size() != MAXIMUM_CHUNK_SIZE) continue;
            BaseCommand.sendNewRegisterInterestResponseChunk(region, riKeys != null ? riKeys : "ALL_KEYS", values, false, servConn);
            values.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void appendNewRegisterInterestResponseChunk(LocalRegion region, VersionedObjectList values, Object riKeys, Set<Map.Entry> set, ServerConnection servConn) throws IOException {
        for (Map.Entry entry : set) {
            if (entry instanceof Region.Entry) {
                Object value;
                Object key;
                VersionTag vt;
                if (entry instanceof EntrySnapshot) {
                    vt = ((EntrySnapshot)entry).getVersionTag();
                    key = ((EntrySnapshot)entry).getRegionEntry().getKey();
                    value = ((EntrySnapshot)entry).getRegionEntry().getValue(null);
                    BaseCommand.updateValues(values, key, value, vt);
                } else {
                    VersionStamp vs = ((NonTXEntry)entry).getRegionEntry().getVersionStamp();
                    vt = vs == null ? null : vs.asVersionTag();
                    key = entry.getKey();
                    value = ((NonTXEntry)entry).getRegionEntry().getValueRetain(region, true);
                    try {
                        BaseCommand.updateValues(values, key, value, vt);
                    }
                    finally {
                        OffHeapHelper.release(value);
                    }
                }
            } else {
                List list = (List)entry.getValue();
                Object value = list.get(0);
                VersionTag tag = (VersionTag)list.get(1);
                BaseCommand.updateValues(values, entry.getKey(), value, tag);
            }
            if (values.size() != MAXIMUM_CHUNK_SIZE) continue;
            BaseCommand.sendNewRegisterInterestResponseChunk(region, riKeys != null ? riKeys : "ALL_KEYS", values, false, servConn);
            values.clear();
        }
    }

    public static void sendNewRegisterInterestResponseChunk(LocalRegion region, Object riKey, VersionedObjectList list, boolean lastChunk, ServerConnection servConn) throws IOException {
        String regionName;
        ChunkedMessage chunkedResponseMsg = servConn.getRegisterInterestResponseMessage();
        chunkedResponseMsg.setNumberOfParts(1);
        chunkedResponseMsg.setLastChunk(lastChunk);
        chunkedResponseMsg.addObjPart(list, false);
        String string = regionName = region == null ? " null " : region.getFullPath();
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Sending{}register interest response chunk for region: {} for keys: {} chunk=<{}>", (Object)servConn.getName(), (Object)(lastChunk ? " last " : " "), (Object)regionName, riKey, (Object)chunkedResponseMsg);
        }
        chunkedResponseMsg.sendChunk(servConn);
    }

    private static void handleRegEx(LocalRegion region, String regex, InterestResultPolicy policy, ServerConnection servConn) throws IOException {
        if (region instanceof PartitionedRegion) {
            BaseCommand.handleRegExPR((PartitionedRegion)region, regex, policy, servConn);
            return;
        }
        ArrayList keyList = new ArrayList(MAXIMUM_CHUNK_SIZE);
        if (region != null) {
            Pattern keyPattern = Pattern.compile(regex);
            for (Object entryKey : region.keySet(BaseCommand.sendTombstonesInRIResults(servConn, policy))) {
                if (!(entryKey instanceof String) || !keyPattern.matcher((String)entryKey).matches()) continue;
                BaseCommand.appendInterestResponseKey(region, regex, entryKey, keyList, servConn);
            }
        }
        BaseCommand.sendRegisterInterestResponseChunk(region, regex, keyList, true, servConn);
    }

    private static void handleRegExPR(final PartitionedRegion region, final String regex, InterestResultPolicy policy, final ServerConnection servConn) throws IOException {
        final ArrayList keyList = new ArrayList(MAXIMUM_CHUNK_SIZE);
        region.getKeysWithRegEx(regex, BaseCommand.sendTombstonesInRIResults(servConn, policy), new PartitionedRegion.SetCollector(){

            @Override
            public void receiveSet(Set theSet) throws IOException {
                BaseCommand.appendInterestResponseKeys(region, regex, theSet, keyList, servConn);
            }
        });
        BaseCommand.sendRegisterInterestResponseChunk(region, regex, keyList, true, servConn);
    }

    private static void handleListPR(final PartitionedRegion region, final List keyList, InterestResultPolicy policy, final ServerConnection servConn) throws IOException {
        final ArrayList newKeyList = new ArrayList(MAXIMUM_CHUNK_SIZE);
        region.getKeysWithList(keyList, BaseCommand.sendTombstonesInRIResults(servConn, policy), new PartitionedRegion.SetCollector(){

            @Override
            public void receiveSet(Set theSet) throws IOException {
                BaseCommand.appendInterestResponseKeys(region, keyList, theSet, newKeyList, servConn);
            }
        });
        BaseCommand.sendRegisterInterestResponseChunk(region, keyList, newKeyList, true, servConn);
    }

    private static void handleKVList(LocalRegion region, List keyList, boolean serializeValues, ServerConnection servConn) throws IOException {
        if (region instanceof PartitionedRegion) {
            BaseCommand.handleKVKeysPR((PartitionedRegion)region, keyList, serializeValues, servConn);
            return;
        }
        VersionedObjectList values = new VersionedObjectList(MAXIMUM_CHUNK_SIZE, true, region == null || region.getAttributes().getConcurrencyChecksEnabled(), serializeValues);
        if (region != null) {
            for (Object key : keyList) {
                if (!region.containsKey(key) && !region.containsTombstone(key)) continue;
                VersionTagHolder versionHolder = BaseCommand.createVersionTagHolder();
                ClientProxyMembershipID id = servConn == null ? null : servConn.getProxyID();
                Object data = region.get(key, null, true, true, true, id, versionHolder, true);
                VersionTag versionTag = versionHolder.getVersionTag();
                BaseCommand.updateValues(values, key, data, versionTag);
                if (values.size() != MAXIMUM_CHUNK_SIZE) continue;
                BaseCommand.sendNewRegisterInterestResponseChunk(region, keyList, values, false, servConn);
                values.clear();
            }
        }
        BaseCommand.sendNewRegisterInterestResponseChunk(region, keyList, values, true, servConn);
    }

    private static VersionTagHolder createVersionTagHolder() {
        VersionTagHolder versionHolder = new VersionTagHolder();
        versionHolder.setOperation(Operation.GET_FOR_REGISTER_INTEREST);
        return versionHolder;
    }

    private static void appendInterestResponseKey(LocalRegion region, Object riKey, Object entryKey, List list, ServerConnection servConn) throws IOException {
        list.add(entryKey);
        if (logger.isDebugEnabled()) {
            logger.debug("{}: appendInterestResponseKey <{}>; list size was {}; region: {}", (Object)servConn.getName(), entryKey, (Object)list.size(), (Object)region.getFullPath());
        }
        if (list.size() == MAXIMUM_CHUNK_SIZE) {
            BaseCommand.sendRegisterInterestResponseChunk(region, riKey, list, false, servConn);
            list.clear();
        }
    }

    private static void appendInterestResponseKeys(LocalRegion region, Object riKey, Collection entryKeys, List collector, ServerConnection servConn) throws IOException {
        for (Object entryKey : entryKeys) {
            BaseCommand.appendInterestResponseKey(region, riKey, entryKey, collector, servConn);
        }
    }

    static {
        Semaphore semaphore = MAX_INCOMING_DATA > 0 ? new Semaphore(MAX_INCOMING_DATA, true) : null;
        INCOMING_DATA_LIMITER = semaphore;
        semaphore = MAX_INCOMING_MESSAGES > 0 ? new Semaphore(MAX_INCOMING_MESSAGES, false) : null;
        INCOMING_MSG_LIMITER = semaphore;
    }
}

