/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.partitioned;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Set;
import org.apache.geode.CancelException;
import org.apache.geode.DataSerializer;
import org.apache.geode.cache.CacheException;
import org.apache.geode.cache.query.QueryException;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.SystemTimer;
import org.apache.geode.internal.cache.DistributedRegion;
import org.apache.geode.internal.cache.ForceReattemptException;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.PartitionedRegionHelper;
import org.apache.geode.internal.cache.partitioned.PartitionMessage;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;

public class PRSanityCheckMessage
extends PartitionMessage {
    private String regionName;

    public PRSanityCheckMessage() {
    }

    public PRSanityCheckMessage(Set recipients, int prId, ReplyProcessor21 processor, String regionName) {
        super(recipients, prId, processor);
        this.regionName = regionName;
    }

    @Override
    public boolean isSevereAlertCompatible() {
        return true;
    }

    @Override
    protected void appendFields(StringBuilder buff) {
        super.appendFields(buff);
        buff.append(" regionName=").append(this.regionName);
    }

    public int getDSFID() {
        return 56;
    }

    @Override
    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        super.fromData(in, context);
        this.regionName = DataSerializer.readString(in);
    }

    @Override
    public void toData(DataOutput out, SerializationContext context) throws IOException {
        super.toData(out, context);
        DataSerializer.writeString(this.regionName, out);
    }

    public static void schedule(final PartitionedRegion pr) {
        if (!Boolean.getBoolean("gemfire.PRSanityCheckDisabled")) {
            final DistributionManager dm = pr.getDistributionManager();
            DistributedRegion prRoot = (DistributedRegion)PartitionedRegionHelper.getPRRoot(pr.getCache(), false);
            if (prRoot == null) {
                return;
            }
            Set<InternalDistributedMember> recipients = prRoot.getDistributionAdvisor().adviseGeneric();
            if (recipients.size() <= 0) {
                return;
            }
            final PRSanityCheckMessage delayedInstance = new PRSanityCheckMessage(recipients, pr.getPRId(), null, pr.getRegionIdentifier());
            delayedInstance.setTransactionDistributed(pr.getCache().getTxManager().isDistributed());
            PRSanityCheckMessage instance = new PRSanityCheckMessage(recipients, pr.getPRId(), null, pr.getRegionIdentifier());
            instance.setTransactionDistributed(pr.getCache().getTxManager().isDistributed());
            dm.putOutgoing(instance);
            int sanityCheckInterval = Integer.getInteger("gemfire.PRSanityCheckInterval", 5000);
            if (sanityCheckInterval != 0) {
                final SystemTimer tm = new SystemTimer(dm.getSystem(), true);
                SystemTimer.SystemTimerTask st = new SystemTimer.SystemTimerTask(){

                    @Override
                    public void run2() {
                        try {
                            if (!(pr.isLocallyDestroyed || pr.isClosed || pr.isDestroyed())) {
                                dm.putOutgoing(delayedInstance);
                            }
                        }
                        catch (CancelException cancelException) {
                        }
                        finally {
                            tm.cancel();
                        }
                    }
                };
                tm.schedule(st, sanityCheckInterval);
            }
        }
    }

    @Override
    public int getProcessorType() {
        return 75;
    }

    @Override
    public void process(ClusterDistributionManager dm) {
        PartitionedRegion.validatePRID(this.getSender(), this.regionId, this.regionName);
    }

    @Override
    protected boolean operateOnPartitionedRegion(ClusterDistributionManager dm, PartitionedRegion pr, long startTime) throws CacheException, QueryException, ForceReattemptException, InterruptedException {
        return false;
    }
}

