/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.PooledDistributionMessage;
import org.apache.geode.distributed.internal.ReplyMessage;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.distributed.internal.ReplySender;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;
import org.apache.geode.internal.serialization.Version;

public class ServerPingMessage
extends PooledDistributionMessage {
    private int processorId = 0;

    public ServerPingMessage() {
    }

    public ServerPingMessage(ReplyProcessor21 processor) {
        this.processorId = processor.getProcessorId();
    }

    public int getDSFID() {
        return 2164;
    }

    public static boolean send(InternalCache cache, Set<InternalDistributedMember> recipients) {
        InternalDistributedSystem ids = cache.getInternalDistributedSystem();
        DistributionManager dm = ids.getDistributionManager();
        HashSet<InternalDistributedMember> filteredRecipients = new HashSet<InternalDistributedMember>();
        for (InternalDistributedMember recipient : recipients) {
            if (Version.GFE_81.compareTo(recipient.getVersionObject()) > 0) continue;
            filteredRecipients.add(recipient);
        }
        if (filteredRecipients.size() == 0) {
            return true;
        }
        ReplyProcessor21 replyProcessor = new ReplyProcessor21(dm, filteredRecipients);
        ServerPingMessage spm = new ServerPingMessage(replyProcessor);
        spm.setRecipients(filteredRecipients);
        Set<InternalDistributedMember> failedServers = null;
        try {
            if (cache.getLogger().fineEnabled()) {
                cache.getLogger().fine("Pinging following servers " + filteredRecipients);
            }
            failedServers = dm.putOutgoing(spm);
            boolean receivedReplies = replyProcessor.waitForReplies(0L);
            dm.getCancelCriterion().checkCancelInProgress(null);
            if (!receivedReplies) {
                cache.getLogger().error(String.format("Could not ping one of the following servers: %s", filteredRecipients));
                return false;
            }
        }
        catch (Throwable e) {
            cache.getLogger().error(String.format("Could not ping one of the following servers: %s", filteredRecipients), e);
            return false;
        }
        if (failedServers == null || failedServers.size() == 0) {
            return true;
        }
        cache.getLogger().info(String.format("Could not ping one of the following servers: %s", failedServers));
        return false;
    }

    @Override
    protected void process(ClusterDistributionManager dm) {
        ReplyMessage.send(this.getSender(), this.processorId, null, (ReplySender)dm);
    }

    @Override
    public void toData(DataOutput out, SerializationContext context) throws IOException {
        super.toData(out, context);
        out.writeInt(this.processorId);
    }

    @Override
    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        super.fromData(in, context);
        this.processorId = in.readInt();
    }

    @Override
    public int getProcessorId() {
        return this.processorId;
    }
}

