/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.geode.internal.cache.InternalRegionArguments;

public class RegionNameValidation {
    private static final Pattern NAME_PATTERN = Pattern.compile("[aA-zZ0-9-_.]+");

    static Pattern getNamePattern() {
        return NAME_PATTERN;
    }

    public static void validate(String name) {
        RegionNameValidation.validate(name, new InternalRegionArguments());
    }

    static void validate(String name, InternalRegionArguments internalRegionArguments) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (name.isEmpty()) {
            throw new IllegalArgumentException("name cannot be empty");
        }
        if (name.contains("/")) {
            throw new IllegalArgumentException(String.format("name cannot contain the separator ' %s '", "/"));
        }
        if (internalRegionArguments.isInternalRegion()) {
            return;
        }
        if (internalRegionArguments.isUsedForMetaRegion()) {
            return;
        }
        if (internalRegionArguments.isUsedForPartitionedRegionAdmin()) {
            return;
        }
        if (internalRegionArguments.isUsedForPartitionedRegionBucket()) {
            return;
        }
        if (name.startsWith("__")) {
            throw new IllegalArgumentException("Region names may not begin with a double-underscore: " + name);
        }
        Matcher matcher = NAME_PATTERN.matcher(name);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Region names may only be alphanumeric and may contain hyphens or underscores: " + name);
        }
    }
}

