/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import org.apache.geode.InternalGemFireError;
import org.apache.geode.InternalGemFireException;
import org.apache.geode.StatisticsFactory;
import org.apache.geode.cache.AttributesFactory;
import org.apache.geode.cache.AttributesMutator;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheListener;
import org.apache.geode.cache.CacheLoader;
import org.apache.geode.cache.CacheRuntimeException;
import org.apache.geode.cache.CustomExpiry;
import org.apache.geode.cache.DataPolicy;
import org.apache.geode.cache.EntryEvent;
import org.apache.geode.cache.EntryNotFoundException;
import org.apache.geode.cache.EvictionAttributes;
import org.apache.geode.cache.ExpirationAction;
import org.apache.geode.cache.ExpirationAttributes;
import org.apache.geode.cache.InterestRegistrationEvent;
import org.apache.geode.cache.PartitionAttributes;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionAttributes;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.cache.RegionEvent;
import org.apache.geode.cache.RegionExistsException;
import org.apache.geode.cache.Scope;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionException;
import org.apache.geode.cache.persistence.PartitionOfflineException;
import org.apache.geode.cache.query.QueryInvalidException;
import org.apache.geode.cache.query.internal.QCompiler;
import org.apache.geode.cache.query.internal.index.IndexCreationData;
import org.apache.geode.cache.query.internal.index.PartitionedIndex;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.cache.AbstractBucketRegionQueue;
import org.apache.geode.internal.cache.BucketAdvisor;
import org.apache.geode.internal.cache.BucketNotFoundException;
import org.apache.geode.internal.cache.BucketPersistenceAdvisor;
import org.apache.geode.internal.cache.BucketRegion;
import org.apache.geode.internal.cache.BucketSetHelper;
import org.apache.geode.internal.cache.CachePerfStats;
import org.apache.geode.internal.cache.ColocationHelper;
import org.apache.geode.internal.cache.DiskRegion;
import org.apache.geode.internal.cache.EntryEventImpl;
import org.apache.geode.internal.cache.EntrySnapshot;
import org.apache.geode.internal.cache.EvictionAttributesImpl;
import org.apache.geode.internal.cache.ForceReattemptException;
import org.apache.geode.internal.cache.HasCachePerfStats;
import org.apache.geode.internal.cache.InternalRegionArguments;
import org.apache.geode.internal.cache.KeyInfo;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.PartitionedRegionException;
import org.apache.geode.internal.cache.PartitionedRegionHelper;
import org.apache.geode.internal.cache.PrimaryBucketException;
import org.apache.geode.internal.cache.ProxyBucketRegion;
import org.apache.geode.internal.cache.RegionEntry;
import org.apache.geode.internal.cache.RegionPerfStats;
import org.apache.geode.internal.cache.StateFlushOperation;
import org.apache.geode.internal.cache.Token;
import org.apache.geode.internal.cache.backup.BackupService;
import org.apache.geode.internal.cache.execute.BucketMovedException;
import org.apache.geode.internal.cache.execute.PartitionedRegionFunctionResultSender;
import org.apache.geode.internal.cache.execute.RegionFunctionContextImpl;
import org.apache.geode.internal.cache.execute.metrics.FunctionStats;
import org.apache.geode.internal.cache.execute.metrics.FunctionStatsManager;
import org.apache.geode.internal.cache.partitioned.Bucket;
import org.apache.geode.internal.cache.partitioned.PRLocallyDestroyedException;
import org.apache.geode.internal.cache.partitioned.PartitionedRegionFunctionStreamingMessage;
import org.apache.geode.internal.cache.partitioned.PartitionedRegionObserver;
import org.apache.geode.internal.cache.partitioned.PartitionedRegionObserverHolder;
import org.apache.geode.internal.cache.partitioned.RedundancyAlreadyMetException;
import org.apache.geode.internal.cache.partitioned.RemoveBucketMessage;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.cache.wan.AbstractGatewaySender;
import org.apache.geode.internal.cache.wan.AbstractGatewaySenderEventProcessor;
import org.apache.geode.internal.cache.wan.GatewaySenderEventImpl;
import org.apache.geode.internal.cache.wan.parallel.ConcurrentParallelGatewaySenderQueue;
import org.apache.geode.internal.statistics.StatisticsClock;
import org.apache.geode.internal.statistics.StatisticsClockFactory;
import org.apache.geode.internal.util.concurrent.StoppableReentrantReadWriteLock;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class PartitionedRegionDataStore
implements HasCachePerfStats {
    private static final Logger logger = LogService.getLogger();
    protected final PartitionedRegion partitionedRegion;
    private final AtomicLong bytesInUse = new AtomicLong(0L);
    private CacheLoader loader;
    final StoppableReentrantReadWriteLock bucketCreationLock;
    private final ConcurrentMap<Integer, BucketRegion> localBucket2RegionMap;
    final AtomicInteger bucketCreatesInProgress = new AtomicInteger();
    private boolean exceededLocalMaxMemoryLimit = false;
    private final long maximumLocalBytes;
    private final CachePerfStats bucketStats;
    final ConcurrentMap keysOfInterest;
    private final Object keysOfInterestLock = new Object();
    private final StatisticsClock statisticsClock;
    private static final boolean UPDATE_ACCESS_TIME_ON_INTEREST = Boolean.getBoolean("gemfire.updateAccessTimeOnClientInterest");
    private Runnable bucketReadHook;

    PartitionedRegionDataStore() {
        this.statisticsClock = StatisticsClockFactory.disabledClock();
        this.bucketCreationLock = null;
        this.bucketStats = null;
        this.partitionedRegion = null;
        this.maximumLocalBytes = -1L;
        this.localBucket2RegionMap = new ConcurrentHashMap<Integer, BucketRegion>();
        this.keysOfInterest = null;
    }

    PartitionedRegionDataStore(PartitionedRegion pr, StatisticsClock statisticsClock) {
        this.statisticsClock = statisticsClock;
        int bucketCount = pr.getTotalNumberOfBuckets();
        this.localBucket2RegionMap = new ConcurrentHashMap<Integer, BucketRegion>(bucketCount);
        this.partitionedRegion = pr;
        this.bucketCreationLock = new StoppableReentrantReadWriteLock(pr.getCancelCriterion());
        if (pr.getAttributes().getCacheLoader() != null) {
            this.loader = pr.getAttributes().getCacheLoader();
            if (logger.isDebugEnabled()) {
                logger.debug("Installing cache loader from partitioned region attributes: {}", (Object)this.loader);
            }
        }
        this.maximumLocalBytes = (long)pr.getLocalMaxMemory() * 0x100000L;
        this.bucketStats = new RegionPerfStats((StatisticsFactory)pr.getCache().getInternalDistributedSystem().getStatisticsManager(), "RegionStats-partition-" + pr.getName(), pr.getCachePerfStats(), pr, pr.getCache().getMeterRegistry(), statisticsClock);
        this.keysOfInterest = new ConcurrentHashMap();
    }

    static PartitionedRegionDataStore createDataStore(Cache cache, PartitionedRegion pr, PartitionAttributes pa, StatisticsClock statisticsClock) throws PartitionedRegionException {
        return new PartitionedRegionDataStore(pr, statisticsClock);
    }

    ConcurrentMap<Integer, BucketRegion> getLocalBucket2RegionMap() {
        return this.localBucket2RegionMap;
    }

    public boolean isManagingBucket(int bucketId) {
        BucketRegion buk = (BucketRegion)this.localBucket2RegionMap.get(bucketId);
        return buk != null && !buk.isDestroyed();
    }

    public short getBucketsManaged() {
        return (short)this.localBucket2RegionMap.size();
    }

    public int getNumberOfPrimaryBucketsManaged() {
        final AtomicInteger numPrimaries = new AtomicInteger();
        this.visitBuckets(new BucketVisitor(){

            @Override
            public void visit(Integer bucketId, Region r) {
                BucketRegion br = (BucketRegion)r;
                if (br.getBucketAdvisor().isPrimary()) {
                    numPrimaries.incrementAndGet();
                }
            }
        });
        return numPrimaries.get();
    }

    public boolean isPartitionedRegionReady(PartitionedRegion partitionedRegion, int bucketId) {
        List<PartitionedRegion> colocatedWithList = this.getColocatedChildRegions(partitionedRegion);
        if (colocatedWithList.size() == 0) {
            return partitionedRegion.isInitialized();
        }
        return this.areAllColocatedPartitionedRegionsReady(bucketId, colocatedWithList);
    }

    private boolean areAllColocatedPartitionedRegionsReady(int bucketId, List<PartitionedRegion> colocatedWithList) {
        return colocatedWithList.stream().allMatch(partitionedRegion -> this.isColocatedPartitionedRegionInitialized((PartitionedRegion)partitionedRegion, bucketId));
    }

    private boolean isColocatedPartitionedRegionInitialized(PartitionedRegion partitionedRegion, int bucketId) {
        if (!partitionedRegion.isInitialized()) {
            return false;
        }
        if (!partitionedRegion.getDataStore().isColocationComplete(bucketId)) {
            return false;
        }
        List<PartitionedRegion> colocatedWithList = this.getColocatedChildRegions(partitionedRegion);
        return this.areAllColocatedPartitionedRegionsReady(bucketId, colocatedWithList);
    }

    List<PartitionedRegion> getColocatedChildRegions(PartitionedRegion partitionedRegion) {
        return ColocationHelper.getColocatedChildRegions(partitionedRegion);
    }

    protected CreateBucketResult grabFreeBucketRecursively(int bucketId, PartitionedRegion pr, InternalDistributedMember moveSource, boolean forceCreation, boolean isRebalance, boolean replaceOfflineData, InternalDistributedMember creationRequestor, boolean isDiskRecovery) {
        InternalDistributedMember dm = pr.getMyId();
        List<PartitionedRegion> colocatedWithList = ColocationHelper.getColocatedChildRegions(pr);
        CreateBucketResult grab = pr.getDataStore().grabFreeBucket(bucketId, dm, null, true, isRebalance, true, replaceOfflineData, creationRequestor);
        if (!grab.nowExists() && logger.isDebugEnabled()) {
            logger.debug("Failed grab for bucketId = {}{}{}", (Object)pr.getPRId(), (Object)":", (Object)bucketId);
        }
        if (colocatedWithList != null) {
            for (PartitionedRegion coLocatedWithPr : colocatedWithList) {
                if (!isDiskRecovery && !coLocatedWithPr.isInitialized() || !coLocatedWithPr.getDataStore().isColocationComplete(bucketId) || (grab = coLocatedWithPr.getDataStore().grabFreeBucketRecursively(bucketId, coLocatedWithPr, moveSource, forceCreation, isRebalance, replaceOfflineData, creationRequestor, isDiskRecovery)).nowExists() || !logger.isDebugEnabled()) continue;
                logger.debug("Failed grab for bucketId = {}{}{}", (Object)pr.getPRId(), (Object)":", (Object)bucketId);
            }
        }
        return grab;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    CreateBucketResult grabFreeBucket(int possiblyFreeBucketId, DistributedMember sender, InternalDistributedMember moveSource, boolean forceCreation, boolean isRebalance, boolean lockRedundancyLock, boolean replaceOffineData, InternalDistributedMember creationRequestor) {
        boolean isDebugEnabled = logger.isDebugEnabled();
        long startTime = this.partitionedRegion.getPrStats().startBucketCreate(isRebalance);
        boolean createdBucket = false;
        PartitionedRegionObserver observer = PartitionedRegionObserverHolder.getInstance();
        observer.beforeBucketCreation(this.partitionedRegion, possiblyFreeBucketId);
        try {
            Object lock;
            CreateBucketResult result = CreateBucketResult.FAILED;
            if (this.isManagingBucket(possiblyFreeBucketId)) {
                if (isDebugEnabled) {
                    logger.debug("grabFreeBucket: VM {} already contains the bucket with bucketId={}{}{}", (Object)this.partitionedRegion.getMyId(), (Object)this.partitionedRegion.getPRId(), (Object)":", (Object)possiblyFreeBucketId);
                }
                this.partitionedRegion.checkReadiness();
                CreateBucketResult createBucketResult = CreateBucketResult.ALREADY_EXISTS;
                return createBucketResult;
            }
            StoppableReentrantReadWriteLock.StoppableReadLock parentBucketCreationLock = this.getParentBucketCreationLock();
            if (parentBucketCreationLock != null) {
                parentBucketCreationLock.lock();
            }
            try {
                if (!this.okToCreateChildBucket(possiblyFreeBucketId)) {
                    CreateBucketResult createBucketResult = CreateBucketResult.FAILED;
                    return createBucketResult;
                }
                lock = this.bucketCreationLock.readLock();
                ((StoppableReentrantReadWriteLock.StoppableReadLock)lock).lock();
                try {
                    ProxyBucketRegion buk;
                    this.bucketCreatesInProgress.incrementAndGet();
                    if (this.partitionedRegion.isDestroyed()) {
                        CreateBucketResult createBucketResult = CreateBucketResult.FAILED;
                        return createBucketResult;
                    }
                    if (isDebugEnabled) {
                        logger.debug("grabFreeBucket: node list {} for bucketId={}{}{}", (Object)PartitionedRegionHelper.printCollection(this.partitionedRegion.getRegionAdvisor().getBucketOwners(possiblyFreeBucketId)), (Object)this.partitionedRegion.getPRId(), (Object)":", (Object)possiblyFreeBucketId);
                    }
                    if (!forceCreation && !this.canAccommodateAnotherBucket()) {
                        CreateBucketResult createBucketResult = result = CreateBucketResult.FAILED;
                        return createBucketResult;
                    }
                    ProxyBucketRegion proxyBucketRegion = buk = this.partitionedRegion.getRegionAdvisor().getProxyBucketArray()[possiblyFreeBucketId];
                    synchronized (proxyBucketRegion) {
                        if (!this.verifyBucketBeforeGrabbing(possiblyFreeBucketId)) {
                            CreateBucketResult createBucketResult = result = CreateBucketResult.FAILED;
                            return createBucketResult;
                        }
                        if (!this.isManagingBucket(possiblyFreeBucketId)) {
                            BucketRegion bukReg;
                            Integer possiblyFreeBucketIdInt;
                            block54: {
                                possiblyFreeBucketIdInt = possiblyFreeBucketId;
                                bukReg = null;
                                Object redundancyLock = this.lockRedundancyLock(moveSource, possiblyFreeBucketId, replaceOffineData);
                                try {
                                    buk.initializePrimaryElector(creationRequestor);
                                    if (this.getPartitionedRegion().getColocatedWith() == null) {
                                        buk.getBucketAdvisor().setShadowBucketDestroyed(false);
                                    }
                                    if (this.getPartitionedRegion().isShadowPR()) {
                                        this.getPartitionedRegion().getColocatedWithRegion().getRegionAdvisor().getBucketAdvisor(possiblyFreeBucketId).setShadowBucketDestroyed(false);
                                    }
                                    if ((bukReg = this.createBucketRegion(possiblyFreeBucketId)) != null) {
                                        observer.beforeAssignBucket(this.partitionedRegion, possiblyFreeBucketId);
                                        this.assignBucketRegion(bukReg.getId(), bukReg);
                                        buk.setHosting(true);
                                        bukReg.invokePartitionListenerAfterBucketCreated();
                                        break block54;
                                    }
                                    if (buk.getPartitionedRegion().getColocatedWith() == null) {
                                        buk.getBucketAdvisor().setShadowBucketDestroyed(true);
                                        this.clearAllTempQueueForShadowPR(buk.getBucketId());
                                    }
                                }
                                finally {
                                    this.releaseRedundancyLock(redundancyLock);
                                    if (bukReg == null) {
                                        buk.clearPrimaryElector();
                                    }
                                }
                            }
                            if (bukReg != null) {
                                if (isDebugEnabled) {
                                    logger.debug("grabFreeBucket: mapped bucketId={}{}{} on node = {}", (Object)this.partitionedRegion.getPRId(), (Object)":", (Object)possiblyFreeBucketId, (Object)this.partitionedRegion.getMyId());
                                }
                                createdBucket = true;
                                result = CreateBucketResult.CREATED;
                            } else {
                                Assert.assertTrue(this.localBucket2RegionMap.get(possiblyFreeBucketIdInt) == null);
                                result = CreateBucketResult.FAILED;
                            }
                        } else {
                            if (isDebugEnabled) {
                                logger.debug("grabFreeBucket: bucketId={}{}{} already mapped on VM = {}", (Object)this.partitionedRegion.getPRId(), (Object)":", (Object)possiblyFreeBucketId, (Object)this.partitionedRegion.getMyId());
                            }
                            result = CreateBucketResult.ALREADY_EXISTS;
                        }
                        if (isDebugEnabled) {
                            logger.debug("grabFreeBucket: Mapped bucketId={}{}{}", (Object)this.partitionedRegion.getPRId(), (Object)":", (Object)possiblyFreeBucketId);
                        }
                    }
                }
                catch (RegionDestroyedException rde) {
                    RegionDestroyedException rde2 = new RegionDestroyedException(this.toString(), this.partitionedRegion.getFullPath());
                    rde2.initCause(rde);
                    throw rde2;
                }
                catch (RedundancyAlreadyMetException e) {
                    if (isDebugEnabled) {
                        logger.debug("Redundancy already met {}{}{} assignment {}", (Object)this.partitionedRegion.getPRId(), (Object)":", (Object)possiblyFreeBucketId, this.localBucket2RegionMap.get(possiblyFreeBucketId));
                    }
                    result = CreateBucketResult.REDUNDANCY_ALREADY_SATISFIED;
                }
                finally {
                    this.bucketCreatesInProgress.decrementAndGet();
                    ((StoppableReentrantReadWriteLock.StoppableReadLock)lock).unlock();
                }
            }
            finally {
                if (parentBucketCreationLock != null) {
                    parentBucketCreationLock.unlock();
                }
            }
            this.partitionedRegion.checkReadiness();
            this.partitionedRegion.checkClosed();
            lock = result;
            return lock;
        }
        catch (PartitionOfflineException validationException) {
            PartitionedRegion leader = ColocationHelper.getLeaderRegion(this.partitionedRegion);
            boolean isLeader = leader.equals(this.partitionedRegion);
            if (isLeader) throw validationException;
            leader.getDataStore().removeBucket(possiblyFreeBucketId, true);
            if (!isDebugEnabled) throw validationException;
            logger.debug("For bucket " + possiblyFreeBucketId + ", failed to create cololcated child bucket for " + this.partitionedRegion.getFullPath() + ", removed leader region " + leader.getFullPath() + " bucket.");
            throw validationException;
        }
        finally {
            this.partitionedRegion.getPrStats().endBucketCreate(startTime, createdBucket, isRebalance);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearAllTempQueueForShadowPR(int bucketId) {
        List<PartitionedRegion> colocatedWithList = ColocationHelper.getColocatedChildRegions(this.partitionedRegion);
        for (PartitionedRegion childRegion : colocatedWithList) {
            if (!childRegion.isShadowPR()) continue;
            AbstractGatewaySender sender = childRegion.getParallelGatewaySender();
            if (sender == null) {
                return;
            }
            AbstractGatewaySenderEventProcessor eventProcessor = sender.getEventProcessor();
            if (eventProcessor == null) {
                return;
            }
            ConcurrentParallelGatewaySenderQueue queue = (ConcurrentParallelGatewaySenderQueue)eventProcessor.getQueue();
            if (queue == null) {
                return;
            }
            BlockingQueue<GatewaySenderEventImpl> tempQueue = queue.getBucketTmpQueue(bucketId);
            if (tempQueue == null) continue;
            BlockingQueue<GatewaySenderEventImpl> blockingQueue = tempQueue;
            synchronized (blockingQueue) {
                for (GatewaySenderEventImpl event : tempQueue) {
                    event.release();
                }
                tempQueue.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object lockRedundancyLock(InternalDistributedMember moveSource, int bucketId, boolean replaceOffineData) {
        PartitionedRegion.BucketLock bl = this.partitionedRegion.getRegionAdvisor().getBucketAdvisor(bucketId).getProxyBucketRegion().getBucketLock();
        bl.lock();
        boolean succeeded = false;
        try {
            ProxyBucketRegion buk = this.partitionedRegion.getRegionAdvisor().getProxyBucketArray()[bucketId];
            if (!buk.checkBucketRedundancyBeforeGrab(moveSource, replaceOffineData)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Redundancy already satisfied. current owners=", this.partitionedRegion.getRegionAdvisor().getBucketOwners(bucketId));
                }
                throw new RedundancyAlreadyMetException();
            }
            succeeded = true;
        }
        finally {
            if (!succeeded) {
                bl.unlock();
            }
        }
        return bl;
    }

    public void releaseRedundancyLock(Object lock) {
        PartitionedRegion.BucketLock bl = (PartitionedRegion.BucketLock)lock;
        bl.unlock();
    }

    private StoppableReentrantReadWriteLock.StoppableReadLock getParentBucketCreationLock() {
        PartitionedRegion colocatedRegion = ColocationHelper.getColocatedRegion(this.partitionedRegion);
        StoppableReentrantReadWriteLock.StoppableReadLock parentLock = null;
        if (colocatedRegion != null) {
            parentLock = colocatedRegion.getDataStore().bucketCreationLock.readLock();
            return parentLock;
        }
        return null;
    }

    private boolean okToCreateChildBucket(int bucketId) {
        PartitionedRegion colocatedRegion = ColocationHelper.getColocatedRegion(this.partitionedRegion);
        if (colocatedRegion != null && !colocatedRegion.getDataStore().isManagingBucket(bucketId)) {
            if (logger.isDebugEnabled()) {
                logger.debug("okToCreateChildBucket - we don't manage the parent bucket");
            }
            return false;
        }
        return this.isColocationComplete(bucketId);
    }

    boolean isColocationComplete(int bucketId) {
        if (!ColocationHelper.isColocationComplete(this.partitionedRegion)) {
            ProxyBucketRegion pb = this.partitionedRegion.getRegionAdvisor().getProxyBucketArray()[bucketId];
            BucketPersistenceAdvisor persistenceAdvisor = pb.getPersistenceAdvisor();
            if (persistenceAdvisor != null && persistenceAdvisor.wasHosting()) {
                return true;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Colocation is incomplete");
            }
            return false;
        }
        return true;
    }

    private BucketRegion createBucketRegion(int bucketId) {
        EvictionAttributesImpl eva;
        CustomExpiry ce;
        this.partitionedRegion.checkReadiness();
        BucketAttributesFactory factory = new BucketAttributesFactory();
        boolean isPersistent = this.partitionedRegion.getDataPolicy().withPersistence();
        if (isPersistent) {
            factory.setDataPolicy(DataPolicy.PERSISTENT_REPLICATE);
            this.setDiskAttributes(factory);
        } else {
            factory.setDataPolicy(DataPolicy.REPLICATE);
        }
        if (PartitionedRegion.DISABLE_SECONDARY_BUCKET_ACK) {
            factory.setScope(Scope.DISTRIBUTED_NO_ACK);
        } else {
            factory.setScope(Scope.DISTRIBUTED_ACK);
        }
        factory.setConcurrencyChecksEnabled(this.partitionedRegion.getConcurrencyChecksEnabled());
        factory.setIndexMaintenanceSynchronous(this.partitionedRegion.getIndexMaintenanceSynchronous());
        if (this.partitionedRegion.getValueConstraint() != null) {
            factory.setValueConstraint(this.partitionedRegion.getValueConstraint());
        }
        if (this.loader != null) {
            factory.setCacheLoader(this.loader);
        }
        factory.setEnableAsyncConflation(true);
        if (Boolean.getBoolean("gemfire.PRDebug")) {
            factory.addCacheListener(this.createDebugBucketListener());
        }
        if (this.partitionedRegion.getStatisticsEnabled()) {
            factory.setStatisticsEnabled(true);
        }
        factory.setCloningEnabled(this.partitionedRegion.getCloningEnabled());
        ExpirationAttributes ea = this.partitionedRegion.getAttributes().getEntryIdleTimeout();
        if (ea != null) {
            factory.setEntryIdleTimeout(ea);
        }
        if ((ea = this.partitionedRegion.getAttributes().getEntryTimeToLive()) != null) {
            factory.setEntryTimeToLive(ea);
        }
        if ((ea = this.partitionedRegion.getAttributes().getRegionIdleTimeout()) != null && ea.getAction() != ExpirationAction.DESTROY) {
            factory.setRegionIdleTimeout(ea);
        }
        if ((ea = this.partitionedRegion.getAttributes().getRegionTimeToLive()) != null && ea.getAction() != ExpirationAction.DESTROY) {
            factory.setRegionTimeToLive(ea);
        }
        if ((ce = this.partitionedRegion.getAttributes().getCustomEntryIdleTimeout()) != null) {
            factory.setCustomEntryIdleTimeout(ce);
        }
        if ((ce = this.partitionedRegion.getAttributes().getCustomEntryTimeToLive()) != null) {
            factory.setCustomEntryTimeToLive(ce);
        }
        if (this.partitionedRegion.getStatisticsEnabled()) {
            factory.setStatisticsEnabled(true);
        }
        if ((eva = (EvictionAttributesImpl)this.partitionedRegion.getEvictionAttributes()) != null) {
            EvictionAttributesImpl evBucket = eva;
            factory.setEvictionAttributes(evBucket);
            if (((EvictionAttributes)evBucket).getAction().isOverflowToDisk()) {
                this.setDiskAttributes(factory);
            }
        }
        factory.setCompressor(this.partitionedRegion.getCompressor());
        factory.setOffHeap(this.partitionedRegion.getOffHeap());
        factory.setBucketRegion(true);
        RegionAttributes attributes = factory.create();
        String bucketRegionName = this.partitionedRegion.getBucketName(bucketId);
        LocalRegion rootRegion = PartitionedRegionHelper.getPRRoot(this.partitionedRegion.getCache());
        BucketRegion bucketRegion = null;
        if (Boolean.getBoolean("gemfire.PRDebug")) {
            logger.info("createBucketRegion: Creating bucketId, {} name, {}.", (Object)this.partitionedRegion.bucketStringForLogs(bucketId), (Object)bucketRegionName);
        }
        try {
            Bucket proxyBucket = this.partitionedRegion.getRegionAdvisor().getBucket(bucketId);
            bucketRegion = (BucketRegion)rootRegion.createSubregion(bucketRegionName, attributes, new InternalRegionArguments().setPartitionedRegionBucketRedundancy(this.partitionedRegion.getRedundantCopies()).setBucketAdvisor(proxyBucket.getBucketAdvisor()).setPersistenceAdvisor(proxyBucket.getPersistenceAdvisor()).setDiskRegion(proxyBucket.getDiskRegion()).setCachePerfStatsHolder(this).setLoaderHelperFactory(this.partitionedRegion).setPartitionedRegion(this.partitionedRegion).setIndexes(this.getIndexes(rootRegion.getFullPath(), bucketRegionName)));
            this.partitionedRegion.getPrStats().incBucketCount(1);
        }
        catch (RegionExistsException ex) {
            if (logger.isDebugEnabled()) {
                logger.debug("PartitionedRegionDataStore#createBucketRegion: Bucket region already created for bucketId={}{}{}", (Object)this.partitionedRegion.getPRId(), (Object)":", (Object)bucketId, (Object)ex);
            }
            bucketRegion = (BucketRegion)rootRegion.getSubregion(bucketRegionName);
        }
        catch (IOException ieo) {
            logger.debug("Unexpected error creating bucket in region", (Throwable)ieo);
            Assert.assertTrue(false, "IOException creating bucket Region: " + ieo);
        }
        catch (ClassNotFoundException cne) {
            if (logger.isDebugEnabled()) {
                logger.debug("Unexpected error creating bucket in region", (Throwable)cne);
            }
            Assert.assertTrue(false, "ClassNotFoundException creating bucket Region: " + cne);
        }
        catch (InternalGemFireError e) {
            if (logger.isDebugEnabled()) {
                logger.info("Assertion error creating bucket in region", (Throwable)e);
            }
            this.getPartitionedRegion().checkReadiness();
            throw e;
        }
        if (Boolean.getBoolean("gemfire.PRDebug")) {
            this.dumpBuckets();
            this.dumpBucket(bucketId, bucketRegion);
        }
        return bucketRegion;
    }

    private List getIndexes(String rootRegion, String bucketRegion) {
        ArrayList<IndexCreationData> indexes = null;
        if (!this.partitionedRegion.isIndexed()) {
            return indexes;
        }
        Map indexMap = this.partitionedRegion.getIndex();
        if (indexMap == null || indexMap.isEmpty()) {
            return indexes;
        }
        indexes = new ArrayList<IndexCreationData>();
        Set indexSet = indexMap.entrySet();
        Iterator it = indexSet.iterator();
        while (it.hasNext()) {
            try {
                Map.Entry indexEntry = it.next();
                PartitionedIndex index = (PartitionedIndex)indexEntry.getValue();
                IndexCreationData icd = new IndexCreationData(index.getName());
                new QCompiler();
                String imports = index.getImports();
                icd.setIndexData(index.getType(), index.getCanonicalizedFromClause(), index.getCanonicalizedIndexedExpression(), index.getImports());
                icd.setPartitionedIndex(index);
                indexes.add(icd);
            }
            catch (Exception ignor) {
                logger.info(String.format("Excpetion  in bucket index creation : %s", ignor.getLocalizedMessage()), (Throwable)ignor);
            }
        }
        return indexes;
    }

    private void setDiskAttributes(BucketAttributesFactory factory) {
        factory.setDiskSynchronous(this.partitionedRegion.getAttributes().isDiskSynchronous());
        factory.setDiskStoreName(this.partitionedRegion.getAttributes().getDiskStoreName());
    }

    public void assignBucketRegion(int bucketId, BucketRegion bukReg) {
        BucketRegion oldbukReg = this.localBucket2RegionMap.putIfAbsent(bucketId, bukReg);
        if (logger.isDebugEnabled()) {
            logger.debug("assigning bucket {} old assignment: {}", (Object)bukReg, (Object)oldbukReg);
        }
        Assert.assertTrue(oldbukReg == null);
    }

    private CacheListener createDebugBucketListener() {
        return new CacheListener(){

            public void afterCreate(EntryEvent event) {
                EntryEventImpl ee = (EntryEventImpl)event;
                logger.debug("BucketListener: o={}, r={}, k={}, nv={}, dm={}", (Object)event.getOperation(), (Object)event.getRegion().getFullPath(), event.getKey(), ee.getRawNewValue(), (Object)event.getDistributedMember());
            }

            public void afterUpdate(EntryEvent event) {
                EntryEventImpl ee = (EntryEventImpl)event;
                logger.debug("BucketListener: o={}, r={}, k={}, ov={}, nv={}, dm={}", (Object)event.getOperation(), (Object)event.getRegion().getFullPath(), event.getKey(), ee.getRawOldValue(), ee.getRawNewValue(), (Object)event.getDistributedMember());
            }

            public void afterInvalidate(EntryEvent event) {
                logger.debug("BucketListener: o={}, r={}, k={}, dm={}", (Object)event.getOperation(), (Object)event.getRegion().getFullPath(), event.getKey(), (Object)event.getDistributedMember());
            }

            public void afterDestroy(EntryEvent event) {
                logger.debug("BucketListener: o={}, r={}, k={}, dm={}", (Object)event.getOperation(), (Object)event.getRegion().getFullPath(), event.getKey(), (Object)event.getDistributedMember());
            }

            public void afterRegionInvalidate(RegionEvent event) {
            }

            public void afterRegionDestroy(RegionEvent event) {
            }

            public void afterRegionClear(RegionEvent event) {
            }

            public void afterRegionCreate(RegionEvent event) {
            }

            public void afterRegionLive(RegionEvent event) {
            }

            @Override
            public void close() {
            }
        };
    }

    public CacheLoader getCacheLoader() {
        return this.loader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cacheLoaderChanged(final CacheLoader newLoader, CacheLoader oldLoader) {
        StoppableReentrantReadWriteLock.StoppableWriteLock lock = this.bucketCreationLock.writeLock();
        lock.lock();
        try {
            this.loader = newLoader;
            this.visitBuckets(new BucketVisitor(){

                @Override
                public void visit(Integer bucketId, Region r) {
                    AttributesMutator mut = r.getAttributesMutator();
                    if (logger.isDebugEnabled()) {
                        logger.debug("setting new cache loader in bucket region: {}", (Object)newLoader);
                    }
                    mut.setCacheLoader(newLoader);
                }
            });
        }
        finally {
            lock.unlock();
        }
    }

    protected void lockBucketCreationAndVisit(BucketVisitor visitor) {
        StoppableReentrantReadWriteLock.StoppableWriteLock lock = this.bucketCreationLock.writeLock();
        lock.lock();
        try {
            this.visitBuckets(visitor);
        }
        finally {
            lock.unlock();
        }
    }

    public long currentAllocatedMemory() {
        return this.bytesInUse.get();
    }

    public boolean handleManageBucketRequest(int bucketId, int size, InternalDistributedMember sender, boolean forceCreation) {
        if (!this.partitionedRegion.isDataStore()) {
            if (logger.isDebugEnabled()) {
                logger.debug("handleRemoteManageBucket: local max memory is zero");
            }
            return false;
        }
        if (!forceCreation && !this.canAccommodateMoreBytesSafely(size)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Partitioned Region {} has exceeded local maximum memory configuration {} Mb, current size is {} Mb", (Object)this.partitionedRegion.getFullPath(), (Object)this.partitionedRegion.getLocalMaxMemory(), (Object)(this.bytesInUse.get() / 0x100000L));
                logger.debug("Refusing remote bucket creation request for bucketId={}{}{} of size {} Mb.", (Object)this.partitionedRegion.getPRId(), (Object)":", (Object)bucketId, (Object)((long)size / 0x100000L));
            }
            return false;
        }
        if (!forceCreation && !this.canAccommodateAnotherBucket()) {
            return false;
        }
        boolean createdBucket = false;
        if (this.grabBucket(bucketId, null, forceCreation, false, true, sender, false).nowExists()) {
            this.partitionedRegion.checkReadiness();
            if (logger.isDebugEnabled()) {
                logger.debug("handleManageBucketRequest: successful, returning:{} bucketId={}{}{} for PR = {}", (Object)this.partitionedRegion.getMyId(), (Object)this.partitionedRegion.getPRId(), (Object)":", (Object)bucketId, (Object)this.getName());
            }
            createdBucket = true;
        } else if (logger.isDebugEnabled()) {
            logger.debug("handleManageBucketRequest: someone else grabbed this bucket");
        }
        return createdBucket;
    }

    boolean canAccommodateAnotherBucket() {
        boolean ret;
        int localMax = this.partitionedRegion.getLocalMaxMemory();
        double totalMax = (double)this.partitionedRegion.getRegionAdvisor().adviseTotalMemoryAllocation() + (double)localMax;
        Assert.assertTrue(totalMax > 0.0);
        double memoryRatio = (double)localMax / totalMax;
        Assert.assertTrue(memoryRatio > 0.0);
        Assert.assertTrue(memoryRatio <= 1.0);
        int totalBucketInstances = this.partitionedRegion.getTotalNumberOfBuckets() * (this.partitionedRegion.getRedundantCopies() + 1);
        double numBucketsToHostLocally = Math.ceil(memoryRatio * (double)totalBucketInstances);
        Assert.assertTrue(numBucketsToHostLocally > 0.0);
        int currentNumBuckets = this.localBucket2RegionMap.size() + this.bucketCreatesInProgress.intValue() - 1;
        boolean bl = ret = numBucketsToHostLocally > (double)currentNumBuckets;
        if (logger.isDebugEnabled()) {
            logger.debug("canAccomodateAnotherBucket: local VM can host {} does host {} concurrent creates {}", (Object)numBucketsToHostLocally, (Object)this.localBucket2RegionMap.size(), (Object)(this.bucketCreatesInProgress.intValue() - 1));
        }
        if (!ret && logger.isDebugEnabled()) {
            logger.debug("Partitioned Region {} potentially unbalanced; maximum number of buckets, {}, has been reached", (Object)this.partitionedRegion.getFullPath(), (Object)numBucketsToHostLocally);
            logger.debug("Total max: {} memoryRatio: {}", (Object)totalMax, (Object)memoryRatio);
        }
        return ret;
    }

    boolean handleRemoteCanRebalance(long size) {
        return false;
    }

    boolean handleRemoteRebalance(int bucketId, Object obj, String regionName) {
        return false;
    }

    boolean handleRemoteCreateBackupRegion(int bucketId) {
        return false;
    }

    public long getBucketSize(int bucketId) {
        BucketRegion bucketRegion = (BucketRegion)this.localBucket2RegionMap.get(bucketId);
        if (bucketRegion == null) {
            return 0L;
        }
        return bucketRegion.getTotalBytes();
    }

    private String getName() {
        return this.partitionedRegion.getName();
    }

    public boolean putLocally(Integer bucketId, EntryEventImpl event, boolean ifNew, boolean ifOld, Object expectedOldValue, boolean requireOldValue, long lastModified) throws PrimaryBucketException, ForceReattemptException {
        BucketRegion br = this.getInitializedBucketForId(event.getKey(), bucketId);
        return this.putLocally(br, event, ifNew, ifOld, expectedOldValue, requireOldValue, lastModified);
    }

    public boolean putLocally(BucketRegion bucketRegion, EntryEventImpl event, boolean ifNew, boolean ifOld, Object expectedOldValue, boolean requireOldValue, long lastModified) throws PrimaryBucketException, ForceReattemptException {
        boolean didPut = false;
        try {
            event.setRegion(bucketRegion);
            didPut = event.isOriginRemote() ? bucketRegion.basicUpdate(event, ifNew, ifOld, lastModified, false) : bucketRegion.virtualPut(event, ifNew, ifOld, expectedOldValue, requireOldValue, lastModified, false);
            bucketRegion.checkReadiness();
        }
        catch (RegionDestroyedException rde) {
            this.checkRegionDestroyedOnBucket(bucketRegion, event.isOriginRemote(), rde);
        }
        return didPut;
    }

    protected boolean hasClientInterest(EntryEventImpl event) {
        return UPDATE_ACCESS_TIME_ON_INTEREST && this.keysOfInterest.containsKey(event.getKey());
    }

    protected void updateMemoryStats(long memoryDelta) {
        this.partitionedRegion.getPrStats().incBytesInUse(memoryDelta);
        long locBytes = this.bytesInUse.addAndGet(memoryDelta);
        if (this.partitionedRegion.isEntryEvictionPossible()) {
            return;
        }
        if (this.exceededLocalMaxMemoryLimit) {
            if (locBytes <= this.maximumLocalBytes) {
                this.exceededLocalMaxMemoryLimit = false;
                logger.info("Partitioned Region {} is at or below local maximum memory configuration {} Mb, current size is {} Mb", (Object)this.partitionedRegion.getFullPath(), (Object)this.partitionedRegion.getLocalMaxMemory(), (Object)(locBytes / 0x100000L));
            }
        } else if (locBytes > this.maximumLocalBytes) {
            this.exceededLocalMaxMemoryLimit = true;
            logger.warn("Partitioned Region {} has exceeded local maximum memory configuration {} Mb, current size is {} Mb", (Object)this.partitionedRegion.getFullPath(), (Object)this.partitionedRegion.getLocalMaxMemory(), (Object)(locBytes / 0x100000L));
        }
    }

    boolean canAccommodateMoreBytesSafely(int bytes) {
        boolean isDebugEnabled = logger.isDebugEnabled();
        if (this.partitionedRegion.getLocalMaxMemory() == 0) {
            return false;
        }
        if (this.partitionedRegion.isEntryEvictionPossible()) {
            return true;
        }
        long curBytes = this.bytesInUse.get();
        if (isDebugEnabled) {
            logger.debug("canAccomodateMoreBytes: bytes = {} allocatedMemory = {} newAllocatedSize = {} thresholdSize = ", (Object)bytes, (Object)curBytes, (Object)(curBytes + (long)bytes), (Object)this.maximumLocalBytes);
        }
        if (curBytes + (long)bytes < this.maximumLocalBytes) {
            if (isDebugEnabled) {
                logger.debug("canAccomodateMoreBytes: returns true");
            }
            return true;
        }
        if (isDebugEnabled) {
            logger.debug("canAccomodateMoreBytes: returns false");
        }
        return false;
    }

    public PartitionedRegion getPartitionedRegion() {
        return this.partitionedRegion;
    }

    public Object destroyLocally(Integer bucketId, EntryEventImpl event, Object expectedOldValue) throws EntryNotFoundException, PrimaryBucketException, ForceReattemptException {
        if (logger.isDebugEnabled()) {
            logger.debug("destroyLocally: key={} bucketId={}{}{}", event.getKey(), (Object)this.partitionedRegion.getPRId(), (Object)":", (Object)bucketId);
        }
        Object obj = null;
        BucketRegion bucketRegion = this.getInitializedBucketForId(event.getKey(), bucketId);
        try {
            event.setRegion(bucketRegion);
            bucketRegion.basicDestroy(event, true, expectedOldValue);
            bucketRegion.checkReadiness();
        }
        catch (EntryNotFoundException enf) {
            if (this.partitionedRegion.isDestroyed()) {
                this.checkRegionDestroyedOnBucket(bucketRegion, event.isOriginRemote(), new RegionDestroyedException("Region has been destroyed", this.partitionedRegion.getFullPath()));
            }
            throw enf;
        }
        catch (RegionDestroyedException rde) {
            this.checkRegionDestroyedOnBucket(bucketRegion, event.isOriginRemote(), rde);
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanUp(boolean removeBucketMapping, boolean removeFromDisk) {
        block22: {
            if (logger.isDebugEnabled()) {
                logger.debug("cleanUp: Starting cleanup for {}", (Object)this.partitionedRegion);
            }
            try {
                if (removeBucketMapping) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("cleanUp: Done destroyBucket2NodeRegionLocally for {}", (Object)this.partitionedRegion);
                    }
                } else if (logger.isDebugEnabled()) {
                    logger.debug("cleanUp: not removing node from b2n region");
                }
                StoppableReentrantReadWriteLock.StoppableWriteLock lock = this.bucketCreationLock.writeLock();
                lock.lock();
                try {
                    ProxyBucketRegion[] proxyBuckets = this.getPartitionedRegion().getRegionAdvisor().getProxyBucketArray();
                    if (proxyBuckets == null) break block22;
                    for (ProxyBucketRegion pbr : proxyBuckets) {
                        DiskRegion diskRegion;
                        Integer bucketId = pbr.getBucketId();
                        BucketRegion buk = (BucketRegion)this.localBucket2RegionMap.get(bucketId);
                        if (buk != null) {
                            try {
                                buk.getBucketAdvisor().getProxyBucketRegion().setHosting(false);
                                if (removeFromDisk) {
                                    buk.localDestroyRegion();
                                } else {
                                    buk.close();
                                }
                                if (logger.isDebugEnabled()) {
                                    logger.debug("cleanup: Locally destroyed bucket {}", (Object)buk.getFullPath());
                                }
                                if (buk instanceof AbstractBucketRegionQueue && buk.getPartitionedRegion().isShadowPR() && buk.getPartitionedRegion().getColocatedWithRegion() != null) {
                                    buk.getPartitionedRegion().getColocatedWithRegion().getRegionAdvisor().getBucketAdvisor(bucketId).setShadowBucketDestroyed(true);
                                }
                            }
                            catch (RegionDestroyedException regionDestroyedException) {
                            }
                            catch (Exception ex) {
                                logger.warn(String.format("PartitionedRegion %s: cleanUp problem destroying bucket %s", this.partitionedRegion.getFullPath(), buk.getId()), (Throwable)ex);
                            }
                            this.localBucket2RegionMap.remove(bucketId);
                            continue;
                        }
                        if (!removeFromDisk || (diskRegion = pbr.getDiskRegion()) == null) continue;
                        diskRegion.beginDestroy(null);
                        diskRegion.endDestroy(null);
                    }
                }
                finally {
                    lock.unlock();
                }
            }
            catch (Exception ex) {
                logger.warn(String.format("PartitionedRegion %s: caught unexpected exception during data cleanup", this.partitionedRegion.getFullPath()), (Throwable)ex);
            }
            finally {
                this.partitionedRegion.getPrStats().setBucketCount(0);
                this.bucketStats.close();
            }
        }
    }

    public boolean isRemotePrimaryReadyForColocatedChildren(int bucketId) {
        boolean isRemotePrimaryReady = true;
        InternalDistributedMember myId = this.partitionedRegion.getDistributionManager().getDistributionManagerId();
        List<PartitionedRegion> colocatedChildPRs = ColocationHelper.getColocatedChildRegions(this.partitionedRegion);
        if (colocatedChildPRs != null) {
            for (PartitionedRegion pr : colocatedChildPRs) {
                InternalDistributedMember primaryChild = pr.getBucketPrimary(bucketId);
                if (logger.isDebugEnabled()) {
                    logger.debug("Checking colocated child bucket " + pr + ", bucketId=" + bucketId + ", primary is " + primaryChild);
                }
                if (primaryChild == null || myId.equals(primaryChild)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Colocated bucket region " + pr + " " + bucketId + " does not have a remote primary yet. Not to remove.");
                    }
                    return false;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug(pr + " bucketId=" + bucketId + " has remote primary, checking its children");
                }
                isRemotePrimaryReady = isRemotePrimaryReady && pr.getDataStore().isRemotePrimaryReadyForColocatedChildren(bucketId);
            }
        }
        return isRemotePrimaryReady;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean removeBucket(int bucketId, boolean forceRemovePrimary) {
        this.waitForInProgressBackup();
        if (!forceRemovePrimary && !this.partitionedRegion.getRedundancyProvider().isPersistentRecoveryComplete()) {
            if (!logger.isDebugEnabled()) return false;
            logger.debug("Returning false from removeBucket because we have not finished recovering all colocated regions from disk");
            return false;
        }
        StoppableReentrantReadWriteLock.StoppableWriteLock lock = this.bucketCreationLock.writeLock();
        lock.lock();
        try {
            InternalDistributedMember primary;
            BucketRegion bucketRegion = (BucketRegion)this.localBucket2RegionMap.get(bucketId);
            if (bucketRegion == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Returning true from removeBucket because we don't have the bucket we've been told to remove");
                }
                boolean bl = true;
                return bl;
            }
            PartitionedRegion leader = ColocationHelper.getLeaderRegion(this.partitionedRegion);
            boolean isLeader = leader.equals(this.partitionedRegion);
            BucketAdvisor bucketAdvisor = bucketRegion.getBucketAdvisor();
            InternalDistributedMember myId = this.partitionedRegion.getDistributionManager().getDistributionManagerId();
            Lock primaryMoveReadLock = bucketAdvisor.getPrimaryMoveReadLock();
            primaryMoveReadLock.lock();
            try {
                if (!forceRemovePrimary && bucketAdvisor.isPrimary()) {
                    boolean bl = false;
                    return bl;
                }
                if (isLeader) {
                    if (!forceRemovePrimary && !this.isRemotePrimaryReadyForColocatedChildren(bucketId)) {
                        boolean bl = false;
                        return bl;
                    }
                    primary = bucketAdvisor.getPrimary();
                    if (!forceRemovePrimary && (primary == null || myId.equals(primary))) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Bucket region " + bucketRegion + " does not have a remote primary yet. Not to remove.");
                        }
                        boolean bl = false;
                        return bl;
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug("Bucket region " + bucketRegion + " has primary at " + primary);
                    }
                }
                this.removeBucketForColocatedChildren(bucketId, forceRemovePrimary);
                if (bucketRegion.getPartitionedRegion().isShadowPR() && bucketRegion.getPartitionedRegion().getColocatedWithRegion() != null) {
                    bucketRegion.getPartitionedRegion().getColocatedWithRegion().getRegionAdvisor().getBucketAdvisor(bucketId).setShadowBucketDestroyed(true);
                }
                bucketAdvisor.getProxyBucketRegion().removeBucket();
            }
            finally {
                primaryMoveReadLock.unlock();
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Removed bucket {} from advisor", (Object)bucketRegion);
            }
            if (!myId.equals(primary = bucketAdvisor.getPrimary())) {
                StateFlushOperation flush = new StateFlushOperation(bucketRegion);
                int executor = 77;
                try {
                    flush.flush(Collections.singleton(primary), myId, executor, false);
                }
                catch (InterruptedException e) {
                    this.partitionedRegion.getCancelCriterion().checkCancelInProgress(e);
                    Thread.currentThread().interrupt();
                    throw new InternalGemFireException("Interrupted while flushing state");
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Finished state flush for removal of {}", (Object)bucketRegion);
                }
            } else if (logger.isDebugEnabled()) {
                logger.debug("We became primary while destroying the bucket. Too late to stop now.");
            }
            bucketRegion.invokePartitionListenerAfterBucketRemoved();
            bucketRegion.preDestroyBucket(bucketId);
            bucketRegion.localDestroyRegion();
            bucketAdvisor.getProxyBucketRegion().finishRemoveBucket();
            if (logger.isDebugEnabled()) {
                logger.debug("Destroyed {}", (Object)bucketRegion);
            }
            this.localBucket2RegionMap.remove(bucketId);
            this.partitionedRegion.getPrStats().incBucketCount(-1);
            boolean bl = true;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    private void waitForInProgressBackup() {
        BackupService backupService = this.getPartitionedRegion().getGemFireCache().getBackupService();
        if (this.getPartitionedRegion().getDataPolicy().withPersistence()) {
            backupService.waitForBackup();
        }
    }

    private boolean removeBucketForColocatedChildren(int bucketId, boolean forceRemovePrimary) {
        boolean removedChildBucket = true;
        List<PartitionedRegion> colocatedChildPRs = ColocationHelper.getColocatedChildRegions(this.partitionedRegion);
        if (colocatedChildPRs != null) {
            for (PartitionedRegion pr : colocatedChildPRs) {
                removedChildBucket = pr.getDataStore().removeBucket(bucketId, forceRemovePrimary) && removedChildBucket;
            }
        }
        return removedChildBucket;
    }

    public CreateBucketResult createRedundantBucket(int bucketId, boolean isRebalance, InternalDistributedMember moveSource) {
        return this.grabBucket(bucketId, moveSource, true, false, isRebalance, null, false);
    }

    public boolean moveBucket(int bucketId, InternalDistributedMember source, boolean isRebalance) {
        boolean removed;
        RemoveBucketMessage.RemoveBucketResponse response;
        if (this.createRedundantBucket(bucketId, isRebalance, source) != CreateBucketResult.CREATED) {
            if (logger.isDebugEnabled()) {
                logger.debug("Failed to move bucket {} to {}", (Object)bucketId, (Object)this);
            }
            return false;
        }
        BucketAdvisor bucketAdvisor = this.partitionedRegion.getRegionAdvisor().getBucketAdvisor(bucketId);
        if (source.equals(bucketAdvisor.getPrimary()) && !bucketAdvisor.becomePrimary(true) && logger.isDebugEnabled()) {
            logger.debug("Failed to become primary for bucket {} on {}", (Object)bucketId, (Object)this);
        }
        if ((response = RemoveBucketMessage.send(source, this.partitionedRegion, bucketId, false)) != null && !(removed = response.waitForResponse()) && logger.isDebugEnabled()) {
            logger.debug("Successfully created bucket {} in {} but failed to remove it from {}", (Object)bucketId, (Object)this, (Object)source);
        }
        return true;
    }

    public BucketRegion getInitializedBucketForId(Object key, Integer bucketId) throws ForceReattemptException {
        BucketRegion bucketRegion = (BucketRegion)this.localBucket2RegionMap.get(bucketId);
        if (null == bucketRegion) {
            this.partitionedRegion.checkReadiness();
            if (logger.isDebugEnabled()) {
                logger.debug("Got null bucket region for bucketId={}{}{} for PartitionedRegion = {}", (Object)this.partitionedRegion.getPRId(), (Object)":", (Object)bucketId, (Object)this.partitionedRegion);
            }
            BucketNotFoundException fre = new BucketNotFoundException(String.format("Bucket id %s not found on VM %s", this.partitionedRegion.bucketStringForLogs(bucketId), this.partitionedRegion.getMyId()));
            if (key != null) {
                fre.setHash(key.hashCode());
            }
            throw fre;
        }
        bucketRegion.waitForData();
        return bucketRegion;
    }

    public BucketRegion getLocalBucketById(Integer bucketId) {
        BucketRegion bucketRegion = (BucketRegion)this.localBucket2RegionMap.get(bucketId);
        if (bucketRegion != null) {
            bucketRegion.waitForData();
        }
        return bucketRegion;
    }

    public BucketRegion getLocalBucketByKey(Object key) {
        Integer bucketId = PartitionedRegionHelper.getHashKey(this.partitionedRegion, null, key, null, null);
        return this.getLocalBucketById(bucketId);
    }

    public int getPerEntryLRUOverhead() {
        BucketRegion br = (BucketRegion)this.localBucket2RegionMap.values().iterator().next();
        return br.getRegionMap().getEntryOverhead();
    }

    public BucketRegion getInitializedBucketWithKnownPrimaryForId(Object key, Integer bucketId) throws ForceReattemptException {
        BucketRegion br = this.getInitializedBucketForId(key, bucketId);
        br.getBucketAdvisor().getPrimary();
        return br;
    }

    public boolean containsValueForKeyLocally(Integer bucketId, Object key) throws PrimaryBucketException, ForceReattemptException, PRLocallyDestroyedException {
        BucketRegion bucketRegion = this.getInitializedBucketForId(key, bucketId);
        this.invokeBucketReadHook();
        boolean ret = false;
        try {
            ret = bucketRegion.containsValueForKey(key);
            this.checkIfBucketMoved(bucketRegion);
        }
        catch (RegionDestroyedException rde) {
            if (this.partitionedRegion.isLocallyDestroyed || this.partitionedRegion.isClosed) {
                throw new PRLocallyDestroyedException(rde);
            }
            this.getPartitionedRegion().checkReadiness();
            if (bucketRegion.isBucketDestroyed()) {
                throw new ForceReattemptException("Bucket removed during containsValueForKey", rde);
            }
            throw new RegionDestroyedException("Unable to get value for key.", this.partitionedRegion.toString(), rde);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("containsValueForKeyLocally: key {} returning {}", key, (Object)ret);
        }
        return ret;
    }

    private void checkIfBucketMoved(BucketRegion br) throws ForceReattemptException {
        if (br.isBucketDestroyed()) {
            this.partitionedRegion.checkReadiness();
            throw new ForceReattemptException("bucket moved to other member during read op");
        }
    }

    public boolean containsKeyLocally(Integer bucketId, Object key) throws PrimaryBucketException, ForceReattemptException, PRLocallyDestroyedException {
        BucketRegion bucketRegion = this.getInitializedBucketForId(key, bucketId);
        this.invokeBucketReadHook();
        try {
            boolean ret = bucketRegion.containsKey(key);
            this.checkIfBucketMoved(bucketRegion);
            if (logger.isDebugEnabled()) {
                logger.debug("containsKeyLocally:  key {}) bucketId={}{}{} region {} returns {}", key, (Object)this.partitionedRegion.getPRId(), (Object)":", (Object)bucketId, (Object)bucketRegion.getName(), (Object)ret);
            }
            return ret;
        }
        catch (RegionDestroyedException rde) {
            if (this.partitionedRegion.isLocallyDestroyed || this.partitionedRegion.isClosed) {
                throw new PRLocallyDestroyedException(rde);
            }
            this.getPartitionedRegion().checkReadiness();
            if (bucketRegion.isBucketDestroyed()) {
                throw new ForceReattemptException("Bucket removed during containsKey", rde);
            }
            throw new RegionDestroyedException("Unable to do containsKey on", this.partitionedRegion.toString(), rde);
        }
    }

    public void invokeBucketReadHook() {
        Runnable r = this.bucketReadHook;
        if (r != null) {
            this.setBucketReadHook(null);
            r.run();
        }
    }

    public void setBucketReadHook(Runnable r) {
        this.bucketReadHook = r;
    }

    public Object getLocally(int bucketId, Object key, Object aCallbackArgument, boolean disableCopyOnRead, boolean preferCD, ClientProxyMembershipID requestingClient, EntryEventImpl clientEvent, boolean returnTombstones) throws PrimaryBucketException, ForceReattemptException, PRLocallyDestroyedException {
        return this.getLocally(bucketId, key, aCallbackArgument, disableCopyOnRead, preferCD, requestingClient, clientEvent, returnTombstones, false);
    }

    public Object getLocally(int bucketId, Object key, Object aCallbackArgument, boolean disableCopyOnRead, boolean preferCD, ClientProxyMembershipID requestingClient, EntryEventImpl clientEvent, boolean returnTombstones, boolean opScopeIsLocal) throws PrimaryBucketException, ForceReattemptException, PRLocallyDestroyedException {
        BucketRegion bucketRegion = this.getInitializedBucketForId(key, bucketId);
        Object ret = null;
        if (logger.isDebugEnabled()) {
            logger.debug("getLocally:  key {}) bucketId={}{}{} region {} returnTombstones {} ", key, (Object)this.partitionedRegion.getPRId(), (Object)":", (Object)bucketId, (Object)bucketRegion.getName(), (Object)returnTombstones);
        }
        this.invokeBucketReadHook();
        try {
            ret = bucketRegion.get(key, aCallbackArgument, true, disableCopyOnRead, preferCD, requestingClient, clientEvent, returnTombstones, opScopeIsLocal, false);
            this.checkIfBucketMoved(bucketRegion);
        }
        catch (RegionDestroyedException rde) {
            if (this.partitionedRegion.isLocallyDestroyed || this.partitionedRegion.isClosed) {
                throw new PRLocallyDestroyedException(rde);
            }
            this.getPartitionedRegion().checkReadiness();
            if (bucketRegion.isBucketDestroyed()) {
                throw new ForceReattemptException("Bucket removed during get", rde);
            }
            throw new InternalGemFireError("Got region destroyed message, but neither bucket nor PR was destroyed", rde);
        }
        return ret;
    }

    public BucketRegion.RawValue getSerializedLocally(KeyInfo keyInfo, boolean doNotLockEntry, ClientProxyMembershipID requestingClient, EntryEventImpl clientEvent, boolean returnTombstones) throws PrimaryBucketException, ForceReattemptException {
        BucketRegion bucketRegion = this.getInitializedBucketForId(keyInfo.getKey(), keyInfo.getBucketId());
        if (logger.isDebugEnabled()) {
            logger.debug("getSerializedLocally:  key {}) bucketId={}{}{} region {}", keyInfo.getKey(), (Object)this.partitionedRegion.getPRId(), (Object)":", (Object)keyInfo.getBucketId(), (Object)bucketRegion.getName());
        }
        this.invokeBucketReadHook();
        try {
            BucketRegion.RawValue result = bucketRegion.getSerialized(keyInfo, true, doNotLockEntry, requestingClient, clientEvent, returnTombstones);
            this.checkIfBucketMoved(bucketRegion);
            return result;
        }
        catch (RegionDestroyedException rde) {
            if (bucketRegion.isBucketDestroyed()) {
                throw new ForceReattemptException("Bucket removed during get", rde);
            }
            throw rde;
        }
        catch (IOException e) {
            throw new ForceReattemptException("Unable to serialize value", e);
        }
    }

    public EntrySnapshot getEntryLocally(int bucketId, Object key, boolean access, boolean allowTombstones) throws EntryNotFoundException, PrimaryBucketException, ForceReattemptException, PRLocallyDestroyedException {
        BucketRegion bucketRegion = this.getInitializedBucketForId(key, bucketId);
        if (logger.isDebugEnabled()) {
            logger.debug("getEntryLocally: key {}) bucketId={}{}{} region {}", key, (Object)this.partitionedRegion.getPRId(), (Object)":", (Object)bucketId, (Object)bucketRegion.getName());
        }
        this.invokeBucketReadHook();
        EntrySnapshot res = null;
        RegionEntry ent = null;
        try {
            ent = bucketRegion.entries.getEntry(key);
            if (ent == null) {
                this.getPartitionedRegion().checkReadiness();
                if (bucketRegion.isBucketDestroyed()) {
                    throw new ForceReattemptException("Bucket removed during getEntry");
                }
                throw new EntryNotFoundException("entry not found");
            }
            if (ent.isTombstone() && allowTombstones || !ent.isDestroyedOrRemoved()) {
                res = new EntrySnapshot(ent, bucketRegion, this.partitionedRegion, allowTombstones);
            }
            this.checkIfBucketMoved(bucketRegion);
            if (access) {
                bucketRegion.updateStatsForGet(ent, res != null);
            }
        }
        catch (RegionDestroyedException rde) {
            try {
                if (this.partitionedRegion.isLocallyDestroyed || this.partitionedRegion.isClosed) {
                    throw new PRLocallyDestroyedException(rde);
                }
                this.getPartitionedRegion().checkReadiness();
                if (bucketRegion.isBucketDestroyed()) {
                    throw new ForceReattemptException("Bucket removed during getEntry", rde);
                }
                throw new RegionDestroyedException("Unable to get Entry.", this.partitionedRegion.toString(), rde);
            }
            catch (Throwable throwable) {
                if (access) {
                    bucketRegion.updateStatsForGet(ent, res != null);
                }
                throw throwable;
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("getEntryLocally returning {}", (Object)res);
        }
        return res;
    }

    public Set handleRemoteGetKeys(Integer bucketId, int interestType2, Object interestArg, boolean allowTombstones) throws PRLocallyDestroyedException, ForceReattemptException {
        if (logger.isDebugEnabled()) {
            logger.debug("handleRemoteGetKeys: bucketId: {}{}{} with tombstones {}", (Object)this.partitionedRegion.getPRId(), (Object)":", (Object)bucketId, (Object)allowTombstones);
        }
        Set ret = Collections.EMPTY_SET;
        BucketRegion r = this.getInitializedBucketForId(null, bucketId);
        try {
            if (r != null) {
                this.invokeBucketReadHook();
                if (!r.isEmpty() || allowTombstones && r.getTombstoneCount() > 0) {
                    ret = r.getKeysWithInterest(interestType2, interestArg, allowTombstones);
                }
                this.checkIfBucketMoved(r);
            }
        }
        catch (RegionDestroyedException rde) {
            if (this.partitionedRegion.isLocallyDestroyed || this.partitionedRegion.isClosed) {
                throw new PRLocallyDestroyedException(rde);
            }
            this.getPartitionedRegion().checkReadiness();
            if (r.isBucketDestroyed()) {
                throw new ForceReattemptException("Bucket removed during remoteGetKeys", rde);
            }
            throw new RegionDestroyedException(String.format("Unable to fetch keys on %s", this.partitionedRegion.toString()), this.partitionedRegion.getFullPath(), rde);
        }
        return ret;
    }

    public Set getKeysLocally(Integer bucketId, boolean allowTombstones) throws PRLocallyDestroyedException, ForceReattemptException {
        if (logger.isDebugEnabled()) {
            logger.debug("handleRemoteGetKeys: bucketId: {}{}{}", (Object)this.partitionedRegion.getPRId(), (Object)":", (Object)bucketId);
        }
        HashSet ret = Collections.EMPTY_SET;
        BucketRegion r = this.getInitializedBucketForId(null, bucketId);
        this.invokeBucketReadHook();
        try {
            if (r != null) {
                ret = new HashSet(r.keySet(allowTombstones));
                this.checkIfBucketMoved(r);
            }
        }
        catch (RegionDestroyedException rde) {
            if (this.partitionedRegion.isLocallyDestroyed || this.partitionedRegion.isClosed) {
                throw new PRLocallyDestroyedException(rde);
            }
            this.getPartitionedRegion().checkReadiness();
            if (r.isBucketDestroyed()) {
                throw new ForceReattemptException("Bucket removed during keySet", rde);
            }
            throw new RegionDestroyedException(String.format("Unable to fetch keys on %s", this.partitionedRegion), this.partitionedRegion.getFullPath(), rde);
        }
        return ret;
    }

    public String toString() {
        if (this.partitionedRegion != null) {
            String rName = this.partitionedRegion.getFullPath();
            return this.partitionedRegion.getMyId() + "@" + this.getClass().getName() + "@" + System.identityHashCode(this) + " name: " + rName + " bucket count: " + this.localBucket2RegionMap.size();
        }
        return null;
    }

    public boolean createLocally(BucketRegion bucketRegion, EntryEventImpl event, boolean ifNew, boolean ifOld, boolean requireOldValue, long lastModified) throws ForceReattemptException {
        boolean result = false;
        try {
            event.setRegion(bucketRegion);
            result = event.isOriginRemote() ? bucketRegion.basicUpdate(event, ifNew, ifOld, lastModified, true) : bucketRegion.virtualPut(event, ifNew, ifOld, null, requireOldValue, lastModified, false);
            bucketRegion.checkReadiness();
        }
        catch (RegionDestroyedException rde) {
            this.checkRegionDestroyedOnBucket(bucketRegion, event.isOriginRemote(), rde);
        }
        return result;
    }

    protected void invalidateLocally(Integer bucketId, EntryEventImpl event) throws EntryNotFoundException, PrimaryBucketException, ForceReattemptException {
        if (logger.isDebugEnabled()) {
            logger.debug("invalidateLocally: bucketId={}{}{} for key={}", (Object)this.partitionedRegion.getPRId(), (Object)":", (Object)bucketId, event.getKey());
        }
        BucketRegion bucketRegion = this.getInitializedBucketForId(event.getKey(), bucketId);
        try {
            event.setRegion(bucketRegion);
            event.setOldValueFromRegion();
            bucketRegion.basicInvalidate(event);
            bucketRegion.checkReadiness();
        }
        catch (RegionDestroyedException rde) {
            this.checkRegionDestroyedOnBucket(bucketRegion, event.isOriginRemote(), rde);
        }
    }

    public Map<Integer, Integer> getSizeLocally() {
        return this.getSizeLocally(false);
    }

    public Map<Integer, Integer> getSizeLocally(boolean primaryOnly) {
        if (this.localBucket2RegionMap.isEmpty()) {
            return Collections.EMPTY_MAP;
        }
        HashMap<Integer, Integer> mySizeMap = new HashMap<Integer, Integer>(this.localBucket2RegionMap.size());
        for (Map.Entry me : this.localBucket2RegionMap.entrySet()) {
            try {
                BucketRegion r = (BucketRegion)me.getValue();
                if (null == r) continue;
                r.waitForData();
                if (primaryOnly) {
                    if (!r.getBucketAdvisor().isPrimary()) continue;
                    mySizeMap.put((Integer)me.getKey(), r.size());
                    continue;
                }
                mySizeMap.put((Integer)me.getKey(), r.size());
            }
            catch (CacheRuntimeException cacheRuntimeException) {}
        }
        if (logger.isDebugEnabled()) {
            logger.debug("getSizeLocally: returns bucketSizes={}", mySizeMap);
        }
        return mySizeMap;
    }

    public Map<Integer, PartitionedRegion.SizeEntry> getSizeForLocalBuckets() {
        return this.getSizeLocallyForBuckets(this.localBucket2RegionMap.keySet());
    }

    public Map<Integer, PartitionedRegion.SizeEntry> getSizeForLocalPrimaryBuckets() {
        return this.getSizeLocallyForBuckets(this.getAllLocalPrimaryBucketIds());
    }

    public Map<Integer, PartitionedRegion.SizeEntry> getSizeEstimateForLocalPrimaryBuckets() {
        return this.getSizeEstimateLocallyForBuckets(this.getAllLocalPrimaryBucketIds());
    }

    public Map<Integer, PartitionedRegion.SizeEntry> getSizeLocallyForBuckets(Collection<Integer> bucketIds) {
        return this.getSizeLocallyForPrimary(bucketIds, false);
    }

    public Map<Integer, PartitionedRegion.SizeEntry> getSizeEstimateLocallyForBuckets(Collection<Integer> bucketIds) {
        return this.getSizeLocallyForPrimary(bucketIds, true);
    }

    private Map<Integer, PartitionedRegion.SizeEntry> getSizeLocallyForPrimary(Collection<Integer> bucketIds, boolean estimate) {
        if (this.localBucket2RegionMap.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Integer, PartitionedRegion.SizeEntry> mySizeMap = new HashMap<Integer, PartitionedRegion.SizeEntry>(this.localBucket2RegionMap.size());
        BucketRegion r = null;
        for (Integer bucketId : bucketIds) {
            try {
                r = this.getInitializedBucketForId(null, bucketId);
                mySizeMap.put(bucketId, new PartitionedRegion.SizeEntry(estimate ? r.sizeEstimate() : r.size(), r.getBucketAdvisor().isPrimary()));
            }
            catch (PrimaryBucketException skip) {
            }
            catch (ForceReattemptException skip) {
            }
            catch (RegionDestroyedException skip) {}
        }
        return mySizeMap;
    }

    public int getSizeOfLocalPrimaryBuckets() {
        int sizeOfLocalPrimaries = 0;
        Set<BucketRegion> primaryBuckets = this.getAllLocalPrimaryBucketRegions();
        for (BucketRegion br : primaryBuckets) {
            sizeOfLocalPrimaries += br.size();
        }
        return sizeOfLocalPrimaries;
    }

    public int getSizeOfLocalBuckets() {
        int sizeOfLocal = 0;
        Set<BucketRegion> allLocalBuckets = this.getAllLocalBucketRegions();
        for (BucketRegion br : allLocalBuckets) {
            sizeOfLocal += br.size();
        }
        return sizeOfLocal;
    }

    public void visitBuckets(BucketVisitor bv) {
        if (this.localBucket2RegionMap.size() > 0) {
            for (Map.Entry me : this.localBucket2RegionMap.entrySet()) {
                Region r = (Region)me.getValue();
                if (r == null) continue;
                bv.visit((Integer)me.getKey(), r);
            }
        }
    }

    private void visitBucket(Integer bucketId, LocalRegion bucket, EntryVisitor ev) {
        try {
            Iterator ei = bucket.entrySet().iterator();
            while (ei.hasNext()) {
                ev.visit(bucketId, (Region.Entry)ei.next());
            }
        }
        catch (CacheRuntimeException cacheRuntimeException) {
            // empty catch block
        }
        ev.finishedVisiting();
    }

    private void visitEntries(final EntryVisitor knock) {
        this.visitBuckets(new BucketVisitor(){

            @Override
            public void visit(Integer bucketId, Region buk) {
                try {
                    ((LocalRegion)buk).waitForData();
                    Iterator ei = buk.entrySet().iterator();
                    while (ei.hasNext()) {
                        knock.visit(bucketId, (Region.Entry)ei.next());
                    }
                }
                catch (CacheRuntimeException cacheRuntimeException) {
                    // empty catch block
                }
                knock.finishedVisiting();
            }
        });
    }

    public List getEntries() {
        final ArrayList al = new ArrayList();
        this.visitEntries(new EntryVisitor(){

            @Override
            public void visit(Integer bucketId, Region.Entry re) {
                if (re.getValue() != Token.TOMBSTONE) {
                    al.add(re);
                }
            }

            @Override
            public void finishedVisiting() {
            }
        });
        return al;
    }

    public void dumpEntries(boolean validateOnly) {
        if (logger.isDebugEnabled()) {
            logger.debug("[dumpEntries] dumping {}", (Object)this);
        }
        if (validateOnly) {
            Object buf = null;
            this.partitionedRegion.waitForData();
        } else {
            this.dumpBackingMaps();
        }
    }

    public void dumpBackingMaps() {
        if (logger.isDebugEnabled()) {
            logger.debug("Bucket maps in {}\n", (Object)this);
        }
        this.visitBuckets(new BucketVisitor(){

            @Override
            public void visit(Integer bucketId, Region buk) {
                try {
                    LocalRegion lbuk = (LocalRegion)buk;
                    lbuk.waitForData();
                    int size = lbuk.size();
                    int keySetSize = new HashSet(lbuk.keySet()).size();
                    if (size != keySetSize && logger.isDebugEnabled()) {
                        logger.debug("Size is not consistent with keySet size! size={} but keySet size={} region={}", (Object)size, (Object)keySetSize, (Object)lbuk);
                    }
                    lbuk.dumpBackingMap();
                }
                catch (CacheRuntimeException cacheRuntimeException) {
                    // empty catch block
                }
            }
        });
    }

    public void dumpBuckets() {
        final StringBuffer buf = new StringBuffer("Buckets in ").append(this).append("\n");
        this.visitBuckets(new BucketVisitor(){

            @Override
            public void visit(Integer bucketId, Region r) {
                buf.append("bucketId: ").append(PartitionedRegionDataStore.this.partitionedRegion.bucketStringForLogs(bucketId)).append(" bucketName: ").append(r).append("\n");
            }
        });
        logger.debug(buf.toString());
    }

    public List getLocalBucketsListTestOnly() {
        final ArrayList bucketList = new ArrayList();
        this.visitBuckets(new BucketVisitor(){

            @Override
            public void visit(Integer bucketId, Region r) {
                bucketList.add(bucketId);
            }
        });
        return bucketList;
    }

    public List getLocalPrimaryBucketsListTestOnly() {
        final ArrayList primaryBucketList = new ArrayList();
        this.visitBuckets(new BucketVisitor(){

            @Override
            public void visit(Integer bucketId, Region r) {
                BucketRegion br = (BucketRegion)r;
                BucketAdvisor ba = (BucketAdvisor)br.getDistributionAdvisor();
                if (ba.isPrimary()) {
                    primaryBucketList.add(bucketId);
                }
            }
        });
        return primaryBucketList;
    }

    public List getLocalNonPrimaryBucketsListTestOnly() {
        final ArrayList nonPrimaryBucketList = new ArrayList();
        this.visitBuckets(new BucketVisitor(){

            @Override
            public void visit(Integer bucketId, Region r) {
                BucketRegion br = (BucketRegion)r;
                BucketAdvisor ba = (BucketAdvisor)br.getDistributionAdvisor();
                if (!ba.isPrimary()) {
                    nonPrimaryBucketList.add(bucketId);
                }
            }
        });
        return nonPrimaryBucketList;
    }

    public void dumpBucket(int bucketId, final LocalRegion bucket) {
        Integer buckId = bucketId;
        this.visitBucket(buckId, bucket, new EntryVisitor(){
            final StringBuffer buf;
            {
                this.buf = new StringBuffer("Entries in bucket ").append(bucket).append("\n");
            }

            @Override
            public void visit(Integer bid, Region.Entry re) {
                this.buf.append(re.getKey()).append(" => ").append(re.getValue()).append("\n");
            }

            @Override
            public void finishedVisiting() {
                logger.debug(this.buf.toString());
            }
        });
    }

    public BucketRegion handleRemoteGetEntries(int bucketId) throws ForceReattemptException {
        if (logger.isDebugEnabled()) {
            logger.debug("handleRemoteGetEntries: bucketId: {}{}{}", (Object)this.partitionedRegion.getPRId(), (Object)":", (Object)bucketId);
        }
        BucketRegion br = this.getInitializedBucketForId(null, bucketId);
        return br;
    }

    @Override
    public CachePerfStats getCachePerfStats() {
        return this.bucketStats;
    }

    public Set<Map.Entry<Integer, BucketRegion>> getAllLocalBuckets() {
        return Collections.unmodifiableSet(this.localBucket2RegionMap.entrySet());
    }

    public Set<Integer> getAllLocalBucketIds() {
        return Collections.unmodifiableSet(this.localBucket2RegionMap.keySet());
    }

    public Set<BucketRegion> getAllLocalBucketRegions() {
        HashSet<BucketRegion> retVal = new HashSet<BucketRegion>();
        for (BucketRegion br : this.localBucket2RegionMap.values()) {
            retVal.add(br);
        }
        return Collections.unmodifiableSet(retVal);
    }

    public boolean isLocalBucketRegionPresent() {
        return this.localBucket2RegionMap.size() > 0;
    }

    public Set<BucketRegion> getAllLocalPrimaryBucketRegions() {
        HashSet<BucketRegion> retVal = new HashSet<BucketRegion>();
        for (BucketRegion br : this.localBucket2RegionMap.values()) {
            if (!br.getBucketAdvisor().isPrimary()) continue;
            retVal.add(br);
        }
        return Collections.unmodifiableSet(retVal);
    }

    public Set<Integer> getAllLocalPrimaryBucketIds() {
        HashSet<Integer> bucketIds = new HashSet<Integer>();
        for (Map.Entry<Integer, BucketRegion> bucketEntry : this.getAllLocalBuckets()) {
            BucketRegion bucket = bucketEntry.getValue();
            if (!bucket.getBucketAdvisor().isPrimary()) continue;
            bucketIds.add(bucket.getId());
        }
        return bucketIds;
    }

    public Set<Integer> getAllLocalPrimaryBucketIdsBetweenProvidedIds(int low, int high) {
        HashSet<Integer> bucketIds = new HashSet<Integer>();
        for (Map.Entry<Integer, BucketRegion> bucketEntry : this.getAllLocalBuckets()) {
            BucketRegion bucket = bucketEntry.getValue();
            if (!bucket.getBucketAdvisor().isPrimary() || bucket.getId() < low || bucket.getId() >= high) continue;
            bucketIds.add(bucket.getId());
        }
        return bucketIds;
    }

    public long getEstimatedLocalBucketSize(boolean primaryOnly) {
        long size = 0L;
        for (BucketRegion br : this.localBucket2RegionMap.values()) {
            if (primaryOnly && !br.getBucketAdvisor().isPrimary()) continue;
            size += br.getEstimatedLocalSize();
        }
        return size;
    }

    public long getEstimatedLocalBucketSize(Set<Integer> bucketIds) {
        long size = 0L;
        for (Integer bid : bucketIds) {
            BucketRegion br = (BucketRegion)this.localBucket2RegionMap.get(bid);
            if (br == null) continue;
            size += br.getEstimatedLocalSize();
        }
        return size;
    }

    public Object getLocalValueInVM(Object key, int bucketId) {
        try {
            BucketRegion br = this.getInitializedBucketForId(key, bucketId);
            return br.getValueInVM(key);
        }
        catch (ForceReattemptException e) {
            e.checkKey(key);
            return null;
        }
    }

    public Object getLocalValueOnDisk(Object key, int bucketId) {
        try {
            BucketRegion br = this.getInitializedBucketForId(key, bucketId);
            return br.getValueOnDisk(key);
        }
        catch (ForceReattemptException e) {
            e.checkKey(key);
            return null;
        }
    }

    public Object getLocalValueOnDiskOrBuffer(Object key, int bucketId) {
        try {
            BucketRegion br = this.getInitializedBucketForId(key, bucketId);
            return br.getValueOnDiskOrBuffer(key);
        }
        catch (ForceReattemptException e) {
            e.checkKey(key);
            return null;
        }
    }

    public void checkRegionDestroyedOnBucket(BucketRegion br, boolean isOriginRemote, RegionDestroyedException rde) throws ForceReattemptException {
        if (isOriginRemote) {
            if (logger.isDebugEnabled()) {
                logger.debug("Operation failed due to RegionDestroyedException", (Throwable)rde);
            }
            if (this.partitionedRegion.isLocallyDestroyed || this.partitionedRegion.isClosed) {
                throw new ForceReattemptException("Operation failed due to RegionDestroyedException :" + rde, rde);
            }
            this.partitionedRegion.checkReadiness();
            if (br.isBucketDestroyed()) {
                throw new ForceReattemptException("Bucket moved", rde);
            }
        } else {
            this.partitionedRegion.checkReadiness();
            if (br.isBucketDestroyed()) {
                throw new ForceReattemptException("Bucket moved", rde);
            }
        }
        throw new InternalGemFireError("Got region destroyed message, but neither bucket nor PR was destroyed", rde);
    }

    public CreateBucketResult grabBucket(int bucketId, InternalDistributedMember moveSource, boolean forceCreation, boolean replaceOffineData, boolean isRebalance, InternalDistributedMember creationRequestor, boolean isDiskRecovery) {
        CreateBucketResult grab = this.grabFreeBucket(bucketId, this.partitionedRegion.getMyId(), moveSource, forceCreation, isRebalance, true, replaceOffineData, creationRequestor);
        if (!grab.nowExists()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Failed grab for bucketId = {}{}{}", (Object)this.partitionedRegion.getPRId(), (Object)":", (Object)bucketId);
            }
        } else {
            List<PartitionedRegion> colocatedWithList = ColocationHelper.getColocatedChildRegions(this.partitionedRegion);
            for (PartitionedRegion pr : colocatedWithList) {
                block8: {
                    if (logger.isDebugEnabled()) {
                        logger.debug("For bucketId = {} isInitialized {} iscolocation complete {} pr name {}", (Object)bucketId, (Object)pr.isInitialized(), (Object)pr.getDataStore().isColocationComplete(bucketId), (Object)pr.getFullPath());
                    }
                    if (!isDiskRecovery && !pr.isInitialized() || !pr.getDataStore().isColocationComplete(bucketId)) continue;
                    try {
                        grab = pr.getDataStore().grabFreeBucketRecursively(bucketId, pr, moveSource, forceCreation, replaceOffineData, isRebalance, creationRequestor, isDiskRecovery);
                    }
                    catch (RegionDestroyedException rde) {
                        if (!logger.isDebugEnabled()) break block8;
                        logger.debug("Failed to grab, colocated region for bucketId = {}{}{} is destroyed.", (Object)this.partitionedRegion.getPRId(), (Object)":", (Object)bucketId);
                    }
                }
                if (grab.nowExists() || !logger.isDebugEnabled()) continue;
                logger.debug("Failed grab for bucketId = {}{}{}", (Object)this.partitionedRegion.getPRId(), (Object)":", (Object)bucketId);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Grab attempt on bucketId={}{}{}; grab:{}", (Object)this.partitionedRegion.getPRId(), (Object)":", (Object)bucketId, (Object)grab);
        }
        return grab;
    }

    public boolean verifyBucketBeforeGrabbing(int buckId) {
        boolean isNodeInMetaData = this.partitionedRegion.getRegionAdvisor().isBucketLocal(buckId);
        if (this.isManagingBucket(buckId)) {
            if (!isNodeInMetaData) {
                this.partitionedRegion.checkReadiness();
                Set<InternalDistributedMember> owners = this.partitionedRegion.getRegionAdvisor().getBucketOwners(buckId);
                logger.info("Verified nodelist for bucketId={} is {}", (Object)this.partitionedRegion.bucketStringForLogs(buckId), (Object)PartitionedRegionHelper.printCollection(owners));
                Assert.assertTrue(false, " This node " + this.partitionedRegion.getNode() + " is managing the bucket with bucketId= " + this.partitionedRegion.bucketStringForLogs(buckId) + " but doesn't have an entry in b2n region for PR " + this.partitionedRegion);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("BR#verifyBucketBeforeGrabbing We already host {}{}{}", (Object)this.partitionedRegion.getPRId(), (Object)":", (Object)buckId);
            }
            return true;
        }
        if (this.partitionedRegion.isDestroyed() || this.partitionedRegion.getGemFireCache().isClosed()) {
            if (logger.isDebugEnabled()) {
                logger.debug("BR#verifyBucketBeforeGrabbing: Exiting early due to Region destruction");
            }
            return false;
        }
        if (isNodeInMetaData && logger.isDebugEnabled()) {
            logger.debug("PartitionedRegionDataStore: grabBackupBuckets: This node is not managing the bucket with Id = {} but has an entry in the b2n region for PartitionedRegion {} because destruction of this PartitionedRegion is initiated on other node", (Object)buckId, (Object)this.partitionedRegion);
        }
        return true;
    }

    public void executeOnDataStore(Set localKeys, Function function, Object object, int prid, int[] bucketArray, boolean isReExecute, PartitionedRegionFunctionStreamingMessage msg, long time, ServerConnection servConn, int transactionID) {
        if (!this.areAllBucketsHosted(bucketArray)) {
            throw new BucketMovedException("Bucket migrated to another node. Please retry.");
        }
        DistributionManager dm = this.partitionedRegion.getDistributionManager();
        PartitionedRegionFunctionResultSender resultSender = new PartitionedRegionFunctionResultSender(dm, this.partitionedRegion, time, msg, function, bucketArray);
        RegionFunctionContextImpl prContext = new RegionFunctionContextImpl(this.getPartitionedRegion().getCache(), function.getId(), this.partitionedRegion, object, localKeys, ColocationHelper.constructAndGetAllColocatedLocalDataSet(this.partitionedRegion, bucketArray), bucketArray, resultSender, isReExecute);
        FunctionStats stats = FunctionStatsManager.getFunctionStats(function.getId(), dm.getSystem());
        long start = stats.startFunctionExecution(function.hasResult());
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Executing Function: {} on Remote Node with context: ", (Object)function.getId(), (Object)prContext);
            }
            function.execute(prContext);
            stats.endFunctionExecution(start, function.hasResult());
        }
        catch (FunctionException functionException) {
            if (logger.isDebugEnabled()) {
                logger.debug("FunctionException occurred on remote node while executing Function: {}", (Object)function.getId(), (Object)functionException);
            }
            stats.endFunctionExecutionWithException(start, function.hasResult());
            if (functionException.getCause() instanceof QueryInvalidException) {
                throw new FunctionException(functionException.getLocalizedMessage());
            }
            throw functionException;
        }
    }

    public boolean areAllBucketsHosted(int[] bucketArray) {
        int bucketlength = BucketSetHelper.length(bucketArray);
        if (bucketlength == 0) {
            return true;
        }
        for (int i = 0; i < bucketlength; ++i) {
            int bucket = BucketSetHelper.get(bucketArray, i);
            if (this.partitionedRegion.getRegionAdvisor().getBucketAdvisor(bucket).isHosting()) continue;
            return false;
        }
        return true;
    }

    public boolean hasSeenEvent(EntryEventImpl event) {
        BucketRegion bucket = this.getLocalBucketById(event.getKeyInfo().getBucketId());
        if (bucket == null) {
            return false;
        }
        return bucket.hasSeenEvent(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleInterestEvent(InterestRegistrationEvent event) {
        if (logger.isDebugEnabled()) {
            logger.debug("PartitionedRegionDataStore for {} handling {}", (Object)this.partitionedRegion.getFullPath(), (Object)event);
        }
        Object object = this.keysOfInterestLock;
        synchronized (object) {
            boolean isRegister = event.isRegister();
            for (Object key : event.getKeysOfInterest()) {
                AtomicInteger references = (AtomicInteger)this.keysOfInterest.get(key);
                int newNumberOfReferences = 0;
                if (isRegister) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("PartitionedRegionDataStore for {} adding interest for: ", (Object)this.partitionedRegion.getFullPath(), key);
                    }
                    if (references == null) {
                        references = new AtomicInteger();
                        this.keysOfInterest.put(key, references);
                    }
                    newNumberOfReferences = references.incrementAndGet();
                } else {
                    if (logger.isDebugEnabled()) {
                        logger.debug("PartitionedRegionDataStore for {} removing interest for: ", (Object)this.partitionedRegion.getFullPath(), key);
                    }
                    if (references != null && (newNumberOfReferences = references.decrementAndGet()) == 0) {
                        this.keysOfInterest.remove(key);
                    }
                }
                if (!logger.isDebugEnabled()) continue;
                logger.debug("PartitionedRegionDataStore for {} now has {} client(s) interested in key {}", (Object)this.partitionedRegion.getFullPath(), (Object)newNumberOfReferences, key);
            }
        }
    }

    public void updateEntryVersionLocally(Integer bucketId, EntryEventImpl event) throws ForceReattemptException {
        if (logger.isDebugEnabled()) {
            logger.debug("updateEntryVersionLocally: bucketId={}{}{} for key={}", (Object)this.partitionedRegion.getPRId(), (Object)":", (Object)bucketId, event.getKey());
        }
        BucketRegion bucketRegion = this.getInitializedBucketForId(event.getKey(), bucketId);
        try {
            event.setRegion(bucketRegion);
            bucketRegion.basicUpdateEntryVersion(event);
            bucketRegion.checkReadiness();
        }
        catch (RegionDestroyedException rde) {
            this.checkRegionDestroyedOnBucket(bucketRegion, event.isOriginRemote(), rde);
        }
    }

    public static enum CreateBucketResult {
        CREATED(true),
        FAILED(false),
        ALREADY_EXISTS(true),
        REDUNDANCY_ALREADY_SATISFIED(false);

        private final boolean nowExists;

        private CreateBucketResult(boolean nowExists) {
            this.nowExists = nowExists;
        }

        boolean nowExists() {
            return this.nowExists;
        }
    }

    class BucketAttributesFactory
    extends AttributesFactory {
        BucketAttributesFactory() {
        }

        @Override
        protected void setBucketRegion(boolean b) {
            super.setBucketRegion(b);
        }
    }

    protected static abstract class EntryVisitor {
        protected EntryVisitor() {
        }

        public abstract void visit(Integer var1, Region.Entry var2);

        public abstract void finishedVisiting();
    }

    public static interface BucketVisitor {
        public void visit(Integer var1, Region var2);
    }
}

