/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.apache.geode.DataSerializer;
import org.apache.geode.cache.CacheEvent;
import org.apache.geode.cache.DataPolicy;
import org.apache.geode.cache.EntryNotFoundException;
import org.apache.geode.cache.Operation;
import org.apache.geode.cache.RegionAttributes;
import org.apache.geode.cache.Scope;
import org.apache.geode.cache.persistence.PersistentReplicatesOfflineException;
import org.apache.geode.cache.query.internal.cq.CqService;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.DirectReplyProcessor;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.cache.AbstractUpdateOperation;
import org.apache.geode.internal.cache.BucketRegion;
import org.apache.geode.internal.cache.CacheDistributionAdvisor;
import org.apache.geode.internal.cache.DistributedCacheOperation;
import org.apache.geode.internal.cache.DistributedPutAllOperation;
import org.apache.geode.internal.cache.DistributedRegion;
import org.apache.geode.internal.cache.EntryEventImpl;
import org.apache.geode.internal.cache.EventID;
import org.apache.geode.internal.cache.FilterProfile;
import org.apache.geode.internal.cache.FilterRoutingInfo;
import org.apache.geode.internal.cache.InternalCacheEvent;
import org.apache.geode.internal.cache.InternalRegion;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.Token;
import org.apache.geode.internal.cache.ha.ThreadIdentifier;
import org.apache.geode.internal.cache.partitioned.RemoveAllPRMessage;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.internal.cache.tier.sockets.VersionedObjectList;
import org.apache.geode.internal.cache.tx.RemoteRemoveAllMessage;
import org.apache.geode.internal.cache.versions.ConcurrentCacheModificationException;
import org.apache.geode.internal.cache.versions.DiskVersionTag;
import org.apache.geode.internal.cache.versions.VersionTag;
import org.apache.geode.internal.serialization.ByteArrayDataInput;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;
import org.apache.geode.internal.serialization.StaticSerialization;
import org.apache.geode.internal.serialization.Version;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class DistributedRemoveAllOperation
extends AbstractUpdateOperation {
    private static final Logger logger = LogService.getLogger();
    protected final RemoveAllEntryData[] removeAllData;
    public int removeAllDataSize;
    protected boolean isBridgeOp = false;
    static final byte USED_FAKE_EVENT_ID = 1;
    static final byte NOTIFY_ONLY = 2;
    static final byte FILTER_ROUTING = 4;
    static final byte VERSION_TAG = 8;
    static final byte POSDUP = 16;
    static final byte PERSISTENT_TAG = 32;
    static final byte HAS_CALLBACKARG = 64;
    static final byte HAS_TAILKEY = -128;

    public DistributedRemoveAllOperation(CacheEvent event, int size, boolean isBridgeOp) {
        super(event, ((EntryEventImpl)event).getEventTime(0L));
        this.removeAllData = new RemoveAllEntryData[size];
        this.removeAllDataSize = 0;
        this.isBridgeOp = isBridgeOp;
    }

    public boolean isBridgeOperation() {
        return this.isBridgeOp;
    }

    public RemoveAllEntryData[] getRemoveAllEntryData() {
        return this.removeAllData;
    }

    public void setRemoveAllEntryData(RemoveAllEntryData[] removeAllEntryData) {
        for (int i = 0; i < removeAllEntryData.length; ++i) {
            this.removeAllData[i] = removeAllEntryData[i];
        }
        this.removeAllDataSize = removeAllEntryData.length;
    }

    public void addEntry(RemoveAllEntryData removeAllEntry) {
        this.removeAllData[this.removeAllDataSize] = removeAllEntry;
        ++this.removeAllDataSize;
    }

    public void addEntry(EntryEventImpl ev) {
        this.removeAllData[this.removeAllDataSize] = new RemoveAllEntryData(ev);
        ++this.removeAllDataSize;
    }

    public void addEntry(EntryEventImpl ev, boolean newCallbackInvoked) {
        this.removeAllData[this.removeAllDataSize] = new RemoveAllEntryData(ev);
        this.removeAllData[this.removeAllDataSize].setCallbacksInvoked(newCallbackInvoked);
        ++this.removeAllDataSize;
    }

    public void addEntry(EntryEventImpl ev, Integer bucketId) {
        this.removeAllData[this.removeAllDataSize] = new RemoveAllEntryData(ev);
        this.removeAllData[this.removeAllDataSize].setBucketId(bucketId);
        ++this.removeAllDataSize;
    }

    public void setUseFakeEventId(boolean status) {
        for (int i = 0; i < this.removeAllDataSize; ++i) {
            this.removeAllData[i].setUsedFakeEventId(status);
        }
    }

    public Iterator eventIterator() {
        return new Iterator(){
            int position = 0;

            @Override
            public boolean hasNext() {
                return DistributedRemoveAllOperation.this.removeAllDataSize > this.position;
            }

            public Object next() {
                EntryEventImpl ev = DistributedRemoveAllOperation.this.getEventForPosition(this.position);
                ++this.position;
                return ev;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public void freeOffHeapResources() {
        for (int i = 0; i < this.removeAllDataSize; ++i) {
            RemoveAllEntryData entry = this.removeAllData[i];
            if (entry == null || entry.event == null) continue;
            entry.event.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntryEventImpl getEventForPosition(int position) {
        RemoveAllEntryData entry = this.removeAllData[position];
        if (entry == null) {
            return null;
        }
        if (entry.event != null) {
            return entry.event;
        }
        LocalRegion region = (LocalRegion)this.event.getRegion();
        EntryEventImpl ev = EntryEventImpl.create((InternalRegion)region, entry.getOp(), entry.getKey(), null, this.event.getCallbackArgument(), false, this.event.getDistributedMember(), this.event.isGenerateCallbacks(), entry.getEventID());
        boolean returnedEv = false;
        try {
            ev.setPossibleDuplicate(entry.isPossibleDuplicate());
            ev.setIsRedestroyedEntry(entry.getRedestroyedEntry());
            if (entry.versionTag != null && region.getConcurrencyChecksEnabled()) {
                Object id = entry.versionTag.getMemberID();
                if (id != null) {
                    entry.versionTag.setMemberID(ev.getRegion().getVersionVector().getCanonicalId(id));
                }
                ev.setVersionTag(entry.versionTag);
            }
            entry.event = ev;
            returnedEv = true;
            ev.setOldValue(entry.getOldValue());
            CqService cqService = region.getCache().getCqService();
            if (cqService.isRunning() && !entry.getOp().isCreate() && !ev.hasOldValue()) {
                ev.setOldValueForQueryProcessing();
            }
            ev.setInvokePRCallbacks(!entry.isNotifyOnly());
            if (this.getBaseEvent().getContext() != null) {
                ev.setContext(this.getBaseEvent().getContext());
            }
            ev.callbacksInvoked(entry.isCallbacksInvoked());
            ev.setTailKey(entry.getTailKey());
            EntryEventImpl entryEventImpl = ev;
            return entryEventImpl;
        }
        finally {
            if (!returnedEv) {
                ev.release();
            }
        }
    }

    public EntryEventImpl getBaseEvent() {
        return this.getEvent();
    }

    @Override
    protected FilterRoutingInfo getRecipientFilterRouting(Set cacheOpRecipients) {
        LocalRegion region = (LocalRegion)this.event.getRegion();
        CacheDistributionAdvisor advisor = region instanceof PartitionedRegion ? ((PartitionedRegion)region).getCacheDistributionAdvisor() : (region.isUsedForPartitionedRegionBucket() ? ((BucketRegion)region).getPartitionedRegion().getCacheDistributionAdvisor() : ((DistributedRegion)region).getCacheDistributionAdvisor());
        FilterRoutingInfo consolidated = new FilterRoutingInfo();
        for (int i = 0; i < this.removeAllData.length; ++i) {
            EntryEventImpl ev = this.getEventForPosition(i);
            if (ev == null) continue;
            FilterRoutingInfo eventRouting = advisor.adviseFilterRouting(ev, cacheOpRecipients);
            if (eventRouting != null) {
                consolidated.addFilterInfo(eventRouting);
            }
            this.removeAllData[i].filterRouting = eventRouting;
        }
        return consolidated;
    }

    @Override
    protected FilterRoutingInfo.FilterInfo getLocalFilterRouting(FilterRoutingInfo frInfo) {
        FilterProfile fp = this.getRegion().getFilterProfile();
        if (fp == null) {
            return null;
        }
        if (this.removeAllData != null && this.removeAllData.length > 0) {
            fp.getLocalFilterRoutingForRemoveAllOp(this, this.removeAllData);
        }
        return null;
    }

    @Override
    protected DistributedCacheOperation.CacheOperationMessage createMessage() {
        EntryEventImpl event = this.getBaseEvent();
        RemoveAllMessage msg = new RemoveAllMessage();
        msg.eventId = event.getEventId();
        msg.context = event.getContext();
        return msg;
    }

    public RemoveAllPRMessage createPRMessagesNotifyOnly(int bucketId) {
        EntryEventImpl event = this.getBaseEvent();
        RemoveAllPRMessage prMsg = new RemoveAllPRMessage(bucketId, this.removeAllDataSize, true, event.isPossibleDuplicate(), !event.isGenerateCallbacks(), event.getCallbackArgument());
        if (event.getContext() != null) {
            prMsg.setBridgeContext(event.getContext());
        }
        for (int i = 0; i < this.removeAllDataSize; ++i) {
            prMsg.addEntry(this.removeAllData[i]);
        }
        return prMsg;
    }

    public HashMap<Integer, RemoveAllPRMessage> createPRMessages() {
        HashMap<Integer, RemoveAllPRMessage> prMsgMap = new HashMap<Integer, RemoveAllPRMessage>();
        EntryEventImpl event = this.getBaseEvent();
        for (int i = 0; i < this.removeAllDataSize; ++i) {
            Integer bucketId = this.removeAllData[i].getBucketId();
            RemoveAllPRMessage prMsg = prMsgMap.get(bucketId);
            if (prMsg == null) {
                prMsg = new RemoveAllPRMessage(bucketId, this.removeAllDataSize, false, event.isPossibleDuplicate(), !event.isGenerateCallbacks(), event.getCallbackArgument());
                prMsg.setTransactionDistributed(event.getRegion().getCache().getTxManager().isDistributed());
                if (event.getContext() != null) {
                    prMsg.setBridgeContext(event.getContext());
                }
            }
            this.removeAllData[i].setFakeEventID();
            prMsg.addEntry(this.removeAllData[i]);
            prMsgMap.put(bucketId, prMsg);
        }
        return prMsgMap;
    }

    @Override
    protected void initMessage(DistributedCacheOperation.CacheOperationMessage msg, DirectReplyProcessor proc) {
        super.initMessage(msg, proc);
        RemoveAllMessage m = (RemoveAllMessage)msg;
        RegionAttributes attr = this.event.getRegion().getAttributes();
        if (attr.getConcurrencyChecksEnabled() && !attr.getDataPolicy().withReplication() && attr.getScope() != Scope.GLOBAL) {
            if (attr.getDataPolicy() == DataPolicy.EMPTY) {
                boolean success = RemoteRemoveAllMessage.distribute((EntryEventImpl)this.event, this.removeAllData, this.removeAllDataSize);
                if (success) {
                    m.callbackArg = this.event.getCallbackArgument();
                    m.removeAllData = new RemoveAllEntryData[0];
                    m.removeAllDataSize = 0;
                    m.skipCallbacks = !this.event.isGenerateCallbacks();
                    return;
                }
                if (!this.getRegion().getGenerateVersionTag()) {
                    throw new PersistentReplicatesOfflineException();
                }
            } else {
                Object[] versionless = this.selectVersionlessEntries();
                if (logger.isTraceEnabled()) {
                    logger.trace("Found these versionless entries: {}", (Object)Arrays.toString(versionless));
                }
                if (versionless.length > 0) {
                    boolean success = RemoteRemoveAllMessage.distribute((EntryEventImpl)this.event, (RemoveAllEntryData[])versionless, versionless.length);
                    if (success) {
                        versionless = null;
                        Object[] versioned = this.selectVersionedEntries();
                        if (logger.isTraceEnabled()) {
                            logger.trace("Found these remaining versioned entries: {}", (Object)Arrays.toString(versioned));
                        }
                        m.callbackArg = this.event.getCallbackArgument();
                        m.removeAllData = versioned;
                        m.removeAllDataSize = versioned.length;
                        m.skipCallbacks = !this.event.isGenerateCallbacks();
                        return;
                    }
                    if (!this.getRegion().getGenerateVersionTag()) {
                        throw new PersistentReplicatesOfflineException();
                    }
                } else if (logger.isDebugEnabled()) {
                    logger.debug("All entries have versions, so using normal DPAO message");
                }
            }
        }
        m.callbackArg = this.event.getCallbackArgument();
        m.removeAllData = this.removeAllData;
        m.removeAllDataSize = this.removeAllDataSize;
        m.skipCallbacks = !this.event.isGenerateCallbacks();
    }

    @Override
    protected boolean shouldAck() {
        return super.shouldAck() || this.getRegion().getConcurrencyChecksEnabled();
    }

    private RemoveAllEntryData[] selectVersionlessEntries() {
        int resultSize = this.removeAllData.length;
        for (int i = 0; i < this.removeAllData.length; ++i) {
            RemoveAllEntryData p = this.removeAllData[i];
            if (p == null || p.isInhibitDistribution()) {
                --resultSize;
                continue;
            }
            if (p.versionTag == null || !p.versionTag.hasValidVersion()) continue;
            --resultSize;
        }
        RemoveAllEntryData[] result = new RemoveAllEntryData[resultSize];
        int ri = 0;
        for (int i = 0; i < this.removeAllData.length; ++i) {
            RemoveAllEntryData p = this.removeAllData[i];
            if (p == null || p.isInhibitDistribution() || p.versionTag != null && p.versionTag.hasValidVersion()) continue;
            result[ri++] = p;
        }
        return result;
    }

    private RemoveAllEntryData[] selectVersionedEntries() {
        int resultSize = 0;
        for (int i = 0; i < this.removeAllData.length; ++i) {
            RemoveAllEntryData p = this.removeAllData[i];
            if (p == null || p.isInhibitDistribution() || p.versionTag == null || !p.versionTag.hasValidVersion()) continue;
            ++resultSize;
        }
        RemoveAllEntryData[] result = new RemoveAllEntryData[resultSize];
        int ri = 0;
        for (int i = 0; i < this.removeAllData.length; ++i) {
            RemoveAllEntryData p = this.removeAllData[i];
            if (p == null || p.isInhibitDistribution() || p.versionTag == null || !p.versionTag.hasValidVersion()) continue;
            result[ri++] = p;
        }
        return result;
    }

    protected void fillVersionedObjectList(VersionedObjectList list) {
        for (RemoveAllEntryData entry : this.removeAllData) {
            if (entry.versionTag == null) continue;
            list.addKeyAndVersion(entry.key, entry.versionTag);
        }
    }

    public static class RemoveAllMessage
    extends AbstractUpdateOperation.AbstractUpdateMessage {
        protected RemoveAllEntryData[] removeAllData;
        protected int removeAllDataSize;
        protected transient ClientProxyMembershipID context;
        protected boolean skipCallbacks;
        protected EventID eventId = null;
        protected static final short HAS_BRIDGE_CONTEXT = 16384;
        protected static final short SKIP_CALLBACKS = Short.MIN_VALUE;

        public boolean isEmpty() {
            return this.removeAllData.length == 0;
        }

        @Override
        protected InternalCacheEvent createEvent(DistributedRegion rgn) throws EntryNotFoundException {
            EntryEventImpl event = EntryEventImpl.create((InternalRegion)rgn, Operation.REMOVEALL_DESTROY, null, null, this.callbackArg, true, this.getSender());
            if (this.context != null) {
                event.context = this.context;
            }
            event.setPossibleDuplicate(this.possibleDuplicate);
            event.setEventId(this.eventId);
            return event;
        }

        @Override
        public void appendFields(StringBuilder sb) {
            super.appendFields(sb);
            if (this.eventId != null) {
                sb.append("; eventId=").append(this.eventId);
            }
            sb.append("; entries=").append(this.removeAllDataSize);
            if (this.removeAllDataSize <= 20) {
                sb.append("; entry values=").append(Arrays.toString(this.removeAllData));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doEntryRemove(RemoveAllEntryData entry, DistributedRegion rgn) {
            EntryEventImpl ev = RemoveAllMessage.createEntryEvent(entry, this.getSender(), this.context, rgn, this.possibleDuplicate, this.needsRouting, this.callbackArg, true, this.skipCallbacks);
            try {
                if (ev.getVersionTag() != null) {
                    this.checkVersionTag(rgn, ev.getVersionTag());
                }
                rgn.basicDestroy(ev, false, null);
            }
            catch (EntryNotFoundException ignore) {
                this.appliedOperation = true;
            }
            catch (ConcurrentCacheModificationException e) {
                this.dispatchElidedEvent(rgn, ev);
                this.appliedOperation = false;
            }
            finally {
                if (ev.hasValidVersionTag() && !ev.getVersionTag().isRecorded() && rgn.getVersionVector() != null) {
                    rgn.getVersionVector().recordVersion(this.getSender(), ev.getVersionTag());
                }
                ev.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static EntryEventImpl createEntryEvent(RemoveAllEntryData entry, InternalDistributedMember sender, ClientProxyMembershipID context, DistributedRegion rgn, boolean possibleDuplicate, boolean needsRouting, Object callbackArg, boolean originRemote, boolean skipCallbacks) {
            Object key = entry.getKey();
            EventID evId = entry.getEventID();
            EntryEventImpl ev = EntryEventImpl.create((InternalRegion)rgn, entry.getOp(), key, null, callbackArg, originRemote, (DistributedMember)sender, !skipCallbacks, evId);
            boolean returnedEv = false;
            try {
                if (context != null) {
                    ev.context = context;
                }
                ev.setPossibleDuplicate(possibleDuplicate);
                ev.setVersionTag(entry.versionTag);
                if (entry.filterRouting != null) {
                    InternalDistributedMember id = rgn.getMyId();
                    ev.setLocalFilterInfo(entry.filterRouting.getFilterInfo(id));
                }
                ev.setTailKey(entry.getTailKey());
                returnedEv = true;
                EntryEventImpl entryEventImpl = ev;
                return entryEventImpl;
            }
            finally {
                if (!returnedEv) {
                    ev.release();
                }
            }
        }

        @Override
        protected void basicOperateOnRegion(EntryEventImpl ev, final DistributedRegion rgn) {
            for (int i = 0; i < this.removeAllDataSize; ++i) {
                if (this.removeAllData[i].versionTag == null) continue;
                this.checkVersionTag(rgn, this.removeAllData[i].versionTag);
            }
            rgn.syncBulkOp(new Runnable(){

                @Override
                public void run() {
                    for (int i = 0; i < removeAllDataSize; ++i) {
                        if (logger.isTraceEnabled()) {
                            logger.trace("removeAll processing {} with {}", (Object)removeAllData[i], (Object)removeAllData[i].versionTag);
                        }
                        removeAllData[i].setSender(sender);
                        this.doEntryRemove(removeAllData[i], rgn);
                    }
                }
            }, ev.getEventId());
        }

        public int getDSFID() {
            return -8;
        }

        @Override
        public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
            super.fromData(in, context);
            this.eventId = (EventID)context.getDeserializer().readObject(in);
            this.removeAllDataSize = (int)InternalDataSerializer.readUnsignedVL(in);
            this.removeAllData = new RemoveAllEntryData[this.removeAllDataSize];
            if (this.removeAllDataSize > 0) {
                Version version = StaticSerialization.getVersionForDataStreamOrNull((DataInput)in);
                ByteArrayDataInput bytesIn = new ByteArrayDataInput();
                for (int i = 0; i < this.removeAllDataSize; ++i) {
                    this.removeAllData[i] = new RemoveAllEntryData(in, this.eventId, i, version, bytesIn, context);
                }
                boolean hasTags = in.readBoolean();
                if (hasTags) {
                    DistributedPutAllOperation.EntryVersionsList versionTags = DistributedPutAllOperation.EntryVersionsList.create(in);
                    for (int i = 0; i < this.removeAllDataSize; ++i) {
                        this.removeAllData[i].versionTag = (VersionTag)versionTags.get(i);
                    }
                }
            }
            if ((this.flags & 0x4000) != 0) {
                this.context = (ClientProxyMembershipID)context.getDeserializer().readObject(in);
            }
            this.skipCallbacks = (this.flags & Short.MIN_VALUE) != 0;
        }

        @Override
        public void toData(DataOutput out, SerializationContext context) throws IOException {
            super.toData(out, context);
            context.getSerializer().writeObject((Object)this.eventId, out);
            InternalDataSerializer.writeUnsignedVL(this.removeAllDataSize, out);
            if (this.removeAllDataSize > 0) {
                DistributedPutAllOperation.EntryVersionsList versionTags = new DistributedPutAllOperation.EntryVersionsList(this.removeAllDataSize);
                boolean hasTags = false;
                for (int i = 0; i < this.removeAllDataSize; ++i) {
                    if (!hasTags && this.removeAllData[i].versionTag != null) {
                        hasTags = true;
                    }
                    VersionTag tag = this.removeAllData[i].versionTag;
                    versionTags.add(tag);
                    this.removeAllData[i].versionTag = null;
                    this.removeAllData[i].serializeTo(out, context);
                    this.removeAllData[i].versionTag = tag;
                }
                out.writeBoolean(hasTags);
                if (hasTags) {
                    InternalDataSerializer.invokeToData(versionTags, out);
                }
            }
            if (this.context != null) {
                context.getSerializer().writeObject((Object)this.context, out);
            }
        }

        @Override
        protected short computeCompressedShort(short s) {
            s = super.computeCompressedShort(s);
            if (this.context != null) {
                s = (short)(s | 0x4000);
            }
            if (this.skipCallbacks) {
                s = (short)(s | Short.MIN_VALUE);
            }
            return s;
        }

        public ClientProxyMembershipID getContext() {
            return this.context;
        }

        public RemoveAllEntryData[] getRemoveAllEntryData() {
            return this.removeAllData;
        }
    }

    public static class RemoveAllEntryData {
        final Object key;
        private final Object oldValue;
        private final Operation op;
        private EventID eventID;
        transient EntryEventImpl event;
        private Integer bucketId = -1;
        protected transient boolean callbacksInvoked = false;
        public FilterRoutingInfo filterRouting;
        protected byte flags = 0;
        private Long tailKey = 0L;
        public VersionTag versionTag;
        transient boolean inhibitDistribution;
        transient boolean redestroyedEntry;

        public RemoveAllEntryData(EntryEventImpl event) {
            this.key = event.getKey();
            Object oldValue = event.getRawOldValue();
            this.oldValue = oldValue == Token.NOT_AVAILABLE || Token.isRemoved(oldValue) ? null : oldValue;
            this.op = event.getOperation();
            this.eventID = event.getEventId();
            this.tailKey = event.getTailKey();
            this.versionTag = event.getVersionTag();
            this.setNotifyOnly(!event.getInvokePRCallbacks());
            this.setCallbacksInvoked(event.callbacksInvoked());
            this.setPossibleDuplicate(event.isPossibleDuplicate());
            this.setInhibitDistribution(event.getInhibitDistribution());
            this.setRedestroyedEntry(event.getIsRedestroyedEntry());
        }

        public RemoveAllEntryData(DataInput in, EventID baseEventID, int idx, Version version, ByteArrayDataInput bytesIn, DeserializationContext context) throws IOException, ClassNotFoundException {
            this.key = context.getDeserializer().readObject(in);
            this.oldValue = null;
            this.op = Operation.fromOrdinal(in.readByte());
            this.flags = in.readByte();
            if ((this.flags & 4) != 0) {
                this.filterRouting = (FilterRoutingInfo)context.getDeserializer().readObject(in);
            }
            if ((this.flags & 8) != 0) {
                boolean persistentTag = (this.flags & 0x20) != 0;
                this.versionTag = VersionTag.create(persistentTag, in);
            }
            if (this.isUsedFakeEventId()) {
                this.eventID = new EventID();
                InternalDataSerializer.invokeFromData(this.eventID, in);
            } else {
                this.eventID = new EventID(baseEventID, idx);
            }
            if ((this.flags & 0xFFFFFF80) != 0) {
                this.tailKey = DataSerializer.readLong(in);
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(50);
            sb.append("(").append(this.getKey()).append(",").append(this.getOldValue());
            if (this.bucketId > 0) {
                sb.append(", b").append(this.bucketId);
            }
            if (this.versionTag != null) {
                sb.append(",v").append(this.versionTag.getEntryVersion()).append(",rv=" + this.versionTag.getRegionVersion());
            }
            if (this.filterRouting != null) {
                sb.append(", ").append(this.filterRouting);
            }
            sb.append(")");
            return sb.toString();
        }

        void setSender(InternalDistributedMember sender) {
            if (this.versionTag != null) {
                this.versionTag.replaceNullIDs(sender);
            }
        }

        public void serializeTo(DataOutput out, SerializationContext context) throws IOException {
            Object key = this.key;
            context.getSerializer().writeObject(key, out);
            out.writeByte(this.op.ordinal);
            byte bits = this.flags;
            if (this.filterRouting != null) {
                bits = (byte)(bits | 4);
            }
            if (this.versionTag != null) {
                bits = (byte)(bits | 8);
                if (this.versionTag instanceof DiskVersionTag) {
                    bits = (byte)(bits | 0x20);
                }
            }
            bits = (byte)(bits | 0xFFFFFF80);
            out.writeByte(bits);
            if (this.filterRouting != null) {
                context.getSerializer().writeObject((Object)this.filterRouting, out);
            }
            if (this.versionTag != null) {
                InternalDataSerializer.invokeToData(this.versionTag, out);
            }
            if (this.isUsedFakeEventId()) {
                InternalDataSerializer.invokeToData(this.eventID, out);
            }
            DataSerializer.writeLong(this.tailKey, out);
        }

        public Object getKey() {
            return this.key;
        }

        public Object getOldValue() {
            return this.oldValue;
        }

        public Long getTailKey() {
            return this.tailKey;
        }

        public void setTailKey(Long key) {
            this.tailKey = key;
        }

        public Operation getOp() {
            return this.op;
        }

        public EventID getEventID() {
            return this.eventID;
        }

        public void setEventId(EventID eventId) {
            this.eventID = eventId;
        }

        public void setBucketId(Integer bucketId) {
            this.bucketId = bucketId;
        }

        public Integer getBucketId() {
            return this.bucketId;
        }

        public boolean setFakeEventID() {
            if (this.bucketId < 0) {
                return false;
            }
            if (!this.isUsedFakeEventId()) {
                long threadId = ThreadIdentifier.createFakeThreadIDForBulkOp(this.bucketId, this.eventID.getThreadID());
                this.eventID = new EventID(this.eventID.getMembershipID(), threadId, this.eventID.getSequenceID());
                this.setUsedFakeEventId(true);
            }
            return true;
        }

        public boolean isUsedFakeEventId() {
            return (this.flags & 1) != 0;
        }

        public void setUsedFakeEventId(boolean usedFakeEventId) {
            this.flags = usedFakeEventId ? (byte)(this.flags | 1) : (byte)(this.flags & 0xFFFFFFFE);
        }

        public boolean isNotifyOnly() {
            return (this.flags & 2) != 0;
        }

        public void setNotifyOnly(boolean notifyOnly) {
            this.flags = notifyOnly ? (byte)(this.flags | 2) : (byte)(this.flags & 0xFFFFFFFD);
        }

        boolean isPossibleDuplicate() {
            return (this.flags & 0x10) != 0;
        }

        public void setPossibleDuplicate(boolean possibleDuplicate) {
            this.flags = possibleDuplicate ? (byte)(this.flags | 0x10) : (byte)(this.flags & 0xFFFFFFEF);
        }

        public boolean isInhibitDistribution() {
            return this.inhibitDistribution;
        }

        public void setInhibitDistribution(boolean inhibitDistribution) {
            this.inhibitDistribution = inhibitDistribution;
        }

        public boolean getRedestroyedEntry() {
            return this.redestroyedEntry;
        }

        public void setRedestroyedEntry(boolean redestroyedEntry) {
            this.redestroyedEntry = redestroyedEntry;
        }

        public boolean isCallbacksInvoked() {
            return this.callbacksInvoked;
        }

        public void setCallbacksInvoked(boolean callbacksInvoked) {
            this.callbacksInvoked = callbacksInvoked;
        }
    }
}

