/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.admin.remote;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.geode.CancelException;
import org.apache.geode.cache.DiskStore;
import org.apache.geode.cache.persistence.PersistentID;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.DistributionMessage;
import org.apache.geode.distributed.internal.ReplyException;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.admin.remote.AdminMultipleReplyProcessor;
import org.apache.geode.internal.admin.remote.AdminResponse;
import org.apache.geode.internal.admin.remote.CliLegacyMessage;
import org.apache.geode.internal.admin.remote.MissingPersistentIDsResponse;
import org.apache.geode.internal.cache.DiskStoreImpl;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.persistence.PersistentMemberID;
import org.apache.geode.internal.cache.persistence.PersistentMemberManager;
import org.apache.geode.internal.cache.persistence.PersistentMemberPattern;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class MissingPersistentIDsRequest
extends CliLegacyMessage {
    private static final Logger logger = LogService.getLogger();

    public static Set<PersistentID> send(DistributionManager dm) {
        Set<InternalDistributedMember> recipients = dm.getOtherDistributionManagerIds();
        MissingPersistentIDsRequest request = new MissingPersistentIDsRequest();
        request.setRecipients(recipients);
        MissingPersistentIDProcessor replyProcessor = new MissingPersistentIDProcessor(dm, (Collection)recipients);
        request.msgId = replyProcessor.getProcessorId();
        dm.putOutgoing(request);
        try {
            replyProcessor.waitForReplies();
        }
        catch (ReplyException e) {
            if (!(e.getCause() instanceof CancelException)) {
                throw e;
            }
        }
        catch (InterruptedException e) {
            logger.warn((Object)e);
        }
        Set results = replyProcessor.missing;
        Set existing = replyProcessor.existing;
        MissingPersistentIDsResponse localResponse = (MissingPersistentIDsResponse)request.createResponse(dm);
        results.addAll(localResponse.getMissingIds());
        existing.addAll(localResponse.getLocalIds());
        results.removeAll(existing);
        return results;
    }

    @Override
    protected AdminResponse createResponse(DistributionManager dm) {
        HashSet<PersistentID> missingIds = new HashSet<PersistentID>();
        HashSet<PersistentID> localPatterns = new HashSet<PersistentID>();
        InternalCache cache = dm.getCache();
        if (cache != null && !cache.isClosed()) {
            PersistentMemberManager mm = cache.getPersistentMemberManager();
            Map<String, Set<PersistentMemberID>> waitingRegions = mm.getWaitingRegions();
            for (Map.Entry<String, Set<PersistentMemberID>> entry : waitingRegions.entrySet()) {
                for (PersistentMemberID id : entry.getValue()) {
                    missingIds.add(new PersistentMemberPattern(id));
                }
            }
            for (DiskStore diskStore : cache.listDiskStoresIncludingRegionOwned()) {
                PersistentMemberID id = ((DiskStoreImpl)diskStore).generatePersistentID();
                localPatterns.add(new PersistentMemberPattern(id));
            }
        }
        return new MissingPersistentIDsResponse(missingIds, localPatterns, this.getSender());
    }

    public int getDSFID() {
        return 2105;
    }

    private static class MissingPersistentIDProcessor
    extends AdminMultipleReplyProcessor {
        private final Set<PersistentID> missing = Collections.synchronizedSet(new HashSet());
        private final Set<PersistentID> existing = Collections.synchronizedSet(new HashSet());

        private MissingPersistentIDProcessor(DistributionManager dm, Collection<InternalDistributedMember> recipients) {
            super(dm, recipients);
        }

        @Override
        protected void process(DistributionMessage message, boolean warn) {
            if (message instanceof MissingPersistentIDsResponse) {
                this.missing.addAll(((MissingPersistentIDsResponse)message).getMissingIds());
                this.existing.addAll(((MissingPersistentIDsResponse)message).getLocalIds());
            }
            super.process(message, warn);
        }
    }
}

