/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.admin.remote;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.apache.geode.DataSerializer;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.locks.DLockService;
import org.apache.geode.distributed.internal.locks.DLockToken;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.admin.DLockInfo;
import org.apache.geode.internal.admin.remote.AdminResponse;
import org.apache.geode.internal.admin.remote.RemoteDLockInfo;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;

public class FetchDistLockInfoResponse
extends AdminResponse {
    DLockInfo[] lockInfos;

    public static FetchDistLockInfoResponse create(DistributionManager dm, InternalDistributedMember recipient) {
        FetchDistLockInfoResponse m = new FetchDistLockInfoResponse();
        InternalDistributedMember id = dm.getDistributionManagerId();
        Set<Map.Entry<String, DLockService>> entries = DLockService.snapshotAllServices().entrySet();
        ArrayList<RemoteDLockInfo> infos = new ArrayList<RemoteDLockInfo>();
        for (Map.Entry<String, DLockService> entry : entries) {
            String serviceName = entry.getKey().toString();
            DLockService service = entry.getValue();
            Set<Map.Entry<Object, DLockToken>> serviceEntries = service.snapshotService().entrySet();
            for (Map.Entry<Object, DLockToken> token : serviceEntries) {
                infos.add(new RemoteDLockInfo(serviceName, token.getKey().toString(), token.getValue(), id));
            }
        }
        m.lockInfos = infos.toArray(new DLockInfo[0]);
        m.setRecipient(recipient);
        return m;
    }

    public DLockInfo[] getLockInfos() {
        return this.lockInfos;
    }

    public int getDSFID() {
        return 1022;
    }

    @Override
    public void toData(DataOutput out, SerializationContext context) throws IOException {
        super.toData(out, context);
        DataSerializer.writeObject(this.lockInfos, out);
    }

    @Override
    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        super.fromData(in, context);
        this.lockInfos = (DLockInfo[])DataSerializer.readObject(in);
    }

    @Override
    public String toString() {
        return String.format("FetchDistLockInfoResponse from %s", this.getSender());
    }
}

