/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import joptsimple.internal.Strings;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.cache.AttributesFactory;
import org.apache.geode.cache.DataPolicy;
import org.apache.geode.cache.DiskStore;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.Scope;
import org.apache.geode.cache.configuration.CacheConfig;
import org.apache.geode.distributed.ConfigurationPersistenceService;
import org.apache.geode.distributed.DistributedLockService;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.DistributedSystem;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.locks.DLockService;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.JarDeployer;
import org.apache.geode.internal.cache.ClusterConfigurationLoader;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.InternalRegionArguments;
import org.apache.geode.internal.cache.persistence.PersistentMemberID;
import org.apache.geode.internal.cache.persistence.PersistentMemberManager;
import org.apache.geode.internal.cache.persistence.PersistentMemberPattern;
import org.apache.geode.internal.cache.xmlcache.CacheXmlGenerator;
import org.apache.geode.internal.config.JAXBService;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.management.configuration.Deployment;
import org.apache.geode.management.internal.configuration.callbacks.ConfigurationChangeListener;
import org.apache.geode.management.internal.configuration.domain.Configuration;
import org.apache.geode.management.internal.configuration.domain.SharedConfigurationStatus;
import org.apache.geode.management.internal.configuration.domain.XmlEntity;
import org.apache.geode.management.internal.configuration.messages.ConfigurationResponse;
import org.apache.geode.management.internal.configuration.messages.SharedConfigurationStatusResponse;
import org.apache.geode.management.internal.configuration.utils.XmlUtils;
import org.apache.logging.log4j.Logger;
import org.apache.shiro.subject.Subject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class InternalConfigurationPersistenceService
implements ConfigurationPersistenceService {
    private static final Logger logger = LogService.getLogger();
    public static final String CLUSTER_CONFIG_ARTIFACTS_DIR_NAME = "cluster_config";
    private static final String CLUSTER_CONFIG_DISK_STORE_NAME = "cluster_config";
    public static final String CLUSTER_CONFIG_DISK_DIR_PREFIX = "ConfigDiskDir_";
    private static final String SHARED_CONFIG_LOCK_SERVICE_NAME = "__CLUSTER_CONFIG_LS";
    private static final String SHARED_CONFIG_LOCK_NAME = "__CLUSTER_CONFIG_LOCK";
    public static final String CONFIG_REGION_NAME = "_ConfigurationRegion";
    private static final String CACHE_CONFIG_VERSION = "1.0";
    private final Path configDirPath;
    private final Path configDiskDirPath;
    private final Set<PersistentMemberPattern> newerSharedConfigurationLocatorInfo = new HashSet<PersistentMemberPattern>();
    private final AtomicReference<SharedConfigurationStatus> status = new AtomicReference();
    private final InternalCache cache;
    private final DistributedLockService sharedConfigLockingService;
    private final JAXBService jaxbService;

    public InternalConfigurationPersistenceService(InternalCache cache, Path workingDirectory, JAXBService jaxbService) {
        this(cache, InternalConfigurationPersistenceService.sharedConfigLockService(cache.getDistributedSystem()), jaxbService, workingDirectory.resolve("cluster_config"), workingDirectory.resolve(CLUSTER_CONFIG_DISK_DIR_PREFIX + cache.getDistributedSystem().getName()));
    }

    @VisibleForTesting
    public InternalConfigurationPersistenceService(JAXBService jaxbService) {
        this(null, null, jaxbService, null, null);
    }

    @VisibleForTesting
    InternalConfigurationPersistenceService(InternalCache cache, DistributedLockService sharedConfigLockingService, JAXBService jaxbService, Path configDirPath, Path configDiskDirPath) {
        this.cache = cache;
        this.configDirPath = configDirPath;
        this.configDiskDirPath = configDiskDirPath;
        this.sharedConfigLockingService = sharedConfigLockingService;
        this.status.set(SharedConfigurationStatus.NOT_STARTED);
        this.jaxbService = jaxbService;
    }

    private static DistributedLockService sharedConfigLockService(DistributedSystem ds) {
        DistributedLockService sharedConfigDls = DLockService.getServiceNamed(SHARED_CONFIG_LOCK_SERVICE_NAME);
        try {
            if (sharedConfigDls == null) {
                sharedConfigDls = DLockService.create(SHARED_CONFIG_LOCK_SERVICE_NAME, (InternalDistributedSystem)ds, true, true);
            }
        }
        catch (IllegalArgumentException ignore) {
            return DLockService.getServiceNamed(SHARED_CONFIG_LOCK_SERVICE_NAME);
        }
        return sharedConfigDls;
    }

    public JAXBService getJaxbService() {
        return this.jaxbService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addXmlEntity(XmlEntity xmlEntity, String[] groups) {
        this.lockSharedConfiguration();
        try {
            Region<String, Configuration> configRegion = this.getConfigurationRegion();
            for (String group : InternalConfigurationPersistenceService.listOf(groups)) {
                String xmlContent;
                Configuration configuration = configRegion.get(group);
                if (configuration == null) {
                    configuration = new Configuration(group);
                }
                if ((xmlContent = configuration.getCacheXmlContent()) == null || xmlContent.isEmpty()) {
                    xmlContent = this.generateInitialXmlContent();
                }
                try {
                    Document doc = XmlUtils.createAndUpgradeDocumentFromXml(xmlContent);
                    XmlUtils.addNewNode(doc, xmlEntity);
                    configuration.setCacheXmlContent(XmlUtils.prettyXml(doc));
                    configRegion.put(group, configuration);
                }
                catch (Exception e) {
                    logger.error("error updating cluster configuration for group {}", (Object)group, (Object)e);
                }
            }
        }
        finally {
            this.unlockSharedConfiguration();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteXmlEntity(XmlEntity xmlEntity, String[] groups) {
        this.lockSharedConfiguration();
        try {
            Region<String, Configuration> configRegion = this.getConfigurationRegion();
            if (groups == null) {
                Set<String> groupSet = configRegion.keySet();
                groups = groupSet.toArray(new String[0]);
            }
            for (String group : groups) {
                Configuration configuration = configRegion.get(group);
                if (configuration == null) continue;
                String xmlContent = configuration.getCacheXmlContent();
                try {
                    if (xmlContent == null || xmlContent.isEmpty()) continue;
                    Document doc = XmlUtils.createAndUpgradeDocumentFromXml(xmlContent);
                    XmlUtils.deleteNode(doc, xmlEntity);
                    configuration.setCacheXmlContent(XmlUtils.prettyXml(doc));
                    configRegion.put(group, configuration);
                }
                catch (Exception e) {
                    logger.error("error updating cluster configuration for group {}", (Object)group, (Object)e);
                }
            }
        }
        finally {
            this.unlockSharedConfiguration();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifyXmlAndProperties(Properties properties, XmlEntity xmlEntity, String[] groups) {
        this.lockSharedConfiguration();
        try {
            Region<String, Configuration> configRegion = this.getConfigurationRegion();
            for (String group : InternalConfigurationPersistenceService.listOf(groups)) {
                Configuration configuration = configRegion.get(group);
                if (configuration == null) {
                    configuration = new Configuration(group);
                }
                if (xmlEntity != null) {
                    String xmlContent = configuration.getCacheXmlContent();
                    if (xmlContent == null || xmlContent.isEmpty()) {
                        StringWriter sw = new StringWriter();
                        PrintWriter pw = new PrintWriter(sw);
                        CacheXmlGenerator.generateDefault(pw);
                        xmlContent = sw.toString();
                    }
                    try {
                        Document doc = XmlUtils.createAndUpgradeDocumentFromXml(xmlContent);
                        XmlUtils.modifyRootAttributes(doc, xmlEntity);
                        configuration.setCacheXmlContent(XmlUtils.prettyXml(doc));
                    }
                    catch (Exception e) {
                        logger.error("error updating cluster configuration for group {}", (Object)group, (Object)e);
                    }
                }
                if (properties != null) {
                    configuration.getGemfireProperties().putAll((Map<?, ?>)properties);
                }
                configRegion.put(group, configuration);
            }
        }
        finally {
            this.unlockSharedConfiguration();
        }
    }

    public void addJarsToThisLocator(List<String> jarFullPaths, String[] groups) throws IOException {
        this.addJarsToThisLocator(this.getDeployedBy(), Instant.now().toString(), jarFullPaths, groups);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void addJarsToThisLocator(String deployedBy, String deployedTime, List<String> jarFullPaths, String[] groups) throws IOException {
        this.lockSharedConfiguration();
        try {
            this.addJarsToGroups(InternalConfigurationPersistenceService.listOf(groups), jarFullPaths, deployedBy, deployedTime);
        }
        finally {
            this.unlockSharedConfiguration();
        }
    }

    private void addJarsToGroups(List<String> groups, List<String> jarFullPaths, String deployedBy, String deployedTime) throws IOException {
        for (String group : groups) {
            this.copyJarsToGroupDir(group, jarFullPaths);
            this.addJarsToGroupConfig(group, jarFullPaths, deployedBy, deployedTime);
        }
    }

    private void addJarsToGroupConfig(String group, List<String> jarFullPaths, String deployedBy, String deployedTime) throws IOException {
        Region<String, Configuration> configRegion = this.getConfigurationRegion();
        Configuration configuration = this.getConfigurationCopy(configRegion, group);
        jarFullPaths.stream().map(InternalConfigurationPersistenceService.toFileName()).map(jarFileName -> new Deployment(jarFileName, deployedBy, deployedTime)).forEach(configuration::putDeployment);
        String memberId = this.cache.getMyId().getId();
        configRegion.put(group, configuration, memberId);
    }

    private static List<String> listOf(String[] groups) {
        if (groups == null || groups.length == 0) {
            return Collections.singletonList("cluster");
        }
        return Arrays.asList(groups);
    }

    private static Function<String, String> toFileName() {
        return fullPath -> Paths.get(fullPath, new String[0]).getFileName().toString();
    }

    private void copyJarsToGroupDir(String group, List<String> jarFullPaths) throws IOException {
        Path groupDir = this.configDirPath.resolve(group);
        for (String jarFullPath : jarFullPaths) {
            File stagedJarFile = new File(jarFullPath);
            String jarFileName = stagedJarFile.getName();
            Path destinationJarPath = groupDir.resolve(jarFileName);
            FileUtils.copyFile((File)stagedJarFile, (File)destinationJarPath.toFile());
            InternalConfigurationPersistenceService.removeOtherVersionsOf(groupDir, jarFileName);
        }
    }

    private static void removeOtherVersionsOf(Path groupDir, String jarFileName) throws IOException {
        String artifactId = JarDeployer.getArtifactId(jarFileName);
        for (File file : groupDir.toFile().listFiles()) {
            if (file.getName().equals(jarFileName) || !JarDeployer.getArtifactId(file.getName()).equals(artifactId)) continue;
            FileUtils.deleteQuietly((File)file);
        }
    }

    private Configuration getConfigurationCopy(Region<String, Configuration> configRegion, String group) throws IOException {
        Configuration configuration = configRegion.get(group);
        if (configuration == null) {
            configuration = new Configuration(group);
            this.createConfigDirIfNecessary(group);
        } else {
            configuration = new Configuration(configuration);
        }
        return configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeJars(String[] jarNames, String[] groups) {
        this.lockSharedConfiguration();
        boolean success = true;
        try {
            Region<String, Configuration> configRegion = this.getConfigurationRegion();
            if (groups == null) {
                groups = (String[])configRegion.keySet().stream().toArray(String[]::new);
            }
            for (String group : groups) {
                Configuration configuration = configRegion.get(group);
                if (configuration == null) {
                    break;
                }
                for (String jarRemoved : jarNames) {
                    File jar = this.getPathToJarOnThisLocator(group, jarRemoved).toFile();
                    if (!jar.exists()) continue;
                    try {
                        FileUtils.forceDelete((File)jar);
                    }
                    catch (IOException e) {
                        logger.error("Exception occurred while attempting to delete a jar from the filesystem: {}", (Object)jarRemoved, (Object)e);
                    }
                }
                Configuration configurationCopy = new Configuration(configuration);
                configurationCopy.removeJarNames(jarNames);
                configRegion.put(group, configurationCopy);
            }
        }
        catch (Exception e) {
            logger.info("Exception occurred while deleting the jar files", (Throwable)e);
            success = false;
        }
        finally {
            this.unlockSharedConfiguration();
        }
        return success;
    }

    public void downloadJarFromOtherLocators(String groupName, String jarName) throws IllegalStateException, IOException {
        logger.info("Getting Jar files from other locators");
        DistributionManager dm = this.cache.getDistributionManager();
        InternalDistributedMember me = this.cache.getMyId();
        ArrayList<InternalDistributedMember> locators = new ArrayList<InternalDistributedMember>(dm.getAllHostedLocatorsWithSharedConfiguration().keySet());
        locators.remove(me);
        this.createConfigDirIfNecessary(groupName);
        if (locators.isEmpty()) {
            throw new IllegalStateException("Request to download jar " + jarName + " but no other locators are present");
        }
        this.downloadJarFromLocator(groupName, jarName, (DistributedMember)locators.get(0));
    }

    public void downloadJarFromLocator(String groupName, String jarName, DistributedMember sourceLocator) throws IllegalStateException, IOException {
        logger.info("Downloading jar {} from locator {}", (Object)jarName, (Object)sourceLocator.getName());
        this.createConfigDirIfNecessary(groupName);
        File jarFile = this.downloadJar(sourceLocator, groupName, jarName);
        File jarToWrite = this.getPathToJarOnThisLocator(groupName, jarName).toFile();
        Files.copy(jarFile.toPath(), jarToWrite.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    public File downloadJar(DistributedMember locator, String groupName, String jarName) throws IOException {
        ClusterConfigurationLoader loader = new ClusterConfigurationLoader();
        return loader.downloadJar(locator, groupName, jarName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initSharedConfiguration(boolean loadSharedConfigFromDir) throws IOException {
        this.status.set(SharedConfigurationStatus.STARTED);
        Region<String, Configuration> configRegion = this.getConfigurationRegion();
        this.lockSharedConfiguration();
        try {
            this.removeInvalidXmlConfigurations(configRegion);
            if (loadSharedConfigFromDir) {
                logger.info("Reading cluster configuration from '{}' directory", (Object)"cluster_config");
                this.loadSharedConfigurationFromDir(this.configDirPath.toFile());
            } else {
                this.persistSecuritySettings(configRegion);
                for (Map.Entry<String, Configuration> stringConfigurationEntry : configRegion.entrySet()) {
                    Configuration config = stringConfigurationEntry.getValue();
                    for (String jar : config.getJarNames()) {
                        if (this.getPathToJarOnThisLocator(stringConfigurationEntry.getKey(), jar).toFile().exists()) continue;
                        this.downloadJarFromOtherLocators(stringConfigurationEntry.getKey(), jar);
                    }
                }
            }
        }
        finally {
            this.unlockSharedConfiguration();
        }
        this.status.set(SharedConfigurationStatus.RUNNING);
    }

    void removeInvalidXmlConfigurations(Region<String, Configuration> configRegion) throws IOException {
        for (Map.Entry<String, Configuration> entry : configRegion.entrySet()) {
            String group = entry.getKey();
            Configuration configuration = entry.getValue();
            String configurationXml = configuration.getCacheXmlContent();
            if (configurationXml == null || configurationXml.isEmpty()) continue;
            try {
                Document document = XmlUtils.createDocumentFromXml(configurationXml);
                boolean removedInvalidReceivers = this.removeInvalidGatewayReceivers(document);
                boolean removedDuplicateReceivers = this.removeDuplicateGatewayReceivers(document);
                if (!removedInvalidReceivers && !removedDuplicateReceivers) continue;
                configuration.setCacheXmlContent(XmlUtils.prettyXml(document));
                configRegion.put(group, configuration);
            }
            catch (ParserConfigurationException | TransformerException | SAXException e) {
                throw new IOException("Unable to parse existing cluster configuration from disk. ", e);
            }
        }
    }

    boolean removeInvalidGatewayReceivers(Document document) throws TransformerException {
        boolean modified = false;
        NodeList receiverNodes = document.getElementsByTagName("gateway-receiver");
        for (int i = receiverNodes.getLength() - 1; i >= 0; --i) {
            String bindAddress;
            Element receiverElement = (Element)receiverNodes.item(i);
            String hostNameForSenders = receiverElement.getAttribute("hostname-for-senders");
            if (StringUtils.isNotBlank((CharSequence)hostNameForSenders)) {
                receiverElement.getParentNode().removeChild(receiverElement);
                logger.info("Removed invalid cluster configuration gateway-receiver element=" + XmlUtils.prettyXml(receiverElement));
                modified = true;
            }
            if (!StringUtils.isNotBlank((CharSequence)(bindAddress = receiverElement.getAttribute("bind-address"))) || bindAddress.equals("0.0.0.0")) continue;
            receiverElement.getParentNode().removeChild(receiverElement);
            logger.info("Removed invalid cluster configuration gateway-receiver element=" + XmlUtils.prettyXml(receiverElement));
            modified = true;
        }
        return modified;
    }

    boolean removeDuplicateGatewayReceivers(Document document) throws TransformerException {
        boolean modified = false;
        NodeList receiverNodes = document.getElementsByTagName("gateway-receiver");
        while (receiverNodes.getLength() > 1) {
            Element receiverElement = (Element)receiverNodes.item(0);
            receiverElement.getParentNode().removeChild(receiverElement);
            logger.info("Removed duplicate cluster configuration gateway-receiver element=" + XmlUtils.prettyXml(receiverElement));
            modified = true;
            receiverNodes = document.getElementsByTagName("gateway-receiver");
        }
        return modified;
    }

    private void persistSecuritySettings(Region<String, Configuration> configRegion) {
        Properties securityProps = this.cache.getDistributedSystem().getSecurityProperties();
        Configuration clusterPropertiesConfig = configRegion.get("cluster");
        if (clusterPropertiesConfig == null) {
            clusterPropertiesConfig = new Configuration("cluster");
            configRegion.put("cluster", clusterPropertiesConfig);
        }
        Properties clusterProperties = clusterPropertiesConfig.getGemfireProperties();
        if (securityProps.containsKey("security-manager")) {
            clusterProperties.setProperty("security-manager", securityProps.getProperty("security-manager"));
        }
        if (securityProps.containsKey("security-post-processor")) {
            clusterProperties.setProperty("security-post-processor", securityProps.getProperty("security-post-processor"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigurationResponse createConfigurationResponse(Set<String> groups) {
        ConfigurationResponse configResponse = null;
        boolean isLocked = this.lockSharedConfiguration();
        if (isLocked) {
            try {
                configResponse = new ConfigurationResponse();
                groups.add("cluster");
                logger.info("Building up configuration response with following configurations: {}", groups);
                for (String group : groups) {
                    Configuration configuration = this.getConfiguration(group);
                    configResponse.addConfiguration(configuration);
                    if (configuration == null) continue;
                    configResponse.addJar(group, configuration.getJarNames());
                }
                ConfigurationResponse configurationResponse = configResponse;
                return configurationResponse;
            }
            finally {
                this.unlockSharedConfiguration();
            }
        }
        return configResponse;
    }

    SharedConfigurationStatusResponse createStatusResponse() {
        SharedConfigurationStatusResponse response = new SharedConfigurationStatusResponse();
        response.setStatus(this.getStatus());
        response.addWaitingLocatorInfo(this.newerSharedConfigurationLocatorInfo);
        return response;
    }

    public void destroySharedConfiguration() {
        try {
            DiskStore configDiskStore;
            Region<String, Configuration> configRegion = this.getConfigurationRegion();
            if (configRegion != null) {
                configRegion.destroyRegion();
            }
            if ((configDiskStore = this.cache.findDiskStore("cluster_config")) != null) {
                configDiskStore.destroy();
            }
            FileUtils.deleteDirectory((File)this.configDirPath.toFile());
        }
        catch (Exception exception) {
            throw new AssertionError((Object)exception);
        }
    }

    public Path getPathToJarOnThisLocator(String groupName, String jarName) {
        return this.configDirPath.resolve(groupName).resolve(jarName);
    }

    public Configuration getConfiguration(String groupName) {
        return this.getConfigurationRegion().get(groupName);
    }

    public void setConfiguration(String groupName, Configuration configuration) {
        this.getConfigurationRegion().put(groupName, configuration);
    }

    public boolean hasXmlConfiguration() {
        Region<String, Configuration> configRegion = this.getConfigurationRegion();
        return configRegion.values().stream().anyMatch(c -> c.getCacheXmlContent() != null);
    }

    public Map<String, Configuration> getEntireConfiguration() {
        Set<String> keys = this.getConfigurationRegion().keySet();
        return this.getConfigurationRegion().getAll(keys);
    }

    @Override
    public Set<String> getGroups() {
        return this.getConfigurationRegion().keySet();
    }

    public Path getClusterConfigDirPath() {
        return this.configDirPath;
    }

    public SharedConfigurationStatus getStatus() {
        PersistentMemberManager pmm;
        Map<String, Set<PersistentMemberID>> waitingRegions;
        SharedConfigurationStatus scStatus = this.status.get();
        if (scStatus == SharedConfigurationStatus.STARTED && !(waitingRegions = (pmm = this.cache.getPersistentMemberManager()).getWaitingRegions()).isEmpty()) {
            this.status.compareAndSet(SharedConfigurationStatus.STARTED, SharedConfigurationStatus.WAITING);
            Set<PersistentMemberID> persMemIds = waitingRegions.get("/_ConfigurationRegion");
            for (PersistentMemberID persMemId : persMemIds) {
                this.newerSharedConfigurationLocatorInfo.add(new PersistentMemberPattern(persMemId));
            }
        }
        return this.status.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadSharedConfigurationFromDir(File configDir) throws IOException {
        this.lockSharedConfiguration();
        try {
            File[] groupNames = configDir.listFiles((FileFilter)DirectoryFileFilter.INSTANCE);
            boolean needToCopyJars = true;
            if (configDir.getAbsolutePath().equals(this.configDirPath.toAbsolutePath().toString())) {
                needToCopyJars = false;
            }
            logger.info("loading the cluster configuration: ");
            HashMap<String, Configuration> sharedConfiguration = new HashMap<String, Configuration>();
            for (File groupName : groupNames) {
                Configuration configuration = this.readConfiguration(groupName);
                logger.info(configuration.getConfigName() + " xml content: \n" + configuration.getCacheXmlContent());
                logger.info(configuration.getConfigName() + " properties: " + configuration.getGemfireProperties().size());
                logger.info(configuration.getConfigName() + " jars: " + Strings.join(configuration.getJarNames(), (String)", "));
                sharedConfiguration.put(groupName.getName(), configuration);
                if (!needToCopyJars || configuration.getJarNames().size() <= 0) continue;
                Path groupDirPath = this.createConfigDirIfNecessary(configuration.getConfigName()).toPath();
                for (String jarName : configuration.getJarNames()) {
                    Files.copy(groupName.toPath().resolve(jarName), groupDirPath.resolve(jarName), new CopyOption[0]);
                }
            }
            Region<String, Configuration> clusterRegion = this.getConfigurationRegion();
            clusterRegion.clear();
            String memberId = this.cache.getMyId().getId();
            clusterRegion.putAll(sharedConfiguration, memberId);
            this.persistSecuritySettings(clusterRegion);
        }
        finally {
            this.unlockSharedConfiguration();
        }
    }

    public void writeConfigToFile(Configuration configuration, File rootDir) throws IOException {
        File configDir = this.createConfigDirIfNecessary(rootDir, configuration.getConfigName());
        File propsFile = new File(configDir, configuration.getPropertiesFileName());
        BufferedWriter bw = new BufferedWriter(new FileWriter(propsFile));
        configuration.getGemfireProperties().store(bw, null);
        bw.close();
        File xmlFile = new File(configDir, configuration.getCacheXmlFileName());
        FileUtils.writeStringToFile((File)xmlFile, (String)configuration.getCacheXmlContent(), (String)"UTF-8");
        if (rootDir.getAbsolutePath().equals(this.configDirPath.toAbsolutePath().toString())) {
            return;
        }
        File locatorConfigDir = this.configDirPath.resolve(configuration.getConfigName()).toFile();
        if (locatorConfigDir.exists()) {
            File[] jarFiles;
            for (File file : jarFiles = locatorConfigDir.listFiles(x -> x.getName().endsWith(".jar"))) {
                Files.copy(file.toPath(), configDir.toPath().resolve(file.getName()), new CopyOption[0]);
            }
        }
    }

    public boolean lockSharedConfiguration() {
        return this.sharedConfigLockingService.lock(SHARED_CONFIG_LOCK_NAME, -1L, -1L);
    }

    public void unlockSharedConfiguration() {
        this.sharedConfigLockingService.unlock(SHARED_CONFIG_LOCK_NAME);
    }

    public Region<String, Configuration> getConfigurationRegion() {
        Region<String, Configuration> configRegion = this.cache.getRegion(CONFIG_REGION_NAME);
        if (configRegion != null) {
            return configRegion;
        }
        try {
            File diskDir = this.configDiskDirPath.toFile();
            if (!diskDir.exists() && !diskDir.mkdirs()) {
                throw new IOException("Cannot create directory at " + this.configDiskDirPath);
            }
            File[] diskDirs = new File[]{diskDir};
            this.cache.createDiskStoreFactory().setDiskDirs(diskDirs).setAutoCompact(true).setMaxOplogSize(10L).create("cluster_config");
            AttributesFactory<String, Configuration> regionAttrsFactory = new AttributesFactory<String, Configuration>();
            regionAttrsFactory.setDataPolicy(DataPolicy.PERSISTENT_REPLICATE);
            regionAttrsFactory.setCacheListener(new ConfigurationChangeListener(this, this.cache));
            regionAttrsFactory.setDiskStoreName("cluster_config");
            regionAttrsFactory.setScope(Scope.DISTRIBUTED_ACK);
            InternalRegionArguments internalArgs = new InternalRegionArguments();
            internalArgs.setIsUsedForMetaRegion(true);
            internalArgs.setMetaRegionWithTransactions(false);
            return this.cache.createVMRegion(CONFIG_REGION_NAME, regionAttrsFactory.create(), internalArgs);
        }
        catch (RuntimeException e) {
            this.status.set(SharedConfigurationStatus.STOPPED);
            throw e;
        }
        catch (Exception e) {
            this.status.set(SharedConfigurationStatus.STOPPED);
            throw new RuntimeException("Error occurred while initializing cluster configuration", e);
        }
    }

    private Configuration readConfiguration(File groupConfigDir) throws IOException {
        Configuration configuration = new Configuration(groupConfigDir.getName());
        File cacheXmlFull = new File(groupConfigDir, configuration.getCacheXmlFileName());
        File propertiesFull = new File(groupConfigDir, configuration.getPropertiesFileName());
        configuration.setCacheXmlFile(cacheXmlFull);
        configuration.setPropertiesFile(propertiesFull);
        String deployedBy = this.getDeployedBy();
        String deployedTime = Instant.now().toString();
        List<String> fileNames = Arrays.asList(groupConfigDir.list());
        InternalConfigurationPersistenceService.loadDeploymentsFromFileNames(fileNames, configuration, deployedBy, deployedTime);
        return configuration;
    }

    private String getDeployedBy() {
        Subject subject = this.cache.getSecurityService().getSubject();
        return subject == null ? null : subject.getPrincipal().toString();
    }

    @VisibleForTesting
    static void loadDeploymentsFromFileNames(Collection<String> fileNames, Configuration configuration, String deployedBy, String deployedTime) {
        fileNames.stream().filter(filename -> filename.endsWith(".jar")).map(jarFileName -> new Deployment(jarFileName, deployedBy, deployedTime)).forEach(configuration::putDeployment);
    }

    private File createConfigDirIfNecessary(String configName) throws IOException {
        return this.createConfigDirIfNecessary(this.configDirPath.toFile(), configName);
    }

    private File createConfigDirIfNecessary(File clusterConfigDir, String configName) throws IOException {
        if (!clusterConfigDir.exists() && !clusterConfigDir.mkdirs()) {
            throw new IOException("Cannot create directory : " + this.configDirPath);
        }
        Path configDirPath = clusterConfigDir.toPath().resolve(configName);
        File configDir = configDirPath.toFile();
        if (!configDir.exists() && !configDir.mkdir()) {
            throw new IOException("Cannot create directory : " + configDirPath);
        }
        return configDir;
    }

    private String generateInitialXmlContent() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        CacheXmlGenerator.generateDefault(pw);
        return sw.toString();
    }

    @Override
    public CacheConfig getCacheConfig(String group) {
        return this.getCacheConfig(group, false);
    }

    @Override
    public CacheConfig getCacheConfig(String group, boolean createNew) {
        Configuration configuration;
        if (group == null) {
            group = "cluster";
        }
        if ((configuration = this.getConfiguration(group)) == null) {
            if (createNew) {
                return new CacheConfig(CACHE_CONFIG_VERSION);
            }
            return null;
        }
        String xmlContent = configuration.getCacheXmlContent();
        if (xmlContent == null || xmlContent.isEmpty()) {
            if (createNew) {
                return new CacheConfig(CACHE_CONFIG_VERSION);
            }
            return null;
        }
        return (CacheConfig)this.jaxbService.unMarshall(xmlContent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateCacheConfig(String group, UnaryOperator<CacheConfig> mutator) {
        if (group == null) {
            group = "cluster";
        }
        this.lockSharedConfiguration();
        try {
            CacheConfig cacheConfig = this.getCacheConfig(group, true);
            cacheConfig = (CacheConfig)mutator.apply(cacheConfig);
            if (cacheConfig == null) {
                return;
            }
            Configuration configuration = this.getConfiguration(group);
            if (configuration == null) {
                configuration = new Configuration(group);
            }
            configuration.setCacheXmlContent(this.jaxbService.marshall(cacheConfig));
            this.getConfigurationRegion().put(group, configuration);
        }
        finally {
            this.unlockSharedConfiguration();
        }
    }
}

