/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.client.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.geode.InternalGemFireError;
import org.apache.geode.cache.InterestResultPolicy;
import org.apache.geode.cache.client.internal.ServerRegionProxy;
import org.apache.geode.cache.client.internal.UnregisterInterestOp;
import org.apache.geode.cache.query.CqQuery;
import org.apache.geode.cache.query.internal.cq.InternalCqQuery;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.tier.InterestType;
import org.apache.geode.internal.cache.tier.sockets.UnregisterAllInterest;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class RegisterInterestTracker {
    private static final Logger logger = LogService.getLogger();
    public static final int interestListIndex = 0;
    public static final int durableInterestListIndex = 1;
    private static final int interestListIndexForUpdatesAsInvalidates = 2;
    private static final int durableInterestListIndexForUpdatesAsInvalidates = 3;
    private final FailoverInterestList[] fils = new FailoverInterestList[4];
    private final ConcurrentMap<CqQuery, Boolean> cqs = new ConcurrentHashMap<CqQuery, Boolean>();

    public RegisterInterestTracker() {
        this.fils[0] = new FailoverInterestList();
        this.fils[2] = new FailoverInterestList();
        this.fils[1] = new FailoverInterestList();
        this.fils[3] = new FailoverInterestList();
    }

    public static int getInterestLookupIndex(boolean isDurable, boolean receiveUpdatesAsInvalidates) {
        if (isDurable) {
            if (receiveUpdatesAsInvalidates) {
                return 3;
            }
            return 1;
        }
        if (receiveUpdatesAsInvalidates) {
            return 2;
        }
        return 0;
    }

    public List<Object> getInterestList(String regionName, int interestType2) {
        RegionInterestEntry rie1 = this.readRegionInterests(regionName, interestType2, false, false);
        RegionInterestEntry rie2 = this.readRegionInterests(regionName, interestType2, false, true);
        RegionInterestEntry rie3 = this.readRegionInterests(regionName, interestType2, true, false);
        RegionInterestEntry rie4 = this.readRegionInterests(regionName, interestType2, true, true);
        ArrayList<Object> result = new ArrayList<Object>();
        if (rie1 != null) {
            result.addAll(rie1.getInterests().keySet());
        }
        if (rie2 != null) {
            result.addAll(rie2.getInterests().keySet());
        }
        if (rie3 != null) {
            result.addAll(rie3.getInterests().keySet());
        }
        if (rie4 != null) {
            result.addAll(rie4.getInterests().keySet());
        }
        return result;
    }

    void addSingleInterest(LocalRegion r, Object key, int interestType2, InterestResultPolicy pol, boolean isDurable, boolean receiveUpdatesAsInvalidates) {
        RegionInterestEntry rie = this.getRegionInterests(r, interestType2, false, isDurable, receiveUpdatesAsInvalidates);
        rie.getInterests().put(key, pol);
    }

    boolean removeSingleInterest(LocalRegion r, Object key, int interestType2, boolean isDurable, boolean receiveUpdatesAsInvalidates) {
        Object interest;
        RegionInterestEntry rie = this.getRegionInterests(r, interestType2, true, isDurable, receiveUpdatesAsInvalidates);
        if (rie == null) {
            return false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("removeSingleInterest region={} key={}", (Object)r.getFullPath(), key);
        }
        if ((interest = rie.getInterests().remove(key)) == null) {
            logger.warn("removeSingleInterest: key {} not registered in the client", key);
            return false;
        }
        return true;
    }

    void addInterestList(LocalRegion r, List keys, InterestResultPolicy pol, boolean isDurable, boolean receiveUpdatesAsInvalidates) {
        RegionInterestEntry rie = this.getRegionInterests(r, 0, false, isDurable, receiveUpdatesAsInvalidates);
        for (Object key : keys) {
            rie.getInterests().put(key, pol);
        }
    }

    public void addCq(InternalCqQuery cqi, boolean isDurable) {
        this.cqs.put(cqi, isDurable);
    }

    public void removeCq(InternalCqQuery cqi) {
        this.cqs.remove(cqi);
    }

    Map getCqsMap() {
        return this.cqs;
    }

    void unregisterRegion(ServerRegionProxy srp, boolean keepalive) {
        this.removeAllInterests(srp, 0, false, keepalive, false);
        this.removeAllInterests(srp, 2, false, keepalive, false);
        this.removeAllInterests(srp, 3, false, keepalive, false);
        this.removeAllInterests(srp, 1, false, keepalive, false);
        this.removeAllInterests(srp, 0, false, keepalive, true);
        this.removeAllInterests(srp, 2, false, keepalive, true);
        this.removeAllInterests(srp, 3, false, keepalive, true);
        this.removeAllInterests(srp, 1, false, keepalive, true);
        if (srp.getPool().isDurableClient()) {
            this.removeAllInterests(srp, 0, true, keepalive, true);
            this.removeAllInterests(srp, 2, true, keepalive, true);
            this.removeAllInterests(srp, 3, true, keepalive, true);
            this.removeAllInterests(srp, 1, true, keepalive, true);
            this.removeAllInterests(srp, 0, true, keepalive, false);
            this.removeAllInterests(srp, 2, true, keepalive, false);
            this.removeAllInterests(srp, 3, true, keepalive, false);
            this.removeAllInterests(srp, 1, true, keepalive, false);
        }
    }

    private void removeAllInterests(ServerRegionProxy srp, int interestType2, boolean durable, boolean keepAlive, boolean receiveUpdatesAsInvalidates) {
        block4: {
            String regName = srp.getRegionName();
            ConcurrentMap<String, RegionInterestEntry> allInterests = this.getRegionToInterestsMap(interestType2, durable, receiveUpdatesAsInvalidates);
            if (allInterests.remove(regName) != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("removeAllInterests region={} type={}", (Object)regName, (Object)InterestType.getString(interestType2));
                }
                try {
                    UnregisterAllInterest key = UnregisterAllInterest.singleton();
                    UnregisterInterestOp.execute(srp.getPool(), regName, key, interestType2, true, keepAlive);
                }
                catch (Exception e) {
                    if (srp.getPool().getCancelCriterion().isCancelInProgress()) break block4;
                    logger.warn("Problem removing all interest on region={} interestType={} :{}", new Object[]{regName, InterestType.getString(interestType2), e.getLocalizedMessage()});
                }
            }
        }
    }

    boolean removeInterestList(LocalRegion r, List keys, boolean isDurable, boolean receiveUpdatesAsInvalidates) {
        RegionInterestEntry rie = this.getRegionInterests(r, 0, true, isDurable, receiveUpdatesAsInvalidates);
        if (rie == null) {
            return false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("removeInterestList region={} keys={}", (Object)r.getFullPath(), (Object)keys);
        }
        int removeCount = 0;
        for (Object key : keys) {
            Object interest = rie.getInterests().remove(key);
            if (interest != null) {
                ++removeCount;
                continue;
            }
            logger.warn("removeInterestList: key {} not registered in the client", key);
        }
        return removeCount != 0;
    }

    ConcurrentMap<String, RegionInterestEntry> getRegionToInterestsMap(int interestType2, boolean isDurable, boolean receiveUpdatesAsInvalidates) {
        FailoverInterestList fil = this.fils[RegisterInterestTracker.getInterestLookupIndex(isDurable, receiveUpdatesAsInvalidates)];
        switch (interestType2) {
            case 0: {
                return fil.keysOfInterest;
            }
            case 1: {
                return fil.regexOfInterest;
            }
            case 2: {
                return fil.filtersOfInterest;
            }
            case 4: {
                return fil.cqsOfInterest;
            }
            case 3: {
                return fil.queriesOfInterest;
            }
        }
        throw new InternalGemFireError("Unknown interestType");
    }

    private RegionInterestEntry getRegionInterests(LocalRegion r, int interestType2, boolean forRemoval, boolean isDurable, boolean receiveUpdatesAsInvalidates) {
        RegionInterestEntry rie;
        String regionName = r.getFullPath();
        ConcurrentMap<String, RegionInterestEntry> mapOfInterest = this.getRegionToInterestsMap(interestType2, isDurable, receiveUpdatesAsInvalidates);
        RegionInterestEntry result = (RegionInterestEntry)mapOfInterest.get(regionName);
        if (result == null && !forRemoval && (result = mapOfInterest.putIfAbsent(regionName, rie = new RegionInterestEntry(r))) == null) {
            result = rie;
        }
        return result;
    }

    private RegionInterestEntry readRegionInterests(String regionName, int interestType2, boolean isDurable, boolean receiveUpdatesAsInvalidates) {
        ConcurrentMap<String, RegionInterestEntry> mapOfInterest = this.getRegionToInterestsMap(interestType2, isDurable, receiveUpdatesAsInvalidates);
        return (RegionInterestEntry)mapOfInterest.get(regionName);
    }

    public static class RegionInterestEntry {
        private final LocalRegion region;
        private final ConcurrentMap<Object, InterestResultPolicy> interests;

        RegionInterestEntry(LocalRegion r) {
            this.region = r;
            this.interests = new ConcurrentHashMap<Object, InterestResultPolicy>();
        }

        public LocalRegion getRegion() {
            return this.region;
        }

        public ConcurrentMap<Object, InterestResultPolicy> getInterests() {
            return this.interests;
        }
    }

    protected static class FailoverInterestList {
        final ConcurrentMap<String, RegionInterestEntry> keysOfInterest = new ConcurrentHashMap<String, RegionInterestEntry>();
        final ConcurrentMap<String, RegionInterestEntry> regexOfInterest = new ConcurrentHashMap<String, RegionInterestEntry>();
        final ConcurrentMap<String, RegionInterestEntry> filtersOfInterest = new ConcurrentHashMap<String, RegionInterestEntry>();
        final ConcurrentMap<String, RegionInterestEntry> queriesOfInterest = new ConcurrentHashMap<String, RegionInterestEntry>();
        final ConcurrentMap<String, RegionInterestEntry> cqsOfInterest = new ConcurrentHashMap<String, RegionInterestEntry>();

        protected FailoverInterestList() {
        }
    }
}

