/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.geode.annotations.Immutable;

@Immutable
public class LossAction
implements Serializable {
    private static final long serialVersionUID = -832035480397447797L;
    @Immutable
    public static final LossAction NO_ACCESS = new LossAction("NO_ACCESS", 0);
    @Immutable
    public static final LossAction LIMITED_ACCESS = new LossAction("LIMITED_ACCESS", 1);
    @Immutable
    public static final LossAction FULL_ACCESS = new LossAction("FULL_ACCESS", 2);
    @Immutable
    public static final LossAction RECONNECT = new LossAction("RECONNECT", 3);
    private final transient String name;
    public final byte ordinal;
    @Immutable
    private static final LossAction[] PRIVATE_VALUES = new LossAction[]{NO_ACCESS, LIMITED_ACCESS, FULL_ACCESS, RECONNECT};
    @Immutable
    public static final List VALUES = Collections.unmodifiableList(Arrays.asList(PRIVATE_VALUES));

    private Object readResolve() throws ObjectStreamException {
        return PRIVATE_VALUES[this.ordinal];
    }

    private LossAction(String name, int ordinal) {
        this.name = name;
        this.ordinal = (byte)ordinal;
    }

    public static LossAction fromOrdinal(byte ordinal) {
        return PRIVATE_VALUES[ordinal];
    }

    public static LossAction fromName(String name) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException(String.format("Invalid LossAction name: %s", name));
        }
        for (int i = 0; i < PRIVATE_VALUES.length; ++i) {
            if (!name.equals(LossAction.PRIVATE_VALUES[i].name)) continue;
            return PRIVATE_VALUES[i];
        }
        throw new IllegalArgumentException(String.format("Invalid LossAction name: %s", name));
    }

    public boolean isNoAccess() {
        return this == NO_ACCESS;
    }

    public boolean isLimitedAccess() {
        return this == LIMITED_ACCESS;
    }

    public boolean isAllAccess() {
        return this == FULL_ACCESS;
    }

    public boolean isReconnect() {
        return this == RECONNECT;
    }

    public String toString() {
        return this.name;
    }
}

