/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.string;

import java.util.List;
import org.apache.geode.cache.Region;
import org.apache.geode.redis.internal.ByteArrayWrapper;
import org.apache.geode.redis.internal.Coder;
import org.apache.geode.redis.internal.Command;
import org.apache.geode.redis.internal.ExecutionHandlerContext;
import org.apache.geode.redis.internal.executor.string.StringExecutor;

public class IncrByFloatExecutor
extends StringExecutor {
    private final String ERROR_VALUE_NOT_USABLE = "Invalid value at this key and cannot be incremented numerically";
    private final String ERROR_INCREMENT_NOT_USABLE = "The increment on this key must be a valid floating point numeric";
    private final String ERROR_OVERFLOW = "This incrementation cannot be performed due to overflow";
    private final int INCREMENT_INDEX = 2;

    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        Double value;
        Double increment;
        List<byte[]> commandElems = command.getProcessedCommand();
        Region<ByteArrayWrapper, ByteArrayWrapper> r = context.getRegionProvider().getStringsRegion();
        if (commandElems.size() < 3) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The wrong number of arguments or syntax was provided, the format for the INCRBY command is \"INCRBY key increment\""));
            return;
        }
        ByteArrayWrapper key = command.getKey();
        this.checkAndSetDataType(key, context);
        ByteArrayWrapper valueWrapper = r.get(key);
        byte[] incrArray = commandElems.get(2);
        String doub = Coder.bytesToString(incrArray).toLowerCase();
        if (doub.contains("inf") || doub.contains("nan")) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "Increment would produce NaN or infinity"));
            return;
        }
        if (valueWrapper != null && valueWrapper.toString().contains(" ")) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "Invalid value at this key and cannot be incremented numerically"));
            return;
        }
        try {
            increment = Coder.stringToDouble(doub);
        }
        catch (NumberFormatException e) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The increment on this key must be a valid floating point numeric"));
            return;
        }
        if (valueWrapper == null) {
            r.put(key, new ByteArrayWrapper(incrArray));
            command.setResponse(Coder.getBulkStringResponse(context.getByteBufAllocator(), increment));
            return;
        }
        String stringValue = Coder.bytesToString(valueWrapper.toBytes());
        try {
            value = Coder.stringToDouble(stringValue);
        }
        catch (NumberFormatException e) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "Invalid value at this key and cannot be incremented numerically"));
            return;
        }
        if (value >= 0.0 && increment > Double.MAX_VALUE - value) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "This incrementation cannot be performed due to overflow"));
            return;
        }
        double result = value + increment;
        if (Double.isNaN(result) || Double.isInfinite(result)) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "increment would produce NaN or Infinity"));
            return;
        }
        value = value + increment;
        stringValue = "" + value;
        r.put(key, new ByteArrayWrapper(Coder.stringToBytes(stringValue)));
        command.setResponse(Coder.getBulkStringResponse(context.getByteBufAllocator(), value));
    }
}

