/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.sortedset;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.geode.cache.Region;
import org.apache.geode.redis.internal.ByteArrayWrapper;
import org.apache.geode.redis.internal.Coder;
import org.apache.geode.redis.internal.Command;
import org.apache.geode.redis.internal.DoubleWrapper;
import org.apache.geode.redis.internal.ExecutionHandlerContext;
import org.apache.geode.redis.internal.RedisDataType;
import org.apache.geode.redis.internal.executor.AbstractScanExecutor;

public class ZScanExecutor
extends AbstractScanExecutor {
    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        byte[] bytes;
        List<byte[]> commandElems = command.getProcessedCommand();
        if (commandElems.size() < 3) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The wrong number of arguments or syntax was provided, the format for the SSCAN command is \"SSCAN key cursor [MATCH pattern] [COUNT count]\""));
            return;
        }
        ByteArrayWrapper key = command.getKey();
        Region<?, ?> keyRegion = context.getRegionProvider().getRegion(key);
        this.checkDataType(key, RedisDataType.REDIS_SORTEDSET, context);
        if (keyRegion == null) {
            command.setResponse(Coder.getScanResponse(context.getByteBufAllocator(), new ArrayList()));
            return;
        }
        byte[] cAr = commandElems.get(2);
        int cursor = 0;
        Pattern matchPattern = null;
        String globMatchPattern = null;
        int count = 10;
        try {
            cursor = Coder.bytesToInt(cAr);
        }
        catch (NumberFormatException e) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "Invalid cursor"));
            return;
        }
        if (cursor < 0) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "Invalid cursor"));
            return;
        }
        if (commandElems.size() > 4) {
            try {
                bytes = commandElems.get(3);
                if (Coder.bytesToString(bytes).equalsIgnoreCase("MATCH")) {
                    bytes = commandElems.get(4);
                    globMatchPattern = Coder.bytesToString(bytes);
                } else if (Coder.bytesToString(bytes).equalsIgnoreCase("COUNT")) {
                    bytes = commandElems.get(4);
                    count = Coder.bytesToInt(bytes);
                }
            }
            catch (NumberFormatException e) {
                command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "Count must be numeric and positive"));
                return;
            }
        }
        if (commandElems.size() > 6) {
            try {
                bytes = commandElems.get(5);
                if (Coder.bytesToString(bytes).equalsIgnoreCase("COUNT")) {
                    bytes = commandElems.get(6);
                    count = Coder.bytesToInt(bytes);
                }
            }
            catch (NumberFormatException e) {
                command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "Count must be numeric and positive"));
                return;
            }
        }
        if (count < 0) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "Count must be numeric and positive"));
            return;
        }
        try {
            matchPattern = this.convertGlobToRegex(globMatchPattern);
        }
        catch (PatternSyntaxException e) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "Incorrect syntax for given glob regex"));
            return;
        }
        List<?> returnList = this.getIteration(new HashSet(keyRegion.entrySet()), matchPattern, count, cursor);
        command.setResponse(Coder.getScanResponse(context.getByteBufAllocator(), returnList));
    }

    @Override
    protected List<?> getIteration(Collection<?> list, Pattern matchPattern, int count, int cursor) {
        ArrayList<Object> returnList = new ArrayList<Object>();
        int size = list.size();
        int beforeCursor = 0;
        int numElements = 0;
        int i = -1;
        for (Map.Entry entry : list) {
            ByteArrayWrapper keyWrapper = (ByteArrayWrapper)entry.getKey();
            String key = keyWrapper.toString();
            DoubleWrapper value = (DoubleWrapper)entry.getValue();
            ++i;
            if (beforeCursor < cursor) {
                ++beforeCursor;
                continue;
            }
            if (numElements >= count) break;
            if (matchPattern != null) {
                if (!matchPattern.matcher(key).matches()) continue;
                returnList.add(keyWrapper);
                returnList.add(value.toString());
                ++numElements;
                continue;
            }
            returnList.add(keyWrapper);
            returnList.add(value.toString());
            ++numElements;
        }
        if (i == size - 1) {
            returnList.add(0, String.valueOf(0));
        } else {
            returnList.add(0, String.valueOf(i));
        }
        return returnList;
    }
}

