/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.sortedset;

import java.util.List;
import org.apache.geode.cache.Region;
import org.apache.geode.redis.internal.ByteArrayWrapper;
import org.apache.geode.redis.internal.Coder;
import org.apache.geode.redis.internal.Command;
import org.apache.geode.redis.internal.DoubleWrapper;
import org.apache.geode.redis.internal.ExecutionHandlerContext;
import org.apache.geode.redis.internal.RedisDataType;
import org.apache.geode.redis.internal.executor.sortedset.SortedSetExecutor;

public class ZCardExecutor
extends SortedSetExecutor {
    private final int NOT_EXISTS = 0;

    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        List<byte[]> commandElems = command.getProcessedCommand();
        if (commandElems.size() < 2) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The wrong number of arguments or syntax was provided, the format for the ZCARD command is \"ZCARD key\""));
            return;
        }
        ByteArrayWrapper key = command.getKey();
        Region<ByteArrayWrapper, DoubleWrapper> keyRegion = this.getRegion(context, key);
        this.checkDataType(key, RedisDataType.REDIS_SORTEDSET, context);
        if (keyRegion == null) {
            command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), 0));
        } else {
            command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), keyRegion.size()));
        }
    }
}

