/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.security;

import java.io.ObjectInputStream;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.Descriptor;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.management.Query;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.loading.ClassLoaderRepository;
import javax.management.remote.MBeanServerForwarder;
import org.apache.geode.internal.security.IntegratedSecurityService;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.management.internal.security.AccessControlMXBean;
import org.apache.geode.security.GemFireSecurityException;
import org.apache.geode.security.ResourcePermission;

public class MBeanServerWrapper
implements MBeanServerForwarder {
    private MBeanServer mbs;
    private SecurityService securityService = IntegratedSecurityService.getSecurityService();
    private static QueryExp notAccessControlMBean = Query.not(Query.isInstanceOf(Query.value(AccessControlMXBean.class.getName())));

    private void checkDomain(ObjectName name) {
        if ("GemFire".equals(name.getDomain())) {
            throw new SecurityException("Access Denied");
        }
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name) throws ReflectionException, InstanceAlreadyExistsException, MBeanException, NotCompliantMBeanException {
        this.checkDomain(name);
        return this.mbs.createMBean(className, name);
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName) throws ReflectionException, InstanceAlreadyExistsException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        this.checkDomain(name);
        return this.mbs.createMBean(className, name, loaderName);
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanException, NotCompliantMBeanException {
        this.checkDomain(name);
        return this.mbs.createMBean(className, name, params, signature);
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        this.checkDomain(name);
        return this.mbs.createMBean(className, name, loaderName, params, signature);
    }

    @Override
    public ObjectInstance registerMBean(Object object, ObjectName name) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        this.checkDomain(name);
        return this.mbs.registerMBean(object, name);
    }

    @Override
    public void unregisterMBean(ObjectName name) throws InstanceNotFoundException, MBeanRegistrationException {
        this.checkDomain(name);
        this.mbs.unregisterMBean(name);
    }

    @Override
    public ObjectInstance getObjectInstance(ObjectName name) throws InstanceNotFoundException {
        return this.mbs.getObjectInstance(name);
    }

    @Override
    public Set<ObjectInstance> queryMBeans(ObjectName name, QueryExp query) {
        if (query != null) {
            return this.mbs.queryMBeans(name, Query.and(query, notAccessControlMBean));
        }
        return this.mbs.queryMBeans(name, notAccessControlMBean);
    }

    @Override
    public Set<ObjectName> queryNames(ObjectName name, QueryExp query) {
        if (query != null) {
            return this.mbs.queryNames(name, Query.and(query, notAccessControlMBean));
        }
        return this.mbs.queryNames(name, notAccessControlMBean);
    }

    @Override
    public boolean isRegistered(ObjectName name) {
        return this.mbs.isRegistered(name);
    }

    @Override
    public Integer getMBeanCount() {
        return this.mbs.getMBeanCount();
    }

    @Override
    public Object getAttribute(ObjectName name, String attribute) throws MBeanException, InstanceNotFoundException, ReflectionException {
        Object result;
        ResourcePermission ctx = this.getOperationContext(name, attribute, false);
        this.securityService.authorize(ctx);
        try {
            result = this.mbs.getAttribute(name, attribute);
        }
        catch (AttributeNotFoundException nex) {
            return null;
        }
        return result;
    }

    @Override
    public AttributeList getAttributes(ObjectName name, String[] attributes) throws InstanceNotFoundException, ReflectionException {
        AttributeList results = new AttributeList();
        for (String attribute : attributes) {
            try {
                Object value = this.getAttribute(name, attribute);
                Attribute att = new Attribute(attribute, value);
                results.add(att);
            }
            catch (Exception e) {
                throw new GemFireSecurityException("error getting value of " + attribute + " from " + name, e);
            }
        }
        return results;
    }

    @Override
    public void setAttribute(ObjectName name, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        ResourcePermission ctx = this.getOperationContext(name, attribute.getName(), false);
        this.securityService.authorize(ctx);
        this.mbs.setAttribute(name, attribute);
    }

    @Override
    public AttributeList setAttributes(ObjectName name, AttributeList attributes) throws InstanceNotFoundException, ReflectionException {
        for (Attribute attribute : attributes.asList()) {
            try {
                this.setAttribute(name, attribute);
            }
            catch (Exception e) {
                throw new GemFireSecurityException("error setting attribute " + attribute + " of " + name, e);
            }
        }
        return attributes;
    }

    @Override
    public Object invoke(ObjectName name, String operationName, Object[] params, String[] signature) throws InstanceNotFoundException, MBeanException, ReflectionException {
        ResourcePermission ctx = this.getOperationContext(name, operationName, true);
        this.securityService.authorize(ctx);
        Object result = this.mbs.invoke(name, operationName, params, signature);
        return result;
    }

    private ResourcePermission getOperationContext(ObjectName objectName, String featureName, boolean isOp) throws InstanceNotFoundException, ReflectionException {
        MBeanInfo beanInfo = null;
        try {
            beanInfo = this.mbs.getMBeanInfo(objectName);
        }
        catch (IntrospectionException e) {
            throw new GemFireSecurityException("error getting beanInfo of " + objectName, e);
        }
        ResourcePermission result = null;
        result = this.getOperationContext(beanInfo.getDescriptor(), result);
        MBeanFeatureInfo[] featureInfos = null;
        featureInfos = isOp ? beanInfo.getOperations() : beanInfo.getAttributes();
        for (MBeanFeatureInfo info : featureInfos) {
            if (!info.getName().equals(featureName)) continue;
            result = this.getOperationContext(info.getDescriptor(), result);
            break;
        }
        return result;
    }

    private ResourcePermission getOperationContext(Descriptor descriptor, ResourcePermission defaultValue) {
        String resource = (String)descriptor.getFieldValue("resource");
        String operationCode = (String)descriptor.getFieldValue("operation");
        if (resource != null && operationCode != null) {
            return new ResourcePermission(resource, operationCode);
        }
        return defaultValue;
    }

    @Override
    public String getDefaultDomain() {
        return this.mbs.getDefaultDomain();
    }

    @Override
    public String[] getDomains() {
        return this.mbs.getDomains();
    }

    @Override
    public void addNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
        this.mbs.addNotificationListener(name, listener, filter, handback);
    }

    @Override
    public void addNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
        this.mbs.addNotificationListener(name, listener, filter, handback);
    }

    @Override
    public void removeNotificationListener(ObjectName name, ObjectName listener) throws InstanceNotFoundException, ListenerNotFoundException {
        this.mbs.removeNotificationListener(name, listener);
    }

    @Override
    public void removeNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
        this.mbs.removeNotificationListener(name, listener, filter, handback);
    }

    @Override
    public void removeNotificationListener(ObjectName name, NotificationListener listener) throws InstanceNotFoundException, ListenerNotFoundException {
        this.mbs.removeNotificationListener(name, listener);
    }

    @Override
    public void removeNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
        this.mbs.removeNotificationListener(name, listener, filter, handback);
    }

    @Override
    public MBeanInfo getMBeanInfo(ObjectName name) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
        return this.mbs.getMBeanInfo(name);
    }

    @Override
    public boolean isInstanceOf(ObjectName name, String className) throws InstanceNotFoundException {
        return this.mbs.isInstanceOf(name, className);
    }

    @Override
    public Object instantiate(String className) throws ReflectionException, MBeanException {
        return this.mbs.instantiate(className);
    }

    @Override
    public Object instantiate(String className, ObjectName loaderName) throws ReflectionException, MBeanException, InstanceNotFoundException {
        return this.mbs.instantiate(className, loaderName);
    }

    @Override
    public Object instantiate(String className, Object[] params, String[] signature) throws ReflectionException, MBeanException {
        return this.mbs.instantiate(className, params, signature);
    }

    @Override
    public Object instantiate(String className, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, MBeanException, InstanceNotFoundException {
        return this.mbs.instantiate(className, params, signature);
    }

    @Override
    public ObjectInputStream deserialize(ObjectName name, byte[] data) throws InstanceNotFoundException, OperationsException {
        return this.mbs.deserialize(name, data);
    }

    @Override
    public ObjectInputStream deserialize(String className, byte[] data) throws OperationsException, ReflectionException {
        return this.deserialize(className, data);
    }

    @Override
    public ObjectInputStream deserialize(String className, ObjectName loaderName, byte[] data) throws InstanceNotFoundException, OperationsException, ReflectionException {
        return this.mbs.deserialize(className, loaderName, data);
    }

    @Override
    public ClassLoader getClassLoaderFor(ObjectName mbeanName) throws InstanceNotFoundException {
        return this.mbs.getClassLoaderFor(mbeanName);
    }

    @Override
    public ClassLoader getClassLoader(ObjectName loaderName) throws InstanceNotFoundException {
        return this.mbs.getClassLoader(loaderName);
    }

    @Override
    public ClassLoaderRepository getClassLoaderRepository() {
        return this.mbs.getClassLoaderRepository();
    }

    @Override
    public MBeanServer getMBeanServer() {
        return this.mbs;
    }

    @Override
    public void setMBeanServer(MBeanServer mbs) {
        this.mbs = mbs;
    }
}

