/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.configuration.domain;

import java.io.IOException;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.apache.geode.internal.cache.xmlcache.CacheXmlParser;
import org.apache.geode.management.internal.configuration.utils.XmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class CacheElement {
    static final String XSD_PREFIX = "xsd";
    private static final String XSD_ALL_CHILDREN = "xsd:element";
    private static final String XSD_COMPLEX_TYPE_CHILDREN = "xsd:group|xsd:all|xsd:choice|xsd:sequence";
    private static final String XSD_CHOICE_OR_SEQUENCE_CHILDREN = "xsd:element|xsd:group|xsd:choice|xsd:sequence|xsd:any";
    static final String CACHE_TYPE_EMBEDDED = "/xsd:schema/xsd:element[@name='cache']/xsd:complexType";
    private String name;
    private int order;
    private boolean multiple;

    public CacheElement(String name, int rank, boolean multiple) {
        this.name = name;
        this.order = rank;
        this.multiple = multiple;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public boolean isMultiple() {
        return this.multiple;
    }

    public void setMultiple(boolean multiple) {
        this.multiple = multiple;
    }

    public static LinkedHashMap<String, CacheElement> buildElementMap(Document doc) throws IOException, XPathExpressionException, SAXException, ParserConfigurationException {
        Map<String, List<String>> schemaLocationMap = XmlUtils.buildSchemaLocationMap(XmlUtils.getAttribute(doc.getFirstChild(), "schemaLocation", "http://www.w3.org/2001/XMLSchema-instance"));
        LinkedHashMap<String, CacheElement> elementMap = new LinkedHashMap<String, CacheElement>();
        CacheElement.buildElementMapCacheType(elementMap, CacheElement.resolveSchema(schemaLocationMap, "http://geode.apache.org/schema/cache"));
        return elementMap;
    }

    private static InputSource resolveSchema(Map<String, List<String>> schemaLocationMap, String namespaceUri) throws IOException {
        CacheXmlParser entityResolver = new CacheXmlParser();
        InputSource inputSource = null;
        List<String> locations = schemaLocationMap.get(namespaceUri);
        for (String location : locations) {
            try {
                inputSource = entityResolver.resolveEntity(null, location);
                if (null == inputSource) continue;
                break;
            }
            catch (SAXException sAXException) {
            }
        }
        if (null == inputSource) {
            inputSource = new InputSource(new URL(namespaceUri).openStream());
        }
        return inputSource;
    }

    private static void buildElementMapCacheType(LinkedHashMap<String, CacheElement> elementMap, InputSource inputSource) throws SAXException, IOException, ParserConfigurationException, XPathExpressionException {
        Document doc = XmlUtils.getDocumentBuilder().parse(inputSource);
        int rank = 0;
        XmlUtils.XPathContext xPathContext = new XmlUtils.XPathContext(XSD_PREFIX, "http://www.w3.org/2001/XMLSchema");
        Element cacheType = XmlUtils.querySingleElement(doc, CACHE_TYPE_EMBEDDED, xPathContext);
        rank = CacheElement.buildElementMapXPath(elementMap, doc, cacheType, rank, XSD_COMPLEX_TYPE_CHILDREN, xPathContext);
    }

    private static int buildElementMapXPath(LinkedHashMap<String, CacheElement> elementMap, Document schema, Node parent, int rank, String xPath, XmlUtils.XPathContext xPathContext) throws XPathExpressionException {
        NodeList children = XmlUtils.query(parent, xPath, xPathContext);
        block11: for (int i = 0; i < children.getLength(); ++i) {
            Element child = (Element)children.item(i);
            switch (child.getNodeName()) {
                case "xsd:element": {
                    String name = XmlUtils.getAttribute(child, "name");
                    elementMap.put(name, new CacheElement(name, rank++, CacheElement.isMultiple(child)));
                    continue block11;
                }
                case "xsd:choice": 
                case "xsd:sequence": {
                    rank = CacheElement.buildElementMapXPath(elementMap, schema, child, rank, XSD_CHOICE_OR_SEQUENCE_CHILDREN, xPathContext);
                    continue block11;
                }
                case "xsd:any": {
                    continue block11;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported child type '" + child.getNodeName() + "'");
                }
            }
        }
        return rank;
    }

    private static boolean isMultiple(Element element) {
        String maxOccurs = XmlUtils.getAttribute(element, "maxOccurs");
        return null != maxOccurs && !maxOccurs.equals("1");
    }
}

