/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.util;

import io.github.lukehutch.fastclasspathscanner.FastClasspathScanner;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

public class ClasspathScanLoadHelper {
    public static Set<Class<?>> scanPackageForClassesImplementing(String packageToScan, Class<?> implementedInterface) {
        HashSet classesImplementing = new HashSet();
        new FastClasspathScanner(new String[]{packageToScan}).matchClassesImplementing(implementedInterface, classesImplementing::add).scan();
        return classesImplementing.stream().filter(ClasspathScanLoadHelper::isInstantiable).collect(Collectors.toSet());
    }

    private static boolean isInstantiable(Class<?> klass) {
        int modifiers = klass.getModifiers();
        return !Modifier.isAbstract(modifiers) && !Modifier.isInterface(modifiers) && Modifier.isPublic(modifiers);
    }
}

